/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwObjectClassSelectionCfg;
import com.wewebu.ow.server.dmsdialogs.views.classes.OwRootClassCfg;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ui.OwTreeView;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OwObjectClassTreeView
extends OwTreeView {
    protected OwConfiguration m_Configuration;
    protected OwResource m_resource;
    protected int m_iObjectType;
    protected OwNetwork m_network;
    private OwObjectClassSelectionCfg classSelectionCfg;

    public OwObjectClassTreeView(OwResource resource_p, int iObjectType_p) {
        this.m_resource = resource_p;
        this.m_iObjectType = iObjectType_p;
    }

    public OwObjectClassTreeView(OwResource resource_p, int iObjectType_p, OwObjectClassSelectionCfg classSelectionCfg) {
        this.m_resource = resource_p;
        this.m_iObjectType = iObjectType_p;
        this.classSelectionCfg = classSelectionCfg;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_Configuration = ((OwMainAppContext)this.getContext()).getConfiguration();
        this.m_network = ((OwMainAppContext)this.getContext()).getNetwork();
    }

    public void navigateClasses(Iterator classNames_p, String strSubFolderPath_p) throws Exception {
        this.navigate(classNames_p, strSubFolderPath_p);
    }

    public void navigateToClass(OwObjectClass objectClass_p) throws Exception {
        String strPath = this.getObjectClassPath(objectClass_p);
        this.navigate(strPath);
    }

    private String getObjectClassPath(OwObjectClass objectClass_p) throws Exception {
        OwObjectClass parent = objectClass_p.getParent();
        if (parent != null) {
            return this.getObjectClassPath(parent) + "/" + objectClass_p.getClassName();
        }
        return "/" + objectClass_p.getClassName();
    }

    @Override
    protected List createChildObjects(Object objectClass_p) throws Exception {
        if (objectClass_p instanceof Iterator) {
            ArrayList<OwObjectClass> childList = new ArrayList<OwObjectClass>();
            while (((Iterator)objectClass_p).hasNext()) {
                String nextClassName = (String)((Iterator)objectClass_p).next();
                OwObjectClass objClass = this.m_network.getObjectClass(nextClassName, this.m_resource);
                childList.add(objClass);
            }
            return childList;
        }
        List objectClassList = ((OwObjectClass)objectClass_p).getChilds(this.m_network, true);
        if (objectClassList != null) {
            ArrayList<OwObjectClass> childList = new ArrayList<OwObjectClass>();
            for (OwObjectClass objClass : objectClassList) {
                childList.add(objClass);
            }
            return childList;
        }
        return null;
    }

    @Override
    protected boolean hasPlusMinusIcon(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        try {
            OwRootClassCfg rootClassCfg;
            OwObjectClass myClass = (OwObjectClass)obj_p;
            if (null != this.classSelectionCfg && null != (rootClassCfg = this.classSelectionCfg.get(myClass.getClassName())) && !rootClassCfg.isIncludeSubclasses()) {
                return false;
            }
            return myClass.hasChilds(this.m_network, true, 1);
        }
        catch (Exception e) {
            return super.hasPlusMinusIcon(obj_p, node_p);
        }
    }

    @Override
    public boolean isEnabled(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        try {
            return ((OwObjectClass)obj_p).canCreateNewObject();
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    protected String getName(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        if (obj_p instanceof OwObjectClass) {
            return ((OwObjectClass)obj_p).getClassName();
        }
        return "/";
    }

    @Override
    protected String getDisplayName(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        if (obj_p instanceof OwObjectClass) {
            return ((OwObjectClass)obj_p).getDisplayName(this.getContext().getLocale());
        }
        return this.getContext().localize("app.OwObjectClassTreeView.rootnode", "Document Classes");
    }

    @Override
    protected String getCloseIconURL(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        StringBuffer iconpath = new StringBuffer();
        iconpath.append(this.getContext().getDesignURL());
        try {
            OwXMLUtil mimenode = ((OwMainAppContext)this.getContext()).getConfiguration().getDefaultMIMENode(((OwObjectClass)obj_p).getType());
            iconpath.append("/micon/");
            if (mimenode != null) {
                iconpath.append(mimenode.getSafeTextValue("icon", "unknown.png"));
            } else {
                iconpath.append("unknown.png");
            }
        }
        catch (ClassCastException e) {
            iconpath.append("/images/OwObjectClassPreviewView/root.png");
        }
        return iconpath.toString();
    }

    @Override
    protected String getOpenIconURL(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        return this.getCloseIconURL(obj_p, node_p);
    }

    @Override
    protected void expandParents(Object theObject_p) {
    }
}

