/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewThumbnails;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.field.OwSort;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;

public class OwObjectListViewCombined
extends OwObjectListView {
    protected ArrayList m_SubViews = new ArrayList();
    OwObjectCollection m_ObjectList = null;
    protected Collection m_ColumnInfoList = null;
    protected static final String QUERY_KEY_PAGE_COMBINED = "combinedpage";

    public OwObjectListViewCombined(int iViewMask_p) {
        super(iViewMask_p);
        this.m_SubViews.add(new OwObjectListViewRow(iViewMask_p));
        this.m_SubViews.add(new OwObjectListViewThumbnails(iViewMask_p));
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.setStickyFooterInUse(false);
            subview.addViewMask(32);
        }
    }

    public OwObjectListViewCombined() {
        this.m_SubViews.add(new OwObjectListViewRow());
        this.m_SubViews.add(new OwObjectListViewThumbnails());
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.addViewMask(32);
        }
    }

    @Override
    public void setConfigNode(Node node_p) throws Exception {
        super.setConfigNode(node_p);
        int iViewIndex = 0;
        for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals("subview")) continue;
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(iViewIndex++);
            subview.setConfigNode(n);
            subview.addViewMask(32);
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            this.addView(subview, null);
            subview.setStickyFooterInUse(false);
        }
        this.m_pageSelectorComponent = this.createPageSelector();
        this.setStickyFooterInUse(false);
    }

    @Override
    public void setDocumentFunctionPluginList(List pluginList_p) {
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.setDocumentFunctionPluginList(pluginList_p);
        }
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        boolean useHtml5DragAndDrop = ((OwMainAppContext)this.getContext()).isUseHtml5DragAndDrop();
        if (useHtml5DragAndDrop) {
            StringBuffer sb = new StringBuffer();
            sb.append("<script type=\"text/javascript\">\n");
            sb.append("var dropArea = document.getElementById('OwSublayout_ContentContainer');\n");
            sb.append("if(typeof addHtml5DropArea == 'function') {\n");
            sb.append("addHtml5DropArea(dropArea, false);\n");
            sb.append("}\n");
            sb.append("</script>\n");
            w_p.write(sb.toString());
        }
        if (this.getIsList()) {
            w_p.write("<div id=\"wrap\">");
            super.onRender(w_p);
            w_p.write("</div>");
            if (this.getIsPaging()) {
                w_p.write("<div id=\"footer\">");
                this.renderCombinedPageButtons(w_p);
                w_p.write("</div>");
            }
        } else {
            w_p.write("<span id=\"emptyList\"  class=\"OwEmptyTextMessage\">" + this.getContext().localize("app.OwObjectListView.emptylist", "No items to display") + "</span>\n");
        }
    }

    @Override
    public boolean isShowMaximized() {
        return this.getParent().isShowMaximized();
    }

    @Override
    protected boolean isPagingEnabled() {
        return !this.getParent().isShowMaximized();
    }

    public boolean getIsList() {
        return this.getIsListValid() && !this.getIsListEmpty();
    }

    public boolean getIsListValid() {
        return this.m_ObjectList != null && this.m_ColumnInfoList != null;
    }

    public boolean getIsListEmpty() {
        return this.m_ObjectList.size() == 0;
    }

    public boolean getIsPaging() {
        return this.isPagingEnabled() && !this.hasViewMask(32);
    }

    protected void renderCombinedPageButtons(Writer w_p) throws Exception {
        this.m_pageSelectorComponent.render(w_p);
    }

    @Override
    public void onPageNext(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(this.getCurrentPage() + 1);
    }

    @Override
    public void onPagePrev(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(this.getCurrentPage() - 1);
    }

    @Override
    public int getPageCount() throws Exception {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getPageCount();
        }
        return 0;
    }

    @Override
    public int getCurrentPage() {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getCurrentPage();
        }
        return 0;
    }

    @Override
    public boolean canPagePrev() {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).canPagePrev();
        }
        return false;
    }

    @Override
    public boolean canPageNext() throws Exception {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).canPageNext();
        }
        return false;
    }

    @Override
    public Collection getColumnInfo() {
        return this.m_ColumnInfoList;
    }

    @Override
    public int getCount() {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getCount();
        }
        return 0;
    }

    @Override
    public OwFieldManager getFieldManager() {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getFieldManager();
        }
        return null;
    }

    @Override
    public void setFieldManager(OwFieldManager fielmanager_p) {
        for (OwObjectListView subview : this.m_SubViews) {
            subview.setFieldManager(fielmanager_p);
        }
    }

    @Override
    public OwObjectCollection getObjectList() {
        return this.m_ObjectList;
    }

    @Override
    public OwObject getParentObject() {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getParentObject();
        }
        return null;
    }

    @Override
    public Collection getRetrievalPropertyNames() throws Exception {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getRetrievalPropertyNames();
        }
        return null;
    }

    @Override
    public OwSort getSort() {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getSort();
        }
        return null;
    }

    @Override
    protected OwClientRefreshContext getRefreshContext() {
        if (this.m_SubViews.size() > 0) {
            return ((OwObjectListView)this.m_SubViews.get(0)).getRefreshContext();
        }
        return null;
    }

    @Override
    protected void pageAbsolut(int iPage_p) throws Exception {
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.pageAbsolut(iPage_p);
        }
    }

    @Override
    public void setColumnInfo(Collection columnInfo_p) {
        this.m_ColumnInfoList = columnInfo_p;
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.setColumnInfo(columnInfo_p);
        }
    }

    @Override
    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception {
        this.m_ObjectList = objectList_p;
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.setObjectList(objectList_p, parentObject_p);
        }
    }

    @Override
    public void setRefreshContext(OwClientRefreshContext eventlistner_p) {
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.setRefreshContext(eventlistner_p);
        }
    }

    @Override
    public void setSort(OwSort sort_p) {
        for (int i = 0; i < this.m_SubViews.size(); ++i) {
            OwObjectListView subview = (OwObjectListView)this.m_SubViews.get(i);
            subview.setSort(sort_p);
        }
    }

    @Override
    public String getTitle() {
        StringBuffer sTitle = new StringBuffer();
        sTitle.append(this.getContext().localize("dmsdialogs.views.OwObjectListViewCombined.title", "Combined:"));
        sTitle.append(" ");
        Iterator it = this.m_SubViews.iterator();
        while (it.hasNext()) {
            OwObjectListView subview = (OwObjectListView)it.next();
            sTitle.append(subview.getTitle());
            if (!it.hasNext()) continue;
            sTitle.append(", ");
        }
        return sTitle.toString();
    }

    @Override
    public String getIcon() throws Exception {
        return "/images/OwObjectListView/OwObjectListViewCombined.png";
    }

    @Override
    public void setEventListner(OwObjectListView.OwObjectListViewEventListner eventlister_p) {
        super.setEventListner(eventlister_p);
        for (OwObjectListView listView : this.m_SubViews) {
            listView.setEventListner(eventlister_p);
        }
    }

    @Override
    public void onPageAbsolut(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(Integer.parseInt(request_p.getParameter("page")));
    }

    protected class OwObjectListViewRowCombined
    extends OwObjectListViewRow {
        public OwObjectListViewRowCombined(int iViewMask_p) {
            super(iViewMask_p);
        }
    }
}

