/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwMultipleSelectionCall;
import com.wewebu.ow.server.app.OwScript;
import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewPluginCache;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwRenderRowException;
import com.wewebu.ow.server.exceptions.OwUserOperationException;
import com.wewebu.ow.server.field.OwEnum;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwHeaderFieldColumnInfo;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.fieldctrlimpl.OwFieldManagerControlNote;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwSimpleAttributeBagWriteable;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwTransientBagRepository;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OwObjectListViewEXTJSGrid
extends OwObjectListViewPluginCache
implements OwFieldProvider {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListViewEXTJSGrid.class);
    protected static final char[] SPECIAL_CHARS = new char[]{'d', 'D', 'j', 'l', 'S', 'w', 'z', 'W', 'F', 'm', 'M', 'n', 't', 'L', 'Y', 'y', 'a', 'A', 'g', 'G', 'h', 'H', 'i', 's', 'O', 'T', 'Z'};
    protected static final int ICON_WIDTH = 16;
    protected static final int DEFAULT_COLUMN_WIDTH = 100;
    protected static final int MAX_COLUMN_WIDTH = 500;
    protected static final int MIN_COLUMN_WIDTH = 5;
    private static final OwIconFieldColumnInfo ICON_FIELD_COLUMN_INFO = new OwIconFieldColumnInfo();
    protected static final String COLUMNS_ID_ATTR_BAG = "OwObjectListViewEXTJSGrid_columns";
    private static final int NOTES_DEFAULT_WIDTH = 235;
    private static final String BPM_PLUGIN_ID = "com.wewebu.ow.bpm";
    private static final String IS_NOTE_EDITABLE_ELEMENT_NAME = "isNoteEditable";
    protected static final String OBJECT_INDEX_KEY = "object";
    protected static final String PLUG_INDEX_KEY = "plugin";
    private static final String TOOLTIP_NODE_NAME = "Tooltip";
    public static final String READ_ONLY_COLUMNS_NODE_NAME = "readOnlyColumns";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_DMSID = "{dmsid}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL = "{serverurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_BASEURL = "{baseurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START = "{prop";
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_ENCODE_CHAR = ':';
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_JSENCODE_CHAR = '~';
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_NOENCODE_CHAR = '#';
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END = "}";
    public static final char TOOLTIP_BLOCK_TOKEN_PROPERTY_END_CHAR = ']';
    public static final String TOOLTIP_BLOCK_TOKEN_PROPERTY_END = "]";
    public static final String TOOLTIP_BLOCK_TOKEN_PROPERTY_START = "[";
    public static final int DATATYPE_UNKNOWN = -1;
    public static final int DATATYPE_STRING = 0;
    public static final int DATATYPE_INTEGER = 1;
    public static final int DATATYPE_BOOLEAN = 2;
    public static final int DATATYPE_DATE = 3;
    public static final int DATATYPE_DOUBLE = 4;
    public static final int DATATYPE_ENUM = 5;
    public static final int DATATYPE_NOTE = 6;
    protected static final String AJAX_PARAM_COLUMN = "col";
    protected static final String AJAX_PARAM_ROW = "row";
    private static final String STORE_EXTJS_COLUMN_INFO_ELEMENT_NAME = "StoreExtJSColumnInfo";
    private static final String NONPERSISTENT_COLUMN_ATTRIBUTE_BAG = "npcab";
    public static String FIRST_PAGE_ACTION_ID = "extjs.first.page";
    public static String LAST_PAGE_ACTION_ID = "extjs.last.page";
    public static String POS1_ACTION_ID = "extjs.pos1";
    public static String END_ACTION_ID = "extjs.pos1";
    private OwSort m_sort;
    protected OwObjectCollection m_ObjectList;
    protected boolean pluginCacheCreated = false;
    private Collection m_ColumnInfoList;
    protected OwFieldManager m_FieldManager;
    private OwClientRefreshContext m_RefreshContext;
    private OwMimeManager m_MimeManager;
    protected HashMap m_AjaxColnameToPropertyMap = new HashMap();
    private ArrayList m_AjaxColumns = new ArrayList();
    private String m_TooltipTextPattern = null;
    private NumberFormat m_NumberFormat;
    private int m_startrow = 0;
    private DateFormat m_TransportDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private OwInformalConfiguration m_informalConfiguration;
    protected HashSet occuringObjectTypes;
    protected boolean m_useTransparentIcon = true;
    protected boolean m_isNoteEditable = false;
    private List m_editableNotePropertyNames;
    private boolean m_columnsModifiedByUser;
    private LinkedList m_readOnlyColumns;

    public OwObjectListViewEXTJSGrid(int iViewMask_p) {
        super(iViewMask_p);
    }

    public OwObjectListViewEXTJSGrid() {
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MimeManager = this.createMimeManager();
        this.m_FieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
        this.m_FieldManager.setExternalFormTarget(this.getFormTarget());
        this.m_FieldManager.setFieldProvider(this);
        this.m_MimeManager.attach(this.getContext(), null);
        this.m_NumberFormat = NumberFormat.getNumberInstance(this.getContext().getLocale());
        this.m_NumberFormat.setGroupingUsed(false);
        this.m_sort = new OwSort(((OwMainAppContext)this.getContext()).getMaxSortCriteriaCount(), true);
    }

    protected OwMimeManager createMimeManager() {
        return new OwMimeManager();
    }

    protected ArrayList getAjaxColumns() {
        return this.m_AjaxColumns;
    }

    @Override
    public void detach() {
        super.detach();
        this.m_MimeManager.detach();
        this.m_FieldManager.detach();
    }

    @Override
    public void setConfigNode(Node node_p) throws Exception {
        Element propertiesNotesElement;
        NodeList properteiesNodeList;
        String value;
        Node editableNodeNodeContent;
        Node editableNoteNode;
        Node tooltipChildNode;
        super.setConfigNode(node_p);
        Node tooltipNode = OwXMLDOMUtil.getChildNode(node_p, TOOLTIP_NODE_NAME);
        if (tooltipNode != null && (tooltipChildNode = tooltipNode.getFirstChild()) != null) {
            if (tooltipChildNode.getNodeType() == 3) {
                this.m_TooltipTextPattern = tooltipChildNode.getNodeValue();
            } else if (tooltipChildNode.getNodeType() == 4) {
                this.m_TooltipTextPattern = tooltipChildNode.getNodeValue();
            }
        }
        if ((editableNoteNode = OwXMLDOMUtil.getChildNode(node_p, IS_NOTE_EDITABLE_ELEMENT_NAME)) != null && (editableNodeNodeContent = editableNoteNode.getFirstChild()) != null && (value = editableNodeNodeContent.getNodeValue().trim()) != null) {
            this.setNoteEditable(Boolean.valueOf(value));
        }
        this.m_editableNotePropertyNames = new LinkedList();
        Node editablePropertiesNode = OwXMLDOMUtil.getChildNode(node_p, "NoteProperties");
        if (editablePropertiesNode != null && editablePropertiesNode.getNodeType() == 1 && (properteiesNodeList = (propertiesNotesElement = (Element)editablePropertiesNode).getElementsByTagName("NoteProperty")) != null) {
            for (int i = 0; i < properteiesNodeList.getLength(); ++i) {
                Node propertyNode = properteiesNodeList.item(i);
                if (propertyNode == null || propertyNode.getFirstChild() == null) continue;
                String propertyName = propertyNode.getFirstChild().getNodeValue().trim();
                this.m_editableNotePropertyNames.add(propertyName);
            }
        }
        this.checkBPMConfiguration(node_p);
        this.initReadOnlyColumnList(node_p);
        this.informalInit(node_p);
    }

    private void informalInit(Node configNode_p) {
        try {
            this.m_informalConfiguration = new OwInformalConfiguration();
            OwStandardXMLUtil configUtill = new OwStandardXMLUtil(configNode_p);
            List cdatas = configUtill.getSafeCDATAList();
            if (cdatas != null && !cdatas.isEmpty()) {
                StringBuilder xmlBuilder = new StringBuilder();
                for (String cdata : cdatas) {
                    xmlBuilder.append(cdata);
                }
                DocumentBuilderFactory domfactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = domfactory.newDocumentBuilder();
                Document informalDocument = documentBuilder.parse(new InputSource(new ByteArrayInputStream(xmlBuilder.toString().getBytes())));
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xpath = xPathFactory.newXPath();
                XPathExpression xpathExpression = xpath.compile("/informal/controls/property");
                Object propertiesResult = xpathExpression.evaluate(informalDocument, XPathConstants.NODESET);
                NodeList properties = (NodeList)propertiesResult;
                for (int i = 0; i < properties.getLength(); ++i) {
                    Node property = properties.item(i);
                    OwStandardXMLUtil propertyUtil = new OwStandardXMLUtil(property);
                    String name = propertyUtil.getSafeStringAttributeValue("name", "");
                    String type = propertyUtil.getSafeStringAttributeValue("type", "");
                    this.m_informalConfiguration.add(new OwPropetyControl(name, type));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Informal configuration error.", (Throwable)e);
        }
    }

    private void checkBPMConfiguration(Node node_p) throws OwConfigurationException {
        String masterPluginId;
        Node idNode;
        Node pluginNode;
        Node resultListNode = node_p.getParentNode();
        if (resultListNode != null && (pluginNode = resultListNode.getParentNode()) != null && (idNode = OwXMLDOMUtil.getChildNode(pluginNode, "id")) != null && (masterPluginId = OwXMLDOMUtil.getElementText((Element)idNode)).equals(BPM_PLUGIN_ID) && this.isNoteEditable()) {
            throw new OwConfigurationException("In BPM AJAX view the notes should not be editable");
        }
    }

    private void initReadOnlyColumnList(Node node_p) {
        this.m_readOnlyColumns = new LinkedList();
        Node readOnly = OwXMLDOMUtil.getChildNode(node_p, READ_ONLY_COLUMNS_NODE_NAME);
        if (readOnly != null) {
            this.m_readOnlyColumns.addAll(OwXMLDOMUtil.getSafeStringList(readOnly));
        }
    }

    protected String getDocumentInstanceFunctionPluginLinks(OwObject obj_p, int iIndex_p, Collection instancePluginsList_p) throws Exception {
        StringBuilder sbLinks = new StringBuilder();
        for (OwObjectListView.OwPluginEntry plugInEntry : instancePluginsList_p) {
            if (this.getPluginCache().isPluginDisabledForAllObjects(plugInEntry)) continue;
            OwObjectListViewPluginCache.OwPluginStatus status = this.getPluginCache().getCachedPluginState(plugInEntry, obj_p);
            boolean isPluginEnabled = status.isCached() ? status.isEnabled() : plugInEntry.m_Plugin.isEnabled(obj_p, this.getParentObject(), 1);
            int maxNumberOfIconsForEntry = this.getPluginCache().getMaximumNumberOfIconsForEntry(plugInEntry);
            if (isPluginEnabled) {
                OwObjectListView.OwIcon owIcon;
                String iconHTMLAsString = plugInEntry.m_Plugin.getIconHTML(obj_p, null);
                if (iconHTMLAsString == null || iconHTMLAsString.trim().length() == 0) {
                    iconHTMLAsString = "";
                    iconHTMLAsString = this.fillWithBlankIcons(maxNumberOfIconsForEntry, iconHTMLAsString);
                }
                if (plugInEntry.m_Plugin.getNoEvent()) {
                    owIcon = new OwObjectListView.OwIcon(iconHTMLAsString);
                    if (owIcon.getNumberOfIcons() < maxNumberOfIconsForEntry) {
                        sbLinks.append(this.fillWithBlankIcons(maxNumberOfIconsForEntry - owIcon.getNumberOfIcons(), ""));
                    }
                    sbLinks.append(iconHTMLAsString);
                    continue;
                }
                owIcon = new OwObjectListView.OwIcon(iconHTMLAsString);
                if (owIcon.getNumberOfIcons() < maxNumberOfIconsForEntry) {
                    sbLinks.append(this.fillWithBlankIcons(maxNumberOfIconsForEntry - owIcon.getNumberOfIcons(), ""));
                }
                sbLinks.append("<a href=\"");
                StringBuilder url = new StringBuilder(OBJECT_INDEX_KEY).append("=").append(iIndex_p);
                url = url.append("&");
                url = url.append(PLUG_INDEX_KEY).append("=").append(plugInEntry.m_iIndex);
                sbLinks.append(this.getEventURL("PluginEvent", url.toString()));
                sbLinks.append("\" title=\"");
                sbLinks.append(plugInEntry.m_Plugin.getTooltip());
                sbLinks.append("\" class=\"OwGeneralList_Plugin_a\">");
                sbLinks.append(iconHTMLAsString);
                sbLinks.append("</a>");
                continue;
            }
            sbLinks.append(this.fillWithBlankIcons(maxNumberOfIconsForEntry, ""));
        }
        return sbLinks.toString();
    }

    private String fillWithBlankIcons(int maxNumberOfIconsForEntry_p, String iconHTMLAsString_p) throws Exception {
        StringBuilder ret = new StringBuilder(iconHTMLAsString_p);
        for (int i = 0; i < maxNumberOfIconsForEntry_p; ++i) {
            ret.append(this.createEmptyIcon());
        }
        return ret.toString();
    }

    private String createEmptyIcon() throws Exception {
        String iconHTMLAsString = "";
        if (this.m_useTransparentIcon) {
            iconHTMLAsString = "<img class=\"OwFunctionIcon\" src=\"" + this.getContext().getDesignURL() + "/images/empty_plugin_small.gif" + "\" alt=\"\" title=\"\" />";
        }
        return iconHTMLAsString;
    }

    @Override
    public void onRender(Writer w_p) throws Exception {
        this.getContext().renderJSInclude("/js/wewebugridheaderextension.js", w_p);
        this.getContext().renderJSInclude("/js/weweburowselectionmodel.js", w_p);
        this.getContext().renderJSInclude("/js/wewebugridview.js", w_p);
        this.getContext().renderJSInclude("/js/owobjectlistviewextjsgrid.js", w_p);
        this.getContext().renderJSInclude("/js/wewebunoteseditor.js", w_p);
        this.getContext().renderJSInclude("/js/wewebuenumeditor.js", w_p);
        if (this.m_ObjectList != null) {
            Node node;
            this.m_MimeManager.reset();
            this.m_FieldManager.reset();
            this.setPluginCache(this.createPluginStatusCacheUtility(this.m_startrow, this.computeEndIndex(), this.getObjectInstancePluginList()));
            this.pluginCacheCreated = true;
            w_p.write("<script type=\"text/javascript\">\n");
            w_p.write("Ext.BLANK_IMAGE_URL = \"");
            w_p.write(this.getContext().getBaseURL());
            w_p.write("/js/extjs/resources/images/default/s.gif\";\n");
            w_p.write("Date.monthNames =\n['");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.January", "January"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.February", "February"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.March", "March"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.April", "April"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.May", "May"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.June", "June"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.July", "July"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.August", "August"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.September", "September"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.October", "October"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.November", "November"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.December", "December"));
            w_p.write("'];\nDate.dayNames =\n['");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Sunday", "Sunday"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Monday", "Monday"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Tuesday", "Tuesday"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Wednesday", "Wednesday"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Thursday", "Thursday"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Friday", "Friday"));
            w_p.write("',\n'");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Saturday", "Saturday"));
            w_p.write("'];\n");
            w_p.write("if(Ext.DatePicker){\n");
            w_p.write("   Ext.apply(Ext.DatePicker.prototype, {\n");
            Node fieldManagerNode = ((OwMainAppContext)this.getContext()).getConfiguration().getFieldManagerConfiguration().getNode();
            if (fieldManagerNode != null && (node = OwXMLDOMUtil.getChildNode(fieldManagerNode, "DatePickerStartDay")) != null) {
                String startDay = node.getFirstChild().getNodeValue().trim();
                w_p.write("      startDay : " + startDay + ",\n");
            }
            String dateFormat = OwObjectListViewEXTJSGrid.convertDateFormat(((OwMainAppContext)this.getContext()).getDateFormatString());
            w_p.write("      todayText         : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Today", "Today"));
            w_p.write("\",\n      minText           : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.BeforeMinimumDate", "This date is below the minimum date."));
            w_p.write("\",\n      maxText           : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.AfterMaximumDate", "This date exceeds the maximum date."));
            w_p.write("\",\n      disabledDaysText  : \"\",\n");
            w_p.write("      disabledDatesText : \"\",\n");
            w_p.write("      invalidText:\"\",\n");
            w_p.write("      monthNames        : Date.monthNames,\n");
            w_p.write("      dayNames          : Date.dayNames,\n");
            w_p.write("      nextText          : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.NextMonth", "Next Month (Ctrl+Right)"));
            w_p.write("\",\n      prevText          : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.PreviousMonth", "Previous Month (Ctrl+Left)"));
            w_p.write("\",\n      monthYearText     : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.ChooseMonth", "Select a month (Ctrl+Up/Down to change the years)"));
            w_p.write("\",\n      todayTip          : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.Spacebar", "{0} (space bar)"));
            w_p.write("\",\n      format            : \"");
            w_p.write(dateFormat);
            w_p.write("\"\n   });\n");
            w_p.write("}\n");
            w_p.write("\n");
            w_p.write("if(Ext.form.DateField){\n");
            w_p.write("    Ext.apply(Ext.form.DateField.prototype, {\n");
            w_p.write("    disabledDaysText  : \"\",\n");
            w_p.write("    disabledDatesText : \"\",\n");
            w_p.write("    minText           : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.BeforeMinimumDate", "Dieses Datum ist vor dem Mindestdatum."));
            w_p.write("\",\n    maxText           : \"");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwEditablePropertyDate.AfterMaximumDate", "Dieses Datum ist nach dem Maximaldatum."));
            w_p.write("\",\n    invalidText       : \"\",\n");
            w_p.write("    format            : \"");
            w_p.write(dateFormat);
            w_p.write("\"\n    })\n");
            w_p.write("    }\n");
            w_p.write("</script>\n");
            this.getContext().registerKeyEvent(65, 512, "javascript:ExtjsGrid_SelectAll();", this.getContext().localize("app.OwObjectListView.toggleselectall", "Select/Deselect all"));
            this.getContext().registerKeyEvent(33, 0, "javascript:ExtjsGrid_previousPage();", this.getContext().localize("app.OwObjectListView.shortcutpreviouspage", "Previous page"));
            this.getContext().registerKeyEvent(34, 0, "javascript:ExtjsGrid_nextPage();", this.getContext().localize("app.OwObjectListView.shortcutnextpage", "Next page"));
            this.getContext().registerKeyAction(FIRST_PAGE_ACTION_ID, "javascript:ExtjsGrid_firstPage(e.keyCode,e);", this.getContext().localize("app.OwObjectListView.shortcutfirstpage", "First page"));
            this.getContext().registerKeyAction(LAST_PAGE_ACTION_ID, "javascript:ExtjsGrid_lastPage(e.keyCode,e);", this.getContext().localize("app.OwObjectListView.shortcutlastpage", "Last page"));
            this.getContext().registerKeyEvent(36, 0, "javascript:ExtjsGrid_firstRow();", this.getContext().localize("app.OwObjectListView.shortcutfirstrow", "First row"));
            this.getContext().registerKeyEvent(35, 0, "javascript:ExtjsGrid_lastRow();", this.getContext().localize("app.OwObjectListView.shortcutlastrow", "Last row"));
            for (OwObjectListView.OwPluginEntry p_entry : this.getContextMenuFunction()) {
                if (!this.showsContextMenuPlugin(p_entry.getPlugin())) continue;
                ((OwMainAppContext)this.getContext()).registerPluginKeyEvent(p_entry.m_Plugin.getPluginID(), "javascript:ExtjsGrid_PluginEvent(" + p_entry.m_iIndex + ");", null, p_entry.m_Plugin.getDefaultLabel());
            }
            this.renderMainRegion(w_p);
            ((OwMainAppContext)this.getContext()).addUniqueFinalScript(new OwScript("\nif (usesEXTJSGrid(true)) {\n                  OwObjectListViewEXTJSGrid.init();}\n", 90));
        } else {
            w_p.write("<span id=\"emptyList\"  class=\"OwEmptyTextMessage\">");
            w_p.write(this.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.PagingEmptyMsg", "No items to display"));
            w_p.write("</span>");
        }
    }

    protected void renderMainRegion(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwObjectListViewEXTJSGrid.jsp", w_p);
    }

    public int getStartRow() {
        return this.m_startrow;
    }

    public void onAjaxReadList(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String strSortProperty;
        OwAjaxColumnEntry ace;
        String sParamSort = request_p.getParameter("sort");
        String sParamDir = request_p.getParameter("dir");
        if (sParamSort != null && sParamDir != null && (ace = (OwAjaxColumnEntry)this.m_AjaxColnameToPropertyMap.get(sParamSort)) != null && ace.getFieldColumnInfo() != null && (strSortProperty = ace.getFieldColumnInfo().getPropertyName()) != null) {
            boolean fAsc_p = sParamDir.toLowerCase().equals("asc");
            OwSort.OwSortCriteria lastCrit = this.m_sort.getLastCriteria();
            if (lastCrit == null || !lastCrit.getPropertyName().equals(strSortProperty) || lastCrit.getAscFlag() != fAsc_p) {
                this.m_sort.setCriteria(strSortProperty, fAsc_p);
                if (this.m_ObjectList != null) {
                    this.m_ObjectList.sort(this.m_sort);
                    this.resetPersistedSelectionState();
                }
                if (this.getEventListner() != null) {
                    this.getEventListner().onObjectListViewSort(this.m_sort, strSortProperty);
                }
            }
        }
        int iStart = 0;
        int iEnd = this.m_ObjectList.size();
        String sParamStart = request_p.getParameter("start");
        String sParamLimit = request_p.getParameter("limit");
        try {
            if (sParamStart != null && sParamLimit != null) {
                int iParamStart = Integer.parseInt(sParamStart);
                int iParamLimit = Integer.parseInt(sParamLimit);
                if (iParamStart >= 0 && iParamStart < iEnd) {
                    iStart = iParamStart;
                    iEnd = iStart + iParamLimit < iEnd ? iStart + iParamLimit : iEnd;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_startrow = iStart;
        if (!this.pluginCacheCreated) {
            if (this.getObjectList() != null) {
                this.setPluginCache(this.createPluginStatusCacheUtility(this.m_startrow, this.computeEndIndex(), this.getObjectInstancePluginList()));
            }
        } else {
            this.pluginCacheCreated = false;
        }
        PrintWriter jsonResponseWriter = response_p.getWriter();
        ((Writer)jsonResponseWriter).write("({items:[");
        int rejected = 0;
        for (int i = iStart; i < iEnd; ++i) {
            try {
                StringWriter jsonWriter = new StringWriter(8192);
                OwObject obj = (OwObject)this.m_ObjectList.get(i);
                this.processOccurred(obj);
                obj.getDMSID();
                if (i > iStart) {
                    jsonWriter.write(",");
                }
                jsonWriter.write("{");
                jsonWriter.write("id:" + i);
                jsonWriter.write(",icon_link:");
                try {
                    StringWriter sw = new StringWriter();
                    this.m_MimeManager.insertIconLink(sw, obj);
                    jsonWriter.write(this.encodeJsonString(sw.toString()));
                }
                catch (Exception e) {
                    LOG.debug((Object)"Exception executing insertIconLink of the MimeManager.", (Throwable)e);
                    jsonWriter.write(this.encodeJsonString(null));
                }
                jsonWriter.write(",row_selected:");
                jsonWriter.write(Boolean.toString(this.isObjectSelectionPersisted(i)));
                StringBuilder buf = new StringBuilder("<img src=\"");
                buf.append(this.getContext().getDesignURL());
                try {
                    if (obj.hasVersionSeries() && obj.getVersion().isCheckedOut(1)) {
                        buf.append("/images/checkedout.png\" title=\"");
                        buf.append(this.getContext().localize("app.Checked_out", "Checked out"));
                        buf.append("\" alt=\"");
                        buf.append(this.getContext().localize("app.Checked_out", "Checked out"));
                    } else {
                        buf.append("/images/notcheckedout.png\" alt=\"\" title=\"");
                    }
                }
                catch (Exception e) {
                    buf.append("/images/notcheckedout.png\" alt=\"\" title=\"");
                }
                buf.append("\" class=\"OwVersionState\" />");
                jsonWriter.write(",checkout_icon:");
                jsonWriter.write(this.encodeJsonString(buf.toString()));
                String sVer = "";
                try {
                    if (obj.hasVersionSeries()) {
                        sVer = obj.getVersion().getVersionInfo();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                jsonWriter.write(",version_str:");
                jsonWriter.write(this.encodeJsonString(sVer));
                jsonWriter.write(",locked_icon:");
                buf = new StringBuilder("<img src=\"");
                buf.append(this.getContext().getDesignURL());
                String lockedTooltip = "";
                if (obj.getLock(1)) {
                    lockedTooltip = this.getContext().localize("image.locked", "Item locked");
                    buf.append("/images/locked.png");
                } else {
                    buf.append("/images/notlocked.png");
                }
                buf.append("\" alt=\"");
                buf.append(lockedTooltip);
                buf.append("\" title=\"");
                buf.append(lockedTooltip);
                buf.append("\" class=\"OwLockIcon\" />");
                jsonWriter.write(this.encodeJsonString(buf.toString()));
                String sPlugins = "";
                if (this.hasViewMask(64)) {
                    Collection instancePluginsList = this.getObjectInstancePluginList();
                    try {
                        sPlugins = this.getDocumentInstanceFunctionPluginLinks(obj, i, instancePluginsList);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                jsonWriter.write(",plugin_links:");
                jsonWriter.write(this.encodeJsonString(sPlugins));
                if (this.hasToolTipPattern()) {
                    jsonWriter.write(",tooltip:");
                    String sTooltip = this.getTooltipUrl(obj);
                    jsonWriter.write(this.encodeJsonString(sTooltip));
                }
                OwMimeManager.OwOpenCommand ocmd = this.m_MimeManager.getOpenCommand(obj);
                jsonWriter.write(",default_action:");
                if (null != ocmd) {
                    if (ocmd.canGetScript()) {
                        jsonWriter.write(this.encodeJsonString("javascript:" + ocmd.getScript(1, null, false)));
                    } else {
                        jsonWriter.write(this.encodeJsonString(ocmd.getURL()));
                    }
                } else {
                    jsonWriter.write(this.encodeJsonString(null));
                }
                jsonWriter.write(",default_newwindow:false");
                jsonWriter.write(",row_class_name:" + this.encodeJsonString(this.getRowClassName(i - iStart, obj)));
                for (int ii = 0; ii < this.m_AjaxColumns.size(); ++ii) {
                    OwAjaxColumnEntry ace2 = (OwAjaxColumnEntry)this.m_AjaxColnameToPropertyMap.get(AJAX_PARAM_COLUMN + ii);
                    if (ace2 == null) {
                        throw new OwRenderRowException("OwObjectListViewEXTJSGrid.onAjaxReadList: Invalid column info (column=" + ii + "), OwAjaxColumnEntry is null...");
                    }
                    OwFieldColumnInfo colInfo = ace2.getFieldColumnInfo();
                    if (colInfo.getPropertyName().equals("ow_icon_column")) continue;
                    try {
                        OwProperty prop = obj.getProperty(colInfo.getPropertyName());
                        if (prop.getValue() == null) continue;
                        jsonWriter.write(44);
                        jsonWriter.write(ace2.getColumnName());
                        jsonWriter.write(58);
                        if (ace2.getEditDataType() == 3 && !(prop.getValue() instanceof Date)) {
                            LOG.error((Object)("The item at position " + i + "column: " + ace2.getColumnName() + " has a property named value that is not an instance of java.util.Date class!"));
                            String columnName = ace2.getColumnName();
                            String displayName = ace2.getFieldColumnInfo().getDisplayName(this.getContext().getLocale());
                            if (ace2.getFieldColumnInfo() != null && displayName != null) {
                                columnName = displayName;
                            }
                            throw new OwConfigurationException(this.getContext().localize1("app.OwObjectListViewEXTJSGrid.err.typeConversionFailed", "Property type conversion failed for column %1.", columnName));
                        }
                        jsonWriter.write(this.getEncodedPropertyValue(ace2, prop));
                        continue;
                    }
                    catch (OwObjectNotFoundException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("On rendering property for column: " + ace2.getColumnName() + " the following error occured: "), (Throwable)e);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Cannot render the properties for object at position: " + i + ", property number: " + ii + " column name: " + ace2.getColumnName()), (Throwable)e);
                        response_p.setStatus(500);
                        String errMsg = e.getLocalizedMessage();
                        response_p.getWriter().write(errMsg);
                        return;
                    }
                }
                jsonWriter.write(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
                ((Writer)jsonResponseWriter).write(jsonWriter.getBuffer().toString());
                continue;
            }
            catch (OwRenderRowException e) {
                LOG.debug((Object)(e.getMessage() + " Could not render list element, row rejected!"));
                ++rejected;
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Could not render list element!", (Throwable)e);
                ++rejected;
            }
        }
        ((Writer)jsonResponseWriter).write("],count:");
        ((Writer)jsonResponseWriter).write(Integer.toString(this.m_ObjectList.size() - rejected));
        ((Writer)jsonResponseWriter).write(", isComplete:" + Boolean.toString(this.m_ObjectList.isComplete()));
        ((Writer)jsonResponseWriter).write(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
        ((Writer)jsonResponseWriter).write(")");
    }

    protected String getTooltipUrl(OwObject obj_p) {
        String sTooltip = null;
        if (this.hasToolTipPattern()) {
            StringBuilder tooltipBuilder = new StringBuilder("<div class=\"OwTooltip\">");
            tooltipBuilder.append(this.getToolTipPattern());
            tooltipBuilder.append("</div>");
            try {
                OwString.replaceAll(tooltipBuilder, VIEWER_SERVLET_REPLACE_TOKEN_BASEURL, this.getContext().getBaseURL() + "/");
                OwString.replaceAll(tooltipBuilder, VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL, this.getContext().getServerURL() + "/");
                OwString.replaceAll(tooltipBuilder, VIEWER_SERVLET_REPLACE_TOKEN_DMSID, OwAppContext.encodeURL(obj_p.getDMSID()));
                sTooltip = this.replaceProperties((OwMainAppContext)this.getContext(), tooltipBuilder.toString(), obj_p);
                sTooltip = this.localizeStrings((OwMainAppContext)this.getContext(), sTooltip);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception operating the tooltip for the EXTJSGrid...", (Throwable)e);
                sTooltip = null;
            }
        }
        return sTooltip;
    }

    public void onAjaxPersistSelection(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        this.persistAjaxTriggeredSelection(request_p, response_p, this.m_ObjectList);
    }

    public void onAjaxgetEnumInfo(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String rowStr = request_p.getParameter(AJAX_PARAM_ROW);
        String colStr = request_p.getParameter(AJAX_PARAM_COLUMN);
        int row = Integer.parseInt(rowStr);
        int col = Integer.parseInt(colStr);
        OwAjaxColumnEntry columnEntry = (OwAjaxColumnEntry)this.m_AjaxColumns.get(col);
        OwFieldColumnInfo fieldColumnInfo = columnEntry.getFieldColumnInfo();
        String propertyName = fieldColumnInfo.getPropertyName();
        int rowIndex = row + this.m_startrow;
        StringBuilder jsonWriter = new StringBuilder();
        jsonWriter.append("(");
        jsonWriter.append("{");
        OwObjectCollection objects = this.getObjectList();
        OwObject theObject = (OwObject)objects.get(rowIndex);
        OwObjectClass theClass = theObject.getObjectClass();
        jsonWriter.append("fields:[");
        try {
            OwPropertyClass propertyClass = theClass.getPropertyClass(propertyName);
            if (propertyClass.isEnum()) {
                StringBuffer sEnums = new StringBuffer();
                Iterator it = propertyClass.getEnums().iterator();
                while (it.hasNext()) {
                    if (sEnums.length() > 0) {
                        sEnums.append(",");
                    }
                    OwEnum Item = (OwEnum)it.next();
                    String displayText = Item.getDisplayName(this.getContext().getLocale());
                    String strValue = Item.getValue().toString();
                    String packedValue = "[[" + this.encodeJsonString(strValue) + "," + this.encodeJsonString(displayText) + "]]";
                    sEnums.append("{value:");
                    sEnums.append(this.encodeJsonString(packedValue));
                    sEnums.append(",text:");
                    sEnums.append(this.encodeJsonString(displayText));
                    sEnums.append(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
                }
                jsonWriter.append(sEnums.toString());
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("OwObjectListViewEXTJSGrid.onAjaxgetEnumInfo(): Could not access the property  " + propertyName), (Throwable)e);
        }
        jsonWriter.append(TOOLTIP_BLOCK_TOKEN_PROPERTY_END);
        jsonWriter.append(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
        jsonWriter.append(")");
        response_p.getWriter().write(jsonWriter.toString());
    }

    public void onAjaxgetColumnInfo(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        this.m_AjaxColnameToPropertyMap.clear();
        StringBuilder jsonWriter = new StringBuilder();
        jsonWriter.append("(");
        jsonWriter.append("{");
        jsonWriter.append("field_defs:[");
        OwResource resource = null;
        for (int i = 0; i < this.m_AjaxColumns.size(); ++i) {
            boolean editRequired;
            boolean canEdit;
            int editDataType;
            String propName;
            OwAjaxColumnEntry ace;
            block30: {
                ace = (OwAjaxColumnEntry)this.m_AjaxColumns.get(i);
                OwFieldColumnInfo colInfo = ace.getFieldColumnInfo();
                ace.setColumnName(AJAX_PARAM_COLUMN + i);
                this.m_AjaxColnameToPropertyMap.put(ace.getColumnName(), ace);
                propName = colInfo.getPropertyName();
                if (i > 0) {
                    jsonWriter.append(",");
                }
                if (propName.equals("ow_icon_column")) {
                    jsonWriter.append("{id:\"");
                    jsonWriter.append(ace.getColumnName());
                    jsonWriter.append("\",display_name:\"ow_icon_column\",");
                    if (ace.m_iColumnWidth == -1 || !this.m_columnsModifiedByUser) {
                        int proposedWidth = this.getPluginCache().getMaximumNumberOfIcons();
                        ace.m_iColumnWidth = proposedWidth;
                        jsonWriter.append("calculate:true,");
                    }
                    jsonWriter.append("proposed_width:");
                    jsonWriter.append(Integer.toString(ace.m_iColumnWidth));
                    jsonWriter.append(",can_edit:false,can_filter:false,filter_active:false,sortable:");
                    jsonWriter.append(Boolean.toString(colInfo.isSortable()));
                    jsonWriter.append(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
                    continue;
                }
                jsonWriter.append("{id:\"");
                jsonWriter.append(ace.getColumnName());
                jsonWriter.append("\",display_name:");
                jsonWriter.append(this.encodeJsonString(colInfo.getDisplayName(this.getContext().getLocale())));
                jsonWriter.append(",proposed_width:" + ace.getColumnWidth());
                jsonWriter.append(",sortable:" + colInfo.isSortable());
                OwSort.OwSortCriteria lastSortingCriteria = this.m_sort.getLastCriteria();
                if (lastSortingCriteria != null && lastSortingCriteria.getPropertyName() != null && lastSortingCriteria.getPropertyName().equals(propName) && ace.getFieldColumnInfo().isSortable()) {
                    jsonWriter.append(",sort_dir:\"");
                    jsonWriter.append(lastSortingCriteria.getAscFlag() ? "ASC" : "DESC");
                    jsonWriter.append("\"");
                }
                OwPropertyClass colPropClass = null;
                try {
                    colPropClass = (OwPropertyClass)((OwMainAppContext)this.getContext()).getNetwork().getFieldDefinition(propName, resource == null ? null : resource.getID());
                }
                catch (OwObjectNotFoundException nfex) {
                    LOG.info((Object)("OwObjectListViewExt.onAjaxgetColumnInfo: Property not found " + propName + ", search in other sources!"));
                    OwMainAppContext context = (OwMainAppContext)this.getContext();
                    Iterator itRes = context.getNetwork().getResourceIDs();
                    while (itRes != null && itRes.hasNext() && colPropClass == null) {
                        try {
                            resource = context.getNetwork().getResource(itRes.next().toString());
                            colPropClass = (OwPropertyClass)context.getNetwork().getFieldDefinition(propName, resource.getID());
                        }
                        catch (OwObjectNotFoundException ex) {}
                    }
                }
                catch (Exception cce) {
                    // empty catch block
                }
                editDataType = -1;
                canEdit = false;
                editRequired = false;
                if (colPropClass != null) {
                    try {
                        canEdit = this.isPropertyEditable(colPropClass);
                        if (!canEdit) break block30;
                        editRequired = colPropClass.isRequired();
                        editDataType = this.getColumnDataType(colPropClass);
                        switch (editDataType) {
                            case 1: {
                                Number maxval = null;
                                Integer minval = null;
                                try {
                                    maxval = (Integer)colPropClass.getMaxValue();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    minval = (Integer)colPropClass.getMinValue();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                jsonWriter.append(",edit_maxvalue:");
                                jsonWriter.append(maxval == null ? "null" : ((Integer)maxval).toString());
                                jsonWriter.append(",edit_minvalue:");
                                jsonWriter.append(minval == null ? "null" : minval.toString());
                                break;
                            }
                            case 4: {
                                Number maxval = null;
                                Double minval = null;
                                try {
                                    maxval = (Double)colPropClass.getMaxValue();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    minval = (Double)colPropClass.getMinValue();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                jsonWriter.append(",edit_maxvalue:");
                                jsonWriter.append(maxval == null ? "null" : ((Double)maxval).toString());
                                jsonWriter.append(",edit_minvalue:");
                                jsonWriter.append(minval == null ? "null" : minval.toString());
                                break;
                            }
                            case 5: {
                                String getEnumInfoURL = this.getAjaxEventURL("getEnumInfo", null);
                                jsonWriter.append(",enum_info_url:");
                                jsonWriter.append(this.encodeJsonString(getEnumInfoURL));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            ace.setEditDataType(editDataType);
            boolean canFilter = false;
            boolean filterActive = false;
            try {
                filterActive = this.getFilter().getFilterEntry(propName).isActive();
                canFilter = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            jsonWriter.append(",can_edit:");
            jsonWriter.append(Boolean.toString(canEdit));
            jsonWriter.append(",can_filter:");
            jsonWriter.append(Boolean.toString(canFilter));
            jsonWriter.append(",filter_active:");
            jsonWriter.append(Boolean.toString(filterActive));
            jsonWriter.append(",edit_datatype:");
            jsonWriter.append(Integer.toString(editDataType));
            jsonWriter.append(",edit_required:");
            jsonWriter.append(Boolean.toString(editRequired));
            String tooltipMessage = "";
            if (ace.getFieldColumnInfo() != null && ace.getFieldColumnInfo().getDisplayName(this.getContext().getLocale()) != null) {
                tooltipMessage = this.getContext().localize1("app.dmsdialogs.OwObjectListViewFilterRow.filtersettingstootlip", "Filter settings for %1", ace.getFieldColumnInfo().getDisplayName(this.getContext().getLocale()));
            }
            jsonWriter.append(",filter_tooltip:");
            jsonWriter.append(this.encodeJsonString(tooltipMessage));
            jsonWriter.append(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
        }
        jsonWriter.append("],count:");
        jsonWriter.append(Integer.toString(this.m_AjaxColumns.size()));
        jsonWriter.append("})");
        response_p.getWriter().write(jsonWriter.toString());
    }

    public void onAjaxsetColumnInfo(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String sParamColumnInfo = request_p.getParameter("columninfo");
        if (sParamColumnInfo == null || this.getColumnInfo() == null) {
            return;
        }
        String[] cols = sParamColumnInfo.split(",");
        this.m_AjaxColumns.clear();
        String attributeBagName = this.getAttributeBagName();
        String persistedeAttribute = (String)this.getColumnsAttributeBag().getSafeAttribute(attributeBagName, "");
        OwColumnInfoBagValue columnInfoBagValue = new OwColumnInfoBagValue(persistedeAttribute);
        HashSet<String> headers = new HashSet<String>();
        for (int i = 0; i < cols.length; ++i) {
            int colwidth;
            OwAjaxColumnEntry ace;
            block10: {
                String[] col_params = cols[i].split("=");
                if (col_params.length != 2 || (ace = (OwAjaxColumnEntry)this.m_AjaxColnameToPropertyMap.get(col_params[0])) == null) continue;
                colwidth = 100;
                try {
                    colwidth = Integer.parseInt(col_params[1]);
                }
                catch (NumberFormatException e) {
                    colwidth = 100;
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug((Object)("The parameter \"columninfo\" contains an invalid value for the colwidth, value=" + col_params[1] + ". Expected was a numeric value. Set the colwidth to default value=" + colwidth), (Throwable)e);
                }
            }
            if (colwidth > 500) {
                colwidth = 500;
            }
            if (colwidth < 5) {
                colwidth = 5;
            }
            ace.setColumnWidth(colwidth);
            this.m_AjaxColumns.add(ace);
            OwFieldColumnInfo aceColumnInfo = ace.getFieldColumnInfo();
            String propertyName = aceColumnInfo.getPropertyName();
            if (!headers.contains("")) {
                columnInfoBagValue.clearDefaultHeader();
                headers.add("");
            }
            columnInfoBagValue.put(propertyName, colwidth);
        }
        OwAttributeBagWriteable ab = this.getColumnsAttributeBag();
        String attValue = columnInfoBagValue.toString();
        ab.setAttribute(attributeBagName, attValue);
        ab.save();
        this.m_columnsModifiedByUser = true;
        if (LOG.isDebugEnabled()) {
            if (this.isExtjsColumnPersistent()) {
                LOG.debug((Object)("Set persistent ExtJS column info: length=" + attValue.length() + ", bagName='" + attributeBagName + "', value='" + attValue + "'"));
            } else {
                LOG.debug((Object)("Set non-persistent ExtJS column info: length=" + attValue.length() + ", bagName='" + attributeBagName + "', value='" + attValue + "'"));
            }
        }
    }

    private String getAttributeBagName() {
        OwFieldColumnInfo columnInfo = (OwFieldColumnInfo)this.getColumnInfo().iterator().next();
        String attBag = COLUMNS_ID_ATTR_BAG;
        String headerId = null;
        if (columnInfo instanceof OwHeaderFieldColumnInfo) {
            headerId = ((OwHeaderFieldColumnInfo)columnInfo).getHeaderID();
            attBag = attBag + "_" + headerId;
        }
        return attBag;
    }

    private boolean isExtjsColumnPersistent() {
        OwMainAppContext mainAppContext = (OwMainAppContext)this.getContext();
        OwConfiguration configuration = mainAppContext.getConfiguration();
        OwXMLUtil bootstrap = configuration.getBootstrapConfiguration();
        return bootstrap.getSafeBooleanValue(STORE_EXTJS_COLUMN_INFO_ELEMENT_NAME, false);
    }

    private synchronized OwAttributeBagWriteable getColumnsAttributeBag() throws Exception {
        if (!this.isExtjsColumnPersistent()) {
            OwTransientBagRepository transientBagRepository = OwTransientBagRepository.getInstance();
            OwBaseUserInfo userInfo = ((OwMainAppContext)this.getContext()).getUserInfo();
            String userId = userInfo.getUserID();
            OwSimpleAttributeBagWriteable nonPersistentAttributebag = transientBagRepository.getBag(userId, NONPERSISTENT_COLUMN_ATTRIBUTE_BAG);
            return nonPersistentAttributebag;
        }
        return this.getDocument().getPersistentAttributeBagWriteable();
    }

    private void buildAjaxColumns() {
        if (this.getColumnInfo() == null) {
            return;
        }
        String sPersistence = "";
        OwColumnInfoBagValue columnInfoBag = new OwColumnInfoBagValue();
        try {
            String attributeBagName = this.getAttributeBagName();
            sPersistence = (String)this.getColumnsAttributeBag().getSafeAttribute(attributeBagName, "");
            columnInfoBag = new OwColumnInfoBagValue(sPersistence);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("buildilng Ajax Columns attributeBag = " + attributeBagName + " info = " + sPersistence));
            }
        }
        catch (Exception e1) {
            LOG.error((Object)"OwObjectListViewEXTJSGrid exception reading attributebag column settings", (Throwable)e1);
        }
        LinkedList<OwIconFieldColumnInfo> columnInfoCopy = new LinkedList<OwIconFieldColumnInfo>(this.m_ColumnInfoList);
        this.m_AjaxColumns.clear();
        boolean persistedIconsWidth = false;
        boolean bl = persistedIconsWidth = columnInfoBag.widthOf("ow_icon_column") != null;
        if (persistedIconsWidth) {
            columnInfoCopy.add(ICON_FIELD_COLUMN_INFO);
        } else {
            this.m_AjaxColumns.add(new OwAjaxColumnEntry(ICON_FIELD_COLUMN_INFO, -1, AJAX_PARAM_COLUMN + Integer.toString(0)));
        }
        TreeMap<Integer, OwAjaxColumnEntry> map = new TreeMap<Integer, OwAjaxColumnEntry>();
        for (int i = 0; i < columnInfoCopy.size(); ++i) {
            Integer width;
            OwFieldColumnInfo columnInfo = (OwFieldColumnInfo)columnInfoCopy.get(i);
            String columnXML = columnInfo.getPropertyName();
            Integer index = columnInfoBag.indexOf(columnXML);
            if (index == null || (width = columnInfoBag.widthOf(columnXML)) == null) continue;
            OwAjaxColumnEntry ajaxColumnEntry = new OwAjaxColumnEntry(columnInfo, width, columnXML);
            map.put(index, ajaxColumnEntry);
        }
        for (Map.Entry entry : map.entrySet()) {
            String column = ((OwAjaxColumnEntry)entry.getValue()).getColumnName();
            Integer colwidth = ((OwAjaxColumnEntry)entry.getValue()).getColumnWidth();
            if (colwidth == null) continue;
            if (column != null && this.isNoteProperty(column)) {
                colwidth = 235;
            }
            if (colwidth < 5) {
                colwidth = 5;
            }
            if (colwidth > 500) {
                colwidth = 500;
            }
            this.m_AjaxColumns.add(new OwAjaxColumnEntry(((OwAjaxColumnEntry)entry.getValue()).getFieldColumnInfo(), colwidth, AJAX_PARAM_COLUMN + this.m_AjaxColumns.size()));
            columnInfoCopy.remove(((OwAjaxColumnEntry)entry.getValue()).getFieldColumnInfo());
        }
        for (int ii = 0; ii < columnInfoCopy.size(); ++ii) {
            OwFieldColumnInfo ci = (OwFieldColumnInfo)columnInfoCopy.get(ii);
            int width = 100;
            if (ci.getPropertyName() != null && this.isNoteProperty(ci.getPropertyName())) {
                width = 235;
            }
            this.m_AjaxColumns.add(new OwAjaxColumnEntry(ci, width, AJAX_PARAM_COLUMN + this.m_AjaxColumns.size()));
        }
    }

    protected boolean showsContextMenuPlugin(OwDocumentFunction docFunction_p) {
        boolean isParentEnabled = !docFunction_p.getNeedParent() || this.getParentObject() != null;
        return isParentEnabled && this.isObjectTypeSupportedByPlugin(docFunction_p, this.occuringObjectTypes);
    }

    public void onAjaxgetContextmenu(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        int iItemCount = 0;
        PrintWriter jsonWriter = response_p.getWriter();
        jsonWriter.write("(");
        jsonWriter.write("{");
        jsonWriter.write("menu_items:[");
        for (OwObjectListView.OwPluginEntry p_entry : this.getContextMenuFunction()) {
            OwDocumentFunction docFunction = p_entry.getPlugin();
            if (!this.showsContextMenuPlugin(docFunction)) continue;
            String sPluginDisplayName = docFunction.getDefaultLabel();
            String sPluginIconUrl = docFunction.getIcon();
            if (iItemCount > 0) {
                jsonWriter.write(",");
            }
            jsonWriter.write("{id:");
            jsonWriter.write(Integer.toString(p_entry.getIndex()));
            jsonWriter.write(",display_name:");
            jsonWriter.write(this.encodeJsonString(sPluginDisplayName));
            jsonWriter.write(",icon_url:");
            jsonWriter.write(this.encodeJsonString(sPluginIconUrl));
            jsonWriter.write(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
            ++iItemCount;
        }
        jsonWriter.write("],count:");
        jsonWriter.write(Integer.toString(iItemCount));
        jsonWriter.write(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END);
        jsonWriter.write(")");
    }

    public void onAjaxsetCellData(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String sParamRow = request_p.getParameter(AJAX_PARAM_ROW);
        String sParamCol = request_p.getParameter(AJAX_PARAM_COLUMN);
        String sParamValue = request_p.getParameter("value");
        if (sParamRow == null || sParamCol == null || sParamValue == null) {
            response_p.setStatus(500);
            String errMsg = OwString.localize(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.missingParams", "Parameters missing.");
            response_p.getWriter().write(errMsg);
            return;
        }
        OwAjaxColumnEntry ace = (OwAjaxColumnEntry)this.m_AjaxColnameToPropertyMap.get(sParamCol);
        if (ace == null || ace.getFieldColumnInfo() == null) {
            response_p.setStatus(500);
            String errMsg = OwString.localize(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.invalidColumn", "Invalid column.");
            response_p.getWriter().write(errMsg);
            return;
        }
        String sPropertyName = ace.getFieldColumnInfo().getPropertyName();
        if (sPropertyName == null) {
            response_p.setStatus(500);
            String errMsg = OwString.localize(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.noColumnProp", "Column has no property name.");
            response_p.getWriter().write(errMsg);
            return;
        }
        OwProperty prop = null;
        OwObject obj = null;
        OwFieldDefinition fieldDef = null;
        try {
            obj = (OwObject)this.m_ObjectList.get(Integer.parseInt(sParamRow));
            prop = obj.getProperty(sPropertyName);
            if (prop == null) {
                String msg = OwString.localize(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.nullProp", "OwObjectListViewEXTJSGrid.onAjaxsetCellData: Cannot resolve the property, is null.");
                LOG.error((Object)msg);
                response_p.setStatus(500);
                response_p.getWriter().write(msg);
                return;
            }
            fieldDef = prop.getFieldDefinition();
            if (fieldDef == null) {
                String msg = OwString.localize(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.nullFieldDef", "OwObjectListViewEXTJSGrid.onAjaxsetCellData: Cannot resolve the fieldDef, is null.");
                LOG.error((Object)msg);
                response_p.setStatus(500);
                response_p.getWriter().write(msg);
                return;
            }
        }
        catch (Exception e) {
            String msg = OwString.localize(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.resolveError", "Error resolving object and property.");
            LOG.error((Object)msg, (Throwable)e);
            response_p.setStatus(500);
            response_p.getWriter().write(msg + e);
            return;
        }
        Object dataObject = null;
        if (sParamValue.length() > 0) {
            String strJavaClassName = fieldDef.getJavaClassName();
            if (strJavaClassName.equalsIgnoreCase("java.util.Date")) {
                try {
                    GregorianCalendar calendar = new GregorianCalendar();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    sdf.setLenient(false);
                    calendar.setTime(sdf.parse(sParamValue));
                    dataObject = calendar.getTime();
                }
                catch (Exception e) {
                    response_p.setStatus(500);
                    String errMsg = OwString.localize1(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.conversionErrorDate", "Error converting new value into date format: %1", e.toString());
                    response_p.getWriter().write(errMsg);
                    return;
                }
            }
            if (strJavaClassName.equalsIgnoreCase("java.lang.Boolean")) {
                try {
                    dataObject = Boolean.valueOf(sParamValue);
                }
                catch (Exception e) {
                    response_p.setStatus(500);
                    String errMsg = OwString.localize1(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.conversionErrorBool", "Error converting new value into boolean format: %1", e.toString());
                    response_p.getWriter().write(errMsg);
                    return;
                }
            }
            try {
                Class<?> newClass = Class.forName(strJavaClassName);
                Constructor<?> constr = newClass.getConstructor(String.class);
                dataObject = constr.newInstance(sParamValue);
            }
            catch (Throwable t) {
                response_p.setStatus(500);
                String errMsg = OwString.localize2(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.conversionError", "Error converting new value into %1: %2", strJavaClassName, t.toString());
                response_p.getWriter().write(errMsg);
                return;
            }
        }
        if (dataObject == null && prop.getPropertyClass().isRequired()) {
            response_p.setStatus(500);
            String errMsg = OwString.localize(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.nullDataObject", "Data object is null for an required property.");
            response_p.getWriter().write(errMsg);
            return;
        }
        try {
            String content;
            String propClassName = prop.getPropertyClass().getClassName();
            if (propClassName != null && this.isNoteProperty(propClassName) && (content = (String)dataObject).length() > 0) {
                OwFieldManagerControlNote.OwNoteDataModel noteDataModel = new OwFieldManagerControlNote.OwNoteDataModel(this.getContext().getLocale(), (String)prop.getValue());
                if (fieldDef.getMaxValue() != null) {
                    noteDataModel.setMaxSize((Integer)fieldDef.getMaxValue());
                }
                String currentUser = ((OwMainAppContext)this.getContext()).getNetwork().getCredentials().getUserInfo().getUserLongName();
                SimpleDateFormat dateFormat = new SimpleDateFormat(((OwMainAppContext)this.getContext()).getDateFormatString());
                String timestamp = dateFormat.format(new Date());
                OwFieldManagerControlNote.OwNote note = new OwFieldManagerControlNote.OwNote(this.getContext().getLocale(), currentUser, timestamp, content);
                noteDataModel.appendNote(note);
                dataObject = noteDataModel.getTrimmedText();
            }
            prop.setValue(dataObject);
            OwStandardPropertyCollection changedProperties = new OwStandardPropertyCollection();
            changedProperties.put(prop.getFieldDefinition().getClassName(), prop);
            obj.setProperties(changedProperties);
            if (propClassName != null && this.isNoteProperty(propClassName)) {
                this.m_FieldManager.insertReadOnlyField(response_p.getWriter(), prop);
            }
        }
        catch (Exception e) {
            response_p.setStatus(500);
            String errMsg = OwString.localize1(this.getContext().getLocale(), "app.OwObjectListViewEXTJSGrid.err.assignError", "Error assigning new value: %1", e.toString());
            response_p.getWriter().write(errMsg);
            return;
        }
        response_p.setStatus(200);
    }

    public void onPluginEvent(HttpServletRequest request_p) throws Exception {
        String strObjectIndices = request_p.getParameter(OBJECT_INDEX_KEY);
        String strPlugIndex = request_p.getParameter(PLUG_INDEX_KEY);
        if (strObjectIndices != null && strPlugIndex != null) {
            String[] sObjects = strObjectIndices.split(",");
            ArrayList objects = new ArrayList();
            for (int i = 0; i < sObjects.length; ++i) {
                try {
                    objects.add(this.m_ObjectList.get(Integer.parseInt(sObjects[i])));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int iPlugIndex = Integer.parseInt(strPlugIndex);
            OwDocumentFunction plugIn = this.getDocumentFunction(iPlugIndex);
            if (objects.size() == 1) {
                plugIn.onClickEvent((OwObject)objects.get(0), this.getParentObject(), this.m_RefreshContext);
            } else {
                if (!plugIn.getMultiselect()) {
                    throw new OwUserOperationException(new OwString1("app.OwObjectListViewEXTJSGrid.onlysingleselectfunction", "Function %1 can only be applied to one object.", plugIn.getDefaultLabel()));
                }
                OwMultipleSelectionCall multiCall = new OwMultipleSelectionCall(plugIn, objects, this.getParentObject(), this.m_RefreshContext, (OwMainAppContext)this.getContext());
                multiCall.invokeFunction();
            }
        }
    }

    protected String encodeJsonString(String in_p) {
        if (null == in_p) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        block9: for (int i = 0; i < in_p.length(); ++i) {
            char c = in_p.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append('\\').append('\\');
                    continue block9;
                }
                case '\b': {
                    sb.append('\\').append('b');
                    continue block9;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    continue block9;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    continue block9;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    continue block9;
                }
                case '\t': {
                    sb.append('\\').append('t');
                    continue block9;
                }
                case '\"': {
                    sb.append('\\').append('\"');
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private static int minPositiveIndex(int[] indexes_p) {
        int min = -1;
        for (int i = 0; i < indexes_p.length; ++i) {
            if (indexes_p[i] <= -1) continue;
            if (min == -1) {
                min = indexes_p[i];
                continue;
            }
            if (min <= indexes_p[i]) continue;
            min = indexes_p[i];
        }
        return min;
    }

    private int replacePropertyBlock(OwMainAppContext context_p, StringBuilder blockBuffer_p, String strIn_p, int index_p, OwObjectReference obj_p) throws Exception {
        int endTokenIndex;
        int startTokenIndex;
        int iOldIndex = index_p;
        int propIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START, iOldIndex);
        int iIndex = OwObjectListViewEXTJSGrid.minPositiveIndex(new int[]{propIndex, startTokenIndex = strIn_p.indexOf(TOOLTIP_BLOCK_TOKEN_PROPERTY_START, iOldIndex), endTokenIndex = strIn_p.indexOf(TOOLTIP_BLOCK_TOKEN_PROPERTY_END, iOldIndex)});
        if (-1 == iIndex) {
            String block = strIn_p.substring(iOldIndex);
            blockBuffer_p.append(OwHTMLHelper.encodeToSecureHTML(block));
            return strIn_p.length();
        }
        while (-1 != iIndex) {
            String blockPart = strIn_p.substring(iOldIndex, iIndex);
            blockBuffer_p.append(OwHTMLHelper.encodeToSecureHTML(blockPart));
            if (propIndex == iIndex) {
                OwObject obj = obj_p.getInstance();
                ++iIndex;
                int iEnd = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END, iIndex += VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START.length());
                String strPropName = strIn_p.substring(iIndex, iEnd);
                String propertyString = null;
                try {
                    OwProperty property = obj.getProperty(strPropName);
                    StringWriter stringWriter = new StringWriter();
                    this.m_FieldManager.insertReadOnlyField(stringWriter, property);
                    propertyString = OwHTMLHelper.encodeToSecureHTML(stringWriter.toString());
                }
                catch (Exception e) {
                    blockBuffer_p.replace(0, blockBuffer_p.length(), "");
                    while (iIndex < strIn_p.length() && strIn_p.charAt(iIndex) != ']') {
                        ++iIndex;
                    }
                    return iIndex;
                }
                if (propertyString != null) {
                    char encodeTokenChar = strIn_p.charAt(iIndex - 1);
                    if (encodeTokenChar == ':') {
                        blockBuffer_p.append(OwHTMLHelper.encodeToSecureHTML(propertyString));
                    } else if (encodeTokenChar == '~') {
                        blockBuffer_p.append(OwHTMLHelper.encodeJavascriptString(propertyString));
                    } else {
                        blockBuffer_p.append(propertyString);
                    }
                }
                iOldIndex = iIndex = iEnd + 1;
            } else if (startTokenIndex == iIndex) {
                ++iIndex;
                StringBuilder subBlock = new StringBuilder();
                iIndex = this.replacePropertyBlock(context_p, subBlock, strIn_p, iIndex, obj_p);
                blockBuffer_p.append((CharSequence)subBlock);
                iOldIndex = iIndex;
            } else if (endTokenIndex == iIndex) {
                if (iOldIndex <= iIndex) {
                    String nonTokenRest = strIn_p.substring(iOldIndex, iIndex);
                    blockBuffer_p.append(OwHTMLHelper.encodeToSecureHTML(nonTokenRest));
                }
                return ++iIndex;
            }
            propIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START, iIndex);
            startTokenIndex = strIn_p.indexOf(TOOLTIP_BLOCK_TOKEN_PROPERTY_START, iIndex);
            endTokenIndex = strIn_p.indexOf(TOOLTIP_BLOCK_TOKEN_PROPERTY_END, iIndex);
            iIndex = OwObjectListViewEXTJSGrid.minPositiveIndex(new int[]{propIndex, startTokenIndex, endTokenIndex});
        }
        if (iOldIndex <= strIn_p.length()) {
            String nonTokenRest = strIn_p.substring(iOldIndex, strIn_p.length());
            blockBuffer_p.append(OwHTMLHelper.encodeToSecureHTML(nonTokenRest));
        }
        return strIn_p.length();
    }

    private String localizeStrings(OwMainAppContext context_p, String strIn_p) throws Exception {
        StringBuilder stringOut = new StringBuilder();
        String[] result = strIn_p.split("\\{localizedString");
        String prefix = result[0].substring(0, result[0].length());
        stringOut.append(prefix);
        for (int x = 1; x < result.length; ++x) {
            int sufixBegin = result[x].indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END) + 1;
            String temp = result[x].substring(1, sufixBegin).trim();
            String sufix = result[x].substring(sufixBegin, result[x].length());
            int endId = temp.indexOf(",");
            String strKey = temp.substring(0, endId);
            String dfValue = temp.substring(endId + 1, temp.length() - 1);
            String localizedString = OwString.localize(context_p.getLocale(), strKey, dfValue);
            stringOut.append(localizedString);
            stringOut.append(sufix);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("localizedString:" + stringOut));
        }
        return stringOut.toString();
    }

    private String replaceProperties(OwMainAppContext context_p, String strIn_p, OwObjectReference obj_p) throws Exception {
        StringBuilder stringOut = new StringBuilder();
        this.replacePropertyBlock(context_p, stringOut, strIn_p, 0, obj_p);
        return stringOut.toString();
    }

    public static String convertDateFormat(String javaSimpleDateFormat_p) {
        StringBuilder sPhpDateFormat = new StringBuilder();
        int iPos = 0;
        while (iPos < javaSimpleDateFormat_p.length()) {
            int iNextPatternStartPos;
            char cCurrentPattern = javaSimpleDateFormat_p.charAt(iPos);
            for (iNextPatternStartPos = iPos; iNextPatternStartPos < javaSimpleDateFormat_p.length() && javaSimpleDateFormat_p.charAt(iNextPatternStartPos) == cCurrentPattern; ++iNextPatternStartPos) {
            }
            int iPatternLength = iNextPatternStartPos - iPos;
            switch (cCurrentPattern) {
                case 'G': {
                    sPhpDateFormat.append("\\A\\D");
                    break;
                }
                case 'y': {
                    if (iPatternLength <= 2) {
                        sPhpDateFormat.append('y');
                        break;
                    }
                    sPhpDateFormat.append('Y');
                    break;
                }
                case 'M': {
                    if (iPatternLength <= 1) {
                        sPhpDateFormat.append('n');
                        break;
                    }
                    sPhpDateFormat.append('m');
                    break;
                }
                case 'w': {
                    sPhpDateFormat.append('W');
                    break;
                }
                case 'W': {
                    break;
                }
                case 'D': {
                    sPhpDateFormat.append('z');
                    break;
                }
                case 'd': {
                    if (iPatternLength <= 1) {
                        sPhpDateFormat.append('j');
                        break;
                    }
                    sPhpDateFormat.append('d');
                    break;
                }
                case 'F': {
                    sPhpDateFormat.append('w');
                    break;
                }
                case 'E': {
                    if (iPatternLength <= 3) {
                        sPhpDateFormat.append('D');
                        break;
                    }
                    sPhpDateFormat.append('l');
                    break;
                }
                case 'a': {
                    sPhpDateFormat.append('A');
                    break;
                }
                case 'H': {
                    if (iPatternLength <= 1) {
                        sPhpDateFormat.append('G');
                        break;
                    }
                    sPhpDateFormat.append('H');
                    break;
                }
                case 'k': {
                    break;
                }
                case 'K': {
                    if (iPatternLength <= 1) {
                        sPhpDateFormat.append('g');
                        break;
                    }
                    sPhpDateFormat.append('h');
                    break;
                }
                case 'h': {
                    break;
                }
                case 'm': {
                    sPhpDateFormat.append('i');
                    break;
                }
                case 's': {
                    sPhpDateFormat.append('s');
                    break;
                }
                case 'S': {
                    break;
                }
                case 'z': {
                    sPhpDateFormat.append('T');
                    break;
                }
                case 'Z': {
                    sPhpDateFormat.append('O');
                    break;
                }
                case '\'': {
                    int iNextPatternAfterString;
                    if (iPatternLength == 2) {
                        sPhpDateFormat.append('\'');
                        break;
                    }
                    for (iNextPatternAfterString = iPos + 1; iNextPatternAfterString < javaSimpleDateFormat_p.length(); ++iNextPatternAfterString) {
                        char cStringChar = javaSimpleDateFormat_p.charAt(iNextPatternAfterString);
                        if (cStringChar == '\'') {
                            if (iNextPatternAfterString + 1 >= javaSimpleDateFormat_p.length() || javaSimpleDateFormat_p.charAt(iNextPatternAfterString) != '\'') break;
                            sPhpDateFormat.append('\'');
                            ++iNextPatternAfterString;
                            continue;
                        }
                        if (OwObjectListViewEXTJSGrid.isPhpSpecialChar(cStringChar)) {
                            sPhpDateFormat.append('\\');
                            sPhpDateFormat.append(cStringChar);
                            continue;
                        }
                        sPhpDateFormat.append(cStringChar);
                    }
                    iNextPatternStartPos = iNextPatternAfterString;
                    break;
                }
                default: {
                    int i;
                    if (OwObjectListViewEXTJSGrid.isPhpSpecialChar(cCurrentPattern)) {
                        for (i = 0; i < iPatternLength; ++i) {
                            sPhpDateFormat.append('\\');
                            sPhpDateFormat.append(cCurrentPattern);
                        }
                    } else {
                        for (i = 0; i < iPatternLength; ++i) {
                            sPhpDateFormat.append(cCurrentPattern);
                        }
                    }
                }
            }
            iPos = iNextPatternStartPos;
        }
        return sPhpDateFormat.toString();
    }

    public static boolean isPhpSpecialChar(char testChar_p) {
        for (int i = 0; i < SPECIAL_CHARS.length; ++i) {
            if (SPECIAL_CHARS[i] != testChar_p) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.title", "Adaptable List");
    }

    @Override
    public String getIcon() throws Exception {
        return "/images/OwObjectListView/OwObjectListViewEXTJSGrid.png";
    }

    @Override
    public Collection getColumnInfo() {
        return this.m_ColumnInfoList;
    }

    @Override
    public int getCount() {
        if (this.m_ObjectList != null) {
            return this.m_ObjectList.size();
        }
        return 0;
    }

    @Override
    public OwFieldManager getFieldManager() {
        return this.m_FieldManager;
    }

    @Override
    public void setFieldManager(OwFieldManager fielmanager_p) {
        this.m_FieldManager = fielmanager_p;
    }

    @Override
    public OwObjectCollection getObjectList() {
        return this.m_ObjectList;
    }

    @Override
    protected OwClientRefreshContext getRefreshContext() {
        return this.m_RefreshContext;
    }

    @Override
    public Collection getRetrievalPropertyNames() throws Exception {
        if (null == this.m_ColumnInfoList) {
            throw new OwInvalidOperationException("OwObjectListViewEXTJSGrid.getRetrievalPropertyNames: Specify setColumnInfo() in OwObjectList.");
        }
        HashSet<String> retList = new HashSet<String>();
        for (OwFieldColumnInfo colInfo : this.m_ColumnInfoList) {
            retList.add(colInfo.getPropertyName());
        }
        if (this.hasViewMask(64)) {
            for (OwObjectListView.OwPluginEntry entry : this.getObjectInstancePluginList()) {
                Collection props = entry.m_Plugin.getRetrievalPropertyNames();
                if (null == props) continue;
                retList.addAll(props);
            }
        }
        return retList;
    }

    @Override
    public OwSort getSort() {
        return this.m_sort;
    }

    protected String getRowClassName(int iIndex_p, OwObject obj_p) {
        try {
            return this.getEventListner().onObjectListViewGetRowClassName(iIndex_p, obj_p).toString();
        }
        catch (Exception e) {
            return iIndex_p % 2 != 0 ? "x-grid-row-alt" : "";
        }
    }

    @Override
    public void setColumnInfo(Collection columnInfo_p) {
        this.m_ColumnInfoList = columnInfo_p;
        this.buildAjaxColumns();
    }

    @Override
    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception {
        this.m_ObjectList = objectList_p;
        this.setParentObject(parentObject_p);
        if (objectList_p != null) {
            this.m_MimeManager.setParent(parentObject_p);
            this.recreateOccuredHashSet();
            if (this.m_startrow >= this.m_ObjectList.size()) {
                int lastPage = this.getPageCount() - 1;
                int iPageSize = ((OwMainAppContext)this.getContext()).getPageSizeForLists();
                this.m_startrow = lastPage * iPageSize;
            }
        }
        this.resetPersistedSelectionState();
    }

    @Override
    protected void pageAbsolut(int page_p) throws Exception {
        int iPageSize = ((OwMainAppContext)this.getContext()).getPageSizeForLists();
        this.m_startrow = page_p * iPageSize;
    }

    @Override
    public int getPageCount() throws Exception {
        if (this.m_ObjectList == null) {
            return 1;
        }
        return (this.m_ObjectList.size() - 1) / ((OwMainAppContext)this.getContext()).getPageSizeForLists() + 1;
    }

    @Override
    public int getCurrentPage() {
        int iPageSize = ((OwMainAppContext)this.getContext()).getPageSizeForLists();
        return this.m_startrow / iPageSize;
    }

    public boolean getShowPaging() throws Exception {
        return this.getPageCount() > 1;
    }

    @Override
    public void setRefreshContext(OwClientRefreshContext eventlister_p) {
        this.m_RefreshContext = eventlister_p;
        this.m_MimeManager.setRefreshContext(eventlister_p);
    }

    @Override
    public void setSort(OwSort sort_p) {
        this.m_sort = sort_p;
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        throw new OwObjectNotFoundException("OwObjectListViewEXTJSGrid.getField: Not implemented or Not supported.");
    }

    @Override
    public String getFieldProviderName() {
        try {
            return this.getParentObject().getName();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public Object getFieldProviderSource() {
        return this.m_ObjectList;
    }

    @Override
    public int getFieldProviderType() {
        return 129;
    }

    @Override
    public Collection getFields() throws Exception {
        throw new OwInvalidOperationException("OwObjectListViewEXTJSGrid.getFields: Not implemented.");
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = this.getField(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = this.getField(sName_p);
        field.setValue(value_p);
    }

    public Collection getObjectInstancePluginList() {
        return super.getPluginEntries();
    }

    private void recreateOccuredHashSet() {
        if (this.occuringObjectTypes != null) {
            this.occuringObjectTypes.clear();
            this.occuringObjectTypes = null;
        }
        this.occuringObjectTypes = new HashSet();
    }

    protected void processOccurred(OwObject obj) {
        Integer type = obj.getType();
        if (!this.occuringObjectTypes.contains(type)) {
            this.occuringObjectTypes.add(type);
        }
    }

    public boolean isNoteEditable() {
        return this.m_isNoteEditable;
    }

    public void setNoteEditable(boolean isNoteEditable_p) {
        this.m_isNoteEditable = isNoteEditable_p;
    }

    protected int computeEndIndex() {
        int iPageSize;
        int iStartIndex;
        int iEndIndex = 0;
        if (this.m_ObjectList != null && (iEndIndex = (iStartIndex = this.m_startrow) + (iPageSize = ((OwMainAppContext)this.getContext()).getPageSizeForLists())) > this.m_ObjectList.size()) {
            iEndIndex = this.m_ObjectList.size();
        }
        return iEndIndex;
    }

    protected OwMimeManager getMimeManager() {
        return this.m_MimeManager;
    }

    protected int getColumnDataType(OwPropertyClass propertyClass_p) throws Exception {
        OwPropetyControl informalPropertyConfig;
        int dataType = -1;
        if (this.m_informalConfiguration != null && (informalPropertyConfig = this.m_informalConfiguration.getPropertyControl(propertyClass_p.getClassName())) != null && "enum".equals(informalPropertyConfig.controlType)) {
            return 5;
        }
        if (propertyClass_p.isEnum()) {
            dataType = 5;
        } else if (propertyClass_p.getJavaClassName().equalsIgnoreCase("java.lang.String")) {
            dataType = 0;
            if (this.isNoteProperty(propertyClass_p.getClassName())) {
                dataType = 6;
            }
        } else if (propertyClass_p.getJavaClassName().equalsIgnoreCase("java.lang.Integer")) {
            dataType = 1;
        } else if (propertyClass_p.getJavaClassName().equalsIgnoreCase("java.lang.Boolean")) {
            dataType = 2;
        } else if (propertyClass_p.getJavaClassName().equalsIgnoreCase("java.util.Date")) {
            dataType = 3;
        } else if (propertyClass_p.getJavaClassName().equalsIgnoreCase("java.lang.Double")) {
            dataType = 4;
        }
        return dataType;
    }

    public boolean isNoteProperty(String propName_p) {
        return this.m_editableNotePropertyNames.contains(propName_p);
    }

    protected boolean isPropertyEditable(OwPropertyClass propertyClass_p) throws Exception {
        boolean editable = false;
        if (this.hasViewMask(128) && !propertyClass_p.isSystemProperty() && !propertyClass_p.isArray() && !propertyClass_p.isReadOnly(0)) {
            editable = true;
            editable = this.isNoteProperty(propertyClass_p.getClassName()) ? this.isNoteEditable() : !this.isConfiguredAsReadOnly(propertyClass_p.getClassName());
        }
        return editable;
    }

    public boolean hasToolTipPattern() {
        return this.getToolTipPattern() != null;
    }

    protected String getToolTipPattern() {
        return this.m_TooltipTextPattern;
    }

    protected String getDateInTransportFormat(Date dateVal_p) {
        return this.m_TransportDateFormat.format(dateVal_p);
    }

    protected String getEncodedPropertyValue(OwAjaxColumnEntry ace_p, OwProperty prop_p) throws Exception {
        String propVal = prop_p.getValue().toString();
        try {
            propVal = OwHTMLHelper.encodeToSecureHTML(propVal);
        }
        catch (IOException exData) {
            LOG.warn((Object)("OwObjectListViewEXTJSGrid.onAjaxReadList: encoding of data failed! name= " + prop_p.getPropertyClass().getClassName() + " value = " + propVal), (Throwable)exData);
        }
        switch (ace_p.getEditDataType()) {
            case 0: {
                propVal = this.encodeJsonString(propVal);
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                propVal = Boolean.valueOf(propVal).toString();
                break;
            }
            case 3: {
                Date dateValue = (Date)prop_p.getValue();
                propVal = this.encodeJsonString(this.getDateInTransportFormat(dateValue));
                break;
            }
            case 5: {
                OwPropertyClass propertyClass = prop_p.getPropertyClass();
                OwEnumCollection enums = propertyClass.getEnums();
                String displayText = propVal;
                if (enums != null) {
                    for (OwEnum item : enums) {
                        if (!item.getValue().equals(prop_p.getValue())) continue;
                        displayText = item.getDisplayName(this.getContext().getLocale());
                    }
                }
                propVal = "[[" + this.encodeJsonString(propVal) + "," + this.encodeJsonString(displayText) + "]]";
                break;
            }
            default: {
                StringWriter sw = new StringWriter();
                try {
                    this.m_FieldManager.insertReadOnlyField(sw, prop_p);
                }
                catch (Exception e) {
                    // empty catch block
                }
                propVal = this.encodeJsonString(sw.toString());
            }
        }
        return propVal;
    }

    protected List getReadOnlyColumns() {
        return this.m_readOnlyColumns;
    }

    protected boolean isConfiguredAsReadOnly(String property_p) {
        return this.getReadOnlyColumns().contains(property_p);
    }

    public String getLoadingMessage() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.loadingMessage", "Please wait while your request is being processed...");
    }

    private static class OwIconFieldColumnInfo
    implements OwFieldColumnInfo {
        private OwIconFieldColumnInfo() {
        }

        @Override
        public int getAlignment() {
            return 0;
        }

        @Override
        public String getDisplayName(Locale locale_p) {
            return "ow_icon_column";
        }

        @Override
        public String getPropertyName() {
            return "ow_icon_column";
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public boolean isSortable() {
            return false;
        }
    }

    protected static class OwAjaxColumnEntry {
        private OwFieldColumnInfo m_ColumnInfo;
        private String m_ColumnName;
        private int m_iColumnWidth;
        private int m_iEditDataType;

        public OwAjaxColumnEntry(OwFieldColumnInfo columnInfo_p, int iColumnWidth_p, String sColumnName_p) {
            this.m_ColumnInfo = columnInfo_p;
            this.m_iColumnWidth = iColumnWidth_p;
            this.m_ColumnName = sColumnName_p;
        }

        public OwFieldColumnInfo getFieldColumnInfo() {
            return this.m_ColumnInfo;
        }

        public String getColumnName() {
            return this.m_ColumnName;
        }

        public void setColumnName(String name_p) {
            this.m_ColumnName = name_p;
        }

        public int getColumnWidth() {
            return this.m_iColumnWidth;
        }

        public void setColumnWidth(int width_p) {
            this.m_iColumnWidth = width_p;
        }

        public void setEditDataType(int iEditDataType_p) {
            this.m_iEditDataType = iEditDataType_p;
        }

        public int getEditDataType() {
            return this.m_iEditDataType;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.m_ColumnInfo != null) {
                result.append("Column info property: ").append(this.m_ColumnInfo.getPropertyName()).append("\n");
            }
            if (this.m_ColumnName != null) {
                result.append("Column name: ").append(this.m_ColumnName).append("\n");
            }
            result.append("Column width: ").append(this.m_iColumnWidth);
            return result.toString();
        }
    }

    private class OwInformalConfiguration {
        private Map<String, OwPropetyControl> propertyControls = new HashMap<String, OwPropetyControl>();

        private OwInformalConfiguration() {
        }

        public void add(OwPropetyControl propertyControl_p) {
            this.propertyControls.put(propertyControl_p.propertyName, propertyControl_p);
        }

        public OwPropetyControl getPropertyControl(String propertyName_p) {
            return this.propertyControls.get(propertyName_p);
        }
    }

    private class OwPropetyControl {
        final String propertyName;
        final String controlType;

        OwPropetyControl(String propertyName_p, String controlType_p) {
            this.propertyName = propertyName_p;
            this.controlType = controlType_p;
        }
    }

    public static class OwColumnInfoBagValue {
        public static final String DEFAULT_EQ = "=";
        public static final String DEFAULT_COLUMN_SEPARATOR = ",";
        public static final String DEFAULT_HEADER_SEPARATOR = "#";
        public static final String DEFAULT_HEADERID_SEPARATOR = "~";
        public static final String DEFAULT_HEADER = "";
        private String columnSeparator = ",";
        private String headerSeparator = "#";
        private String headerIDSeparator = "~";
        private String eq = "=";
        private Map<String, Map<String, Integer[]>> columns = new LinkedHashMap<String, Map<String, Integer[]>>();

        public OwColumnInfoBagValue() {
        }

        public OwColumnInfoBagValue(String value_p) throws OwInvalidOperationException {
            if (value_p != null && value_p.length() > 0) {
                if (value_p.contains(this.headerIDSeparator)) {
                    String[] headers;
                    for (String header : headers = value_p.split(this.headerSeparator)) {
                        String[] headerSplit = header.split(this.headerIDSeparator);
                        if (headerSplit == null || headerSplit.length != 2) {
                            String msg = "Invalid header foud : " + header;
                            LOG.error((Object)("OwColumnInfoBagValue.init : " + msg));
                            throw new OwInvalidOperationException(msg);
                        }
                        String headerId = headerSplit[0];
                        String headerColumns = headerSplit[1];
                        this.setAll(headerId, headerColumns);
                    }
                } else {
                    this.setAll(DEFAULT_HEADER, value_p);
                }
            }
        }

        private void setAll(String header_p, String columnsValue_p) throws OwInvalidOperationException {
            String[] columnsEqs;
            for (String columnEq : columnsEqs = columnsValue_p.split(this.columnSeparator)) {
                int columnWidth;
                String columnName;
                block4: {
                    String[] eqSplit = columnEq.split(this.eq);
                    if (eqSplit.length != 2) {
                        String msg = "Invalid column found : " + columnEq;
                        LOG.error((Object)("OwColumnInfoBagValue.setAll : " + msg));
                        throw new OwInvalidOperationException(msg);
                    }
                    columnName = eqSplit[0];
                    String columnWidthString = eqSplit[1];
                    columnWidth = 100;
                    try {
                        columnWidth = Integer.parseInt(columnWidthString);
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug((Object)("Invalid value for the colwidth, value=" + columnName + ". Expected was a numeric value. Set the colwidth to default value=" + columnWidthString), (Throwable)e);
                    }
                }
                this.put(header_p, columnName, columnWidth);
            }
        }

        private Map<String, Integer[]> force(String header_p) {
            Map<String, Integer[]> header = this.columns.get(header_p);
            if (header == null) {
                header = new LinkedHashMap<String, Integer[]>();
                this.columns.put(header_p, header);
            }
            return header;
        }

        public Set<String> getHeaders() {
            return this.columns.keySet();
        }

        private Map<String, Integer[]> getDefaultHeader() {
            return this.header(DEFAULT_HEADER);
        }

        public Integer widthOf(String column_p) {
            return this.widthOf(DEFAULT_HEADER, column_p);
        }

        public Integer widthOf(String header_p, String column_p) {
            Map<String, Integer[]> header = this.header(header_p);
            if (header != null) {
                Integer[] columnNumebrs = header.get(column_p);
                return columnNumebrs != null ? columnNumebrs[0] : null;
            }
            return null;
        }

        public Set<String> getDefaultColumns() {
            Map<String, Integer[]> defaultHeader = this.getDefaultHeader();
            if (defaultHeader == null) {
                return Collections.EMPTY_SET;
            }
            return defaultHeader.keySet();
        }

        public Set<String> columnsOf(String header_p) {
            Map<String, Integer[]> header = this.columns.get(header_p);
            if (header != null) {
                return header.keySet();
            }
            return Collections.EMPTY_SET;
        }

        private Map<String, Integer[]> header(String header_p) {
            return this.columns.get(header_p);
        }

        public void put(String column_p, int width_p) {
            this.put(DEFAULT_HEADER, column_p, width_p);
        }

        public void clearDefaultHeader() {
            this.clear(DEFAULT_HEADER);
        }

        public void clear(String header_p) {
            Map<String, Integer[]> header = this.header(header_p);
            if (header != null) {
                header.clear();
            }
        }

        public void put(String header_p, String column_p, int width_p) {
            Map<String, Integer[]> header = this.force(header_p);
            Integer[] oldColumn = header.get(column_p);
            Integer index = header.size();
            if (oldColumn != null) {
                index = oldColumn[1];
            }
            header.put(column_p, new Integer[]{width_p, index});
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Set<Map.Entry<String, Map<String, Integer[]>>> headerEtries = this.columns.entrySet();
            for (Map.Entry<String, Map<String, Integer[]>> headerEntry : headerEtries) {
                if (builder.length() > 0) {
                    builder.append(this.headerSeparator);
                }
                builder.append(headerEntry.getKey());
                Map<String, Integer[]> headerColumns = headerEntry.getValue();
                Set<Map.Entry<String, Integer[]>> headerColumnEntries = headerColumns.entrySet();
                for (Map.Entry<String, Integer[]> columnEntry : headerColumnEntries) {
                    builder.append(columnEntry.getKey());
                    builder.append(this.eq);
                    Integer[] value = columnEntry.getValue();
                    builder.append(value[0]);
                    builder.append(this.columnSeparator);
                }
                if (headerColumnEntries.isEmpty()) continue;
                int builderLen = builder.length();
                builder.delete(builderLen - this.columnSeparator.length(), builderLen);
            }
            return builder.toString();
        }

        public Integer indexOf(String header_p, String column_p) {
            Map<String, Integer[]> header = this.header(header_p);
            if (header != null) {
                Integer[] columnNumbers = header.get(column_p);
                return columnNumbers != null ? columnNumbers[1] : null;
            }
            return null;
        }

        public Integer indexOf(String column_p) {
            return this.indexOf(DEFAULT_HEADER, column_p);
        }
    }
}

