/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.perf4j.log4j.Log4JStopWatch;

public abstract class OwObjectListViewPluginCache
extends OwObjectListView {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListViewPluginCache.class);
    private OwPluginStatusCachingUtility pluginCache;

    public OwObjectListViewPluginCache() {
    }

    public OwObjectListViewPluginCache(int viewMask) {
        super(viewMask);
    }

    protected OwPluginStatusCachingUtility getPluginCache() {
        return this.pluginCache;
    }

    protected void setPluginCache(OwPluginStatusCachingUtility newCache) {
        this.pluginCache = newCache;
    }

    protected OwPluginStatusCachingUtility createPluginStatusCacheUtility(int startIndex, int endIndex, Collection pluginEntries) throws Exception {
        return this.createPluginStatusCacheUtility(startIndex, endIndex, this.getObjectList(), this.getParentObject(), pluginEntries, this.isEmptyPluginColumnRendered());
    }

    protected OwPluginStatusCachingUtility createPluginStatusCacheUtility(int startIndex, int endIndex, List objectList, OwObject parentObject, Collection pluginEntries, boolean displayEmptyPluginColumn) throws Exception {
        return new OwPluginStatusCachingUtility(startIndex, endIndex, objectList, parentObject, pluginEntries, displayEmptyPluginColumn);
    }

    protected static class OwPluginStatus {
        private boolean isCached;
        private boolean isEnabled;
        public static final OwPluginStatus NOT_CACHED = new OwPluginStatus(false, false);

        public OwPluginStatus(boolean isCached_p, boolean isEnabled_p) {
            this.isCached = isCached_p;
            this.isEnabled = isEnabled_p;
        }

        public boolean isCached() {
            return this.isCached;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    protected static class OwPluginStatusCachingUtility {
        private Map m_object2PluginStatusMap = new HashMap();
        private boolean m_displayEmptyPluginColumn;
        private int m_startIndex;
        private int m_endIndex;
        private List m_disabledPlugins = new LinkedList();
        private List m_ObjectList;
        private OwObject m_parentObject;
        private Map m_maxNumberOfIconsPerEntry = new HashMap();

        public OwPluginStatusCachingUtility(int startIndex_p, int endIndex_p, List objectList_p, OwObject parentObject_p, Collection pluginEntries_p) throws Exception {
            this(startIndex_p, endIndex_p, objectList_p, parentObject_p, pluginEntries_p, false);
        }

        public OwPluginStatusCachingUtility(int startIndex_p, int endIndex_p, List objectList_p, OwObject parentObject_p, Collection pluginEntries_p, boolean displayEmptyPluginColumn_p) throws Exception {
            this.m_displayEmptyPluginColumn = displayEmptyPluginColumn_p;
            this.m_startIndex = startIndex_p;
            this.m_endIndex = endIndex_p;
            this.m_ObjectList = objectList_p;
            this.m_parentObject = parentObject_p;
            try {
                this.preparePluginInfo(pluginEntries_p);
            }
            catch (Exception e) {
                LOG.error((Object)"OwPluginStatusCachingUtility.constructor: Cannot prepare plugin info. Reason:", (Throwable)e);
                throw e;
            }
        }

        private void addPluginStatusForObject(OwObject object_p, OwObjectListView.OwPluginEntry pluginEntry_p, boolean isEnabled_p) {
            try {
                String key = this.createKey(object_p, pluginEntry_p);
                this.m_object2PluginStatusMap.put(key, isEnabled_p ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot add plugin status for object: " + object_p + " and for plugin entry: " + pluginEntry_p), (Throwable)e);
            }
        }

        private String createKey(OwObject object_p, OwObjectListView.OwPluginEntry pluginEntry_p) throws Exception {
            String objectId = object_p.getDMSID();
            String key = objectId + "_" + pluginEntry_p.getIndex();
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void preparePluginInfo(Collection instancePluginsList_p) throws Exception {
            if (!this.m_displayEmptyPluginColumn && instancePluginsList_p != null) {
                Log4JStopWatch preparePluginInfoStopWatch = new Log4JStopWatch("preparePluginInfo");
                try {
                    if (this.m_endIndex > 0) {
                        Iterator pluginsIterator = new CopyOnWriteArraySet(instancePluginsList_p).iterator();
                        this.m_disabledPlugins = new LinkedList();
                        while (pluginsIterator.hasNext()) {
                            OwObjectListView.OwPluginEntry entry = (OwObjectListView.OwPluginEntry)pluginsIterator.next();
                            this.preparePluginInfo(entry);
                        }
                    }
                }
                finally {
                    preparePluginInfoStopWatch.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void preparePluginInfo(OwObjectListView.OwPluginEntry entry) throws Exception {
            boolean isPluginEnabled = false;
            String pluginName = entry.getPlugin().getName();
            Log4JStopWatch pluginStopWatch = new Log4JStopWatch("plugin.isEnabled." + pluginName, String.format("# of objects %d", this.m_endIndex - this.m_startIndex));
            try {
                for (int i = this.m_startIndex; i < this.m_endIndex; ++i) {
                    OwObject obj = (OwObject)this.m_ObjectList.get(i);
                    if (obj == null) continue;
                    if (entry.m_Plugin.isEnabled(obj, this.m_parentObject, 1)) {
                        String icon = entry.m_Plugin.getIconHTML(obj, this.m_parentObject);
                        OwObjectListView.OwIcon owIcon = new OwObjectListView.OwIcon(icon);
                        int numberOfIcons = owIcon.getNumberOfIcons();
                        this.addNumberOfIconsForEntry(entry, numberOfIcons);
                        if (numberOfIcons > 0) {
                            isPluginEnabled = true;
                            this.addPluginStatusForObject(obj, entry, true);
                            continue;
                        }
                        this.addPluginStatusForObject(obj, entry, false);
                        continue;
                    }
                    this.addPluginStatusForObject(obj, entry, false);
                }
            }
            finally {
                pluginStopWatch.stop();
            }
            if (!isPluginEnabled) {
                this.m_disabledPlugins.add(entry);
                this.addNumberOfIconsForEntry(entry, 0);
            }
        }

        private void addNumberOfIconsForEntry(OwObjectListView.OwPluginEntry entry_p, int numberOfIcons_p) {
            Integer key = entry_p.getIndex();
            if (this.m_maxNumberOfIconsPerEntry.containsKey(key)) {
                Integer existingNumberOfIcons = (Integer)this.m_maxNumberOfIconsPerEntry.get(key);
                if (existingNumberOfIcons < numberOfIcons_p) {
                    this.m_maxNumberOfIconsPerEntry.put(key, numberOfIcons_p);
                }
            } else {
                this.m_maxNumberOfIconsPerEntry.put(key, numberOfIcons_p);
            }
        }

        public int getMaximumNumberOfIconsForEntry(OwObjectListView.OwPluginEntry entry_p) {
            int result = 0;
            if (entry_p != null) {
                Integer resultAsInt = (Integer)this.m_maxNumberOfIconsPerEntry.get(entry_p.getIndex());
                result = resultAsInt != null ? resultAsInt : result;
            }
            return result;
        }

        public int getMaximumNumberOfIcons() {
            int result = 0;
            for (Integer value : this.m_maxNumberOfIconsPerEntry.values()) {
                result += value.intValue();
            }
            return result;
        }

        public boolean isPluginDisabledForAllObjects(OwObjectListView.OwPluginEntry entry_p) {
            boolean result = this.m_disabledPlugins.contains(entry_p);
            if (this.m_displayEmptyPluginColumn) {
                result = false;
            }
            return result;
        }

        public OwPluginStatus getCachedPluginState(OwObjectListView.OwPluginEntry pluginEntry_p, OwObject obj_p) {
            OwPluginStatus result;
            try {
                String key = this.createKey(obj_p, pluginEntry_p);
                Boolean status = (Boolean)this.m_object2PluginStatusMap.get(key);
                result = status == null ? OwPluginStatus.NOT_CACHED : new OwPluginStatus(true, status);
            }
            catch (Exception e) {
                result = OwPluginStatus.NOT_CACHED;
            }
            return result;
        }

        public int getNumberOfDisabledPlugins() {
            return this.m_disabledPlugins.size();
        }
    }
}

