/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwMultipleSelectionCall;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewPluginCache;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwUserOperationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwScriptTable;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OwObjectListViewRow
extends OwObjectListViewPluginCache
implements OwFieldProvider {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListViewRow.class);
    protected OwMainAppContext m_MainContext;
    protected int m_iCurrentPage = 0;
    protected OwSort m_Sort;
    protected boolean m_useContextMenu;
    OwMimeManager m_MimeManager = this.createMimeManager();
    OwObjectCollection m_ObjectList;
    protected Collection m_ColumnInfoList;
    protected OwFieldManager m_theFieldManager;
    protected OwClientRefreshContext m_RefreshContext;
    protected Set m_occuredObjectTypes;

    protected OwMimeManager createMimeManager() {
        return new OwMimeManager();
    }

    public void setMimeTypeContext(String context_p) {
        this.m_MimeManager.setMimeTypeContext(context_p);
    }

    public OwObjectListViewRow(int iViewMask_p) {
        super(iViewMask_p);
        this.setStickyFooterInUse(true);
    }

    public OwObjectListViewRow() {
        this.setStickyFooterInUse(true);
    }

    protected String getHtmlAlignment(int iAlignment_p) {
        return OwObjectListViewRow.m_HtmlAlignments.m_list[iAlignment_p];
    }

    @Override
    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception {
        this.m_ObjectList = objectList_p;
        this.setParentObject(parentObject_p);
        this.m_MimeManager.setParent(parentObject_p);
        if (this.m_ObjectList != null && this.m_iCurrentPage >= this.getPageCount()) {
            this.m_iCurrentPage = this.getPageCount() - 1;
        }
        if (null != this.m_Sort && null != this.m_ObjectList) {
            this.m_ObjectList.sort(this.m_Sort);
        }
        this.resetPersistedSelectionState();
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    @Override
    public OwObjectCollection getObjectList() {
        return this.m_ObjectList;
    }

    @Override
    protected boolean isPagingEnabled() {
        OwView parent = this.getParent();
        return parent == null || !parent.isShowMaximized();
    }

    @Override
    public int getPageCount() throws Exception {
        if (this.m_ObjectList == null) {
            return 1;
        }
        return (this.m_ObjectList.size() - 1) / ((OwMainAppContext)this.getContext()).getPageSizeForLists() + 1;
    }

    @Override
    public int getCurrentPage() {
        return this.m_iCurrentPage;
    }

    @Override
    public void onPageAbsolut(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(Integer.parseInt(request_p.getParameter("page")));
    }

    @Override
    protected void pageAbsolut(int iPage_p) throws Exception {
        if (iPage_p < 0 || iPage_p >= this.getPageCount()) {
            throw new OwInvalidOperationException("OwObjectListViewRow.pageAbsolut: Page index out of bound.");
        }
        this.m_iCurrentPage = iPage_p;
    }

    @Override
    public void onPageNext(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(this.getCurrentPage() + 1);
    }

    @Override
    public void onPagePrev(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(this.getCurrentPage() - 1);
    }

    @Override
    public boolean canPagePrev() {
        return this.getCurrentPage() > 0;
    }

    @Override
    public boolean canPageNext() throws Exception {
        return this.getCurrentPage() < this.getPageCount() - 1;
    }

    public String getPagePrevURL() {
        return this.getEventURL("PagePrev", null);
    }

    public String getPageNextURL() {
        return this.getEventURL("PageNext", null);
    }

    public String getPageAbsolutURL(int iPage_p) {
        return this.getEventURL("PageAbsolut", "page=" + String.valueOf(iPage_p));
    }

    @Override
    public OwFieldManager getFieldManager() {
        return this.m_theFieldManager;
    }

    @Override
    public void setFieldManager(OwFieldManager fielmanager_p) {
        this.m_theFieldManager = fielmanager_p;
    }

    @Override
    public void setRefreshContext(OwClientRefreshContext eventlister_p) {
        this.m_RefreshContext = eventlister_p;
        this.m_MimeManager.setRefreshContext(eventlister_p);
    }

    @Override
    protected OwClientRefreshContext getRefreshContext() {
        return this.m_RefreshContext;
    }

    @Override
    public int getCount() {
        if (this.m_ObjectList != null) {
            return this.m_ObjectList.size();
        }
        return 0;
    }

    @Override
    public void setColumnInfo(Collection columnInfo_p) {
        this.m_ColumnInfoList = columnInfo_p;
    }

    @Override
    public Collection getColumnInfo() {
        return this.m_ColumnInfoList;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MainContext = (OwMainAppContext)this.getContext();
        if (this.hasViewMask(1)) {
            boolean bl = this.m_useContextMenu = this.m_MainContext.getConfiguration().isDocmentFunctionRequirement(1) && (this.hasViewMask(4) || this.hasViewMask(16));
            if (!this.m_useContextMenu) {
                this.clearViewMask(4);
                this.clearViewMask(16);
            }
        } else {
            this.m_useContextMenu = false;
            this.clearViewMask(4);
            this.clearViewMask(16);
        }
        this.m_Sort = new OwSort(this.m_MainContext.getMaxSortCriteriaCount(), true);
        this.m_theFieldManager = this.m_MainContext.createFieldManager();
        this.m_theFieldManager.setExternalFormTarget(this.getFormTarget());
        this.m_theFieldManager.setFieldProvider(this);
        this.m_MimeManager.attach(this.m_MainContext, null);
        this.m_pageSelectorComponent = this.createPageSelector();
    }

    @Override
    public void setSort(OwSort sort_p) {
        this.m_Sort = sort_p;
    }

    @Override
    public OwSort getSort() {
        return this.m_Sort;
    }

    @Override
    public void detach() {
        super.detach();
        this.m_MimeManager.detach();
        this.m_theFieldManager.detach();
    }

    protected String getSortOrderType(String strProperty_p) throws Exception {
        String sortOrderType = this.getContext().localize("app.OwObjectListView.sorting.ascending", "ascending");
        String ascending = this.getContext().localize("app.OwObjectListView.sorting.ascending", "ascending");
        String descending = this.getContext().localize("app.OwObjectListView.sorting.descending", "descending");
        if (null == this.m_Sort) {
            return sortOrderType;
        }
        OwSort.OwSortCriteria SortCriteria = this.m_Sort.getCriteria(strProperty_p);
        if (SortCriteria != null) {
            if (SortCriteria.getAscFlag()) {
                return descending;
            }
            return ascending;
        }
        return sortOrderType;
    }

    protected String getSortOrderImage(String strProperty_p) throws Exception {
        if (null == this.m_Sort) {
            return this.m_MainContext.getDesignURL() + "/images/OwObjectListView/nosort.png";
        }
        OwSort.OwSortCriteria SortCriteria = this.m_Sort.getCriteria(strProperty_p);
        if (SortCriteria != null) {
            if (SortCriteria.getAscFlag()) {
                return this.m_MainContext.getDesignURL() + "/images/OwObjectListView/sortasc.png";
            }
            return this.m_MainContext.getDesignURL() + "/images/OwObjectListView/sortdesc.png";
        }
        return this.m_MainContext.getDesignURL() + "/images/OwObjectListView/nosort.png";
    }

    protected void renderExtraColumnHeader(Writer w_p) throws Exception {
        if (this.hasViewMask(2)) {
            this.renderVersionHeader(w_p);
        }
        this.renderVersionHeader(w_p);
    }

    protected void renderExtraColumnRows(Writer w_p, OwObject obj_p, int iIndex_p) throws Exception {
        if (this.hasViewMask(2)) {
            w_p.write("\n<td align=\"center\" width=\"1\"><a title=\"");
            String selectButtonTooltip = this.getContext().localize("app.OwObjectListView.selecttooltip", "Select");
            w_p.write(selectButtonTooltip);
            w_p.write("\" href=\"");
            w_p.write(this.getEventURL("Select", "oi"));
            w_p.write("=");
            w_p.write(String.valueOf(iIndex_p));
            w_p.write("\"><img src=\"");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/OwObjectListView/select.png\" border=\"0\" ");
            w_p.write("alt=\"");
            w_p.write(selectButtonTooltip);
            w_p.write("\" title=\"");
            w_p.write(selectButtonTooltip);
            w_p.write("\" /></a></td>\n");
        }
    }

    protected void renderLockedColumn(Writer w_p, OwObject obj_p) throws Exception, IOException {
        if (obj_p.getLock(1)) {
            String lockedTooltip = this.getContext().localize("image.locked", "Locked item");
            w_p.write("\n<td align=\"center\" width=\"1\"><img src=\"");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/plug/owbpm/locked.png\" ");
            w_p.write("alt=\"");
            w_p.write(lockedTooltip);
            w_p.write("\" title=\"");
            w_p.write(lockedTooltip);
            w_p.write("\" /></td>\n");
        } else {
            w_p.write("\n<td width=\"1\"/>\n");
        }
    }

    public void renderTableCaption(Writer w_p) throws Exception {
        w_p.write(this.getContext().localize("app.OwObjectListView.table.caption", "Result list"));
    }

    public void renderSortHeader(Writer w_p, Collection instancePluginsList_p) throws Exception {
        if (this.hasViewMask(4)) {
            OwScriptTable.writeSelectableListHeaderStart(String.valueOf(this.getListViewID()), w_p, "OwGeneralList_header", this.getContext());
        } else {
            w_p.write("\n<tr class=\"OwGeneralList_header\">\n");
        }
        this.renderIndexHeader(w_p);
        this.renderExtraColumnHeader(w_p);
        this.insertDocumentFunctionPluginHeader(w_p, instancePluginsList_p);
        this.renderVersionHeader(w_p);
        this.renderMimeTypeHeader(w_p);
        this.renderPropertiesHeader(w_p);
        w_p.write("\n</tr>\n");
    }

    protected void renderPropertiesHeader(Writer w_p) throws IOException, Exception {
        int iWidth = 90 / (this.m_ColumnInfoList.size() > 0 ? this.m_ColumnInfoList.size() : 1);
        String strWidth = String.valueOf(iWidth) + "%";
        for (OwFieldColumnInfo colInfo : this.m_ColumnInfoList) {
            w_p.write("\n<th class=\"OwGeneralList_property\" ");
            w_p.write(this.getHtmlAlignment(colInfo.getAlignment()));
            w_p.write(" width=\"");
            w_p.write(strWidth);
            w_p.write("\">");
            this.renderPropertyColumnHeader(w_p, colInfo);
            w_p.write("</th>\n");
        }
    }

    protected void renderVersionHeader(Writer w_p) throws IOException {
        w_p.write("\n<th width=\"1\">&nbsp;</th>\n");
    }

    protected void renderMimeTypeHeader(Writer w_p) throws IOException {
        w_p.write("\n<th width=\"1\">&nbsp;</th>\n");
    }

    protected void insertDocumentFunctionPluginHeader(Writer w_p, Collection instancePluginsList_p) throws IOException, Exception {
        for (OwObjectListView.OwPluginEntry entry : instancePluginsList_p) {
            if (this.getPluginCache().isPluginDisabledForAllObjects(entry)) continue;
            w_p.write("\n<th width=\"1\">");
            if (entry.m_Plugin.getEnableColumnClickEvent()) {
                w_p.write("<a title=\"");
                w_p.write(entry.m_Plugin.getTooltip());
                w_p.write("\" class=\"OwGeneralList_sort\" href=\"");
                w_p.write(this.getEventURL("ColumnClickEvent", "pi=" + String.valueOf(entry.m_iIndex)));
                w_p.write("\">");
                w_p.write(entry.m_Plugin.getColumnTitle());
                w_p.write("</a>");
            } else {
                w_p.write(entry.m_Plugin.getColumnTitle());
            }
            w_p.write("</th>");
        }
    }

    protected void renderIndexHeader(Writer w_p) throws IOException, Exception {
        w_p.write("\n<th id=\"a1\" class=\"align-right\" width=\"1\">");
        if (!this.m_ObjectList.isComplete()) {
            w_p.write("&gt;&nbsp;");
        }
        w_p.write(String.valueOf(this.m_ObjectList.size()));
        w_p.write("&nbsp;");
        w_p.write("</th>\n");
    }

    protected void renderPropertyColumnHeader(Writer w_p, OwFieldColumnInfo colInfo_p) throws Exception {
        if (colInfo_p.isSortable()) {
            w_p.write("<a href=\"");
            w_p.write(this.getEventURL("Sort", "prop=" + colInfo_p.getPropertyName()));
            w_p.write("\" title=\"");
            String text = OwString.localize2(this.getContext().getLocale(), "app.OwObjectListView.sortTooltip", "Sort %1 %2", colInfo_p.getDisplayName(this.getContext().getLocale()), this.getSortOrderType(colInfo_p.getPropertyName()));
            w_p.write(text);
            w_p.write("\" class=\"OwGeneralList_sort\">");
            w_p.write(colInfo_p.getDisplayName(this.getContext().getLocale()));
            w_p.write("&nbsp;<img class=\"OwGeneralList_sortimg\" alt=\"");
            w_p.write(text);
            w_p.write("\" title=\"");
            w_p.write(text);
            w_p.write("\" border=\"0\" src=\"");
            w_p.write(this.getSortOrderImage(colInfo_p.getPropertyName()));
            w_p.write("\">");
            w_p.write("</a>");
        } else {
            String tooltip = this.getContext().localize("app.OwObjectListView.notsortable", "Not sortable");
            w_p.write("<div  class=\"OwGeneralList_sort\" alt=\"");
            w_p.write(tooltip);
            w_p.write("\" title=\"");
            w_p.write(tooltip);
            w_p.write("\">");
            w_p.write(colInfo_p.getDisplayName(this.getContext().getLocale()));
            w_p.write("&nbsp;<img class=\"OwGeneralList_sortimg\"  src=\"");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/OwObjectListView/nosortable.png\" ");
            w_p.write("alt=\"");
            w_p.write(tooltip);
            w_p.write("\" title=\"");
            w_p.write(tooltip);
            w_p.write("\"/></div>");
        }
    }

    protected String getRowClassName(int iIndex_p, OwObject obj_p) {
        try {
            return this.getEventListner().onObjectListViewGetRowClassName(iIndex_p, obj_p).toString();
        }
        catch (Exception e) {
            return iIndex_p % 2 != 0 ? "OwGeneralList_RowEven" : "OwGeneralList_RowOdd";
        }
    }

    protected String getSelectedRowClassName(int iIndex_p, OwObject obj_p) {
        return "OwGeneralList_RowSelected";
    }

    protected int computeStartIndex() {
        int iStartIndex = 0;
        if (this.isPagingEnabled()) {
            int iPageSize = ((OwMainAppContext)this.getContext()).getPageSizeForLists();
            iStartIndex = this.m_iCurrentPage * iPageSize;
            if (this.m_ObjectList != null && iStartIndex > this.m_ObjectList.size()) {
                this.m_iCurrentPage = 0;
                iStartIndex = 0;
            }
        }
        return iStartIndex;
    }

    protected int computeEndIndex() {
        int iEndIndex = 0;
        if (this.m_ObjectList != null) {
            if (this.isPagingEnabled()) {
                int iPageSize = ((OwMainAppContext)this.getContext()).getPageSizeForLists();
                int iStartIndex = this.computeStartIndex();
                iEndIndex = iStartIndex + iPageSize;
                if (iEndIndex > this.m_ObjectList.size()) {
                    iEndIndex = this.m_ObjectList.size();
                }
            } else {
                iEndIndex = this.m_ObjectList.size();
            }
        }
        return iEndIndex;
    }

    public void renderRows(Writer w_p, Collection instancePluginsList_p) throws Exception {
        BufferedWriter bwr = new BufferedWriter(w_p, 30000);
        int iStartIndex = this.computeStartIndex();
        int iEndIndex = this.computeEndIndex();
        this.m_occuredObjectTypes = new HashSet();
        for (int i = iStartIndex; i < iEndIndex; ++i) {
            StringWriter rowBuffer = new StringWriter(30000);
            OwObject obj = (OwObject)this.m_ObjectList.get(i);
            try {
                this.m_occuredObjectTypes.add(obj.getType());
                String strRowClass = this.getRowClassName(i, obj);
                String strSelectedRowClass = this.getSelectedRowClassName(i, obj);
                if (this.hasViewMask(4)) {
                    boolean selectedObj = this.isObjectSelectionPersisted(i);
                    OwScriptTable.writeSelectableListRowStart(this.getContext().getLocale(), String.valueOf(this.getListViewID()), rowBuffer, i, strRowClass, strSelectedRowClass, true, selectedObj);
                } else {
                    rowBuffer.write("\n<tr class=\"");
                    rowBuffer.write(strRowClass);
                    rowBuffer.write("\">\n");
                }
                this.renderExtraColumnRows(rowBuffer, obj, i);
                this.renderIndex(rowBuffer, i);
                this.renderLockedColumn(rowBuffer, obj);
                this.insertDocumentFunctionPluginRows(rowBuffer, obj, i, instancePluginsList_p);
                this.renderVersion(rowBuffer, obj);
                this.renderMimeType(rowBuffer, obj);
                this.renderProperties(rowBuffer, obj);
                bwr.write(rowBuffer.getBuffer().toString());
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Could not render row !", (Throwable)e);
            }
        }
        bwr.flush();
    }

    protected void renderProperties(StringWriter rowBuffer, OwObject obj) throws Exception {
        for (OwFieldColumnInfo ColInfo : this.m_ColumnInfoList) {
            try {
                OwProperty Prop = obj.getProperty(ColInfo.getPropertyName());
                OwPropertyClass PropClass = Prop.getPropertyClass();
                rowBuffer.write("\n<td class=\"OwGeneralList_property\" ");
                rowBuffer.write(this.getHtmlAlignment(ColInfo.getAlignment()));
                if (PropClass.isNameProperty()) {
                    rowBuffer.write(" id=\"MIME_TYPE_LINK\" onMouseDown=\"return onMimeMouseDown(event);\" onKeyDown=\"return onMimeKeyDown(event);\"");
                }
                rowBuffer.write(">");
                if (PropClass.isNameProperty()) {
                    try {
                        this.m_MimeManager.insertTextLink(rowBuffer, Prop.getValue().toString(), obj);
                    }
                    catch (NullPointerException e) {
                        this.m_MimeManager.insertTextLink(rowBuffer, null, obj);
                    }
                } else {
                    this.m_theFieldManager.insertReadOnlyField(rowBuffer, Prop);
                }
                rowBuffer.write("</td>\n");
            }
            catch (OwObjectNotFoundException e) {
                rowBuffer.write("\n<td>&nbsp;</td>\n");
            }
        }
        rowBuffer.write("\n</tr>\n");
    }

    protected void renderMimeType(StringWriter rowBuffer, OwObject obj) throws Exception {
        rowBuffer.write("\n<td align=\"center\" width=\"1\" id=\"MIME_TYPE_ICON\" onMouseDown=\"return onMimeMouseDown(event);\" onKeyDown=\"return onMimeKeyDown(event);\">");
        this.m_MimeManager.insertIconLink(rowBuffer, obj);
        rowBuffer.write("</td>\n");
    }

    protected void renderVersion(StringWriter rowBuffer, OwObject obj) throws Exception {
        rowBuffer.write("\n<td nowrap align=\"right\">&nbsp;");
        if (obj.hasVersionSeries()) {
            this.renderCheckedOut(rowBuffer, obj);
            rowBuffer.write("(");
            rowBuffer.write(obj.getVersion().getVersionInfo());
            rowBuffer.write(")");
        } else {
            rowBuffer.write("&nbsp;");
        }
        rowBuffer.write("&nbsp;</td>\n");
    }

    protected void renderCheckedOut(StringWriter rowBuffer, OwObject obj) throws Exception {
        if (obj.getVersion().isCheckedOut(1)) {
            rowBuffer.write("<img align=\"top\" src=\"");
            rowBuffer.write(this.getContext().getDesignURL());
            rowBuffer.write("/images/checkedout.png\"");
            String tooltip = this.getContext().localize("app.Checked_out", "Checked out");
            rowBuffer.write(" alt=\"");
            rowBuffer.write(tooltip);
            rowBuffer.write("\" title=\"");
            rowBuffer.write(tooltip);
            rowBuffer.write("\" border=\"0\"/>");
        } else {
            rowBuffer.write("<img align=\"top\" alt=\"\" title=\"\" src=\"");
            rowBuffer.write(this.getContext().getDesignURL());
            rowBuffer.write("/images/notcheckedout.png\" border=\"0\"/>");
        }
    }

    protected void renderIndex(StringWriter rowBuffer, int i) {
        rowBuffer.write("\n<td class=\"align-right\" width=\"1\">&nbsp;");
        rowBuffer.write(String.valueOf(i + 1));
        rowBuffer.write("&nbsp;</td>\n");
    }

    public boolean getIsList() {
        return this.getIsListValid() && !this.getIsListEmpty();
    }

    public boolean getIsListValid() {
        return this.m_ObjectList != null && this.m_ColumnInfoList != null;
    }

    public boolean getIsListEmpty() {
        return this.m_ObjectList.size() == 0;
    }

    public boolean getIsPaging() {
        return this.isPagingEnabled() && !this.hasViewMask(32);
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.m_MimeManager.reset();
        this.m_theFieldManager.reset();
        this.setPluginCache(this.createPluginStatusCacheUtility(this.computeStartIndex(), this.computeEndIndex(), this.getPluginEntries()));
        this.renderMainRegion(w_p);
        if (this.getIsList()) {
            if (this.m_useContextMenu) {
                this.renderContextMenu(w_p, this.m_occuredObjectTypes);
            }
            if (this.hasViewMask(4)) {
                OwScriptTable.writeSelectableListEnableScript(String.valueOf(this.getListViewID()), w_p, this.getContext());
            }
        }
        this.addAjaxPersistenceService(w_p, "PersistSelection");
    }

    public void onAjaxPersistSelection(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        this.persistAjaxTriggeredSelection(request_p, response_p, this.m_ObjectList);
    }

    protected void renderMainRegion(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwObjectListViewRow.jsp", w_p);
    }

    public int getPageSize() {
        return ((OwMainAppContext)this.getContext()).getPageSizeForLists();
    }

    protected void insertDocumentFunctionPluginRows(Writer w_p, OwObject obj_p, int iIndex_p, Collection instancePluginsList_p) throws Exception {
        for (OwObjectListView.OwPluginEntry pluginEntry : instancePluginsList_p) {
            if (this.getPluginCache().isPluginDisabledForAllObjects(pluginEntry)) continue;
            OwObjectListViewPluginCache.OwPluginStatus status = this.getPluginCache().getCachedPluginState(pluginEntry, obj_p);
            boolean isPluginEnabled = status.isCached() ? status.isEnabled() : pluginEntry.m_Plugin.isEnabled(obj_p, this.getParentObject(), 1);
            if (isPluginEnabled) {
                if (pluginEntry.m_Plugin.getNoEvent()) {
                    w_p.write("\n<td style=\"white-space:nowrap;\">");
                    w_p.write(pluginEntry.m_Plugin.getIconHTML(obj_p, null));
                    w_p.write("</td>\n");
                    continue;
                }
                w_p.write("\n<td><a href=\"");
                StringBuffer url = new StringBuffer("oi").append("=").append(iIndex_p);
                url.append("&").append("pi").append("=").append(pluginEntry.m_iIndex);
                w_p.write(this.getEventURL("PluginEvent", url.toString()));
                w_p.write("\" title=\"");
                w_p.write(pluginEntry.m_Plugin.getTooltip());
                w_p.write("\" class=\"OwGeneralList_Plugin_a\">");
                w_p.write(pluginEntry.m_Plugin.getIconHTML(obj_p, null));
                w_p.write("</a></td>\n");
                continue;
            }
            w_p.write("\n<td width=\"1\"></td>\n");
        }
    }

    public void onSort(HttpServletRequest request_p) throws Exception {
        String strSortProperty = request_p.getParameter("prop");
        if (strSortProperty != null) {
            this.m_Sort.toggleCriteria(strSortProperty);
            if (this.m_ObjectList != null) {
                this.m_ObjectList.sort(this.m_Sort);
                this.resetPersistedSelectionState();
            }
            if (this.getEventListner() != null) {
                this.getEventListner().onObjectListViewSort(this.m_Sort, strSortProperty);
            }
        }
    }

    public void onContextMenuEvent(HttpServletRequest request_p) throws Exception {
        String strPlugIndex = request_p.getParameter("pi");
        this.multiSelectEvent(request_p, strPlugIndex);
    }

    public void onColumnClickEvent(HttpServletRequest request_p) throws Exception {
        int iPlugIndex = Integer.parseInt(request_p.getParameter("pi"));
        OwDocumentFunction PlugIn = this.getDocumentFunction(iPlugIndex);
        PlugIn.onColumnClickEvent(this.m_ObjectList, this.getParentObject(), this.m_RefreshContext);
    }

    public void onMultiSelectEvent(HttpServletRequest request_p) throws Exception {
        String strPlugIndex = request_p.getParameter("owmcm");
        this.multiSelectEvent(request_p, strPlugIndex);
    }

    private void multiSelectEvent(HttpServletRequest request_p, String strPluginIndex_p) throws Exception {
        String[] checked = request_p.getParameterValues(OwScriptTable.getSelectableListCheckBoxName(String.valueOf(this.getListViewID())));
        if (null != checked && strPluginIndex_p != null) {
            int iPlugIndex = Integer.parseInt(strPluginIndex_p);
            OwDocumentFunction plugIn = this.getDocumentFunction(iPlugIndex);
            ArrayList<OwObject> objects = new ArrayList<OwObject>();
            for (int i = 0; i < checked.length; ++i) {
                OwObject obj = (OwObject)this.m_ObjectList.get(Integer.parseInt(checked[i]));
                objects.add(obj);
            }
            if (objects.size() == 1) {
                plugIn.onClickEvent((OwObject)objects.get(0), this.getParentObject(), this.m_RefreshContext);
            } else {
                if (!plugIn.getMultiselect()) {
                    throw new OwUserOperationException(new OwString1("app.OwObjectListViewRow.onlysingleselectfunction", "Function %1 can only be applied to one object.", plugIn.getDefaultLabel()));
                }
                OwMultipleSelectionCall multiCall = new OwMultipleSelectionCall(plugIn, objects, this.getParentObject(), this.m_RefreshContext, this.m_MainContext);
                multiCall.invokeFunction();
            }
        }
    }

    public void onPluginEvent(HttpServletRequest request_p) throws Exception {
        String strObjectIndex = request_p.getParameter("oi");
        String strPlugIndex = request_p.getParameter("pi");
        if (strObjectIndex != null && strPlugIndex != null) {
            int iPlugIndex = Integer.parseInt(strPlugIndex);
            OwDocumentFunction plugIn = this.getDocumentFunction(iPlugIndex);
            int iObjectIndex = Integer.parseInt(strObjectIndex);
            OwObject obj = (OwObject)this.m_ObjectList.get(iObjectIndex);
            plugIn.onClickEvent(obj, this.getParentObject(), this.m_RefreshContext);
            this.resetPersistedSelectionState();
            this.persistObjectSelectionState(iObjectIndex, true);
        }
    }

    public void onSelect(HttpServletRequest request_p) throws Exception {
        int objectIndex = Integer.parseInt(request_p.getParameter("oi"));
        OwObject obj = (OwObject)this.m_ObjectList.get(objectIndex);
        this.resetPersistedSelectionState();
        this.persistObjectSelectionState(objectIndex, true);
        if (this.getEventListner() != null) {
            this.getEventListner().onObjectListViewSelect(obj, this.getParentObject());
        }
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return true;
    }

    @Override
    public Collection getRetrievalPropertyNames() throws Exception {
        if (null == this.m_ColumnInfoList) {
            throw new OwInvalidOperationException("OwObjectListViewRow.getRetrievalPropertyNames: Specify setColumnInfo() in OwObjectList.");
        }
        HashSet<String> retList = new HashSet<String>();
        for (OwFieldColumnInfo ColInfo : this.m_ColumnInfoList) {
            retList.add(ColInfo.getPropertyName());
        }
        for (OwObjectListView.OwPluginEntry entry : this.getPluginEntries()) {
            Collection props = entry.m_Plugin.getRetrievalPropertyNames();
            if (null == props) continue;
            retList.addAll(props);
        }
        return retList;
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        throw new OwObjectNotFoundException("OwObjectListViewRow.getField: Not implemented or Not supported.");
    }

    @Override
    public int getFieldProviderType() {
        return 129;
    }

    @Override
    public Object getFieldProviderSource() {
        return this.m_ObjectList;
    }

    @Override
    public String getFieldProviderName() {
        try {
            return this.getParentObject().getName();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = this.getField(sName_p);
        field.setValue(value_p);
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = this.getField(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public Collection getFields() throws Exception {
        throw new OwInvalidOperationException("OwObjectListViewRow.getFields: Not implemented.");
    }

    @Override
    public String getTitle() {
        return this.getContext().localize("dmsdialogs.views.OwObjectListViewRow.title", "List");
    }

    @Override
    public String getIcon() throws Exception {
        return "/images/OwObjectListView/OwObjectListViewRow.png";
    }

    public OwMimeManager getMimeManager() {
        return this.m_MimeManager;
    }

    public void renderPageSelector(Writer w_p) throws Exception {
        this.m_pageSelectorComponent.render(w_p);
    }
}

