/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.app.OwMultipleSelectionCall;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwUserOperationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwScriptTable;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwObjectListViewThumbnails
extends OwObjectListView
implements OwFieldProvider {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectListViewThumbnails.class);
    public static final int DEFAULT_THUMBS_PER_ROW = 3;
    protected OwMainAppContext m_MainContext;
    protected int m_iCurrentPage = 0;
    protected int MAX_THUMBNAIL_PER_ROW = 3;
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_DMSID = "{dmsid}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL = "{serverurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_BASEURL = "{baseurl}";
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START = "{prop";
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_ENCODE_CHAR = ':';
    public static final char VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_NOENCODE_CHAR = '#';
    public static final String VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END = "}";
    protected OwSort m_Sort;
    protected boolean m_useContextMenu;
    protected OwMimeManager m_MimeManager = new OwMimeManager();
    OwObjectCollection m_ObjectList;
    protected Collection m_ColumnInfoList;
    protected OwFieldManager m_theFieldManager;
    protected OwClientRefreshContext m_RefreshContext;
    private Set m_occuredObjectTypes;
    private static final String THUMBNAIL_TYPES_NODE_NAME = "ThumbnailTypes";
    public static final int THUMBNAIL_LIST = 1;
    public static final int CONTEXT_MENU = 2;
    public static final int PAGE_BUTTONS = 3;
    protected ArrayList<ThumbnailTypeConfig> m_ThumbnailTypes = new ArrayList();

    public OwObjectListViewThumbnails(int iViewMask_p) {
        super(iViewMask_p);
    }

    public OwObjectListViewThumbnails() {
    }

    public boolean getIsList() {
        return this.m_ObjectList != null && this.m_ObjectList.size() != 0 && this.m_ColumnInfoList != null;
    }

    public boolean getIsListValid() {
        return this.m_ObjectList != null && this.m_ColumnInfoList != null;
    }

    @Override
    public void setConfigNode(Node node_p) throws Exception {
        super.setConfigNode(node_p);
        Node thumbnailtypesNode = OwXMLDOMUtil.getChildNode(node_p, THUMBNAIL_TYPES_NODE_NAME);
        if (null == thumbnailtypesNode) {
            String msg = "OwObjectListViewThumbnails.setConfigNode: Please define a ThumbnailTypes node in the plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_ThumbnailTypes.clear();
        List thumbnailTypes = OwXMLDOMUtil.getSafeNodeList(thumbnailtypesNode);
        for (Node thumbnailTypeNode : thumbnailTypes) {
            String sDisplayname = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "displayname", null);
            String sWidth = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "width", null);
            String sHeight = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "height", null);
            String sUrl = OwXMLDOMUtil.getSafeStringAttributeValue(thumbnailTypeNode, "url", null);
            if (sDisplayname == null || sWidth == null || sHeight == null || sUrl == null) continue;
            try {
                int iWidth = Integer.parseInt(sWidth);
                int iHeight = Integer.parseInt(sHeight);
                this.m_ThumbnailTypes.add(new ThumbnailTypeConfig(sDisplayname, iWidth, iHeight, sUrl));
            }
            catch (Exception e) {}
        }
        if (this.m_ThumbnailTypes.size() <= 0) {
            String msg = "OwObjectListViewThumbnails.setConfigNode: Please define at least one ThumbnailType in the plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
    }

    protected static String replaceProperties(OwMainAppContext context_p, String strIn_p, OwObjectReference obj_p) throws Exception {
        int iIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START);
        if (-1 == iIndex) {
            return strIn_p;
        }
        OwObject obj = obj_p.getInstance();
        int iOldIndex = 0;
        StringBuilder strRet = new StringBuilder();
        while (-1 != iIndex) {
            strRet.append(strIn_p.substring(iOldIndex, iIndex));
            ++iIndex;
            int iEnd = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_END, iIndex += VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START.length());
            String strPropName = strIn_p.substring(iIndex, iEnd);
            if (strIn_p.charAt(iIndex - 1) == ':') {
                try {
                    strRet.append(OwAppContext.encodeURL(obj.getProperty(strPropName).getValue().toString()));
                }
                catch (Exception e) {}
            } else {
                try {
                    strRet.append(obj.getProperty(strPropName).getValue().toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            iOldIndex = iIndex = iEnd + 1;
            iIndex = strIn_p.indexOf(VIEWER_SERVLET_REPLACE_TOKEN_PROPERTY_START, iIndex);
        }
        if (iOldIndex <= strIn_p.length()) {
            strRet.append(strIn_p.substring(iOldIndex, strIn_p.length()));
        }
        return strRet.toString();
    }

    protected String getHtmlAlignment(int iAlignment_p) {
        return OwObjectListViewThumbnails.m_HtmlAlignments.m_list[iAlignment_p];
    }

    @Override
    public void setObjectList(OwObjectCollection objectList_p, OwObject parentObject_p) throws Exception {
        this.m_ObjectList = objectList_p;
        this.setParentObject(parentObject_p);
        this.m_MimeManager.setParent(parentObject_p);
        if (this.m_ObjectList != null && this.m_iCurrentPage >= this.getPageCount()) {
            this.m_iCurrentPage = this.getPageCount() - 1;
        }
        this.resetPersistedSelectionState();
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    @Override
    public OwObjectCollection getObjectList() {
        return this.m_ObjectList;
    }

    @Override
    protected boolean isPagingEnabled() {
        return !this.getParent().isShowMaximized();
    }

    @Override
    public int getPageCount() throws Exception {
        if (this.m_ObjectList == null) {
            return 1;
        }
        return (this.m_ObjectList.size() - 1) / ((OwMainAppContext)this.getContext()).getPageSizeForLists() + 1;
    }

    @Override
    public int getCurrentPage() {
        return this.m_iCurrentPage;
    }

    @Override
    public void onPageAbsolut(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(Integer.parseInt(request_p.getParameter("page")));
    }

    @Override
    protected void pageAbsolut(int iPage_p) throws Exception {
        if (iPage_p < 0 || iPage_p >= this.getPageCount()) {
            throw new OwInvalidOperationException("OwObjectListViewThumbnails.pageAbsolut: Page index out of bound.");
        }
        this.m_iCurrentPage = iPage_p;
    }

    @Override
    public void onPageNext(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(this.getCurrentPage() + 1);
    }

    @Override
    public void onPagePrev(HttpServletRequest request_p) throws Exception {
        this.pageAbsolut(this.getCurrentPage() - 1);
    }

    @Override
    public boolean canPagePrev() {
        return this.getCurrentPage() > 0;
    }

    @Override
    public boolean canPageNext() throws Exception {
        return this.getCurrentPage() < this.getPageCount() - 1;
    }

    @Override
    public OwFieldManager getFieldManager() {
        return this.m_theFieldManager;
    }

    @Override
    public void setFieldManager(OwFieldManager fielmanager_p) {
        this.m_theFieldManager = fielmanager_p;
    }

    @Override
    public void setRefreshContext(OwClientRefreshContext eventlister_p) {
        this.m_RefreshContext = eventlister_p;
        this.m_MimeManager.setRefreshContext(eventlister_p);
    }

    @Override
    protected OwClientRefreshContext getRefreshContext() {
        return this.m_RefreshContext;
    }

    @Override
    public int getCount() {
        if (this.m_ObjectList != null) {
            return this.m_ObjectList.size();
        }
        return 0;
    }

    @Override
    public void setColumnInfo(Collection columnInfo_p) {
        this.m_ColumnInfoList = columnInfo_p;
    }

    @Override
    public Collection getColumnInfo() {
        return this.m_ColumnInfoList;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MainContext = (OwMainAppContext)this.getContext();
        if (this.hasViewMask(1)) {
            boolean bl = this.m_useContextMenu = this.m_MainContext.getConfiguration().isDocmentFunctionRequirement(1) && (this.hasViewMask(4) || this.hasViewMask(16));
            if (!this.m_useContextMenu) {
                this.clearViewMask(4);
                this.clearViewMask(16);
            }
        } else {
            this.m_useContextMenu = false;
            this.clearViewMask(4);
            this.clearViewMask(16);
        }
        this.m_Sort = new OwSort(this.m_MainContext.getMaxSortCriteriaCount(), true);
        this.m_theFieldManager = this.m_MainContext.createFieldManager();
        this.m_theFieldManager.setExternalFormTarget(this.getFormTarget());
        this.m_theFieldManager.setFieldProvider(this);
        this.m_MimeManager.attach(this.m_MainContext, null);
        this.m_pageSelectorComponent = this.createPageSelector();
        this.setStickyFooterInUse(false);
    }

    @Override
    public void setSort(OwSort sort_p) {
        this.m_Sort = sort_p;
    }

    @Override
    public OwSort getSort() {
        return this.m_Sort;
    }

    @Override
    public void detach() {
        super.detach();
        this.m_MimeManager.detach();
        this.m_theFieldManager.detach();
    }

    protected String getThumbnailRowId(int idx_p, int line_p) {
        String x = "" + line_p;
        while (x.length() < 4) {
            x = "0" + x;
        }
        return "mtn" + x + "_" + this.getListViewID() + "_" + idx_p;
    }

    protected Set renderThumbnails(Writer w_p, Collection instancePluginsList_p) throws Exception {
        int iStartIndex = 0;
        int iEndIndex = this.m_ObjectList.size();
        if (this.isPagingEnabled()) {
            int iPageSize = ((OwMainAppContext)this.getContext()).getPageSizeForLists();
            iStartIndex = this.m_iCurrentPage * iPageSize;
            if (iStartIndex > this.m_ObjectList.size()) {
                this.m_iCurrentPage = 0;
                iStartIndex = 0;
            }
            if ((iEndIndex = iStartIndex + iPageSize) > this.m_ObjectList.size()) {
                iEndIndex = this.m_ObjectList.size();
            }
        }
        HashSet<Integer> occuredObjectTypes = new HashSet<Integer>();
        String listViewId = String.valueOf(this.getListViewID());
        for (int i = iStartIndex; i < iEndIndex; ++i) {
            try {
                StringWriter writeBuffer = new StringWriter();
                OwObject obj = (OwObject)this.m_ObjectList.get(i);
                boolean objectIsSelected = this.isObjectSelectionPersisted(i);
                String thumbDivClass = "OwObjectListViewThumbnails_div";
                if (objectIsSelected) {
                    thumbDivClass = "OwObjectListViewThumbnails_divselected";
                }
                occuredObjectTypes.add(obj.getType());
                this.renderBlockBegin(iStartIndex, i, writeBuffer);
                writeBuffer.write("<div id=\"owtndiv_");
                writeBuffer.write(listViewId);
                writeBuffer.write("_" + i);
                writeBuffer.write("\" class=\"");
                writeBuffer.write(thumbDivClass);
                writeBuffer.write("\">\n");
                int linecounter = 1;
                writeBuffer.write("<table class=\"OwObjectListViewThumbnails_table\" name=\"OwObjectListViewThumbnails_table\">\n");
                writeBuffer.write("<tr id=\"");
                writeBuffer.write(this.getThumbnailRowId(i, linecounter++));
                writeBuffer.write("\" class=\"OwObjectListViewThumbnails_row\">\n");
                writeBuffer.write("<td class=\"OwObjectListViewThumbnails_headcell\" align=center valign=middle>\n");
                writeBuffer.write("<table border=0 cellpadding=0 cellspacing=2><tbody class=\"OwObjectListViewThumbnails_HeadTableBody\"><tr>");
                boolean isLocked = obj.getLock(1);
                writeBuffer.write("<td align=\"center\" valign=\"middle\" width=\"10%\">");
                writeBuffer.write("<input onclick=\"onClickThumbnailCheckBox('" + i);
                writeBuffer.write("','");
                writeBuffer.write(listViewId);
                writeBuffer.write("');\" type=\"checkbox\"");
                writeBuffer.write(" id=\"owtcid_");
                writeBuffer.write(listViewId);
                writeBuffer.write("_" + i);
                writeBuffer.write("\" name=\"owtcb_");
                writeBuffer.write(listViewId);
                writeBuffer.write("\" title=\"");
                writeBuffer.write(this.getContext().localize1("app.OwObjectListViewThumbnails.thumbnail.checkbox.title", "Thumbnail %1", "" + (i + 1)));
                writeBuffer.write("\" value=\"" + i + "\"");
                if (objectIsSelected) {
                    writeBuffer.write(" checked");
                }
                writeBuffer.write(">\n");
                writeBuffer.write("</td>\n");
                this.renderLockedColumn(writeBuffer, obj);
                String pluginWidth = "47%";
                if (isLocked) {
                    pluginWidth = "40%";
                }
                writeBuffer.write("<td align=\"center\" valign=\"middle\" width=\"" + pluginWidth + "\">\n");
                this.insertDocumentFunctionPlugins(writeBuffer, obj, i, instancePluginsList_p);
                writeBuffer.write("</td>\n");
                String versionWidth = "43%";
                if (isLocked) {
                    versionWidth = "40%";
                }
                writeBuffer.write("<td align=\"center\" valign=\"middle\" style=\"white-space:nowrap;\"  width=\"" + versionWidth + "\">\n");
                if (obj.hasVersionSeries()) {
                    if (obj.getVersion().isCheckedOut(1)) {
                        writeBuffer.write("<img align=\"top\" src=\"" + this.getContext().getDesignURL() + "/images/checkedout.png\"");
                        String tooltip = this.getContext().localize("app.Checked_out", "Checked out");
                        writeBuffer.write(" alt=\"");
                        writeBuffer.write(tooltip);
                        writeBuffer.write("\" title=\"");
                        writeBuffer.write(tooltip);
                        writeBuffer.write("\" border=\"0\">\n");
                    }
                    writeBuffer.write("(" + obj.getVersion().getVersionInfo() + ")\n");
                }
                writeBuffer.write("</td>\n");
                writeBuffer.write("</tr></tbody></table>");
                writeBuffer.write("</td>\n");
                writeBuffer.write("</tr>\n");
                writeBuffer.write("<tr id=\"" + this.getThumbnailRowId(i, linecounter++));
                writeBuffer.write("\" class=\"OwObjectListViewThumbnails_row\">\n");
                writeBuffer.write("<td class=\"OwObjectListViewThumbnails_cell\">\n");
                writeBuffer.write("<img align=\"absmiddle\" alt=\"\" title=\"\"");
                boolean defaultdone = false;
                for (int ii = 0; ii < this.m_ThumbnailTypes.size(); ++ii) {
                    ThumbnailTypeConfig ttc = this.m_ThumbnailTypes.get(ii);
                    StringBuilder sUrl = new StringBuilder(ttc.getUrl());
                    OwString.replaceAll(sUrl, VIEWER_SERVLET_REPLACE_TOKEN_BASEURL, this.getContext().getBaseURL() + "/");
                    OwString.replaceAll(sUrl, VIEWER_SERVLET_REPLACE_TOKEN_SERVERURL, this.getContext().getServerURL() + "/");
                    OwString.replaceAll(sUrl, VIEWER_SERVLET_REPLACE_TOKEN_DMSID, OwAppContext.encodeURL(obj.getDMSID()));
                    String rsUrl = OwObjectListViewThumbnails.replaceProperties((OwMainAppContext)this.getContext(), sUrl.toString(), obj);
                    if (!defaultdone) {
                        writeBuffer.write(" width=\"" + ttc.getWidth());
                        writeBuffer.write("\" height=\"" + ttc.getHeight());
                        writeBuffer.write("\" src=\"");
                        writeBuffer.write(rsUrl);
                        writeBuffer.write("\"");
                        defaultdone = true;
                    }
                    writeBuffer.write(" type" + ii);
                    writeBuffer.write("src=\"");
                    writeBuffer.write(rsUrl);
                    writeBuffer.write("\"");
                }
                writeBuffer.write(" border=\"0\" name=\"OwObjectListViewThumbnails_image\">\n");
                writeBuffer.write("</td>\n");
                writeBuffer.write("</tr>\n");
                for (OwFieldColumnInfo ColInfo : this.m_ColumnInfoList) {
                    try {
                        OwProperty Prop = obj.getProperty(ColInfo.getPropertyName());
                        OwPropertyClass PropClass = Prop.getPropertyClass();
                        writeBuffer.write("<tr id=\"");
                        writeBuffer.write(this.getThumbnailRowId(i, linecounter++));
                        writeBuffer.write("\" class=\"OwObjectListViewThumbnails_row\">\n");
                        writeBuffer.write("<td class=\"OwObjectListViewThumbnails_cell\" ");
                        writeBuffer.write(this.getHtmlAlignment(ColInfo.getAlignment()));
                        writeBuffer.write(">\n");
                        if (PropClass.isNameProperty()) {
                            try {
                                this.m_MimeManager.insertTextLink(writeBuffer, Prop.getValue().toString(), obj);
                            }
                            catch (NullPointerException e) {
                                this.m_MimeManager.insertTextLink(writeBuffer, null, obj);
                            }
                        } else {
                            this.m_theFieldManager.insertReadOnlyField(writeBuffer, Prop);
                        }
                        writeBuffer.write("\n</td>\n</tr>\n");
                    }
                    catch (OwObjectNotFoundException e) {
                        writeBuffer.write("<tr class=\"OwObjectListViewThumbnails_row\">\n<td class=\"OwObjectListViewThumbnails_cell\">\n&nbsp;\n</td>\n</tr>\n");
                    }
                }
                writeBuffer.write("</table>\n");
                writeBuffer.write("</div>\n");
                this.renderBlockEnd(iStartIndex, iEndIndex, i, writeBuffer);
                w_p.write(writeBuffer.getBuffer().toString());
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Could not render thumbnail!", (Throwable)e);
            }
        }
        String strToolTip = this.getContext().localize("app.OwObjectListView.toggleselectall", "Alles (de)selektieren");
        this.getContext().registerKeyEvent(65, 512, "javascript:keyboardSelectAll();", strToolTip);
        w_p.write("\n\n<script type=\"text/javascript\">activeListCheckBoxId=");
        w_p.write("\"owtcb_");
        w_p.write(listViewId);
        w_p.write("\";</script>\n\n");
        return occuredObjectTypes;
    }

    protected void renderBlockEnd(int startIndexPosition_p, int endIndexPosition_p, int currentPosition_p, StringWriter w_p) {
        if ((currentPosition_p - startIndexPosition_p) % this.MAX_THUMBNAIL_PER_ROW == this.MAX_THUMBNAIL_PER_ROW - 1 || currentPosition_p == endIndexPosition_p - 1) {
            w_p.write("</div><!-- end of .OwBlock -->");
        }
    }

    protected void renderBlockBegin(int startIndexPosition_p, int currentPosition_p, StringWriter w_p) {
        if ((currentPosition_p - startIndexPosition_p) % this.MAX_THUMBNAIL_PER_ROW == 0) {
            w_p.write("<div class=\"OwBlock\">");
        }
    }

    private void renderLockedColumn(StringWriter writeBuffer_p, OwObject obj_p) throws Exception {
        if (obj_p.getLock(1)) {
            String lockedTooltip = this.getContext().localize("image.locked", "Locked item");
            writeBuffer_p.write("<td width=\"10%\"><img src=\"" + this.getContext().getDesignURL() + "/images/plug/owbpm/locked.png\" alt=\"" + lockedTooltip + "\" title=\"" + lockedTooltip + "\"/></td>\n");
        }
    }

    @Override
    public boolean isRegion(int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 3: {
                return this.isPagingEnabled() && !this.hasViewMask(32);
            }
        }
        return super.isRegion(iRegion_p);
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                if (this.m_useContextMenu) {
                    this.renderContextMenu(w_p, this.m_occuredObjectTypes);
                }
                if (!this.hasViewMask(4)) break;
                OwScriptTable.writeSelectableListEnableScript(String.valueOf(this.getListViewID()), w_p, this.getContext());
                break;
            }
            case 1: {
                this.m_occuredObjectTypes = this.renderThumbnails(w_p, this.getPluginEntries());
                break;
            }
            case 3: {
                if (!this.isPagingEnabled() || this.hasViewMask(32)) break;
                this.renderPageButtons(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    public String getThumbnailTypeDisplayName(int i_p) {
        ThumbnailTypeConfig ttc = this.m_ThumbnailTypes.get(i_p);
        return ((OwMainAppContext)this.getContext()).localizeLabel(ttc.getDisplayname());
    }

    public int getThumbnailTypeCount() {
        return this.m_ThumbnailTypes.size();
    }

    public String getThumbnailTypeUrl(int i_p) {
        ThumbnailTypeConfig ttc = this.m_ThumbnailTypes.get(i_p);
        return "javascript:Thumbnails_setType(" + i_p + "," + ttc.getWidth() + "," + ttc.getHeight() + ");";
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.m_MimeManager.reset();
        this.m_theFieldManager.reset();
        this.addAjaxPersistenceService(w_p, "PersistSelection");
        this.serverSideDesignInclude("OwObjectListViewThumbnails.jsp", w_p);
    }

    public void onAjaxPersistSelection(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        this.persistAjaxTriggeredSelection(request_p, response_p, this.m_ObjectList);
    }

    protected void renderPageButtons(Writer w_p) throws Exception {
        this.m_pageSelectorComponent.render(w_p);
    }

    protected void insertDocumentFunctionPlugins(Writer w_p, OwObject obj_p, int iIndex_p, Collection instancePluginsList_p) throws Exception {
        for (OwObjectListView.OwPluginEntry plugInEntry : instancePluginsList_p) {
            if (!plugInEntry.m_Plugin.isEnabled(obj_p, this.getParentObject(), 1)) continue;
            if (plugInEntry.m_Plugin.getNoEvent()) {
                w_p.write(plugInEntry.m_Plugin.getIconHTML(obj_p, null));
                continue;
            }
            w_p.write("<a href=\"");
            w_p.write(this.getEventURL("PluginEvent", "oi"));
            w_p.write("=");
            w_p.write(String.valueOf(iIndex_p));
            w_p.write("&");
            w_p.write("pi");
            w_p.write("=");
            w_p.write(String.valueOf(plugInEntry.m_iIndex));
            w_p.write("\" title=\"");
            w_p.write(plugInEntry.m_Plugin.getTooltip());
            w_p.write("\" class=\"OwGeneralList_Plugin_a\">");
            w_p.write(plugInEntry.m_Plugin.getIconHTML(obj_p, null));
            w_p.write("</a>\n");
        }
    }

    public void onSort(HttpServletRequest request_p) throws Exception {
        String strSortProperty = request_p.getParameter("prop");
        if (strSortProperty != null) {
            this.m_Sort.toggleCriteria(strSortProperty);
            if (this.m_ObjectList != null) {
                this.m_ObjectList.sort(this.m_Sort);
            }
            if (this.getEventListner() != null) {
                this.getEventListner().onObjectListViewSort(this.m_Sort, strSortProperty);
            }
        }
    }

    public void onContextMenuEvent(HttpServletRequest request_p) throws Exception {
        String strPlugIndex = request_p.getParameter("pi");
        this.multiSelectEvent(request_p, strPlugIndex);
    }

    public void onColumnClickEvent(HttpServletRequest request_p) throws Exception {
        int iPlugIndex = Integer.parseInt(request_p.getParameter("pi"));
        OwDocumentFunction plugIn = ((OwObjectListView.OwPluginEntry)this.getPluginEntries().get(iPlugIndex)).getPlugin();
        plugIn.onColumnClickEvent(this.m_ObjectList, this.getParentObject(), this.m_RefreshContext);
    }

    public void onMultiSelectEvent(HttpServletRequest request_p) throws Exception {
        String strPlugIndex = request_p.getParameter("owmcm");
        this.multiSelectEvent(request_p, strPlugIndex);
    }

    private void multiSelectEvent(HttpServletRequest request_p, String strPluginIndex_p) throws Exception {
        String[] checked = request_p.getParameterValues("owtcb_" + this.getListViewID());
        if (null != checked && strPluginIndex_p != null) {
            int iPlugIndex = Integer.parseInt(strPluginIndex_p);
            OwDocumentFunction plugIn = this.getDocumentFunction(iPlugIndex);
            ArrayList<OwObject> objects = new ArrayList<OwObject>();
            for (int i = 0; i < checked.length; ++i) {
                OwObject obj = (OwObject)this.m_ObjectList.get(Integer.parseInt(checked[i]));
                objects.add(obj);
            }
            if (objects.size() == 1) {
                plugIn.onClickEvent((OwObject)objects.get(0), this.getParentObject(), this.m_RefreshContext);
            } else {
                if (!plugIn.getMultiselect()) {
                    throw new OwUserOperationException(new OwString1("app.OwObjectListViewRow.onlysingleselectfunction", "Function %1 can only be applied to one object.", plugIn.getDefaultLabel()));
                }
                OwMultipleSelectionCall multiCall = new OwMultipleSelectionCall(plugIn, objects, this.getParentObject(), this.m_RefreshContext, this.m_MainContext);
                multiCall.invokeFunction();
            }
        }
    }

    public void onPluginEvent(HttpServletRequest request_p) throws Exception {
        String strObjectIndex = request_p.getParameter("oi");
        String strPlugIndex = request_p.getParameter("pi");
        if (strObjectIndex != null && strPlugIndex != null) {
            int iPlugIndex = Integer.parseInt(strPlugIndex);
            OwDocumentFunction plugIn = this.getDocumentFunction(iPlugIndex);
            int iObjectIndex = Integer.parseInt(strObjectIndex);
            OwObject obj = (OwObject)this.m_ObjectList.get(iObjectIndex);
            plugIn.onClickEvent(obj, this.getParentObject(), this.m_RefreshContext);
        }
    }

    public void onSelect(HttpServletRequest request_p) throws Exception {
        OwObject obj = (OwObject)this.m_ObjectList.get(Integer.parseInt(request_p.getParameter("oi")));
        if (this.getEventListner() != null) {
            this.getEventListner().onObjectListViewSelect(obj, this.getParentObject());
        }
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return true;
    }

    @Override
    public Collection getRetrievalPropertyNames() throws Exception {
        if (null == this.m_ColumnInfoList) {
            throw new OwInvalidOperationException("OwObjectListViewThumbnails.getRetrievalPropertyNames: Specify setColumnInfo() in OwObjectList.");
        }
        HashSet<String> retList = new HashSet<String>();
        for (OwFieldColumnInfo ColInfo : this.m_ColumnInfoList) {
            retList.add(ColInfo.getPropertyName());
        }
        for (OwObjectListView.OwPluginEntry entry : this.getPluginEntries()) {
            Collection props = entry.m_Plugin.getRetrievalPropertyNames();
            if (null == props) continue;
            retList.addAll(props);
        }
        return retList;
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        throw new OwObjectNotFoundException("OwObjectListViewThumbnails.getField: Not implemented or Not supported.");
    }

    @Override
    public int getFieldProviderType() {
        return 129;
    }

    @Override
    public Object getFieldProviderSource() {
        return this.m_ObjectList;
    }

    @Override
    public String getFieldProviderName() {
        try {
            return this.getParentObject().getName();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = this.getField(sName_p);
        field.setValue(value_p);
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = this.getField(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public Collection getFields() throws Exception {
        throw new OwInvalidOperationException("OwObjectListViewThumbnails.getFields: Not implemented.");
    }

    @Override
    public String getTitle() {
        return this.getContext().localize("dmsdialogs.views.OwObjectListViewThumbnails.title", "Thumbnail View");
    }

    @Override
    public String getIcon() throws Exception {
        return "/images/OwObjectListView/OwObjectListViewThumbnail.png";
    }

    protected class ThumbnailTypeConfig {
        private String m_displayname = "";
        private String m_url = "";
        private int m_width = 0;
        private int m_height = 0;

        public ThumbnailTypeConfig(String displayname_p, int width_p, int height_p, String url_p) {
            this.m_displayname = displayname_p;
            this.m_width = width_p;
            this.m_height = height_p;
            this.m_url = url_p;
        }

        public String getDisplayname() {
            return this.m_displayname;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public String getUrl() {
            return this.m_url;
        }
    }
}

