/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwJspFormConfigurator;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMenuView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.dmsdialogs.views.OwBatchPropertiesHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.dmsdialogs.views.OwPasteMetadataHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwStandardBatchPropertiesHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwStandardPasteMetadataHandler;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwJspConfigurable;
import com.wewebu.ow.server.ui.OwView;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwObjectPropertyFormularView
extends OwView
implements OwFieldProvider,
OwJspConfigurable {
    private static final Logger LOG = OwLogCore.getLogger(OwObjectPropertyFormularView.class);
    private static final String PLACEHOLDER_MENU = "ow_menu";
    private OwBatchPropertiesHandler m_batchPropertiesHandler;
    private OwPropertyCollection m_changedProperties = new OwStandardPropertyCollection();
    private boolean m_displayNoSaveMsg;
    protected boolean m_enablesaveall;
    private boolean m_fAllPropertiesReadonly = true;
    protected int m_iSaveButton;
    private boolean m_isPasteMetadataEnabled;
    private OwJspFormConfigurator m_jspConfigurator;
    private OwSubMenuView m_menu;
    private OwObject m_objectref;
    protected OwPasteMetadataHandler m_pasteMetadataHandler;
    protected OwPropertyCollection m_properties;
    private int m_ReadOnlyContext = 0;
    private boolean m_readOnlyView;
    protected boolean m_saveAllActive;
    protected int m_saveAllButtonIndex = -1;
    private String m_strHtmlContent;
    private String m_strJspPage;
    protected OwFieldManager m_theFieldManager;

    protected void addSaveAllButton(String saveAllText_p) throws Exception {
        if (this.getMenu() != null && this.m_enablesaveall) {
            this.m_saveAllButtonIndex = this.getMenu().addFormMenuItem(this, saveAllText_p, "SaveAll", null);
        }
    }

    private boolean areAllPropertiesReadOnly() {
        for (OwProperty property : this.m_properties.values()) {
            try {
                OwPropertyClass propertyClass = property.getPropertyClass();
                boolean readOnly = property.isReadOnly(this.getReadOnlyContext());
                if (!propertyClass.isSystemProperty() && propertyClass.isHidden(this.getReadOnlyContext()) || readOnly) continue;
                this.m_fAllPropertiesReadonly = false;
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot read object properties " + e.getMessage()));
            }
        }
        return this.m_fAllPropertiesReadonly;
    }

    protected void changeSaveAllButtonState() {
        if (this.getMenu() != null && this.m_enablesaveall) {
            boolean visualyEnabled = !this.isReadOnly() && this.m_saveAllActive;
            this.getMenu().enable(this.m_saveAllButtonIndex, visualyEnabled);
        }
    }

    protected OwBatchPropertiesHandler createBatchPropertiesHandler() {
        return new OwStandardBatchPropertiesHandler(this.getDocument());
    }

    protected OwPasteMetadataHandler createPasteMetadataHandler() {
        return new OwStandardPasteMetadataHandler((OwMainAppContext)this.getContext(), false, this.m_isPasteMetadataEnabled);
    }

    @Override
    public void detach() {
        super.detach();
        this.m_theFieldManager.detach();
    }

    public boolean displayNoSaveMsg() {
        return this.m_displayNoSaveMsg;
    }

    public void filterProperties(Collection<OwObjectPropertyView.OwPropertyInfo> propertyInfos_p) throws Exception {
        if (propertyInfos_p != null && this.m_properties != null) {
            OwStandardPropertyCollection filtered = new OwStandardPropertyCollection();
            for (OwObjectPropertyView.OwPropertyInfo owPropertyInfo : propertyInfos_p) {
                OwProperty prop;
                String propName = owPropertyInfo.getPropertyName();
                if (propName == null || (prop = (OwProperty)this.m_properties.get(propName)) == null || prop.isHidden(this.m_ReadOnlyContext)) continue;
                filtered.put(propName, prop);
            }
            this.m_properties = filtered;
        }
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception {
        OwProperty prop = (OwProperty)this.m_properties.get(strFieldClassName_p);
        if (prop == null) {
            String msg = "OwObjectPropertyFormularView.getField: Property not found, strFieldClassName_p = " + strFieldClassName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return prop;
    }

    public OwFieldManager getFieldManager() {
        return this.m_theFieldManager;
    }

    @Override
    public String getFieldProviderName() {
        try {
            return this.m_strJspPage.toString();
        }
        catch (NullPointerException e) {
            return "htmlform";
        }
    }

    @Override
    public Object getFieldProviderSource() {
        return this.m_objectref;
    }

    @Override
    public int getFieldProviderType() {
        switch (this.m_ReadOnlyContext) {
            case 1: {
                return 17;
            }
            case 2: {
                return 33;
            }
        }
        return 1;
    }

    @Override
    public Collection getFields() throws Exception {
        return this.m_properties.values();
    }

    @Override
    public OwJspFormConfigurator getJspConfigurator() {
        return this.m_jspConfigurator;
    }

    public OwMenuView getMenu() {
        return this.m_menu;
    }

    public OwObject getObjectRef() {
        return this.m_objectref;
    }

    protected int getReadOnlyContext() {
        return this.m_ReadOnlyContext;
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = (OwField)this.m_properties.get(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    protected int getSaveBtnIndex() {
        return this.m_iSaveButton;
    }

    public boolean getUpdateStatus() {
        return this.m_theFieldManager.getUpdateStatus();
    }

    protected void informUserOnSuccess() {
        ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("app.OwObjectPropertyFormularView.saved", "Changes have been saved."));
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_theFieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
        this.m_theFieldManager.setFieldProvider(this);
        this.m_theFieldManager.setExternalFormTarget(this.getFormTarget());
        this.m_menu = new OwSubMenuView();
        this.addView(this.m_menu, null);
        this.m_iSaveButton = this.m_menu.addFormMenuItem(this, this.getContext().localize("owcore.OwObjectPropertyFormularView.savebtn", "Save"), "Save", null);
        this.m_menu.setDefaultMenuItem(this.m_iSaveButton);
        this.getMenu().enable(this.m_iSaveButton, false);
        this.m_batchPropertiesHandler = this.createBatchPropertiesHandler();
        this.m_pasteMetadataHandler = this.createPasteMetadataHandler();
        this.setDisplayNoSaveMsg(false);
    }

    @Override
    public boolean isNamedRegion(String strRegion_p) throws Exception {
        if (super.isNamedRegion(strRegion_p)) {
            return true;
        }
        if (strRegion_p.equals(PLACEHOLDER_MENU)) {
            return true;
        }
        if (this.m_properties == null) {
            return false;
        }
        OwPropertyPlaceholder scanedPlaceholder = new OwPropertyPlaceholder(strRegion_p);
        return this.m_properties.containsKey(scanedPlaceholder.getIdentifier());
    }

    public boolean isPasteMetadataActivated() {
        return this.m_pasteMetadataHandler.isPasteMetadataActivated();
    }

    public boolean isReadOnly() {
        if (this.areAllPropertiesReadOnly()) {
            this.m_readOnlyView = true;
        }
        return this.m_readOnlyView;
    }

    private boolean isReadOnlyRendered(OwPropertyPlaceholder scanedPlaceholder_p, OwProperty property_p) throws Exception {
        boolean canSetProperties = this.m_objectref.canSetProperties(2);
        return scanedPlaceholder_p.isReadOnly() || !canSetProperties || property_p.isReadOnly(this.getReadOnlyContext());
    }

    public boolean isSystemPropertyView() {
        return false;
    }

    public void onBatchIndex() throws Exception {
        this.m_batchPropertiesHandler.onBatchIndex();
    }

    public void onPasteAllMetaData(HttpServletRequest request_p) throws Exception {
        this.m_pasteMetadataHandler.onPasteAllMetaData(request_p);
    }

    public void onPasteThisMetaData(HttpServletRequest request_p) throws Exception {
        this.m_pasteMetadataHandler.onPasteThisMetaData(request_p);
    }

    @Override
    protected void onRender(Writer w_p) throws IOException, Exception {
        this.m_theFieldManager.reset();
        if (this.m_strJspPage == null) {
            this.m_strJspPage = this.m_jspConfigurator.getJspForm(this.getObjectRef().getObjectClass().getClassName());
        }
        w_p.write(this.m_theFieldManager.renderErrors());
        if (null != this.m_strHtmlContent) {
            this.renderHTMLFormular(w_p, this.m_strHtmlContent);
        } else if (null != this.m_strJspPage) {
            this.serverSideDesignInclude(this.m_strJspPage, w_p);
        } else {
            StringBuilder message = new StringBuilder();
            message.append("Cannot find a default JSP page (JspForm) for rendering. Please define a JSP page (JspForm) for the objectclass:  ");
            message.append(this.getObjectRef().getObjectClass().getClassName());
            w_p.write(message.toString());
            LOG.warn((Object)"Default <JspForm> tag not configured properly in owplugins.xml");
            throw new OwConfigurationException(message.toString());
        }
    }

    public boolean onSave(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (this.onSaveInternal(request_p, oReason_p)) {
            if (null != this.getDocument()) {
                this.getDocument().update(this, 2, null);
                this.getDocument().update(this, 15, null);
            }
            this.informUserOnSuccess();
            return true;
        }
        if (this.m_displayNoSaveMsg) {
            String message = this.getContext().localize("owdocprops.OwEditPropertiesDialog.NotSaved", "Nothing was changed therefore the document was not saved.");
            ((OwMainAppContext)this.getContext()).postMessage(message);
        }
        this.getDocument().update(this, 18, null);
        return false;
    }

    protected boolean onSaveInternal(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwPropertyCollection changedProperties = this.update(request_p);
        return this.save(changedProperties);
    }

    protected void renderMenuRegion(Writer w_p) throws Exception {
        this.m_menu.render(w_p);
    }

    public boolean isFieldMandatory(String strPlaceHolder_p) throws Exception {
        OwPropertyPlaceholder scanedPlaceholder = new OwPropertyPlaceholder(strPlaceHolder_p);
        OwProperty property = (OwProperty)this.m_properties.get(scanedPlaceholder.getIdentifier());
        if (null != property) {
            return property.getPropertyClass().isRequired();
        }
        return false;
    }

    @Override
    public void renderNamedRegion(Writer w_p, String strPlaceHolder_p) throws Exception {
        if (strPlaceHolder_p.equals(PLACEHOLDER_MENU)) {
            this.renderMenuRegion(w_p);
            return;
        }
        if (this.m_properties == null) {
            return;
        }
        OwPropertyPlaceholder scanedPlaceholder = new OwPropertyPlaceholder(strPlaceHolder_p);
        if (scanedPlaceholder.isError()) {
            OwProperty property = (OwProperty)this.m_properties.get(scanedPlaceholder.getIdentifier());
            if (property != null) {
                w_p.write(this.m_theFieldManager.getSafeFieldError(property));
            } else {
                w_p.write("Property not found: " + scanedPlaceholder.getIdentifier());
            }
        } else if (scanedPlaceholder.isValidation()) {
            OwProperty property = (OwProperty)this.m_properties.get(scanedPlaceholder.getIdentifier());
            if (property != null) {
                w_p.write("<span class='OwPropertyError' id='HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(property) + "'></span>");
            } else {
                w_p.write("Property not found: " + scanedPlaceholder.getIdentifier());
            }
        } else {
            OwProperty property = (OwProperty)this.m_properties.get(scanedPlaceholder.getIdentifier());
            if (property != null) {
                if (scanedPlaceholder.hasSubIdentifier()) {
                    OwObject obj = (OwObject)property.getValue();
                    if (null != obj) {
                        OwProperty subProperty = obj.getProperty(scanedPlaceholder.getSubIdentifier());
                        if (subProperty == null) {
                            w_p.write("Property not found: " + scanedPlaceholder.getIdentifier() + "." + scanedPlaceholder.getSubIdentifier());
                        } else {
                            this.m_theFieldManager.insertReadOnlyField(w_p, subProperty);
                        }
                    }
                } else {
                    this.renderProperty(w_p, property, this.isReadOnlyRendered(scanedPlaceholder, property));
                }
            } else {
                w_p.write("Property not found: " + scanedPlaceholder.getIdentifier());
            }
        }
        if (this.getMenu() != null) {
            this.getMenu().enable(this.m_iSaveButton, !this.isReadOnly());
        }
    }

    public void renderPasteAll(Writer w_p) throws Exception {
        this.m_pasteMetadataHandler.renderPasteAllMetadata(w_p, this);
    }

    public void renderPasteProperty(Writer w_p, String propName_p) throws Exception {
        OwProperty prop;
        OwPropertyPlaceholder scanedPlaceholder = new OwPropertyPlaceholder(propName_p);
        if (this.m_properties != null && (prop = (OwProperty)this.m_properties.get(scanedPlaceholder.getIdentifier())) != null) {
            this.m_pasteMetadataHandler.renderPasteMetadata(w_p, prop, this);
        }
    }

    protected void renderProperty(Writer w_p, OwProperty prop_p, boolean fReadOnly_p) throws Exception {
        if (fReadOnly_p) {
            this.m_theFieldManager.insertReadOnlyField(w_p, prop_p);
        } else {
            this.m_theFieldManager.insertEditField(w_p, prop_p);
        }
    }

    protected boolean save(OwPropertyCollection changedProperties_p) throws Exception {
        if (changedProperties_p == null || changedProperties_p.size() == 0) {
            return false;
        }
        try {
            this.m_objectref.setProperties(changedProperties_p);
            changedProperties_p.clear();
        }
        catch (Exception e) {
            String msg = "Error saving the properties to the object.";
            LOG.warn((Object)msg, (Throwable)e);
            throw e;
        }
        finally {
            this.m_properties = this.m_objectref.getClonedProperties(null);
            this.m_batchPropertiesHandler.setProperties(this.m_properties);
            this.m_pasteMetadataHandler.setProperties(this.m_properties);
        }
        return true;
    }

    public void setBatchProperties(Collection batchIndexProperties_p) {
        this.m_batchPropertiesHandler.setBatchIndexProperties(batchIndexProperties_p);
    }

    public void setDisplayNoSaveMsg(boolean display_p) {
        this.m_displayNoSaveMsg = display_p;
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = (OwField)this.m_properties.get(sName_p);
        if (null == field) {
            String msg = "OwObjectPropertyFormularView.setField: Field not found, name = " + sName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        field.setValue(value_p);
        this.m_changedProperties.put(field.getFieldDefinition().getClassName(), field);
    }

    public void setHTMLFormular(String strHTMLPage_p) {
        this.m_strHtmlContent = strHTMLPage_p;
    }

    @Override
    public void setJspConfigurator(OwJspFormConfigurator jspFormConfigurator_p) {
        this.m_jspConfigurator = jspFormConfigurator_p;
    }

    public void setJspFormular(String strJspPage_p) throws Exception {
        this.m_strJspPage = strJspPage_p;
        if (this.getJspConfigurator() == null) {
            this.setJspConfigurator(new OwJspFormConfigurator(this.m_strJspPage));
        }
    }

    public void setObjectRef(OwObject objectRef_p) throws Exception {
        this.m_objectref = objectRef_p;
        if (this.getJspConfigurator() != null) {
            this.m_strJspPage = this.getJspConfigurator().getJspForm(this.m_objectref.getObjectClass().getClassName());
        }
        this.m_properties = this.m_objectref.getClonedProperties(null);
        this.m_batchPropertiesHandler.setProperties(this.m_properties);
        this.m_pasteMetadataHandler.setProperties(this.m_properties);
    }

    public void setPasteMetadataEnabled(boolean enabled_p) {
        this.m_isPasteMetadataEnabled = enabled_p;
    }

    public void setReadOnlyContext(int context_p) {
        this.m_ReadOnlyContext = context_p;
    }

    public void setSaveAllActive(boolean saveAllEnabled_p) {
        this.m_saveAllActive = saveAllEnabled_p;
    }

    protected OwPropertyCollection update(HttpServletRequest request_p) throws Exception {
        if (this.m_theFieldManager.update(request_p, this.m_changedProperties, this.m_objectref.getProperties(null))) {
            this.m_batchPropertiesHandler.saveBatchIndexProperties();
            return this.m_changedProperties;
        }
        return null;
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        OwStandardPropertyCollection changedProperties = new OwStandardPropertyCollection();
        return this.m_theFieldManager.update(request_p, changedProperties, this.m_objectref.getProperties(null));
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    public class OwPropertyPlaceholder {
        private static final String PLACEHOLDER_ERROR_PREFIX = "ow_err_";
        private static final String PLACEHOLDER_READONLY_PREFIX = "ow_ro_";
        private static final String PLACEHOLDER_VALIDATION_PREFIX = "ow_validate_";
        private boolean m_fError;
        private boolean m_fReadOnly;
        private boolean m_fSubProperty;
        private boolean m_fValidation;
        private String m_strIdentifier;
        private String m_strSubIdentifier;

        public OwPropertyPlaceholder(String strPlaceHolder_p) {
            this.m_strIdentifier = strPlaceHolder_p;
            int iQualifiedMarkerIndex = this.m_strIdentifier.indexOf(125);
            if (-1 != iQualifiedMarkerIndex) {
                this.m_strSubIdentifier = this.m_strIdentifier.substring(iQualifiedMarkerIndex + 1);
                this.m_strIdentifier = this.m_strIdentifier.substring(0, iQualifiedMarkerIndex);
                this.m_strIdentifier = this.m_strIdentifier.replaceAll("\\{", "");
                this.m_strIdentifier = this.m_strIdentifier.replaceAll("\\}", "");
                if (this.m_strSubIdentifier != null) {
                    if (this.m_strSubIdentifier.startsWith(".")) {
                        this.m_fSubProperty = true;
                        this.m_strSubIdentifier = this.m_strSubIdentifier.substring(1);
                        this.m_strSubIdentifier = this.m_strSubIdentifier.replaceAll("\\{", "");
                        this.m_strSubIdentifier = this.m_strSubIdentifier.replaceAll("\\}", "");
                    } else {
                        this.m_strSubIdentifier = null;
                    }
                }
            } else {
                int iNamespaceOperatorIndex = this.m_strIdentifier.indexOf(46);
                if (-1 != iNamespaceOperatorIndex) {
                    this.m_strSubIdentifier = this.m_strIdentifier.substring(iNamespaceOperatorIndex + 1);
                    this.m_strIdentifier = this.m_strIdentifier.substring(0, iNamespaceOperatorIndex);
                    this.m_fSubProperty = true;
                }
            }
            if (this.m_strIdentifier.startsWith(PLACEHOLDER_READONLY_PREFIX)) {
                this.m_strIdentifier = this.m_strIdentifier.substring(PLACEHOLDER_READONLY_PREFIX.length());
                this.m_fReadOnly = true;
            }
            if (this.m_strIdentifier.startsWith(PLACEHOLDER_ERROR_PREFIX)) {
                this.m_strIdentifier = this.m_strIdentifier.substring(PLACEHOLDER_ERROR_PREFIX.length());
                this.m_fError = true;
            }
            if (this.m_strIdentifier.startsWith(PLACEHOLDER_VALIDATION_PREFIX)) {
                this.m_strIdentifier = this.m_strIdentifier.substring(PLACEHOLDER_VALIDATION_PREFIX.length());
                this.m_fValidation = true;
            }
        }

        public String getIdentifier() {
            return this.m_strIdentifier;
        }

        public String getSubIdentifier() {
            return this.m_strSubIdentifier;
        }

        public boolean hasSubIdentifier() {
            return this.m_fSubProperty;
        }

        public boolean isError() {
            return this.m_fError;
        }

        public boolean isReadOnly() {
            return this.m_fReadOnly;
        }

        public boolean isValidation() {
            return this.m_fValidation;
        }
    }
}

