/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMenuView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.dmsdialogs.OwGroupPropertiesConfiguration;
import com.wewebu.ow.server.dmsdialogs.views.OwBatchPropertiesHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwPasteMetadataHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwStandardBatchPropertiesHandler;
import com.wewebu.ow.server.dmsdialogs.views.OwStandardPasteMetadataHandler;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwEnum;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwMultipanel;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OwObjectPropertyView
extends OwLayout
implements OwMultipanel,
OwFieldProvider {
    protected static final String BATCH_INDEX_PROPERTIES_ATTRIBTUE_BAG_NAME = "OwObjectPropertyViewBatchIndexProperties";
    public static final int ERRORS_REGION = 4;
    private static final String GROUP_HEADER_CLASS_NAME = "groupHeader";
    private static final Logger LOG = OwLogCore.getLogger(OwObjectPropertyView.class);
    public static final int MAIN_REGION = 1;
    public static final int MENU_REGION = 2;
    public static final int MODES_REGION = 3;
    private static final String MODES_SELECT_ID = "owmodes";
    private static final int NO_MODE = -1;
    protected static final String QUERY_KEY_PROPNAME = "prop";
    public static final int VIEW_MASK_DISABLE_INTERNAL_MENU = 2;
    public static final int VIEW_MASK_ENABLE_PASTE_METADATA = 1;
    public static final int VIEW_MASK_READONLY = 8;
    public static final int VIEW_MASK_RENDER_VERTICAL = 4;
    protected Collection m_batchIndexProperties;
    protected OwBatchPropertiesHandler m_batchPropertiesHandler;
    private boolean m_displayNoSaveMsg;
    protected boolean m_enablesaveall;
    protected boolean m_fAllPropertiesReadonly = true;
    protected boolean m_fReadOnly;
    protected boolean m_fSystem;
    private OwGroupPropertiesConfiguration m_groupPropertyConfiguration;
    protected int m_iAppyBtnIndex;
    private int m_icurrentmode = -1;
    protected int m_iLockIndex;
    protected int m_iNextButtonIndex = -1;
    protected int m_iUnLockIndex;
    protected int m_iViewMask;
    protected OwSubMenuView m_MenuView;
    private int m_modetype = 1;
    protected OwObject m_ObjectRef;
    protected OwPasteMetadataHandler m_pasteMetadataHandler;
    protected OwPropertyCollection m_Properties;
    private Collection m_propertyfilter;
    protected int m_ReadOnlyContext = 0;
    protected Map m_readOnlyProperties;
    protected boolean m_saveAllActive;
    protected OwFieldManager m_theFieldManager;
    private boolean m_updateNoChanges = false;
    private boolean m_informUserOnSuccess = true;

    public void setUpdateNoChanges(boolean updateNoChanges) {
        this.m_updateNoChanges = updateNoChanges;
    }

    public void setInformUserOnSuccess(boolean informUserOnSuccess) {
        this.m_informUserOnSuccess = informUserOnSuccess;
    }

    private boolean areAllPropertiesReadOnly() {
        for (OwProperty property : this.m_Properties.values()) {
            try {
                OwPropertyClass propertyClass = property.getPropertyClass();
                if (this.m_fSystem != propertyClass.isSystemProperty() || this.isPropertyReadonly(property)) continue;
                this.m_fAllPropertiesReadonly = false;
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot read object properties " + e.getMessage()));
            }
        }
        return this.m_fAllPropertiesReadonly;
    }

    public void clearBatchIndex() throws OwInvalidOperationException {
        this.m_batchPropertiesHandler.clearBatchIndex();
    }

    protected OwBatchPropertiesHandler createBatchPropertiesHandler() {
        return new OwStandardBatchPropertiesHandler(this.getDocument());
    }

    protected OwPasteMetadataHandler createPasteMetadataHandler() {
        return new OwStandardPasteMetadataHandler((OwMainAppContext)this.getContext(), this.m_fSystem, this.hasViewMask(1));
    }

    @Override
    public void detach() {
        super.detach();
        this.m_theFieldManager.detach();
    }

    protected OwClipboard getClipboard() {
        return ((OwMainAppContext)this.getContext()).getClipboard();
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception {
        OwProperty prop = (OwProperty)this.m_Properties.get(strFieldClassName_p);
        if (prop == null) {
            throw new OwObjectNotFoundException("OwObjectPropertyView.getField: Property not found, strFieldClassName_p = " + strFieldClassName_p);
        }
        return prop;
    }

    public OwFieldManager getFieldManager() {
        return this.m_theFieldManager;
    }

    @Override
    public String getFieldProviderName() {
        return this.m_ObjectRef.getName();
    }

    @Override
    public Object getFieldProviderSource() {
        return this.m_ObjectRef;
    }

    @Override
    public int getFieldProviderType() {
        switch (this.m_ReadOnlyContext) {
            case 1: {
                return 17;
            }
            case 2: {
                return 33;
            }
        }
        return 1;
    }

    @Override
    public Collection getFields() throws Exception {
        return this.m_Properties.values();
    }

    protected OwPropertyCollection getFilteredClonedProperties() throws Exception {
        OwPropertyCollection ret = this.m_ObjectRef.getClonedProperties(this.m_propertyfilter);
        if (null != this.m_propertyfilter) {
            OwStandardPropertyCollection retFiltered = new OwStandardPropertyCollection();
            for (String sPropName : this.m_propertyfilter) {
                OwProperty prop = (OwProperty)ret.get(sPropName);
                if (prop == null || prop.isHidden(this.m_ReadOnlyContext)) continue;
                retFiltered.put(sPropName, prop);
            }
            return retFiltered;
        }
        OwStandardPropertyCollection retFiltered = new OwStandardPropertyCollection();
        for (OwProperty prop : ret.values()) {
            if (prop == null || prop.isHidden(this.m_ReadOnlyContext)) continue;
            retFiltered.put(prop.getPropertyClass().getClassName(), prop);
        }
        return retFiltered;
    }

    public OwMenuView getMenu() {
        return this.m_MenuView;
    }

    public OwObject getObjectRef() {
        return this.m_ObjectRef;
    }

    protected String getRowClassName(int iIndex_p, OwProperty prop_p) {
        return iIndex_p % 2 != 0 ? "OwObjectPropertyView_OddRow" : "OwObjectPropertyView_EvenRow";
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = (OwField)this.m_Properties.get(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    public int getSaveBtnIndex() {
        return this.m_iAppyBtnIndex;
    }

    public boolean getUpdateStatus() {
        return this.m_theFieldManager.getUpdateStatus();
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (this.m_iViewMask & iViewMask_p) > 0;
    }

    protected void informUserOnSuccess() {
        if (this.m_informUserOnSuccess) {
            ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("app.OwObjectPropertyView.saved", "Changes have been saved."));
        }
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_theFieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
        this.m_theFieldManager.setExternalFormTarget(this.getFormTarget());
        if (!this.hasViewMask(2)) {
            this.m_MenuView = new OwSubMenuView();
            this.addView(this.m_MenuView, 2, null);
        }
        if (this.getMenu() != null) {
            this.m_iAppyBtnIndex = this.getMenu().addFormMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.save", "Save"), "Apply", null);
            this.getMenu().setDefaultMenuItem(this.m_iAppyBtnIndex);
            this.getMenu().enable(this.m_iAppyBtnIndex, false);
        }
        this.m_batchPropertiesHandler = this.createBatchPropertiesHandler();
        this.m_pasteMetadataHandler = this.createPasteMetadataHandler();
        this.setDisplayNoSaveMsg(false);
    }

    protected boolean isGroupWithErrors(OwGroupPropertiesConfiguration.OwPropertyGroup theGroup_p) throws Exception {
        List<OwPropertyInfo> props = theGroup_p.getProperties();
        boolean result = false;
        for (OwPropertyInfo prop : props) {
            OwField owProp = (OwField)this.m_Properties.get(prop.getPropertyName());
            String errorString = this.m_theFieldManager.getSafeFieldError(owProp);
            if (errorString == null || errorString.length() <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isPropertyReadonly(OwProperty property_p) throws Exception {
        if (property_p.isReadOnly(this.m_ReadOnlyContext)) {
            return true;
        }
        return null != this.m_readOnlyProperties && this.m_readOnlyProperties.containsKey(property_p.getFieldDefinition().getClassName());
    }

    public boolean isReadOnly() {
        if (this.areAllPropertiesReadOnly()) {
            this.m_fReadOnly = true;
        }
        return this.m_fReadOnly;
    }

    @Override
    public boolean isRegion(int region_p) {
        switch (region_p) {
            case 4: {
                return true;
            }
            case 3: {
                try {
                    if (this.m_modetype == 0) {
                        return false;
                    }
                    return null != this.m_ObjectRef.getObjectClass().getModes(this.m_modetype);
                }
                catch (Exception e) {
                    return false;
                }
            }
            case 1: {
                return true;
            }
        }
        return super.isRegion(region_p);
    }

    protected boolean isSupportLock() {
        return true;
    }

    public boolean isSystemPropertyView() {
        return this.m_fSystem;
    }

    @Override
    public boolean isValidated() throws Exception {
        if (null == this.m_Properties) {
            return false;
        }
        for (OwProperty prop : this.m_Properties.values()) {
            OwPropertyClass propClass = prop.getPropertyClass();
            if (propClass.isSystemProperty() || !propClass.isRequired() || prop.getValue() != null && prop.getValue().toString().length() != 0) continue;
            return false;
        }
        return true;
    }

    public Boolean mapProperties(Map map_p, String name_p) {
        if (map_p.get(name_p) == null) {
            return null;
        }
        if (map_p.get(name_p).toString().equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void onAjaxPropertyGroupCollapse(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String groupId = request_p.getParameter("owGroupId");
        String isGroupCollapsed = request_p.getParameter("isGroupCollapsed");
        if (this.m_groupPropertyConfiguration != null && groupId != null && isGroupCollapsed != null) {
            OwGroupPropertiesConfiguration.OwPropertyGroup group = this.m_groupPropertyConfiguration.getGroupById(groupId);
            group.setCollapsed(Boolean.parseBoolean(isGroupCollapsed));
        }
    }

    public boolean onApply(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (this.onApplyInternal(request_p, oReason_p)) {
            this.safeUpdate(this, 2);
            this.safeUpdate(this, 15);
            this.informUserOnSuccess();
            return true;
        }
        if (this.m_displayNoSaveMsg) {
            String message = this.getContext().localize("owdocprops.OwEditPropertiesDialog.NotSaved", "Nothing was changed therefore the document was not saved.");
            ((OwMainAppContext)this.getContext()).postMessage(message);
            this.safeUpdate(this, 18);
        }
        return false;
    }

    protected boolean onApplyInternal(HttpServletRequest request_p, Object oReason_p) throws Exception {
        OwPropertyCollection changedProperties = this.update(request_p);
        if (null == changedProperties) {
            return this.m_updateNoChanges;
        }
        return this.save(changedProperties);
    }

    public void onBatchIndex() throws Exception {
        this.m_batchPropertiesHandler.onBatchIndex();
    }

    public void onLock(HttpServletRequest request_p, Object oReason_p) throws Exception {
        this.m_ObjectRef.setLock(true);
        this.safeUpdate(this, 2);
    }

    public void onNext(HttpServletRequest request_p, Object oReason_p) throws Exception {
        if (this.onApplyInternal(request_p, null)) {
            ((OwView)oReason_p).activate();
        }
    }

    public void onPasteAllMetaData(HttpServletRequest request_p) throws Exception {
        this.m_pasteMetadataHandler.onPasteAllMetaData(request_p);
    }

    public void onPasteThisMetaData(HttpServletRequest request_p) throws Exception {
        this.m_pasteMetadataHandler.onPasteThisMetaData(request_p);
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwObjectPropertyView.jsp", w_p);
        ((OwMainAppContext)this.getContext()).setFocusControlID(this.m_theFieldManager.getFocusControlID());
    }

    public void onUnLock(HttpServletRequest request_p, Object oReason_p) throws Exception {
        this.m_ObjectRef.setLock(false);
        this.safeUpdate(this, 2);
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        switch (iCode_p) {
            case 1: {
                this.m_Properties = this.getFilteredClonedProperties();
                this.m_batchPropertiesHandler.setProperties(this.m_Properties);
                this.m_pasteMetadataHandler.setProperties(this.m_Properties);
            }
            case 2: {
                if (this.m_fSystem || this.hasViewMask(8)) {
                    this.m_fReadOnly = true;
                } else {
                    boolean bl = this.m_fReadOnly = this.m_ObjectRef.canLock() && !this.m_ObjectRef.getLock(2) || !this.m_ObjectRef.canSetProperties(2);
                }
                if (this.getMenu() == null || !this.isSupportLock() || !this.m_ObjectRef.canLock()) break;
                if (this.m_ObjectRef.getLock(2)) {
                    this.getMenu().enable(this.m_iLockIndex, false);
                    this.getMenu().enable(this.m_iUnLockIndex, true);
                    this.getMenu().setDefaultMenuItem(this.m_iAppyBtnIndex);
                    break;
                }
                this.getMenu().enable(this.m_iLockIndex, true);
                this.getMenu().enable(this.m_iUnLockIndex, false);
                this.getMenu().setDefaultMenuItem(this.m_iLockIndex);
            }
        }
    }

    protected void renderErrorsRegion(Writer w_p) throws Exception {
        w_p.write(this.m_theFieldManager.renderErrors());
    }

    protected void renderExtraColumnHeader(Writer w_p) throws Exception {
        if (this.m_pasteMetadataHandler.isPasteMetadataActivated()) {
            w_p.write("<th class=\"OwPasteMetadata\">");
            this.m_pasteMetadataHandler.renderPasteAllMetadata(w_p, this);
            w_p.write("</th>");
        }
    }

    protected void renderExtraColumnRows(Writer w_p, OwProperty prop_p) throws Exception {
        if (this.m_pasteMetadataHandler.isPasteMetadataActivated()) {
            w_p.write("\n<td class=\"OwPasteMetadata\">");
            this.m_pasteMetadataHandler.renderPasteMetadata(w_p, prop_p, this);
            w_p.write("</td>");
        }
    }

    protected void renderGroupHeader(OwGroupPropertiesConfiguration.OwPropertyGroup theGroup_p, Writer w_p, String strRowClassName_p) throws Exception {
        if (this.isGroupWithErrors(theGroup_p)) {
            theGroup_p.setCollapsed(false);
        }
        w_p.write("<tr class='" + strRowClassName_p + "' ");
        w_p.write("onClick=\"");
        w_p.write("OwPropGroup.toggleGroup('" + theGroup_p.getGroupId() + "','" + this.getAjaxEventURL("PropertyGroupCollapse", null) + "');");
        w_p.write("\">\n");
        w_p.write("<td id=\"td_" + OwHTMLHelper.encodeJavascriptVariableName(theGroup_p.getGroupId()) + "\" class=\"");
        if (!theGroup_p.isCollapsed()) {
            w_p.write("OwGroupExpanded");
        } else {
            w_p.write("OwGroupCollapsed");
        }
        w_p.write("\">&nbsp;</td>");
        int numberOfColumns = this.m_pasteMetadataHandler.isPasteMetadataActivated() ? 3 : 2;
        w_p.write("<td colspan=\"" + numberOfColumns + "\" class=\"OwGroupName\">");
        w_p.write(OwHTMLHelper.encodeToSecureHTML(theGroup_p.getDisplayName(this.getContext())));
        w_p.write("<input type=\"hidden\" value =\"" + theGroup_p.isCollapsed() + "\" id=\"isCollapsed_" + theGroup_p.getGroupId() + "\"/>");
        w_p.write("</td>");
        w_p.write("</tr>\n");
    }

    protected void renderHorizontalProperties(Writer w_p) throws Exception {
        Iterator it = this.m_Properties.values().iterator();
        String strRowClassName = null;
        int iIndex = 0;
        while (it.hasNext()) {
            OwProperty property = (OwProperty)it.next();
            OwPropertyClass propertyClass = property.getPropertyClass();
            if (this.m_fSystem != propertyClass.isSystemProperty()) continue;
            strRowClassName = this.getRowClassName(iIndex, property);
            this.renderHorizontalProperty(w_p, strRowClassName, property, propertyClass);
            ++iIndex;
        }
    }

    protected void renderHorizontalProperty(Writer w_p, String strRowClassName_p, OwProperty property_p, OwPropertyClass propertyClass_p) throws Exception {
        w_p.write("<tr class='" + strRowClassName_p + "'>\n");
        this.renderExtraColumnRows(w_p, property_p);
        w_p.write("<td class=\"OwRequired\">");
        if (propertyClass_p.isRequired()) {
            String requiredTooltip = this.getContext().localize("app.OwObjectPropertyView.required", "Required");
            w_p.write("<img src='" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/required.png' alt='" + requiredTooltip + "' title='" + requiredTooltip + "'/>");
        } else {
            w_p.write("<img src='" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/notrequired.gif' alt=''>");
        }
        w_p.write("</td>\n");
        w_p.write("<td class='OwPropertyName' title='" + propertyClass_p.getClassName() + "'>");
        this.m_theFieldManager.insertLabel(w_p, this.m_fReadOnly, this.isPropertyReadonly(property_p), property_p, ":&nbsp;&nbsp;", true);
        w_p.write("</td>\n<td class='DefaultInput'>\n");
        w_p.write("<div class='OwPropertyControl'>");
        if (this.m_fReadOnly || this.isPropertyReadonly(property_p)) {
            this.m_theFieldManager.insertReadOnlyField(w_p, property_p);
        } else {
            w_p.write("\n");
            this.m_theFieldManager.insertEditField(w_p, property_p);
            this.m_fAllPropertiesReadonly = false;
        }
        w_p.write("</div>\n");
        w_p.write("<div class='OwPropertyError'>");
        w_p.write(this.m_theFieldManager.getSafeFieldError(property_p));
        w_p.write("</div>\n");
        w_p.write("<div class='OwPropertyError' id='HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(property_p) + "'></div>\n");
        w_p.write("</td>\n");
        w_p.write("</tr>\n");
    }

    protected void renderHorizontalPropertyGroups(Writer w_p) throws Exception {
        List<OwGroupPropertiesConfiguration.OwPropertyGroup> groups = this.m_groupPropertyConfiguration.getGroups();
        int index = 0;
        for (OwGroupPropertiesConfiguration.OwPropertyGroup owPropertyGroup : groups) {
            w_p.write("<tbody id=\"groupHeader" + OwHTMLHelper.encodeJavascriptVariableName(owPropertyGroup.getGroupId()) + "\">");
            this.renderGroupHeader(owPropertyGroup, w_p, GROUP_HEADER_CLASS_NAME);
            w_p.write("</tbody>");
            w_p.write("<tbody id=\"" + OwHTMLHelper.encodeJavascriptVariableName(owPropertyGroup.getGroupId()) + "\"");
            w_p.write(" class=\"");
            if (owPropertyGroup.isCollapsed()) {
                w_p.write("OwGroupBodyCollapsed");
            } else {
                w_p.write("OwGroupBodyExpanded");
            }
            w_p.write("\">");
            List<OwPropertyInfo> properties = owPropertyGroup.getProperties();
            for (OwPropertyInfo owPropertyInfo : properties) {
                OwProperty prop = (OwProperty)this.m_Properties.get(owPropertyInfo.m_propertyName);
                if (prop == null) continue;
                OwPropertyClass propertyClass = prop.getPropertyClass();
                String strRowClassName = this.getRowClassName(index, prop);
                this.renderHorizontalProperty(w_p, strRowClassName, prop, propertyClass);
                ++index;
            }
            w_p.write("</tbody>");
        }
    }

    protected void renderMainRegion(Writer w_p) throws Exception {
        this.m_theFieldManager.reset();
        if (this.m_Properties == null || this.m_Properties.size() == 0) {
            return;
        }
        if (this.hasViewMask(4)) {
            for (OwProperty property : this.m_Properties.values()) {
                OwPropertyClass propertyClass = property.getPropertyClass();
                if (this.m_fSystem != propertyClass.isSystemProperty()) continue;
                w_p.write("<div class='OwPropertyName' style='clear: both;'>");
                this.m_theFieldManager.insertLabel(w_p, this.m_fReadOnly, this.isPropertyReadonly(property), property, ":&nbsp;&nbsp;", true);
                w_p.write("</div>\n");
                w_p.write("<div>\n");
                w_p.write("<div class='OwPropertyControl'>");
                if (this.m_fReadOnly || this.isPropertyReadonly(property)) {
                    this.m_theFieldManager.insertReadOnlyField(w_p, property);
                } else {
                    this.m_theFieldManager.insertEditField(w_p, property);
                    this.m_fAllPropertiesReadonly = false;
                }
                w_p.write("</div>\n");
                w_p.write("<div class='OwPropertyError'>");
                w_p.write(this.m_theFieldManager.getSafeFieldError(property));
                w_p.write("</div>\n");
                w_p.write("<div class='OwPropertyError' id='HotInfo" + this.m_theFieldManager.getFieldJSErrorCtrlID(property) + "'></div>\n");
                w_p.write("<br><br>\n");
                w_p.write("</div>\n");
            }
        } else {
            w_p.write("<table class='OwObjectPropertyView_PropList'>\n");
            w_p.write("<thead>\n");
            w_p.write("<tr class='OwObjectPropertyView_Header'>\n");
            this.renderExtraColumnHeader(w_p);
            w_p.write("<th class='OwRequired'><img  alt='' src='" + this.getContext().getDesignURL() + "/images/OwObjectPropertyView/notrequired.gif'></th>");
            w_p.write("<th class=\"OwPropertyName\">" + this.getContext().localize("app.OwObjectPropertyView.propertycolumn", "Property") + "&nbsp;&nbsp;</th><th>" + this.getContext().localize("app.OwObjectPropertyView.valuecolumn", "Value") + "&nbsp;&nbsp;</th>\n");
            w_p.write("</tr>\n");
            w_p.write("</thead>\n");
            if (this.m_groupPropertyConfiguration != null && this.m_groupPropertyConfiguration.isConfigured()) {
                this.getContext().renderJSInclude("/js/oweditproperties.js", w_p);
                this.renderHorizontalPropertyGroups(w_p);
            } else {
                w_p.write("<tbody>\n");
                this.renderHorizontalProperties(w_p);
                w_p.write("</tbody>\n");
            }
            w_p.write("</table>\n");
        }
        if (this.m_fSystem || this.hasViewMask(8) || this.m_fAllPropertiesReadonly) {
            this.m_fReadOnly = true;
        } else {
            boolean bl = this.m_fReadOnly = this.m_ObjectRef.canLock() && !this.m_ObjectRef.getLock(2) || !this.m_ObjectRef.canSetProperties(2);
        }
        if (this.getMenu() != null) {
            this.getMenu().enable(this.m_iAppyBtnIndex, !this.m_fReadOnly);
        }
    }

    protected void renderModesRegion(Writer w_p) throws Exception {
        if (this.m_modetype == 0 || this.m_fReadOnly) {
            return;
        }
        List propmodes = this.m_ObjectRef.getObjectClass().getModes(this.m_modetype);
        if (null != propmodes) {
            LinkedList<OwDefaultComboItem> items = new LinkedList<OwDefaultComboItem>();
            for (int i = 0; i < propmodes.size(); ++i) {
                OwEnum mode = (OwEnum)propmodes.get(i);
                OwDefaultComboItem item = new OwDefaultComboItem(String.valueOf(i), mode.getDisplayName(this.getContext().getLocale()));
                items.add(item);
            }
            OwDefaultComboModel model = new OwDefaultComboModel(false, false, "" + this.m_icurrentmode, items);
            OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(model, MODES_SELECT_ID, null, null, new OwString("app.OwObjectPropertyView.modes.title", "Modes"));
            renderer.renderCombo(w_p);
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 4: {
                this.renderErrorsRegion(w_p);
                break;
            }
            case 3: {
                this.renderModesRegion(w_p);
                break;
            }
            case 1: {
                this.renderMainRegion(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    private void safeBatchIndexProperties() throws Exception {
        this.m_batchPropertiesHandler.saveBatchIndexProperties();
    }

    private void safeUpdate(OwEventTarget target_p, int iCode_p) throws Exception {
        OwDocument doc = this.getDocument();
        if (null != doc) {
            doc.update(target_p, iCode_p, null);
        }
    }

    protected boolean save(OwPropertyCollection changedProperties_p) throws Exception {
        if (changedProperties_p == null || changedProperties_p.size() == 0) {
            return this.m_updateNoChanges;
        }
        Object mode = null;
        if (-1 != this.m_icurrentmode) {
            List propmodes = this.m_ObjectRef.getObjectClass().getModes(this.m_modetype);
            OwEnum modeenum = (OwEnum)propmodes.get(this.m_icurrentmode);
            mode = modeenum.getValue();
        }
        try {
            this.m_ObjectRef.setProperties(changedProperties_p, mode);
        }
        catch (Exception e) {
            String msg = "Error saving the properties to the object.";
            LOG.error((Object)msg, (Throwable)e);
            throw e;
        }
        finally {
            this.m_Properties = this.getFilteredClonedProperties();
        }
        return true;
    }

    public void setBatchProperties(Collection set_p) {
        this.m_batchIndexProperties = set_p;
        this.m_batchPropertiesHandler.setBatchIndexProperties(set_p);
    }

    protected void setDisplayNoSaveMsg(boolean display_p) {
        this.m_displayNoSaveMsg = display_p;
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = (OwField)this.m_Properties.get(sName_p);
        if (null == field) {
            String msg = "OwObjectPropertyView.setField: Field not found, name = " + sName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        field.setValue(value_p);
    }

    public void setGroupPropertiesConfiguration(OwGroupPropertiesConfiguration groupPropertyConfiguration_p) {
        this.m_groupPropertyConfiguration = groupPropertyConfiguration_p;
        if (this.m_groupPropertyConfiguration != null && this.m_groupPropertyConfiguration.isConfigured()) {
            List<String> filteredPropNames;
            Map<String, Boolean> readOnlyProps = this.m_groupPropertyConfiguration.getReadOnlyProperties();
            if (readOnlyProps.size() > 0) {
                if (this.m_readOnlyProperties == null) {
                    this.m_readOnlyProperties = new HashMap();
                }
                this.m_readOnlyProperties.putAll(this.m_groupPropertyConfiguration.getReadOnlyProperties());
            }
            if ((filteredPropNames = this.m_groupPropertyConfiguration.getAllPropertyNames()).size() > 0) {
                if (this.m_propertyfilter == null) {
                    this.m_propertyfilter = new ArrayList();
                }
                this.m_propertyfilter.addAll(filteredPropNames);
            }
        }
    }

    public void setModeType(int modetype_p) {
        this.m_modetype = modetype_p;
    }

    @Override
    public void setNextActivateView(OwView nextView_p) throws Exception {
        if (this.getMenu() != null) {
            this.m_iNextButtonIndex = this.getMenu().addFormMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.next", "Next"), null, "Next", nextView_p, null);
            this.getMenu().enable(this.m_iNextButtonIndex, true);
        }
    }

    public void setObjectRef(OwObject objectRef_p, boolean showSystemProperties_p) throws Exception {
        this.setObjectRefEx(objectRef_p, showSystemProperties_p, null);
    }

    public void setObjectRefEx(OwObject objectRef_p, boolean showSystemProperties_p, Collection propertyInfos_p) throws Exception {
        if (null != propertyInfos_p) {
            this.m_propertyfilter = new ArrayList();
            this.m_readOnlyProperties = new HashMap();
            for (OwPropertyInfo pi : propertyInfos_p) {
                this.m_propertyfilter.add(pi.getPropertyName());
                if (!pi.isReadOnly()) continue;
                this.m_readOnlyProperties.put(pi.getPropertyName(), Boolean.TRUE);
            }
        }
        this.m_theFieldManager.reset();
        this.m_ObjectRef = objectRef_p;
        this.m_theFieldManager.setFieldProvider(this);
        this.m_fSystem = showSystemProperties_p;
        if (this.getMenu() != null && this.isSupportLock() && this.m_ObjectRef.canLock()) {
            this.m_iLockIndex = this.getMenu().addMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.lock", "Lock document"), "Lock", null);
            this.m_iUnLockIndex = this.getMenu().addMenuItem(this, this.getContext().localize("app.OwObjectPropertyView.unlcok", "Unlock document"), "UnLock", null);
        }
        this.m_Properties = this.getFilteredClonedProperties();
        this.onUpdate(this, 2, null);
        this.m_batchPropertiesHandler.setProperties(this.m_Properties);
        this.m_pasteMetadataHandler.setProperties(this.m_Properties);
    }

    @Override
    public void setPrevActivateView(OwView prevView_p) throws Exception {
    }

    public void setReadOnlyContext(int context_p) {
        this.m_ReadOnlyContext = context_p;
    }

    public void setSaveAllActive(boolean active_p) {
        this.m_saveAllActive = active_p;
    }

    public void setSaveBtnIndex(int mIAppyBtnIndex_p) {
        this.m_iAppyBtnIndex = mIAppyBtnIndex_p;
    }

    public void setViewMask(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    protected OwPropertyCollection update(HttpServletRequest request_p) throws Exception {
        OwStandardPropertyCollection changedProperties;
        List propmodes;
        if (this.m_modetype != 0 && null != (propmodes = this.m_ObjectRef.getObjectClass().getModes(this.m_modetype))) {
            this.m_icurrentmode = Integer.parseInt(request_p.getParameter(MODES_SELECT_ID));
        }
        if (this.m_theFieldManager.update(request_p, changedProperties = new OwStandardPropertyCollection(), this.m_ObjectRef.getProperties(null))) {
            this.safeBatchIndexProperties();
            return changedProperties;
        }
        return null;
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        OwStandardPropertyCollection changedProperties = new OwStandardPropertyCollection();
        if (this.m_ObjectRef == null) {
            LOG.debug((Object)"OwObjectPropertyView.updateExternalFormTarget: The refer object (property, objectclass...) is missing. Please select one.");
            throw new OwInvalidOperationException(this.getContext().localize("app.OwObjectPropertyView.invalid.objectreferer", "The refer object (property, objectclass...) is missing. Please select one."));
        }
        OwPropertyCollection properties = this.m_ObjectRef.getProperties(null);
        return this.m_theFieldManager.update(request_p, changedProperties, properties);
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    public static class OwPropertyInfo {
        private String m_propertyName;
        private boolean m_readOnly;

        public OwPropertyInfo(String propertyName_p, boolean readOnly_p) {
            this.m_propertyName = propertyName_p;
            this.m_readOnly = readOnly_p;
        }

        public String getPropertyName() {
            return this.m_propertyName;
        }

        public boolean isReadOnly() {
            return this.m_readOnly;
        }

        public int hashCode() {
            return this.m_propertyName.hashCode();
        }

        public String toString() {
            return this.m_propertyName;
        }
    }
}

