/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwScript;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectTreeView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwTreeView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OwObjectTreeViewEXTJS
extends OwObjectTreeView {
    private static Logger LOG = OwLogCore.getLogger(OwObjectTreeViewEXTJS.class);
    protected static final String FOLDER_CLOSE_CSS_CLASS = "folder-close";
    protected static final String FOLDER_OPEN_CSS_CLASS = "folder-open";
    private String m_externalUpdateURL;
    private Map<String, String> m_componentsUpdateURLs = new LinkedHashMap<String, String>();
    private boolean m_useIconClass = false;
    private boolean m_expandOnSelect = false;
    private OwTreeViewNodeJS m_theSelectedNode = null;
    private String dnDAppletURL = null;

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.getContext().renderJSInclude("/js/owobjecttreeviewextjs.js", w_p);
        this.renderMainRegion(w_p);
        ((OwMainAppContext)this.getContext()).addFinalScript(new OwScript("\n if (typeof(window['OwObjectTreeViewEXTJS']) != 'undefined') {OwObjectTreeViewEXTJS.init();}\n", 90));
    }

    protected void renderMainRegion(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwObjectTreeViewEXTJS.jsp", w_p);
    }

    public synchronized void onAjaxNodeCollapsed(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String collapsedParam = request_p.getParameter("collapsed");
        String nodeId = request_p.getParameter("owNodeId");
        if (collapsedParam != null && nodeId != null) {
            boolean colapsedStatus = Boolean.parseBoolean(collapsedParam);
            OwTreeViewNodeJS node = (OwTreeViewNodeJS)this.getNodeFromID(nodeId);
            if (node != null && node.isCollapsed() != colapsedStatus) {
                node.toggleExpand();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Node <" + node + "> collapsed state: " + collapsedParam));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAjaxGetTreeData(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        OwObjectTreeViewEXTJS owObjectTreeViewEXTJS = this;
        synchronized (owObjectTreeViewEXTJS) {
            if (this.m_theSelectedNode == null) {
                this.m_theSelectedNode = (OwTreeViewNodeJS)super.getCurrentNode();
            }
            PrintWriter writer = response_p.getWriter();
            String node = request_p.getParameter("node");
            if (node != null) {
                OwTreeViewNodeJS selectedNode = (OwTreeViewNodeJS)this.m_nodeMap.get(node);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("onAjaxGetTreeData: " + selectedNode.getDisplayPath()));
                }
                String subtreeJSON = selectedNode.toJSONTree();
                ((Writer)writer).write(subtreeJSON);
            }
            ((Writer)writer).close();
        }
    }

    private void appendNodeIconLook(StringBuilder result_p, OwTreeViewNodeJS node_p) throws Exception {
        if (this.m_useIconClass) {
            this.appendNodeIconCls(result_p, node_p);
        } else {
            this.appendNodeIcon(result_p, node_p);
            result_p.append(",openedIcon:'");
            result_p.append(node_p.getOpenIconURL());
            result_p.append("'");
            result_p.append(",closedIcon:'");
            result_p.append(node_p.getCloseIconURL());
            result_p.append("'");
        }
    }

    private void writeChildren(OwTreeViewNodeJS selectedNode_p, boolean renderSelectedNode_p, StringBuilder buffer_p, Iterator<OwTreeViewNodeJS> childrenIterator_p) throws Exception {
        while (childrenIterator_p.hasNext()) {
            OwTreeViewNodeJS node = childrenIterator_p.next();
            buffer_p.append("{");
            buffer_p.append("singleClickExpand:").append(this.m_expandOnSelect).append(",");
            buffer_p.append("text: '").append(node.getDisplayHTML()).append("'");
            buffer_p.append(",id: '").append(node.getID()).append("'");
            buffer_p.append(",cls: 'folder',expanded:");
            buffer_p.append(!node.isCollapsed());
            buffer_p.append(",");
            this.appendNodeIconLook(buffer_p, node);
            if (!node.hasPlusMinusIcon()) {
                buffer_p.append(",leaf: true");
            }
            this.writeNode(selectedNode_p, renderSelectedNode_p, buffer_p, node);
            buffer_p.append("}");
            if (!childrenIterator_p.hasNext()) continue;
            buffer_p.append(",");
        }
    }

    private void writeNode(OwTreeViewNodeJS selectedNode_p, boolean renderSelectedNode_p, StringBuilder result_p, OwTreeViewNodeJS currentNode_p) throws Exception {
        List<OwTreeViewNodeJS> children;
        OwTreeView.OwTreeViewNode currentSelectedNode;
        if (selectedNode_p.isCollapsed() && renderSelectedNode_p) {
            selectedNode_p.toggleExpand();
        }
        if ((currentNode_p.equals(currentSelectedNode = this.getCurrentSelectedNode()) || currentNode_p.equals(selectedNode_p)) && renderSelectedNode_p && currentNode_p.hasPlusMinusIcon()) {
            result_p.append(",children: ");
            result_p.append(this.writeFirstLevel(currentNode_p));
        }
        if (currentSelectedNode != null && currentNode_p.equals(currentSelectedNode.getParent()) && (children = currentNode_p.getChildren()) != null) {
            result_p.append(",children: [");
            this.writeChildren(currentNode_p, renderSelectedNode_p, result_p, children.iterator());
            result_p.append("]");
        }
    }

    protected String writeFirstLevel(OwTreeViewNodeJS currentNode_p) throws Exception {
        StringBuilder firstLevelBuffer = new StringBuilder();
        firstLevelBuffer.append("[");
        Iterator<OwTreeViewNodeJS> childrenIterator = currentNode_p.getChildren().iterator();
        while (childrenIterator.hasNext()) {
            StringBuilder buff = new StringBuilder();
            OwTreeViewNodeJS node = childrenIterator.next();
            buff.append("{");
            buff.append("singleClickExpand:").append(this.m_expandOnSelect).append(",");
            buff.append("text: '").append(node.getDisplayHTML()).append("',");
            buff.append("cls: 'folder',expanded:");
            buff.append(!node.isCollapsed()).append(",");
            this.appendNodeIconLook(buff, node);
            if (!node.hasPlusMinusIcon()) {
                buff.append(",leaf: true");
            }
            buff.append(",id: '");
            buff.append(node.getID()).append("'");
            firstLevelBuffer.append(buff.toString());
            firstLevelBuffer.append("}");
            if (!childrenIterator.hasNext()) continue;
            firstLevelBuffer.append(",");
        }
        firstLevelBuffer.append("]");
        return firstLevelBuffer.toString();
    }

    private void appendNodeIcon(StringBuilder buffer_p, OwTreeViewNodeJS node_p) throws Exception {
        buffer_p.append("icon:'");
        String iconString = null;
        iconString = this.getNodeIcon(node_p);
        buffer_p.append(iconString);
        buffer_p.append("'");
    }

    private String getNodeIcon(OwTreeViewNodeJS node_p) throws Exception {
        OwTreeView.OwTreeViewNode currentNode = this.getCurrentNode();
        String iconString = currentNode != null && node_p.equals(currentNode) ? node_p.getOpenIconURL() : node_p.getCloseIconURL();
        return iconString;
    }

    private void appendNodeIconCls(StringBuilder buffer_p, OwTreeViewNodeJS node_p) {
        String nodeStyleClass = null;
        nodeStyleClass = this.getNodeIconClass(node_p);
        buffer_p.append("iconCls: '" + nodeStyleClass + "' ");
    }

    private String getNodeIconClass(OwTreeViewNodeJS node_p) {
        OwTreeView.OwTreeViewNode currentNode = this.getCurrentNode();
        String nodeStyleClass = currentNode != null && node_p.equals(currentNode) ? FOLDER_OPEN_CSS_CLASS : FOLDER_CLOSE_CSS_CLASS;
        return nodeStyleClass;
    }

    public String getRootIconClass() {
        String result = "";
        if (this.m_root != null) {
            result = this.getNodeIconClass((OwTreeViewNodeJS)this.m_root);
        }
        return result;
    }

    public String getRootText() throws Exception {
        String result = "";
        if (this.m_root != null) {
            result = this.m_root.getDisplayHTML();
        }
        return result;
    }

    public String getRootId() {
        return this.m_root.getID();
    }

    @Override
    protected String getDisplayHTML(Object obj_p, OwTreeView.OwTreeViewNode node_p) throws Exception {
        try {
            int iChildCount = ((OwObject)obj_p).getChildCount(new int[]{4096}, 1);
            StringBuilder ret = new StringBuilder();
            ret.append(OwHTMLHelper.encodeToSecureHTML(this.getDisplayName(obj_p, node_p)));
            ret.append("<span class=&quot;OwObjectTreeViewChildCount&quot;> (");
            ret.append(String.valueOf(iChildCount));
            ret.append(")</span>");
            return ret.toString();
        }
        catch (OwStatusContextException e) {
            return OwHTMLHelper.encodeToSecureHTML(this.getDisplayName(obj_p, node_p));
        }
    }

    @Override
    protected OwTreeView.OwTreeViewNode createTreeViewNode(OwTreeView treeView_p, Object obj_p) {
        return new OwTreeViewNodeJS(treeView_p, obj_p);
    }

    public String getExternalUpdateURL() {
        return this.m_externalUpdateURL;
    }

    public void setExternalUpdateURL(String externalUpdateURL_p) {
        this.m_externalUpdateURL = externalUpdateURL_p;
    }

    public String getSelectedId() {
        String selectedId = this.m_root.getID();
        if (this.getCurrentSelectedNode() != null) {
            selectedId = this.getCurrentSelectedNode().getID();
        }
        return selectedId;
    }

    public String getSelectedPathIds() {
        List<String> selectedPathIds = this.computeSelectedPathIds();
        Iterator<String> iterator = selectedPathIds.iterator();
        return this.createJsArray(iterator);
    }

    private String createJsArray(Iterator<String> iterator_p) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        while (iterator_p.hasNext()) {
            String element = iterator_p.next();
            result.append("'").append(element).append("'");
            if (!iterator_p.hasNext()) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    private List<String> computeSelectedPathIds() {
        LinkedList<String> result = new LinkedList<String>();
        if (this.getCurrentSelectedNode() != null) {
            result.add(this.getCurrentSelectedNode().getID());
            OwTreeView.OwTreeViewNode node = this.getCurrentSelectedNode();
            while (node.getParent() != null) {
                node = node.getParent();
                result.add(node.getID());
            }
        }
        Collections.reverse(result);
        return result;
    }

    public String getRootIcon() throws Exception {
        String result = "";
        if (this.m_root != null) {
            result = this.getNodeIcon((OwTreeViewNodeJS)this.m_root);
        }
        return result;
    }

    public void addComponentUpdateURL(String elementId_p, String updateLink_p) {
        this.m_componentsUpdateURLs.put(elementId_p, updateLink_p);
    }

    public String getUpdateComponentIds() {
        return this.createJsArray(this.m_componentsUpdateURLs.keySet().iterator());
    }

    public String getUpdateComponentsURLs() {
        return this.createJsArray(this.m_componentsUpdateURLs.values().iterator());
    }

    public String getRootClosedIcon() throws Exception {
        String result = "";
        if (this.m_root != null) {
            result = this.m_root.getCloseIconURL();
        }
        return result;
    }

    public String getRootOpenedIcon() throws Exception {
        String result = "";
        if (this.m_root != null) {
            result = this.m_root.getOpenIconURL();
        }
        return result;
    }

    public boolean isIconClassInUse() {
        return this.m_useIconClass;
    }

    public void setIconClassInUse(boolean useIconClass_p) {
        this.m_useIconClass = useIconClass_p;
    }

    public String getLoadingMessage() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.loadingMessage", "Please wait while your request is being processed...");
    }

    public String getErrorTitleText() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.errorTitle", "Error");
    }

    public String getUpdateErrorText() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.updateError", "Update error:");
    }

    public String getRequestTimeOutText() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.requestTimeOut", "Request timeout. Try again or configure a bigger timeout interval for AJAX requests.");
    }

    public String getCannotLoadNodeText() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.cannotLoadNode", "Could not load the selected node.");
    }

    public String getShowStacktraceMessage() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.showStacktrace", "Show details");
    }

    public String getCollapseStacktraceMessage() {
        return this.getContext().localize("app.OwObjectTreeViewEXTJS.collapseStacktrace", "Hide details");
    }

    public void setExpandOnSelect(boolean expandOnSelect_p) {
        this.m_expandOnSelect = expandOnSelect_p;
    }

    public boolean isExpandOnSelect() {
        return this.m_expandOnSelect;
    }

    @Override
    public synchronized void navigateToId(String nodeId_p) throws Exception {
        super.navigateToId(nodeId_p);
        OwTreeView.OwTreeViewNode currentNode = this.getCurrentNode();
        this.m_theSelectedNode = (OwTreeViewNodeJS)currentNode;
        if (this.isExpandOnSelect() && currentNode != null) {
            currentNode.toggleExpand();
        }
    }

    @Override
    public void navigate(Object obj_p, String strPath_p) throws Exception {
        super.navigate(obj_p, strPath_p);
        OwTreeView.OwTreeViewNode currentNode = this.getCurrentNode();
        this.m_theSelectedNode = (OwTreeViewNodeJS)currentNode;
    }

    public boolean isSelectedNodeExpanded() {
        boolean result = false;
        try {
            OwTreeView.OwTreeViewNode currentNode = this.getCurrentSelectedNode();
            if (currentNode != null) {
                result = !currentNode.isCollapsed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public OwTreeView.OwTreeViewNode getCurrentSelectedNode() {
        return this.m_theSelectedNode;
    }

    @Override
    protected void onActivate(int index_p, Object reason_p) throws Exception {
        if (this.m_root != null) {
            ((OwTreeViewNodeJS)this.m_root).refresh();
        }
    }

    public String getDnDAppletURL() {
        return this.dnDAppletURL;
    }

    public void setDnDAppletURL(String dnDAppletURL) {
        this.dnDAppletURL = dnDAppletURL;
    }

    public class OwTreeViewNodeJS
    extends OwTreeView.OwTreeViewNode {
        public OwTreeViewNodeJS(OwTreeView treeView_p, Object obj_p) {
            super(OwObjectTreeViewEXTJS.this, treeView_p, obj_p);
        }

        public List<OwTreeViewNodeJS> getChildren() throws Exception {
            if (!this.m_fChildsCreated) {
                this.createChilds();
                this.m_fChildsCreated = true;
            }
            return this.m_childs;
        }

        public String toString() {
            return this.m_displaypath;
        }

        @Override
        protected void refresh() throws Exception {
            super.refresh();
        }

        public String toJSONTree() throws Exception {
            StringBuilder result = new StringBuilder();
            result.append("[");
            List<OwTreeViewNodeJS> children = this.getChildren();
            for (OwTreeViewNodeJS child : children) {
                result.append("{text: '");
                result.append(child.getDisplayHTML());
                result.append("',cls: 'folder',id: '");
                result.append(child.getID());
                result.append("',singleClickExpand:");
                result.append(OwObjectTreeViewEXTJS.this.m_expandOnSelect).append(",");
                OwObjectTreeViewEXTJS.this.appendNodeIconLook(result, child);
                if (!child.hasPlusMinusIcon()) {
                    result.append(", leaf: true");
                } else if (!child.isCollapsed()) {
                    result.append(", children: ");
                    result.append(child.toJSONTree());
                }
                result.append(",expanded:").append(!child.isCollapsed()).append("},");
            }
            int lastCharIndex = result.length() - 1;
            if (',' == result.charAt(lastCharIndex)) {
                result.deleteCharAt(lastCharIndex);
            }
            result.append("]");
            return result.toString();
        }
    }
}

