/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwPermissionsDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwPolicyLevelDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwUIGenericAccessRightsModul;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPolicy;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwString;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OwPolicyLevelView
extends OwView {
    private static final String EFFECTIVE_LIST_ID = "effective_id";
    private static final String AVAILABLE_LIST_ID = "available_id";
    private static final String ALL_LIST_ID = "all_id";
    public static final int SELECT_ALL_POLICIES_REGION = 1;
    public static final int MESSAGE_REGION = 2;
    private OwUserInfo m_userInfo;
    private int m_lastItemId = 0;
    private Map m_ownedViewItems = new HashMap();
    private boolean m_readonly = false;
    private boolean m_forceLiveUpdate = false;
    private String message;

    public OwPolicyLevelView(OwUIGenericAccessRightsModul accessRightsView_p, OwUserInfo userInfo_p, boolean readonly_p) {
        this(accessRightsView_p, userInfo_p, readonly_p, false);
    }

    public OwPolicyLevelView(OwUIGenericAccessRightsModul accessRightsView_p, OwUserInfo userInfo_p, boolean readonly_p, boolean forceLiveUpdate_p) {
        OwPermissionsDocument permissionsDocument = accessRightsView_p.getDocument();
        OwPolicyLevelDocument doc = this.createPolicyLevelDocument(permissionsDocument);
        if (doc != null) {
            this.setDocument(doc);
        }
        this.m_userInfo = userInfo_p;
        this.m_readonly = readonly_p;
        this.m_forceLiveUpdate = forceLiveUpdate_p;
    }

    protected OwPolicyLevelDocument createPolicyLevelDocument(OwPermissionsDocument permissionsDocument_p) {
        return new OwPolicyLevelDocument(permissionsDocument_p);
    }

    public boolean isForceLiveUpdate() {
        return this.m_forceLiveUpdate;
    }

    @Override
    public OwPolicyLevelDocument getDocument() {
        return (OwPolicyLevelDocument)super.getDocument();
    }

    protected OwPermissionCollection getPermissions() {
        OwPolicyLevelDocument document = this.getDocument();
        return document.getPermissions();
    }

    public boolean canSetPolicies() {
        OwPermissionCollection permissions = this.getPermissions();
        return permissions.canSetPolicies() && !this.isReadonly();
    }

    public boolean canAddMultiPolicy() {
        OwPermissionCollection permissions = this.getPermissions();
        return permissions.canAddMultiPolicy();
    }

    public List getEffectivePolicyItems() {
        OwPermissionCollection permissions = this.getPermissions();
        Collection effectivePolicies = permissions.getAppliedPolicies();
        return this.createPolicyItems(effectivePolicies, effectivePolicies);
    }

    public List getAvailablePolicyItems() {
        OwPermissionCollection permissions = this.getPermissions();
        Collection availablePolicies = permissions.getAvailablePolicies(this.m_userInfo);
        Collection effectivePolicies = permissions.getAppliedPolicies();
        availablePolicies.removeAll(effectivePolicies);
        return this.createPolicyItems(availablePolicies, effectivePolicies);
    }

    public List getAllPolicyItems() {
        OwPermissionCollection permissions = this.getPermissions();
        Collection availablePolicies = permissions.getAvailablePolicies(this.m_userInfo);
        Collection effectivePolicies = permissions.getAppliedPolicies();
        return this.createPolicyItems(availablePolicies, effectivePolicies);
    }

    protected synchronized List createPolicyItems(Collection policies_p, Collection selectedPolicies_p) {
        ArrayList<OwPolicyViewItem> items = new ArrayList<OwPolicyViewItem>();
        Collection allItems = policies_p;
        if (allItems == null || allItems.isEmpty()) {
            allItems = selectedPolicies_p;
        }
        for (OwPolicy policy : allItems) {
            items.add(this.createPolicyItem(policy, selectedPolicies_p.contains(policy)));
        }
        return items;
    }

    protected synchronized OwPolicyViewItem createPolicyItem(OwPolicy policy_p, boolean selected_p) {
        OwPolicyViewItem item = new OwPolicyViewItem(policy_p, selected_p);
        this.m_ownedViewItems.put(item.getIntegerId(), item);
        return item;
    }

    public synchronized void clearOwnedItems() {
        this.m_ownedViewItems = new HashMap();
        this.m_lastItemId = 0;
    }

    public String createAddEventURL() {
        return this.getFormEventFunction("Add", null);
    }

    public String createRemoveEventURL() {
        return this.getFormEventFunction("Remove", null);
    }

    public synchronized void onAdd(HttpServletRequest request_p) throws Exception {
        String[] policyIdValues = request_p.getParameterValues(this.getAvailableListId());
        if (policyIdValues == null) {
            policyIdValues = request_p.getParameterValues(this.getAllListId());
        }
        if (policyIdValues != null) {
            OwPermissionCollection permissions = this.getPermissions();
            for (int i = 0; i < policyIdValues.length; ++i) {
                OwPolicyViewItem item = (OwPolicyViewItem)this.m_ownedViewItems.get(Integer.valueOf(policyIdValues[i]));
                if (item == null) continue;
                OwPolicy policy = item.getPolicy();
                permissions.addPolicy(policy);
            }
        }
    }

    public synchronized void onRemove(HttpServletRequest request_p) throws Exception {
        String[] effectiveValues = request_p.getParameterValues(this.getEffectiveListId());
        if (effectiveValues != null) {
            OwPermissionCollection permissions = this.getPermissions();
            for (int i = 0; i < effectiveValues.length; ++i) {
                OwPolicyViewItem item = (OwPolicyViewItem)this.m_ownedViewItems.get(Integer.valueOf(effectiveValues[i]));
                if (item == null) continue;
                OwPolicy policy = item.getPolicy();
                permissions.removePolicy(policy);
            }
        }
    }

    public String getEffectiveListId() {
        return EFFECTIVE_LIST_ID;
    }

    public String getAvailableListId() {
        return AVAILABLE_LIST_ID;
    }

    public String getAllListId() {
        return ALL_LIST_ID;
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        super.onRender(w_p);
        this.clearOwnedItems();
        this.serverSideDesignInclude("OwPolicyLevelView.jsp", w_p);
    }

    public void renderSelectAllPolicies(Writer w_p) throws Exception {
        List allItems = this.getAllPolicyItems();
        LinkedList<OwDefaultComboItem> allComboItems = new LinkedList<OwDefaultComboItem>();
        OwDefaultComboItem selectedItem = null;
        for (OwPolicyViewItem item : allItems) {
            OwDefaultComboItem comboItem = new OwDefaultComboItem("" + item.getId(), item.getName());
            allComboItems.add(comboItem);
            if (!item.isSelected()) continue;
            selectedItem = comboItem;
        }
        OwDefaultComboModel model = new OwDefaultComboModel(false, false, selectedItem.getValue(), allComboItems);
        OwMainAppContext context = (OwMainAppContext)this.getContext();
        OwComboboxRenderer renderer = context.createComboboxRenderer(model, this.getAllListId(), null, null, new OwString("owlabel.ACL policies", "ACL policies"));
        renderer.addEvent("onchange", "policyChanged()");
        renderer.setEnabled(!this.isReadonly() && this.canSetPolicies());
        renderer.renderCombo(w_p);
    }

    @Override
    public void renderRegion(Writer w_p, int region_p) throws Exception {
        switch (region_p) {
            case 1: {
                this.renderSelectAllPolicies(w_p);
                break;
            }
            case 2: {
                this.renderMessageRegion(w_p);
            }
        }
    }

    protected void renderMessageRegion(Writer w_p) throws Exception {
        if (this.message != null) {
            w_p.write(this.message);
        }
    }

    public final boolean isReadonly() {
        return this.m_readonly;
    }

    public final void setReadOnly(boolean readOnly_p) {
        this.m_readonly = readOnly_p;
    }

    public synchronized void onSave(HttpServletRequest request_p, Object reason_p) throws OwException {
        String[] policiesIds;
        if (!this.canAddMultiPolicy() && (policiesIds = request_p.getParameterValues(this.getAllListId())) != null && policiesIds.length > 0) {
            OwPermissionCollection permissions = this.getPermissions();
            OwPolicyViewItem selectedItem = (OwPolicyViewItem)this.m_ownedViewItems.get(Integer.valueOf(policiesIds[0]));
            OwPolicy policy = selectedItem.getPolicy();
            permissions.addPolicy(policy);
        }
    }

    public void setMessage(String message_p) {
        this.message = message_p;
    }

    public class OwPolicyViewItem {
        private OwPolicy m_policy;
        private int m_id;
        private boolean m_selected;

        private OwPolicyViewItem(OwPolicy m_policy, boolean selected_p) {
            this.m_policy = m_policy;
            OwPolicyLevelView.this.m_lastItemId++;
            this.m_id = OwPolicyLevelView.this.m_lastItemId;
            this.m_selected = selected_p;
        }

        public boolean isSelected() {
            return this.m_selected;
        }

        public int hashCode() {
            return this.m_id % 10;
        }

        public boolean equals(Object obj_p) {
            if (obj_p instanceof OwPolicyViewItem) {
                OwPolicyViewItem item = (OwPolicyViewItem)obj_p;
                return this.m_id == item.m_id;
            }
            return false;
        }

        public final OwPolicy getPolicy() {
            return this.m_policy;
        }

        public final int getId() {
            return this.m_id;
        }

        public final Integer getIntegerId() {
            return this.getId();
        }

        public final String getName() {
            return this.m_policy.getName();
        }
    }
}

