/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.ui.OwDocument;
import java.util.Collection;
import java.util.List;

public class OwSplitObjectListDocument
extends OwDocument {
    public static final String NO_NAME = "";
    private String[] splitNames;
    private OwObjectCollection[] splitObjects;
    private Collection<OwFieldColumnInfo>[] columnInfos;
    private List<OwDocumentFunction> documentFunctions;

    public OwSplitObjectListDocument(String[] splits, Collection<OwFieldColumnInfo>[] columnInfos, List<OwDocumentFunction> documentFunctions) {
        this.splitNames = new String[splits.length];
        System.arraycopy(splits, 0, this.splitNames, 0, splits.length);
        this.splitObjects = new OwObjectCollection[splits.length];
        this.setColumnInfos(columnInfos);
        this.setDocumentFunctions(documentFunctions);
    }

    public int getSplitCount() {
        return this.splitNames.length;
    }

    public synchronized void setSplits(OwObjectCollection[] splits) throws OwException {
        System.arraycopy(splits, 0, this.splitObjects, 0, splits.length);
        this.updateSplitViews();
    }

    public OwObjectCollection getSplit(int index) {
        return this.splitObjects[index];
    }

    public String getSplitName(int index) {
        return this.splitNames[index];
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.splitObjects.length; ++i) {
            if (this.splitObjects[i] == null || this.splitObjects[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void updateSplitViews() throws OwException {
        try {
            this.update(this, 0, null);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Error udating views.", (Throwable)e);
        }
    }

    public Collection<OwFieldColumnInfo>[] getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(Collection<OwFieldColumnInfo>[] columnInfos) {
        this.columnInfos = columnInfos;
    }

    public List<OwDocumentFunction> getDocumentFunctions() {
        return this.documentFunctions;
    }

    public void setDocumentFunctions(List<OwDocumentFunction> documentFunctions) {
        this.documentFunctions = documentFunctions;
    }
}

