/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwField;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwPasteMetadataHandler;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class OwStandardPasteMetadataHandler
implements OwPasteMetadataHandler {
    protected static final String QUERY_KEY_PROPNAME = "prop";
    private static final String EVENT_NAME_PASTE_THIS_META_DATA = "PasteThisMetaData";
    private OwMainAppContext m_context;
    protected OwPropertyCollection m_properties;
    private boolean m_isSystemView;
    private boolean m_hasPasteMetaDataEnabled;

    public OwStandardPasteMetadataHandler(OwMainAppContext context_p, boolean isSystemPropertiesView_p, boolean hasPasteMetadataEnabled_p) {
        this.m_context = context_p;
        this.m_isSystemView = isSystemPropertiesView_p;
        this.m_hasPasteMetaDataEnabled = hasPasteMetadataEnabled_p;
        this.m_properties = new OwStandardPropertyCollection();
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p) {
        this.m_properties = properties_p;
    }

    @Override
    public void onPasteAllMetaData(HttpServletRequest request_p) throws Exception {
        OwClipboard clipboard = this.getClipboard();
        switch (clipboard.getContentType()) {
            case 1: {
                for (OwProperty prop : this.m_properties.values()) {
                    this.pasteMetaDataFromClipboardObject(prop);
                }
                break;
            }
            case 3: {
                for (OwProperty prop : this.m_properties.values()) {
                    this.pasteMetaDataFromClipboardField(prop);
                }
                break;
            }
        }
    }

    private void pasteMetaDataFromClipboardObject(OwProperty prop_p) throws Exception {
        if (prop_p != null) {
            OwClipboard clipboard = this.getClipboard();
            OwObject clipboardObject = ((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject();
            try {
                OwProperty clipboardProperty = clipboardObject.getProperty(prop_p.getPropertyClass().getClassName());
                if (this.isPropertyPasteable(prop_p, clipboardObject)) {
                    prop_p.setValue(clipboardProperty.getValue());
                }
            }
            catch (OwObjectNotFoundException e) {
                // empty catch block
            }
        }
    }

    private void pasteMetaDataFromClipboardField(OwProperty prop_p) throws Exception {
        OwClipboard clipboard = this.getClipboard();
        if (clipboard != null && !clipboard.getContent().isEmpty()) {
            Iterator<OwClipboard.OwClipboardContent> it = clipboard.getContent().iterator();
            while (it.hasNext()) {
                OwField field = ((OwClipboardContentOwField)it.next()).getField();
                if (!field.getFieldDefinition().getClassName().equals(prop_p.getFieldDefinition().getClassName())) continue;
                OwPropertyClass info = prop_p.getPropertyClass();
                if (info.isReadOnly(2) || info.isSystemProperty()) break;
                prop_p.setValue(field.getValue());
                break;
            }
        }
    }

    private boolean isPropertyPasteable(OwProperty prop_p, OwObject clipboardObject_p) throws Exception {
        try {
            OwProperty clipboardProperty = clipboardObject_p.getProperty(prop_p.getPropertyClass().getClassName());
            return clipboardProperty.getPropertyClass().getJavaClassName().equals(prop_p.getPropertyClass().getJavaClassName()) && !prop_p.getPropertyClass().isSystemProperty() && !prop_p.isReadOnly(2) && !prop_p.isHidden(2) && clipboardProperty.getValue() != null;
        }
        catch (OwObjectNotFoundException e) {
            return false;
        }
    }

    @Override
    public void onPasteThisMetaData(HttpServletRequest request_p) throws Exception {
        OwClipboard clipboard = this.getClipboard();
        String strPropertyName = request_p.getParameter(QUERY_KEY_PROPNAME);
        OwProperty prop = (OwProperty)this.m_properties.get(strPropertyName);
        switch (clipboard.getContentType()) {
            case 1: {
                this.pasteMetaDataFromClipboardObject(prop);
                break;
            }
            case 3: {
                this.pasteMetaDataFromClipboardField(prop);
                break;
            }
        }
    }

    protected OwClipboard getClipboard() {
        return this.m_context.getClipboard();
    }

    @Override
    public boolean isPasteMetadataActivated() {
        if (this.m_isSystemView || !this.m_hasPasteMetaDataEnabled) {
            return false;
        }
        OwClipboard clipboard = this.getClipboard();
        switch (clipboard.getContentType()) {
            case 1: {
                return clipboard.getContent().size() == 1;
            }
            case 3: {
                return clipboard.getContent().size() > 0;
            }
        }
        return false;
    }

    @Override
    public void renderPasteAllMetadata(Writer w_p, OwEventTarget view_p) throws Exception {
        String pasteMetadataTooltip = this.m_context.localize("app.OwObjectPropertyView.pasteallmeta", "Paste all metadata from clipboard.");
        w_p.write("<a title=\"" + pasteMetadataTooltip + "\" href=\"" + view_p.getEventURL("PasteAllMetaData", null) + "\"><img hspace=\"5\" border=\"0\" src=\"" + this.m_context.getDesignURL() + "/images/OwObjectPropertyView/paste_metadata.png\"");
        w_p.write(" alt=\"");
        w_p.write(pasteMetadataTooltip);
        w_p.write("\" title=\"");
        w_p.write(pasteMetadataTooltip);
        w_p.write("\"/></a>");
    }

    @Override
    public void renderPasteMetadata(Writer w_p, OwProperty prop_p, OwEventTarget view_p) throws Exception {
        OwObject clipboardObject;
        OwClipboard clipboard = this.getClipboard();
        if (clipboard.getContentType() == 1 && this.isPropertyPasteable(prop_p, clipboardObject = ((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject())) {
            try {
                String pasteMetadataTooltip = this.m_context.localize("app.OwObjectPropertyView.pastethismeta", "Paste property from clipboard.");
                w_p.write("<a title=\"" + pasteMetadataTooltip + "\" href=\"" + view_p.getFormEventURL(EVENT_NAME_PASTE_THIS_META_DATA, "prop=" + prop_p.getPropertyClass().getClassName()) + "\">");
                w_p.write("<img src=\"" + this.m_context.getDesignURL() + "/images/OwObjectPropertyView/paste_metadata.png\"");
                w_p.write(" alt=\"");
                w_p.write(pasteMetadataTooltip);
                w_p.write("\" title=\"");
                w_p.write(pasteMetadataTooltip);
                w_p.write("\"/></a>");
            }
            catch (OwObjectNotFoundException e) {
                // empty catch block
            }
        }
        if (clipboard.getContentType() == 3) {
            Iterator<OwClipboard.OwClipboardContent> it = clipboard.getContent().iterator();
            while (it.hasNext()) {
                OwField field = ((OwClipboardContentOwField)it.next()).getField();
                if (!field.getFieldDefinition().getClassName().equals(prop_p.getFieldDefinition().getClassName())) continue;
                String pasteMetadataTooltip = this.m_context.localize("app.OwObjectPropertyView.pastethismeta", "Paste property from clipboard.");
                w_p.write("<a title=\"" + pasteMetadataTooltip);
                w_p.write("\" href=\"");
                w_p.write(view_p.getFormEventURL(EVENT_NAME_PASTE_THIS_META_DATA, "prop=" + prop_p.getPropertyClass().getClassName()));
                w_p.write("\"><img src=\"");
                w_p.write(this.m_context.getDesignURL());
                w_p.write("/images/OwObjectPropertyView/paste_metadata.png");
                w_p.write("\" alt=\"");
                w_p.write(pasteMetadataTooltip);
                w_p.write("\" title=\"");
                w_p.write(pasteMetadataTooltip);
                w_p.write("\"/></a>");
                break;
            }
        }
    }
}

