/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMenuView;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.dmsdialogs.views.OwPermissionsDocument;
import com.wewebu.ow.server.dmsdialogs.views.OwPolicyLevelView;
import com.wewebu.ow.server.dmsdialogs.views.OwPrivilegesView;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.ui.OwUIAccessRightsModul;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.ui.OwMenu;
import com.wewebu.ow.server.ui.OwSmallSubNavigationView;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OwUIGenericAccessRightsModul
extends OwUIAccessRightsModul {
    public static final int POLICIES_ONLY = 1;
    public static final int PRIVILEGES_ONLY = 2;
    public static final int BOTH = 3;
    private boolean m_readOnly = false;
    private OwPolicyLevelView m_policyLevelView;
    private OwPrivilegesView m_privilegesView;
    private OwSubNavigationView m_subNavigationView;
    private OwMenuView m_menu;
    private int m_iSaveMenuBtnIndex;
    private OwPermissionCollection m_permissions;
    private String m_policyViewTitle = null;
    private String m_privilegesViewTitle = null;
    private Map<String, String> m_privilegeDisplayNames = new HashMap<String, String>();
    private boolean m_policiesEnabled = true;
    private boolean m_privilegesEnabled = true;
    private boolean m_canGetPermissions;
    private boolean m_canSetPermissions;
    private String policyViewMessage;
    private String aclViewMessage;
    private boolean useTabs = true;
    private OwView activeView = null;

    public OwUIGenericAccessRightsModul(OwNetwork network_p, OwObject object_p) throws OwException {
        this(network_p, object_p, 3);
    }

    public OwUIGenericAccessRightsModul(OwNetwork network_p, OwObject object_p, int views_p) throws OwException {
        this(network_p, object_p, null, null, views_p);
    }

    public OwUIGenericAccessRightsModul(OwNetwork network_p, OwObject object_p, String policyViewTitle_p, String privilegesViewTitle_p, int views_p) throws OwException {
        this(network_p, object_p, policyViewTitle_p, privilegesViewTitle_p, null, views_p);
    }

    public OwUIGenericAccessRightsModul(OwNetwork network_p, OwObject object_p, String policyViewTitle_p, String privilegesViewTitle_p, Map<String, String> privilegeDisplayNames_p, int views_p) throws OwException {
        OwPermissionsDocument document = new OwPermissionsDocument(object_p);
        if (document != null) {
            this.setDocument(document);
        }
        this.m_policyViewTitle = policyViewTitle_p;
        this.m_privilegesViewTitle = privilegesViewTitle_p;
        this.m_policiesEnabled = true;
        this.m_privilegesEnabled = true;
        if (1 == views_p) {
            this.m_privilegesEnabled = false;
        }
        if (2 == views_p) {
            this.m_policiesEnabled = false;
        }
        this.useTabs = this.m_privilegesEnabled && this.m_policiesEnabled;
        this.m_privilegeDisplayNames = privilegeDisplayNames_p == null ? new HashMap() : privilegeDisplayNames_p;
        this.init(network_p);
    }

    @Override
    public void init(OwNetwork theNetwork_p) throws OwException {
        try {
            super.init(theNetwork_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Unknown error", (Throwable)e);
        }
    }

    @Override
    protected void init() throws Exception {
        this.detach();
        super.init();
        this.m_canGetPermissions = this.getDocument().getObject().canGetPermissions();
        this.m_canSetPermissions = this.getDocument().getObject().canSetPermissions();
        boolean canGetPolicies = false;
        boolean canGetPrivileges = false;
        this.m_permissions = null;
        if (this.m_canGetPermissions) {
            this.m_permissions = this.getDocument().getObject().getPermissions();
            canGetPolicies = this.m_permissions.canGetPolicies();
            canGetPrivileges = this.m_permissions.canGetPrivileges();
        }
        if (this.m_permissions != null) {
            this.m_policyLevelView = this.createPolicyLevelView();
            this.m_policyLevelView.setMessage(this.policyViewMessage);
            this.m_policyLevelView.setExternalFormTarget(this.getFormTarget());
            this.m_privilegesView = this.createPrivilegesView();
            this.m_privilegesView.setMessage(this.aclViewMessage);
            this.m_privilegesView.setExternalFormTarget(this.getFormTarget());
            if (this.m_policyViewTitle == null) {
                this.m_policyViewTitle = this.getContext().localize("owdocprops.OwUIGenericAccessRightsModul.policies", "Policies");
            }
            if (this.m_privilegesViewTitle == null) {
                this.m_privilegesViewTitle = this.getContext().localize("owdocprops.OwUIGenericAccessRightsModul.privileges", "Privileges");
            }
        }
        if (this.useTabs) {
            this.m_subNavigationView = this.createNavigationView();
            this.addView(this.m_subNavigationView, null);
        } else if (this.m_permissions != null) {
            if (this.m_policiesEnabled) {
                this.activeView = this.m_policyLevelView;
                this.addView(this.m_policyLevelView, null);
            } else if (this.m_privilegesEnabled) {
                this.activeView = this.m_privilegesView;
                this.addView(this.m_privilegesView, null);
            }
        }
        this.m_menu = new OwSubMenuView();
        this.addView(this.m_menu, null);
        this.m_iSaveMenuBtnIndex = this.m_menu.addFormMenuItem(this, this.getContext().localize("owdocprops.OwUIGenericAccessRightsModul.policies.save", "Save"), "Save", null);
        this.m_menu.enable(this.m_iSaveMenuBtnIndex, this.m_canSetPermissions && !this.m_readOnly);
        if (this.useTabs) {
            if (this.m_permissions != null) {
                if (this.m_policiesEnabled) {
                    this.m_subNavigationView.addView(this.m_policyLevelView, this.m_policyViewTitle, null, null, null, null);
                    this.m_subNavigationView.enable(0, canGetPolicies);
                }
                if (this.m_privilegesEnabled) {
                    this.m_subNavigationView.addView(this.m_privilegesView, this.m_privilegesViewTitle, null, null, null, null);
                    this.m_subNavigationView.enable(1, canGetPrivileges);
                }
            }
            this.m_subNavigationView.setValidatePanels(true);
            this.m_subNavigationView.navigate(0);
            this.activeView = this.m_subNavigationView;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly_p) {
        this.m_readOnly = readOnly_p;
        if (this.m_menu != null) {
            this.m_menu.enable(this.m_iSaveMenuBtnIndex, this.m_canSetPermissions && !this.m_readOnly);
        }
        if (this.m_policyLevelView != null) {
            this.m_policyLevelView.setReadOnly(readOnly_p);
        }
        if (this.m_privilegesView != null) {
            this.m_privilegesView.setReadOnly(readOnly_p);
        }
    }

    protected OwPolicyLevelView createPolicyLevelView() throws Exception {
        Object network = this.getNetwork();
        OwCredentials credentials = network.getCredentials();
        OwPolicyLevelView owPolicyLevelView = new OwPolicyLevelView(this, credentials.getUserInfo(), this.m_readOnly, this.getLiveUpdate());
        return owPolicyLevelView;
    }

    protected OwPrivilegesView createPrivilegesView() throws Exception {
        OwPrivilegesView owPrivilegesView = new OwPrivilegesView(this, this.m_privilegeDisplayNames, this.getLiveUpdate());
        return owPrivilegesView;
    }

    protected OwSubNavigationView createNavigationView() {
        return new OwSmallSubNavigationView(true);
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    @Override
    public OwMenu getMenu() {
        return this.m_menu;
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        if (this.activeView != null) {
            this.activeView.render(w_p);
        }
        if (this.useTabs) {
            w_p.write("<div style='float:left;clear:left;margin-left:10px;margin-top:5px;'>");
        } else {
            w_p.write("<div class='OwObjectPropertyView_MENU OwInlineMenu'>");
        }
        this.m_menu.render(w_p);
        w_p.write("</div>");
    }

    public void onSave(HttpServletRequest request_p, Object reason_p) throws Exception {
        if (this.useTabs) {
            int currentIndex = this.m_subNavigationView.getNavigationIndex();
            if (currentIndex == 0 && this.m_policiesEnabled) {
                this.m_policyLevelView.onSave(request_p, reason_p);
            } else {
                this.m_privilegesView.onSave(request_p, reason_p);
            }
        } else if (this.m_policiesEnabled) {
            this.m_policyLevelView.onSave(request_p, reason_p);
        } else {
            this.m_privilegesView.onSave(request_p, reason_p);
        }
        OwPermissionsDocument document = this.getDocument();
        document.savePermissions();
    }

    public void setPolicyViewMessage(String message_p) {
        this.policyViewMessage = message_p;
    }

    public void setACLViewMessage(String message_p) {
        this.aclViewMessage = message_p;
    }

    protected Map<String, String> getPrivilegeDisplayNames() {
        return this.m_privilegeDisplayNames;
    }

    @Override
    public OwPermissionsDocument getDocument() {
        return (OwPermissionsDocument)super.getDocument();
    }

    protected final OwObject getObject() {
        OwPermissionsDocument document = this.getDocument();
        return document.getObject();
    }
}

