/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views.classes;

import com.wewebu.ow.server.dmsdialogs.views.classes.OwRootClassCfg;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwObjectClassSelectionCfg {
    private static final Logger LOG = Logger.getLogger(OwObjectClassSelectionCfg.class);
    public static final String EL_OBJECT_CLASS_SELECTION = "ObjectClassSelection";
    public static final String EL_OBJECT_CLASS = "ObjectClass";
    public static final String ATT_INCLUDE_SUB_CLASS = "includeSubClasses";
    private Map<String, OwRootClassCfg> rootClasses = new HashMap<String, OwRootClassCfg>();

    private OwObjectClassSelectionCfg() {
    }

    public Set<OwRootClassCfg> getRootClasses() {
        return new HashSet<OwRootClassCfg>(this.rootClasses.values());
    }

    public OwRootClassCfg get(String rootClassName) {
        return this.rootClasses.get(rootClassName);
    }

    public boolean hasDefaultClass() {
        return null != this.getDefaultClass();
    }

    public OwRootClassCfg getDefaultClass() {
        OwRootClassCfg defaultRootClass;
        if (1 == this.getRootClasses().size() && !(defaultRootClass = this.getRootClasses().toArray(new OwRootClassCfg[0])[0]).isIncludeSubclasses()) {
            return defaultRootClass;
        }
        return null;
    }

    public static OwObjectClassSelectionCfg createSingleClassConfiguration(String defaultClassName) {
        OwObjectClassSelectionCfg cfg = new OwObjectClassSelectionCfg();
        OwObjectClassSelectionCfg.addRootSelectionClass(cfg, defaultClassName, false);
        return cfg;
    }

    public static OwObjectClassSelectionCfg fromPluginXml(OwXMLUtil pluginXMLCfg) throws OwConfigurationException {
        OwXMLUtil objectClassesXML;
        try {
            objectClassesXML = pluginXMLCfg.getSubUtil(EL_OBJECT_CLASS_SELECTION);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            OwString errMsg = new OwString("plug.owadddocument.cfg.missingCLassName", "Configuration error <ObjectClassSelection>, the object class is missing.");
            throw new OwConfigurationException(errMsg, (Throwable)e);
        }
        String strParentObjectClass = pluginXMLCfg.getSafeTextValue("ObjectClassParent", null);
        String strClassName = pluginXMLCfg.getSafeTextValue(EL_OBJECT_CLASS, null);
        if (null == objectClassesXML && null == strParentObjectClass && null == strClassName) {
            return OwObjectClassSelectionCfg.createEmptyConfiguration();
        }
        if (null != strParentObjectClass || null != strClassName) {
            LOG.warn((Object)"Usage of the <ObjectClassParent> and <ObjectClass> is deprecated. Please use the new <ObjectClassSelection>...</ObjectClassSelection> configuration element.");
        }
        OwObjectClassSelectionCfg cfg = new OwObjectClassSelectionCfg();
        if (null != objectClassesXML) {
            List xmlClasses = objectClassesXML.getSafeUtilList(EL_OBJECT_CLASS);
            for (OwXMLUtil xmlClass : xmlClasses) {
                OwRootClassCfg rootClassCfg = OwRootClassCfg.fromXml(xmlClass);
                OwObjectClassSelectionCfg.addRootClass(cfg, rootClassCfg);
            }
        } else if (null != strClassName) {
            OwRootClassCfg rootClassCfg = new OwRootClassCfg(strClassName, false);
            OwObjectClassSelectionCfg.addRootClass(cfg, rootClassCfg);
        } else if (null != strParentObjectClass) {
            OwRootClassCfg rootClassCfg = new OwRootClassCfg(strParentObjectClass, true);
            OwObjectClassSelectionCfg.addRootClass(cfg, rootClassCfg);
        }
        return cfg;
    }

    private static void addRootClass(OwObjectClassSelectionCfg cfg, OwRootClassCfg rootClassCfg) {
        cfg.rootClasses.put(rootClassCfg.getName(), rootClassCfg);
    }

    public static OwObjectClassSelectionCfg createEmptyConfiguration() {
        return new OwObjectClassSelectionCfg();
    }

    public static void addRootSelectionClass(OwObjectClassSelectionCfg cfg, String rootClassName, boolean includeSubClasses) {
        OwRootClassCfg rootCfg = new OwRootClassCfg(rootClassName, includeSubClasses);
        OwObjectClassSelectionCfg.addRootClass(cfg, rootCfg);
    }
}

