/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.history.OwStandardHistoryPropertyChangeEvent;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwMimeTypes;
import com.wewebu.ow.server.util.OwStreamUtil;
import com.wewebu.ow.server.util.OwString;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OwFileObject
implements OwObject,
OwContentCollection,
OwContentElement {
    private static final String UNDEF_STRING_VALUE = "[undef]";
    private static final Logger LOG = OwLogCore.getLogger(OwFileObject.class);
    protected File m_File;
    private OwNetwork m_network;
    protected OwPropertyCollection m_PropertyMap;
    protected static final OwFileObjectClass m_FileClassDescription = new OwFileObjectClass(false);
    protected static final OwFileObjectClass m_DirectoryClassDescription = new OwFileObjectClass(true);
    private OwObjectCollection m_parents;
    private InputStream m_in;
    protected OwEventManager m_eventmanager;
    protected Locale m_locale;
    private int m_iChildCount = -1;

    protected OwNetwork getNetwork() {
        return this.m_network;
    }

    protected OwFileObject() throws Exception {
    }

    public OwFileObject(OwNetwork network_p, File file_p) throws Exception {
        this.m_network = network_p;
        this.m_locale = network_p.getLocale();
        this.m_eventmanager = network_p.getEventManager();
        this.m_File = file_p;
        if (!this.m_File.exists() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwFileObject.OwFileObject: the file doesn't exist:" + this.m_File.getAbsolutePath()));
        }
        this.loadProperties();
    }

    public OwFileObject(OwNetwork network_p, File file_p, String fileName_p) throws Exception {
        this(network_p, file_p);
        this.m_PropertyMap.put("ow_Filename", new OwStandardProperty(fileName_p, this.getObjectClass().getPropertyClass("ow_Filename")));
    }

    public OwFileObject(OwNetwork network_p, File file_p, String fileName_p, String mimeType_p) throws Exception {
        this(network_p, file_p);
        this.m_PropertyMap.put("ow_Filename", new OwStandardProperty(fileName_p, this.getObjectClass().getPropertyClass("ow_Filename")));
        this.m_PropertyMap.put("ow_MimeType", new OwStandardProperty(mimeType_p, this.getObjectClass().getPropertyClass("ow_MimeType")));
    }

    public File getFileObject() {
        return this.m_File;
    }

    public boolean exists() {
        return this.m_File.exists();
    }

    private static String mimeOf(File file_p) {
        String strMime;
        String strExt = file_p.getName();
        int iLast = strExt.lastIndexOf(46);
        if (-1 != iLast) {
            strExt = strExt.substring(iLast + 1, strExt.length());
        }
        if ((strMime = OwMimeTypes.getMimeTypeFromExtension(strExt)) == null) {
            strMime = "unknown";
        }
        return strMime;
    }

    protected void loadProperties() throws Exception {
        if (this.m_PropertyMap == null) {
            this.m_PropertyMap = new OwStandardPropertyCollection();
            String strTitel = this.m_File.getName();
            int iLast = strTitel.lastIndexOf(46);
            this.m_PropertyMap.put("ow_FileID", new OwStandardProperty(strTitel, this.getObjectClass().getPropertyClass("ow_FileID")));
            if (-1 != iLast) {
                strTitel = strTitel.substring(0, iLast);
            }
            this.m_PropertyMap.put("ow_Filename", new OwStandardProperty(strTitel, this.getObjectClass().getPropertyClass("ow_Filename")));
            this.m_PropertyMap.put("ow_Filesize", new OwStandardProperty(this.m_File.length(), this.getObjectClass().getPropertyClass("ow_Filesize")));
            this.m_PropertyMap.put("ow_Last-Modified", new OwStandardProperty(new Date(this.m_File.lastModified()), this.getObjectClass().getPropertyClass("ow_Last-Modified")));
            String strMime = OwFileObject.mimeOf(this.m_File);
            this.m_PropertyMap.put("ow_MimeType", new OwStandardProperty(strMime, this.getObjectClass().getPropertyClass("ow_MimeType")));
        }
    }

    @Override
    public String getName() {
        try {
            return (String)((OwStandardProperty)this.m_PropertyMap.get("ow_Filename")).getValue();
        }
        catch (Exception e) {
            return UNDEF_STRING_VALUE;
        }
    }

    @Override
    public String getID() {
        try {
            return (String)((OwStandardProperty)this.m_PropertyMap.get("ow_FileID")).getValue();
        }
        catch (Exception e) {
            return UNDEF_STRING_VALUE;
        }
    }

    @Override
    public String getClassName() {
        return this.getObjectClass().getClassName();
    }

    @Override
    public OwObjectClass getObjectClass() {
        if (this.m_File.isFile()) {
            return m_FileClassDescription;
        }
        return m_DirectoryClassDescription;
    }

    @Override
    public void setContentCollection(OwContentCollection content_p) throws Exception {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = content_p.getContentElement(1, 1).getContentStream(null);
            out = new FileOutputStream(this.m_File);
            byte[] buffer = new byte[4096];
            int iRead = 0;
            while (-1 != (iRead = in.read(buffer))) {
                out.write(buffer, 0, iRead);
            }
        }
        catch (Exception e) {
            String msg = "Error setting the Content Collection, FileOutputStream -> file = " + this.m_File;
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
                out = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
                in = null;
            }
        }
    }

    @Override
    public String getContentURL() throws Exception {
        if (this.getContentRepresentation() == 4) {
            FileInputStream fis = null;
            try {
                Properties URLProps = new Properties();
                fis = new FileInputStream(this.m_File);
                URLProps.load(fis);
                String string = URLProps.getProperty("URL");
                return string;
            }
            catch (Exception e) {
                String msg = "Error creating file InputStream and loading the properties, file = " + this.m_File;
                LOG.error((Object)msg, (Throwable)e);
                throw new OwInvalidOperationException(msg, (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                    fis = null;
                }
            }
        }
        String msg = "OwFileObject.getContentURL: Not supported to get the content URL from the object.";
        LOG.debug((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    @Override
    public boolean isInputStreamNative() {
        return true;
    }

    @Override
    public Object getContentObject() throws Exception {
        throw new OwObjectNotFoundException("OwFileObject.getContentObject: Not implemented or Not supported.");
    }

    @Override
    public int getContentRepresentation() throws Exception {
        return this.getMIMEType().equals("text/url") ? 4 : 2;
    }

    @Override
    public InputStream getContentStream(OutputStream out_p) throws Exception {
        this.m_in = null;
        if (!this.m_File.isFile() || this.m_File.length() <= 0L) {
            throw new OwObjectNotFoundException("OwFileObject.getContentStream: No file available.");
        }
        this.m_in = new FileInputStream(this.m_File);
        if (null == out_p) {
            return this.m_in;
        }
        OwStreamUtil.upload(this.m_in, out_p, false);
        out_p.flush();
        this.m_in.close();
        return null;
    }

    @Override
    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception {
        if (iContentType_p == 1) {
            return this.m_File.canWrite();
        }
        return false;
    }

    @Override
    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception {
        if (iContentType_p == 1) {
            return this.m_File.canRead();
        }
        return false;
    }

    @Override
    public Collection getContentTypes() throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        list.add(1);
        return list;
    }

    @Override
    public int getType() {
        if (this.m_File.isDirectory()) {
            return 8193;
        }
        return 4097;
    }

    @Override
    public OwObjectCollection getParents() throws Exception {
        if (null == this.m_parents) {
            this.m_parents = new OwStandardObjectCollection();
            if (this.m_File.getParentFile() != null) {
                this.m_parents.add(this.createFileObject(this.m_File.getParentFile()));
            }
        }
        return this.m_parents;
    }

    @Override
    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        boolean fDirectory = false;
        boolean fFile = false;
        block4: for (int i = 0; i < iObjectTypes_p.length; ++i) {
            switch (iObjectTypes_p[i]) {
                case 4096: 
                case 4097: {
                    fFile = true;
                    continue block4;
                }
                case 8192: 
                case 8193: {
                    fDirectory = true;
                }
            }
        }
        OwStandardObjectCollection Childs = new OwStandardObjectCollection();
        File[] Files = this.m_File.listFiles();
        int len = Files.length;
        if (Files.length > iMaxSize_p) {
            len = iMaxSize_p;
            Childs.setAttribute("ow_complete", Boolean.FALSE);
        }
        for (int i = 0; i < Files.length; ++i) {
            if ((!Files[i].isDirectory() || !fDirectory) && (!Files[i].isFile() || !fFile)) continue;
            if (len-- == 0) break;
            OwFileObject FileOb = this.createFileObject(Files[i]);
            Childs.add(FileOb);
        }
        Childs.setAttribute("ow_size", Childs.size());
        return Childs;
    }

    protected OwFileObject createFileObject(File file_p) throws Exception {
        return new OwFileObject(this.m_network, file_p);
    }

    @Override
    public boolean canFilterChilds() throws Exception {
        return false;
    }

    @Override
    public Collection getFilterProperties(Collection propertynames_p) throws Exception {
        return null;
    }

    @Override
    public OwVersionSeries getVersionSeries() throws Exception {
        return null;
    }

    @Override
    public boolean hasVersionSeries() throws Exception {
        return false;
    }

    @Override
    public OwVersion getVersion() throws Exception {
        return null;
    }

    @Override
    public String getMIMEType() throws Exception {
        if (this.m_File.isFile()) {
            return (String)((OwStandardProperty)this.m_PropertyMap.get("ow_MimeType")).getValue();
        }
        return "ow_folder/" + this.getClassName();
    }

    @Override
    public String getMIMEParameter() throws Exception {
        StringBuffer buf = new StringBuffer("name=\"");
        buf.append(this.m_File.getName());
        buf.append("\"");
        return buf.toString();
    }

    @Override
    public String getDMSID() throws Exception {
        throw new OwNotSupportedException("OwFileObject.getDMSID: Override in derived class.");
    }

    @Override
    public OwProperty getProperty(String strPropertyName_p) throws Exception {
        this.loadProperties();
        OwProperty prop = (OwProperty)this.m_PropertyMap.get(strPropertyName_p);
        if (prop == null) {
            String msg = "OwFileObject.getProperty: Cannot find the property, propertyName = " + strPropertyName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return prop;
    }

    @Override
    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception {
        this.loadProperties();
        return this.m_PropertyMap;
    }

    @Override
    public OwPropertyCollection getClonedProperties(Collection propertyNames_p) throws Exception {
        return OwStandardPropertyClass.getClonedProperties(this, propertyNames_p);
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        for (OwProperty propIn : properties_p.values()) {
            OwProperty prop = (OwProperty)this.m_PropertyMap.get(propIn.getPropertyClass().getClassName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwFileObject.setProperties: Prop=[" + propIn.getPropertyClass().getClassName() + "], PrevValue=[" + prop.getValue() + "], NewValue=[" + propIn.getValue() + "]"));
            }
            prop.setValue(propIn.getValue());
        }
        this.m_eventmanager.addEvent(6, "modifyprops", new OwStandardHistoryPropertyChangeEvent(this, properties_p), 1);
    }

    @Override
    public boolean canSetProperties(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean canGetProperties(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean canLock() throws Exception {
        return false;
    }

    @Override
    public boolean setLock(boolean fLock_p) throws Exception {
        this.m_eventmanager.addEvent(6, "lockobject", 1);
        return false;
    }

    @Override
    public boolean getLock(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public boolean getMyLock(int iContext_p) throws Exception {
        return false;
    }

    @Override
    public String getLockUserID(int iContext_p) throws Exception {
        return null;
    }

    @Override
    public void delete() throws Exception {
        if (!this.m_File.delete()) {
            this.m_eventmanager.addEvent(6, "delete", 2);
            throw new OwInvalidOperationException(OwString.localize(this.m_locale, "ecm.OwFileObject.deletefailed", "Could not delete file:") + this.m_File.getName());
        }
        this.m_eventmanager.addEvent(6, "delete", 1);
    }

    @Override
    public boolean canDelete(int iContext_p) throws Exception {
        return this.m_File.canWrite();
    }

    @Override
    public void removeReference(OwObject oObject_p) throws Exception {
        this.m_eventmanager.addEvent(6, "removeref", 1);
        oObject_p.delete();
    }

    @Override
    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws Exception {
        return oObject_p.canDelete(iContext_p) && this.m_File.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(OwObject oObject_p) throws Exception {
        if (!this.m_File.isDirectory()) {
            throw new OwInvalidOperationException(OwString.localize(this.m_locale, "ecm.OwFileObject.nodir", "You can only insert into a directory."));
        }
        File newFile = new File(this.m_File, oObject_p.getName() + "." + OwMimeTypes.getExtensionFromMime(oObject_p.getMIMEType()));
        if (newFile.exists()) {
            throw new OwInvalidOperationException(OwString.localize(this.m_locale, "ecm.OwFileObject.existsalready", "There already exists a file with this name:") + oObject_p.getName());
        }
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(newFile);
            in = oObject_p.getContentCollection().getContentElement(1, 1).getContentStream(null);
            byte[] bBuf = new byte[10000];
            int iRead = 0;
            do {
                if ((iRead = in.read(bBuf)) == -1) continue;
                out.write(bBuf, 0, iRead);
            } while (iRead != -1);
            out.flush();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
                in = null;
            }
            if (out != null) {
                try {
                    out.close();
                    out = null;
                }
                catch (IOException e) {}
            }
        }
        this.m_eventmanager.addEvent(6, "addobject", 1);
    }

    @Override
    public boolean canAdd(OwObject oObject_p, int iContext_p) throws Exception {
        return this.m_File.isDirectory() && oObject_p.getType() == 4097;
    }

    @Override
    public void move(OwObject oObject_p, OwObject oldParent_p) throws Exception {
        this.add(oObject_p);
        oldParent_p.removeReference(oObject_p);
        this.m_eventmanager.addEvent(6, "moveobject", 1);
    }

    @Override
    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws Exception {
        return this.canAdd(oObject_p, iContext_p) && oldParent_p != null && oldParent_p.canRemoveReference(oObject_p, iContext_p);
    }

    @Override
    public OwSearchTemplate getSearchTemplate() throws Exception {
        return null;
    }

    @Override
    public Collection getColumnInfoList() throws Exception {
        return null;
    }

    @Override
    public int getPageNumber(int lPageIndex_p) throws Exception {
        return lPageIndex_p + 1;
    }

    @Override
    public int getPageCount() throws Exception {
        return 1;
    }

    @Override
    public OwResource getResource() throws Exception {
        return null;
    }

    @Override
    public OwPermissionCollection getPermissions() throws Exception {
        return null;
    }

    @Override
    public OwPermissionCollection getClonedPermissions() throws Exception {
        throw new OwNotSupportedException("OwFileObject.getClonedPermissions: Not implemented.");
    }

    @Override
    public boolean canGetPermissions() throws Exception {
        return false;
    }

    @Override
    public boolean canSetPermissions() throws Exception {
        return false;
    }

    @Override
    public void setPermissions(OwPermissionCollection permissions_p) throws Exception {
        this.m_eventmanager.addEvent(7, "modifyperm", 2);
        throw new OwNotSupportedException("OwFileObject.setPermissions: Not implemented.");
    }

    @Override
    public OwContentCollection getContentCollection() throws Exception {
        return this;
    }

    @Override
    public void refreshProperties() throws Exception {
    }

    @Override
    public void refreshProperties(Collection props_p) throws Exception {
        this.refreshProperties();
    }

    @Override
    public Object getNativeObject() throws Exception {
        return this.m_File;
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        return this.getProperty(strFieldClassName_p);
    }

    @Override
    public Object getFieldProviderSource() {
        return this;
    }

    @Override
    public int getFieldProviderType() {
        return 1;
    }

    @Override
    public boolean hasContent(int iContext_p) throws Exception {
        return this.m_File.exists();
    }

    @Override
    public String getContentFilePath() throws Exception {
        return this.m_File.getAbsolutePath();
    }

    @Override
    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return this.m_File.isDirectory() && this.m_File.listFiles(new OwObjectFileFilter(iObjectTypes_p)).length > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public String getPath() throws Exception {
        throw new OwNotSupportedException("OwFileObject.getPath: Not implemented.");
    }

    @Override
    public void releaseResources() {
        if (this.m_in != null) {
            try {
                this.m_in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_in = null;
        }
    }

    @Override
    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        if (this.m_File.isDirectory()) {
            if (this.m_iChildCount == -1) {
                this.m_iChildCount = this.m_File.listFiles(new OwObjectFileFilter(iObjectTypes_p)).length;
            }
            return this.m_iChildCount;
        }
        return 0;
    }

    @Override
    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws Exception {
        throw new OwInvalidOperationException("OwFileObject.changeClass: not implemented.");
    }

    @Override
    public boolean canChangeClass() throws Exception {
        return false;
    }

    @Override
    public String getFieldProviderName() {
        return this.getName();
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        this.getProperty(sName_p).setValue(value_p);
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            return this.getProperty(sName_p).getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public Collection getFields() throws Exception {
        return this.getProperties(null).values();
    }

    @Override
    public OwContentElement getContentElement(int iContentType_p, int iPage_p) throws Exception {
        return this;
    }

    @Override
    public OwObject getInstance() throws Exception {
        return this;
    }

    @Override
    public String getResourceID() throws Exception {
        try {
            return this.getResource().getID();
        }
        catch (NullPointerException e) {
            throw new OwObjectNotFoundException("Resource ID not found for: " + this.getDMSID(), (Throwable)e);
        }
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws Exception {
        this.setProperties(properties_p);
    }

    protected class OwObjectFileFilter
    implements FileFilter {
        private boolean m_fFiles;
        private boolean m_fDirectories;

        public OwObjectFileFilter(int[] iObjectTypes_p) {
            for (int i = 0; i < iObjectTypes_p.length; ++i) {
                if (OwStandardObjectClass.isContainerType(iObjectTypes_p[i])) {
                    this.m_fDirectories = true;
                }
                if (!OwStandardObjectClass.isContentType(iObjectTypes_p[i])) continue;
                this.m_fFiles = true;
            }
        }

        @Override
        public boolean accept(File pathname_p) {
            return pathname_p.isFile() && this.m_fFiles || pathname_p.isDirectory() && this.m_fDirectories;
        }
    }

    protected static class OwFilePropertyClass
    extends OwStandardPropertyClass {
        public OwFilePropertyClass(String strClassName_p, String strJavaClassName_p, OwString displayName_p, boolean fSystem_p, boolean fReadOnly_p, boolean fName_p) {
            this.m_strClassName = strClassName_p;
            this.m_strJavaClassName = strJavaClassName_p;
            this.m_DisplayName = displayName_p;
            this.m_fSystem = fSystem_p;
            this.m_fReadOnly[0] = fReadOnly_p;
            this.m_fReadOnly[1] = fReadOnly_p;
            this.m_fReadOnly[2] = fReadOnly_p;
            this.m_fName = fName_p;
        }

        public OwFilePropertyClass(String strClassName_p, String strJavaClassName_p, OwString displayName_p, boolean fSystem_p, boolean fReadOnly_p, boolean fName_p, boolean fRequired_p) {
            this.m_strClassName = strClassName_p;
            this.m_strJavaClassName = strJavaClassName_p;
            this.m_DisplayName = displayName_p;
            this.m_fSystem = fSystem_p;
            this.m_fReadOnly[0] = fReadOnly_p;
            this.m_fReadOnly[1] = fReadOnly_p;
            this.m_fReadOnly[2] = fReadOnly_p;
            this.m_fName = fName_p;
            this.m_fRequired = fRequired_p;
        }
    }

    public static class OwFileObjectClass
    implements OwObjectClass {
        public static final String NAME_PROPERTY = "ow_Filename";
        public static final String ID_PROPERTY = "ow_FileID";
        public static final String LAST_MODIFIED_PROPERTY = "ow_Last-Modified";
        public static final String SIZE_PROPERTY = "ow_Filesize";
        public static final String MIME_PROPERTY = "ow_MimeType";
        protected HashMap m_PropertyClassesMap = new HashMap();
        private boolean m_fDirectory;

        public OwFileObjectClass(boolean fDirectory_p) {
            this.m_fDirectory = fDirectory_p;
            this.m_PropertyClassesMap.put(ID_PROPERTY, new OwFilePropertyClass(ID_PROPERTY, "java.lang.String", new OwString("ecm.OwFileObject.id", "ID"), false, false, true, true));
            this.m_PropertyClassesMap.put(NAME_PROPERTY, new OwFilePropertyClass(NAME_PROPERTY, "java.lang.String", new OwString("ecm.OwFileObject.name", "Name"), false, false, true, true));
            this.m_PropertyClassesMap.put(LAST_MODIFIED_PROPERTY, new OwFilePropertyClass(LAST_MODIFIED_PROPERTY, "java.util.Date", new OwString("ecm.OwFileObject.last-modified", "Last modified"), true, true, false));
            this.m_PropertyClassesMap.put(SIZE_PROPERTY, new OwFilePropertyClass(SIZE_PROPERTY, "java.lang.Integer", new OwString("ecm.OwFileObject.size", "Size"), true, true, false));
            this.m_PropertyClassesMap.put(MIME_PROPERTY, new OwFilePropertyClass(MIME_PROPERTY, "java.lang.String", new OwString("ecm.OwFileObject.mime", "MIME Type"), true, true, false));
        }

        @Override
        public int getType() {
            return this.m_fDirectory ? 8193 : 4097;
        }

        @Override
        public OwObjectClass getParent() throws Exception {
            return null;
        }

        @Override
        public List getChilds(OwNetwork network_p, boolean fExcludeHidden_p) throws Exception {
            return null;
        }

        @Override
        public boolean hasChilds(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p, int context_p) {
            return false;
        }

        @Override
        public Map getChildNames(OwNetwork network_p, boolean fExcludeHiddenAndNonInstantiable_p) {
            return null;
        }

        @Override
        public String getClassName() {
            if (this.m_fDirectory) {
                return "OwFileSystemDirectory";
            }
            return "OwFileSystemFile";
        }

        public String getID() {
            return this.getClassName();
        }

        @Override
        public String getDisplayName(Locale locale_p) {
            return this.getClassName();
        }

        @Override
        public OwPropertyClass getPropertyClass(String strClassName_p) throws Exception {
            OwPropertyClass propertyClassDescription = (OwPropertyClass)this.m_PropertyClassesMap.get(strClassName_p);
            if (null == propertyClassDescription) {
                String msg = "OwFileObject.getPropertyClass: Cannot find the class for property = " + strClassName_p;
                LOG.debug((Object)msg);
                throw new OwObjectNotFoundException(msg);
            }
            return propertyClassDescription;
        }

        @Override
        public Collection getPropertyClassNames() throws Exception {
            return this.m_PropertyClassesMap.keySet();
        }

        @Override
        public String getNamePropertyName() throws Exception {
            return NAME_PROPERTY;
        }

        @Override
        public boolean canCreateNewObject() throws Exception {
            return true;
        }

        @Override
        public boolean hasVersionSeries() throws Exception {
            return false;
        }

        @Override
        public String getDescription(Locale locale_p) {
            return OwString.localize(locale_p, "ecm.OwFileObject.description", "Standard class for objects in the file system.");
        }

        @Override
        public boolean isHidden() throws Exception {
            return false;
        }

        @Override
        public List getModes(int operation_p) throws Exception {
            return null;
        }
    }
}

