/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwSearchObjectStore;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import org.apache.log4j.Logger;

public class OwSearchPath {
    private static final Logger LOG = OwLogCore.getLogger(OwSearchPath.class);
    public static final String PATH_DELIMITER = "/";
    private OwSearchObjectStore objectStore;
    private String pathName;
    private String id;
    private boolean searchSubFolders;

    public OwSearchPath(OwSearchObjectStore objectStore_p) throws OwInvalidOperationException {
        if (objectStore_p == null) {
            String msg = "Invalid search path! Missing object store in root search path!";
            LOG.error((Object)(" OwSearchPath. OwSearchPath():" + msg));
            throw new OwInvalidOperationException(msg);
        }
        this.objectStore = objectStore_p;
        this.id = null;
        this.pathName = null;
        this.searchSubFolders = true;
    }

    public OwSearchPath(String id_p, String pathName_p, boolean searchSubFolders_p, OwSearchObjectStore objectStore_p) throws OwInvalidOperationException {
        if (id_p == null && pathName_p == null) {
            String msg = "Invalid search path! One of id or pathName must be provided!";
            LOG.error((Object)("OwSearchPath. OwSearchPath():" + msg));
            throw new OwInvalidOperationException(msg);
        }
        this.objectStore = objectStore_p;
        this.pathName = OwSearchPath.normalizePathDelimiter(pathName_p);
        this.id = id_p;
        this.searchSubFolders = searchSubFolders_p;
    }

    public static String normalizePathDelimiter(String strPath_p) {
        if (strPath_p == null) {
            return null;
        }
        StringBuffer path = new StringBuffer();
        block3: for (int i = 0; i < strPath_p.length(); ++i) {
            char c = strPath_p.charAt(i);
            switch (c) {
                case '\\': {
                    path.append(PATH_DELIMITER);
                    continue block3;
                }
                default: {
                    path.append(c);
                }
            }
        }
        return path.toString();
    }

    public OwSearchObjectStore getObjectStore() {
        return this.objectStore;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSearchSubFolders() {
        return this.searchSubFolders;
    }

    public String toString() {
        return "[Search Path (pathName=" + this.pathName + ";id=" + this.id + ";searchSubfolder=" + this.searchSubFolders + ";objectStore=" + this.objectStore + ")]";
    }

    public boolean isObjectStoreReference() {
        return (this.id == null || this.id != null && this.id.length() == 0) && (this.pathName == null || this.pathName != null && this.pathName.length() == 0);
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwSearchPath) {
            OwSearchPath pathObject = (OwSearchPath)obj_p;
            if (this.id != null ? !this.id.equals(pathObject.id) : null != pathObject.id) {
                return false;
            }
            if (this.pathName != null ? !this.pathName.equals(pathObject.pathName) : null != pathObject.pathName) {
                return false;
            }
            if (this.searchSubFolders != pathObject.searchSubFolders) {
                return false;
            }
            if (this.objectStore != null) {
                return this.objectStore.equals(pathObject.objectStore);
            }
            return pathObject.objectStore == null;
        }
        return false;
    }

    public int hashCode() {
        StringBuilder build = new StringBuilder();
        if (this.id != null) {
            build.append(this.id);
        }
        if (this.objectStore != null) {
            build.append(this.objectStore);
        }
        if (this.pathName != null) {
            build.append(this.pathName);
        }
        build.append(this.searchSubFolders);
        return build.toString().hashCode();
    }
}

