/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class OwStandardContentCollection
implements OwContentCollection,
OwContentElement {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardContentCollection.class);
    private InputStream m_input;
    private int m_iContentType;
    private Collection m_ContentTypes;
    private int m_iPageNumber;
    private String m_mimetype;

    public OwStandardContentCollection(InputStream input_p, int iContentType_p, int iPageNumber_p) {
        this(input_p, iContentType_p, iPageNumber_p, "");
    }

    public OwStandardContentCollection(InputStream input_p, int iContentType_p, int iPageNumber_p, String sMimeType_p) {
        this.m_input = input_p;
        this.m_iContentType = iContentType_p;
        this.m_ContentTypes = new ArrayList(1);
        this.m_ContentTypes.add(iContentType_p);
        this.m_iPageNumber = iPageNumber_p;
        this.m_mimetype = sMimeType_p;
    }

    @Override
    public String getContentURL() throws Exception {
        throw new OwObjectNotFoundException("OwStandardContentCollection.getContentURL: Not implemented or Not supported.");
    }

    @Override
    public Object getContentObject() throws Exception {
        throw new OwObjectNotFoundException("OwStandardContentCollection.getContentObject: Not implemented or Not supported.");
    }

    @Override
    public int getContentRepresentation() throws Exception {
        return 2;
    }

    @Override
    public boolean isInputStreamNative() {
        return true;
    }

    @Override
    public OwContentElement getContentElement(int iContentType_p, int iPage_p) throws Exception {
        if (iContentType_p == this.m_iContentType && iPage_p == this.m_iPageNumber) {
            return this;
        }
        String msg = "OwStandardContentCollection.getContentElement: Content Element not found, type = " + this.m_iContentType + ", page = " + this.m_iPageNumber;
        LOG.debug((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getContentStream(OutputStream out_p) throws Exception {
        if (null == out_p) {
            return this.m_input;
        }
        try {
            OwStreamUtil.upload(this.m_input, out_p, false);
            out_p.flush();
        }
        finally {
            try {
                this.m_input.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    @Override
    public Collection getContentTypes() throws Exception {
        return this.m_ContentTypes;
    }

    @Override
    public int getPageNumber(int lPageIndex_p) throws Exception {
        return this.m_iPageNumber;
    }

    @Override
    public String getMIMEType() throws Exception {
        return this.m_mimetype;
    }

    @Override
    public String getMIMEParameter() throws Exception {
        return "";
    }

    @Override
    public int getPageCount() throws Exception {
        return 1;
    }

    @Override
    public String getContentFilePath() throws Exception {
        return null;
    }

    @Override
    public void releaseResources() {
        if (this.m_input != null) {
            try {
                this.m_input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_input = null;
        }
    }
}

