/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwClass;
import com.wewebu.ow.server.ecm.OwCrossMappings;
import com.wewebu.ow.server.ecm.OwExtendedCrossMappings;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwStandardDecoratorObject;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardDecoratorSearchCriteria;
import com.wewebu.ow.server.field.OwStandardDecoratorSearchNode;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class OwStandardCrossMappings
implements OwExtendedCrossMappings {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardCrossMappings.class);
    private OwXMLUtil m_confignode;
    private Map m_propertymappings;
    private Map m_usermappings;
    private Map m_groupmappings;
    private OwCrossLogin m_defaultlogin;
    private Map<String, String> m_xClassMappings;
    private Map<String, String> m_internalPropertyMappings;
    private Map<String, String> m_iClassMappings;

    public OwStandardCrossMappings(OwXMLUtil config_p) {
        this.m_confignode = config_p;
    }

    protected OwXMLUtil getConfigNode() {
        return this.m_confignode;
    }

    protected OwCrossLogin getDefaultlogin() {
        return this.m_defaultlogin;
    }

    protected Map getUsermappings() {
        if (null == this.m_usermappings) {
            this.createUserGroupMappings();
        }
        return this.m_usermappings;
    }

    protected Map getGroupmappings() throws Exception {
        if (null == this.m_groupmappings) {
            this.createUserGroupMappings();
        }
        return this.m_groupmappings;
    }

    protected Map getPropertyMappings() throws OwConfigurationException {
        if (null == this.m_propertymappings) {
            this.m_propertymappings = new HashMap();
            for (OwXMLUtil propertymap : this.getConfigNode().getSafeUtilList("propertymappings", "propertymap")) {
                String name = propertymap.getSafeStringAttributeValue("name", null);
                String xname = propertymap.getSafeTextValue(null);
                if (name == null || xname == null) {
                    String msg = "OwStandardCrossMappings.getPropertyMappings: name undefined, please define name attribute and x-namevalue in propertymap tag.";
                    LOG.fatal((Object)msg);
                    throw new OwConfigurationException(msg);
                }
                this.m_propertymappings.put(name, xname);
            }
        }
        return this.m_propertymappings;
    }

    private void createUserGroupMappings() {
        this.m_usermappings = new HashMap();
        this.m_groupmappings = new HashMap();
        for (OwXMLUtil usermapp : this.getConfigNode().getSafeUtilList("usermappings", "usermap")) {
            String user = usermapp.getSafeStringAttributeValue("name", null);
            String group = usermapp.getSafeStringAttributeValue("group", null);
            String xuser = usermapp.getSafeTextValue("user", null);
            String xpassword = usermapp.getSafeTextValue("password", null);
            if (null != user) {
                this.m_usermappings.put(user, new OwCrossLogin(xuser, xpassword));
                continue;
            }
            if (null != group) {
                this.m_groupmappings.put(group, new OwCrossLogin(xuser, xpassword));
                continue;
            }
            this.m_defaultlogin = new OwCrossLogin(xuser, xpassword);
        }
    }

    @Override
    public Collection getXProperties(Collection propertyNames_p) throws OwConfigurationException {
        Vector<String> ret = new Vector<String>();
        for (String name : propertyNames_p) {
            String xname = (String)this.getPropertyMappings().get(name);
            if (null == xname) {
                ret.add(name);
                continue;
            }
            ret.add(xname);
        }
        return ret;
    }

    @Override
    public void doXLogin(OwNetwork xnetwork_p, OwNetwork parentnetwork_p, String parentuser_p, String parentpassword_p) throws OwAuthenticationException, OwServerException {
        String msg;
        OwCrossLogin login = (OwCrossLogin)this.getUsermappings().get(parentuser_p);
        if (login == null) {
            LOG.info((Object)"OwStandardCrossMappings.doXLogin: No usermapping found, searching through group mapping.");
            try {
                OwUserInfo user = parentnetwork_p.getCredentials().getUserInfo();
                Iterator it = user.getGroups().iterator();
                while (it.hasNext() && login == null) {
                    OwUserInfo group = (OwUserInfo)it.next();
                    LOG.debug((Object)("OwStandardCrossMappings.doXLogin: Request group mapping displayname = " + group.getUserDisplayName()));
                    login = (OwCrossLogin)this.getGroupmappings().get(group.getUserDisplayName());
                    if (login == null) {
                        LOG.debug((Object)("OwStandardCrossMappings.doXLogin: Request group mapping long name = " + group.getUserLongName()));
                        login = (OwCrossLogin)this.getGroupmappings().get(group.getUserLongName());
                    }
                    if (login == null) {
                        LOG.debug((Object)("OwStandardCrossMappings.doXLogin: Request group mapping short name = " + group.getUserShortName()));
                        login = (OwCrossLogin)this.getGroupmappings().get(group.getUserShortName());
                    }
                    if (login != null) continue;
                    LOG.debug((Object)("OwStandardCrossMappings.doXLogin: Request group mapping getUserName = " + group.getUserName()));
                    login = (OwCrossLogin)this.getGroupmappings().get(group.getUserName());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Could not retrieve user info for groupinformation", (Throwable)e);
            }
        }
        if (login == null) {
            try {
                if (this.getDefaultlogin() == null && this.getUsermappings().isEmpty() && this.getGroupmappings().isEmpty()) {
                    LOG.debug((Object)"OwStandardCrossMappings.doXLogin: No mappings defined pass through credentials to XNetwork.");
                    login = new OwCrossLogin(parentuser_p, parentpassword_p);
                } else {
                    LOG.debug((Object)"OwStandardCrossMappings.doXLogin: No mappings found getting default login.");
                    login = this.getDefaultlogin();
                }
            }
            catch (Exception e) {
                msg = "OwStandardCrossMappings.doXLogin: Cannot retrieve group mappings!";
                LOG.fatal((Object)msg, (Throwable)e);
                throw new OwServerException(msg, (Throwable)e);
            }
        }
        if (login == null) {
            String msg2 = "OwStandardCrossMappings.doXLogin: No login found for X adapter = " + xnetwork_p.getDMSPrefix();
            LOG.fatal((Object)msg2);
            throw new OwServerException(msg2);
        }
        try {
            xnetwork_p.loginDefault(login.getUser(), login.getPassword());
        }
        catch (Exception e) {
            msg = "Your login information is invalid or the X adapter = " + xnetwork_p.getDMSPrefix() + " is not available. Please make sure that name and password are correct and the X adapter is running. " + "Please also check the <usermappings> configuration entry for user Administrator, member of groups...";
            LOG.debug((Object)msg, (Throwable)e);
            throw new OwAuthenticationException(msg, (Throwable)e);
        }
    }

    @Override
    public String getXProperty(String name_p) throws OwConfigurationException {
        String ret = (String)this.getPropertyMappings().get(name_p);
        if (null == ret) {
            return name_p;
        }
        return ret;
    }

    @Override
    public void mapXObjectCollection(OwObjectCollection objects_p) {
        for (int i = 0; i < objects_p.size(); ++i) {
            OwObject obj = (OwObject)objects_p.get(i);
            OwCrossDecoratorObject crossobj = new OwCrossDecoratorObject(obj, this);
            objects_p.set(i, crossobj);
        }
    }

    @Override
    public OwSearchNode getXSearch(OwSearchNode searchNode_p, String xRepositoryID_p, OwNetwork xNetwork_p) throws CloneNotSupportedException {
        return new OwCrossDecoratorSearchNode(searchNode_p, this, xNetwork_p, xRepositoryID_p);
    }

    @Override
    public OwSort getXSort(OwSort sort_p) throws CloneNotSupportedException, OwConfigurationException {
        Collection criteriaCollection = sort_p.getCriteriaCollection();
        OwSort xSort = new OwSort(sort_p.getMaxSize(), sort_p.getDefaultAsc());
        for (OwSort.OwSortCriteria sortCriteria : criteriaCollection) {
            String sortPropertyName = sortCriteria.getPropertyName();
            sortPropertyName = this.getXProperty(sortPropertyName);
            xSort.addCriteria(new OwSort.OwSortCriteria(sortPropertyName, sortCriteria.getAscFlag()));
        }
        return xSort;
    }

    private Map<String, String>[] loadConfigMapping(String configNodeName_p, String configItemName_p) throws OwConfigurationException {
        HashMap[] twoWayMaps = new HashMap[2];
        HashMap<String, String> xMappings = new HashMap<String, String>();
        HashMap<String, String> iMappings = new HashMap<String, String>();
        for (OwXMLUtil propertymap : this.getConfigNode().getSafeUtilList(configNodeName_p, configItemName_p)) {
            String name = propertymap.getSafeStringAttributeValue("name", null);
            String xname = propertymap.getSafeTextValue(null);
            if (name == null || xname == null) {
                String msg = "loadConfigMapping: name undefined, please define name attribute and x-namevalue in propertymap tag.";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            xMappings.put(name, xname);
            iMappings.put(xname, name);
        }
        twoWayMaps[0] = xMappings;
        twoWayMaps[1] = iMappings;
        return twoWayMaps;
    }

    private synchronized void loadPropertyMappings() throws OwConfigurationException {
        Map<String, String>[] twoWayMappings = this.loadConfigMapping("propertymappings", "propertymap");
        this.m_propertymappings = twoWayMappings[0];
        this.m_internalPropertyMappings = twoWayMappings[1];
    }

    protected synchronized Map getInternalPropertyMappings() throws OwConfigurationException {
        if (null == this.m_internalPropertyMappings) {
            this.loadPropertyMappings();
        }
        return this.m_internalPropertyMappings;
    }

    protected Map<String, String> getXClassMappings() throws OwConfigurationException {
        if (null == this.m_xClassMappings) {
            Map<String, String>[] twoWayMappings = this.loadConfigMapping("classmappings", "classmap");
            this.m_xClassMappings = twoWayMappings[0];
        }
        return this.m_xClassMappings;
    }

    protected Map<String, String> getIClassMappings() throws OwConfigurationException {
        if (null == this.m_iClassMappings) {
            Map<String, String>[] twoWayMappings = this.loadConfigMapping("classmappings", "classmap");
            this.m_iClassMappings = twoWayMappings[1];
        }
        return this.m_iClassMappings;
    }

    @Override
    public OwClass[] getXClasses(OwClass[] classes_p) throws OwConfigurationException {
        OwClass[] xClasses = new OwClass[classes_p.length];
        for (int i = 0; i < xClasses.length; ++i) {
            String xClassName = this.getXClassMappings().get(classes_p[i].getClassName());
            xClasses[i] = new OwClass(classes_p[i].getObjectType(), xClassName, classes_p[i].isEnabled(), classes_p[i].isIncludeSubclasses());
        }
        return xClasses;
    }

    @Override
    public String getXClass(String className_p) throws OwConfigurationException {
        String ret = this.getXClassMappings().get(className_p);
        if (null == ret) {
            return className_p;
        }
        return ret;
    }

    @Override
    public String getIClass(String className_p) throws OwConfigurationException {
        String ret = this.getIClassMappings().get(className_p);
        if (null == ret) {
            return className_p;
        }
        return ret;
    }

    @Override
    public Collection getIProperties(Collection propertyNames_p) throws OwConfigurationException {
        Vector<String> iProperties = null;
        if (propertyNames_p != null) {
            iProperties = new Vector<String>();
            for (String xName : propertyNames_p) {
                String iName = (String)this.getInternalPropertyMappings().get(xName);
                if (null == iName) {
                    iProperties.add(xName);
                    continue;
                }
                iProperties.add(iName);
            }
        }
        return iProperties;
    }

    @Override
    public String getIProperty(String xPropertyName_p) throws OwConfigurationException {
        String iName = (String)this.getInternalPropertyMappings().get(xPropertyName_p);
        if (null == iName) {
            return xPropertyName_p;
        }
        return iName;
    }

    @Override
    public Object convert(Object value_p, OwFieldDefinition from_p, OwFieldDefinition to_p) throws OwException {
        if (from_p.getJavaClassName().equals(String.class.getName()) && to_p.getJavaClassName().equals(BigInteger.class.getName())) {
            return value_p == null ? null : new BigInteger(value_p.toString());
        }
        if (to_p.getJavaClassName().equals(String.class.getName()) && from_p.getJavaClassName().equals(BigInteger.class.getName())) {
            return value_p == null ? null : value_p.toString();
        }
        return value_p;
    }

    private static class OwCrossLogin {
        private String m_user;
        private String m_password;

        public OwCrossLogin(String user_p, String password_p) {
            this.m_user = user_p;
            this.m_password = password_p;
        }

        public String getUser() {
            return this.m_user;
        }

        public String getPassword() {
            return this.m_password;
        }
    }

    private static class OwCrossDecoratorObject
    extends OwStandardDecoratorObject {
        private OwObject m_object;
        private OwCrossMappings m_crossMappings;

        public OwCrossDecoratorObject(OwObject object_p, OwCrossMappings crossMappings_p) {
            this.m_object = object_p;
            this.m_crossMappings = crossMappings_p;
        }

        @Override
        public OwObject getWrappedObject() {
            return this.m_object;
        }

        @Override
        public OwProperty getProperty(String strPropertyName_p) throws Exception {
            String xprop = this.m_crossMappings.getXProperty(strPropertyName_p);
            return super.getProperty(xprop);
        }
    }

    public static class OwCrossDecoratorSearchNode
    extends OwStandardDecoratorSearchNode {
        private OwSearchNode m_searchnode;
        private OwCrossMappings m_crossMappings;
        private OwNetwork m_xNetwork;
        private String m_xResourceID;

        public OwCrossDecoratorSearchNode(OwSearchNode searchnode_p, OwCrossMappings crossMappings_p, OwNetwork xNetwork_p, String xResourceID_p) {
            this.m_searchnode = searchnode_p;
            this.m_crossMappings = crossMappings_p;
            this.m_xNetwork = xNetwork_p;
            this.m_xResourceID = xResourceID_p;
        }

        @Override
        public OwSearchNode getWrappedSearchNode() {
            return this.m_searchnode;
        }

        @Override
        public OwSearchNode findSearchNode(int nodeType_p) {
            return this.createCrossDecoratorSearchNode(super.findSearchNode(nodeType_p), this.m_crossMappings, this.m_xNetwork, this.m_xResourceID);
        }

        @Override
        public List getChilds() {
            ArrayList<OwStandardDecoratorSearchNode> ret = new ArrayList<OwStandardDecoratorSearchNode>();
            List children = super.getChilds();
            if (children != null) {
                for (OwSearchNode n : children) {
                    ret.add(this.createCrossDecoratorSearchNode(n, this.m_crossMappings, this.m_xNetwork, this.m_xResourceID));
                }
            }
            return ret;
        }

        @Override
        public OwSearchCriteria createWrappedCriteria(OwSearchCriteria criteria_p) {
            if (criteria_p == null) {
                return null;
            }
            return new OwWrappedSearchCriteria(criteria_p, this.m_crossMappings, this.m_xNetwork, this.m_xResourceID);
        }

        public OwStandardDecoratorSearchNode createCrossDecoratorSearchNode(OwSearchNode searchnode_p, OwCrossMappings crossMappings_p, OwNetwork xNetwork_p, String xResourceID_p) {
            if (searchnode_p == null) {
                return null;
            }
            return new OwCrossDecoratorSearchNode(searchnode_p, crossMappings_p, xNetwork_p, xResourceID_p);
        }

        public static class OwWrappedSearchCriteria
        extends OwStandardDecoratorSearchCriteria {
            private OwSearchCriteria m_searchcriteria;
            private OwCrossMappings m_crossMappings;
            private OwNetwork m_xNetwork;
            private String m_xResourceID;

            public OwWrappedSearchCriteria(OwSearchCriteria searchcriteria_p, OwCrossMappings crossMappings_p, OwNetwork xNetwork_p, String xResourceID_p) {
                this.m_searchcriteria = searchcriteria_p;
                this.m_crossMappings = crossMappings_p;
                this.m_xNetwork = xNetwork_p;
                this.m_xResourceID = xResourceID_p;
            }

            @Override
            public OwSearchCriteria getWrappedCriteria() {
                return this.m_searchcriteria;
            }

            @Override
            public OwFieldDefinition getFieldDefinition() throws Exception {
                String xClassName;
                OwFieldDefinition superFieldDefinition = super.getFieldDefinition();
                String superClassName = superFieldDefinition.getClassName();
                if (!superClassName.equals(xClassName = this.m_crossMappings.getXProperty(superClassName))) {
                    return this.m_xNetwork.getFieldDefinition(xClassName, this.m_xResourceID);
                }
                LOG.warn((Object)("Cross incompatible field definition " + superFieldDefinition.getClassName() + " " + superFieldDefinition.getClass()));
                return superFieldDefinition;
            }

            @Override
            public OwSearchCriteria getSecondRangeCriteria() {
                return new OwWrappedSearchCriteria(super.getSecondRangeCriteria(), this.m_crossMappings, this.m_xNetwork, this.m_xResourceID);
            }

            @Override
            public Object getValue() {
                Object superValue = super.getValue();
                if (this.getUniqueName().equals("OwClassSelectObject")) {
                    Object[] classes = (Object[])superValue;
                    Object[] classesValue = new Object[classes.length];
                    for (int i = 0; i < classesValue.length; ++i) {
                        if (classes[i] instanceof OwClass) {
                            OwClass clazz = (OwClass)classes[i];
                            try {
                                String crossBaseClassName = ((OwExtendedCrossMappings)this.m_crossMappings).getXClass(clazz.getBaseClassName());
                                String crossClassName = ((OwExtendedCrossMappings)this.m_crossMappings).getXClass(clazz.getClassName());
                                classesValue[i] = new OwClass(clazz.getObjectType(), crossClassName, clazz.isEnabled(), clazz.isIncludeSubclasses());
                            }
                            catch (OwConfigurationException e) {
                                LOG.error((Object)("Could not cross convert search class " + clazz.getClassName()), (Throwable)e);
                                classesValue[i] = clazz;
                            }
                            continue;
                        }
                        classesValue[i] = classes[i];
                    }
                    return classesValue;
                }
                try {
                    OwFieldDefinition superFieldDefinition = super.getFieldDefinition();
                    OwFieldDefinition thisFieldDefinition = this.getFieldDefinition();
                    return this.m_crossMappings.convert(superValue, superFieldDefinition, thisFieldDefinition);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error converting search value .", (Throwable)e);
                    return superValue;
                }
            }

            @Override
            public String getClassName() {
                try {
                    String className = super.getClassName();
                    return this.m_crossMappings.getXProperty(className);
                }
                catch (OwConfigurationException e) {
                    return super.getClassName();
                }
            }

            @Override
            public String getUniqueName() {
                try {
                    String uName = super.getUniqueName();
                    return this.m_crossMappings.getXProperty(uName);
                }
                catch (OwConfigurationException e) {
                    return super.getUniqueName();
                }
            }
        }
    }

    public static class OwCrossSort
    extends OwSort {
        private OwSort sort;

        public OwCrossSort(OwSort sort) {
            this.sort = sort;
        }
    }
}

