/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwStandardObjectCollection
extends ArrayList
implements OwObjectCollection {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = OwLogCore.getLogger(OwStandardObjectCollection.class);
    private boolean m_fComplete = true;
    private Map m_Attributes = null;

    @Override
    public void sort(OwSort sortCriteria_p) throws Exception {
        Iterator it = sortCriteria_p.getCriteriaCollection().iterator();
        while (it.hasNext()) {
            Collections.sort(this, new OwObjectCollectionComparator((OwSort.OwSortCriteria)it.next()));
        }
    }

    @Override
    public boolean isComplete() throws Exception {
        return this.m_fComplete;
    }

    public void setComplete(boolean fComplete_p) {
        this.m_fComplete = fComplete_p;
    }

    @Override
    public boolean hasNext() throws Exception {
        return false;
    }

    @Override
    public boolean hasPrev() throws Exception {
        return false;
    }

    @Override
    public void getNext() throws Exception {
    }

    @Override
    public void getPrev() throws Exception {
    }

    @Override
    public Object getAttribute(int iIndex_p) throws Exception {
        throw new OwInvalidOperationException("OwStandardObjectCollection.getAttribute(int iIndex_p): Not implemented, use getAttribute(String strName_p).");
    }

    @Override
    public Object getSafeAttribute(String strName_p, Object default_p) {
        if (null != this.m_Attributes) {
            Object obj = this.m_Attributes.get(strName_p);
            if (obj != null) {
                return obj;
            }
            return default_p;
        }
        return default_p;
    }

    @Override
    public Object getAttribute(String strName_p) throws Exception {
        if (null != this.m_Attributes) {
            Object obj = this.m_Attributes.get(strName_p);
            if (obj != null) {
                return obj;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwStandardObjectCollection.getAttribute(String strName_p): Object not found Exception, strName_p = " + strName_p));
            }
            throw new OwObjectNotFoundException("OwStandardObjectCollection.getAttribute(String strName_p): strName_p = " + strName_p);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwStandardObjectCollection.getAttribute(String strName_p): Object not found Exception, The map for the OwAttributeBag implementation (Attributes == null), strName_p = " + strName_p));
        }
        throw new OwObjectNotFoundException("OwStandardObjectCollection.getAttribute(String strName_p): The map for the OwAttributeBag implementation (Attributes == null), strName_p = " + strName_p);
    }

    public void setAttribute(String strName_p, Object object_p) throws Exception {
        if (null == this.m_Attributes) {
            this.m_Attributes = new HashMap();
        }
        this.m_Attributes.put(strName_p, object_p);
    }

    @Override
    public boolean hasAttribute(String strName_p) {
        if (null != this.m_Attributes) {
            return this.m_Attributes.containsKey(strName_p);
        }
        return false;
    }

    @Override
    public Collection getAttributeNames() {
        if (null != this.m_Attributes) {
            return this.m_Attributes.keySet();
        }
        return new ArrayList();
    }

    @Override
    public int attributecount() {
        return this.m_Attributes.size();
    }

    protected class OwObjectCollectionComparator
    implements Comparator {
        private OwSort.OwSortCriteria m_SortCriteria;

        public OwObjectCollectionComparator(OwSort.OwSortCriteria sortCriteria_p) {
            this.m_SortCriteria = sortCriteria_p;
        }

        public int compare(Object o1_p, Object o2_p) {
            int iRet = 0;
            OwProperty Prop1 = null;
            OwProperty Prop2 = null;
            try {
                Prop1 = ((OwObject)o1_p).getProperty(this.m_SortCriteria.getPropertyName());
                Prop2 = ((OwObject)o2_p).getProperty(this.m_SortCriteria.getPropertyName());
                iRet = Prop1.getValue() == null && Prop2.getValue() == null ? 0 : (Prop1.getValue() == null ? -1 : (Prop2.getValue() == null ? 1 : Prop1.compareTo(Prop2)));
            }
            catch (Exception e) {
                iRet = Prop1 == null && Prop2 == null ? 0 : (Prop1 == null ? -1 : 1);
            }
            if (!this.m_SortCriteria.getAscFlag()) {
                return -1 * iRet;
            }
            return iRet;
        }
    }
}

