/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwEscapedStringTokenizer;
import java.util.Vector;

public class OwStandardObjectReference
implements OwObjectReference {
    protected String m_dmsid;
    protected String m_id;
    protected String m_mimeparameter;
    protected String m_mimetype;
    protected String m_name;
    protected int m_pagecount;
    protected int m_type;
    protected boolean m_fhascontent;
    protected String m_resourceid;
    protected OwRepository m_repository;

    public OwStandardObjectReference() {
    }

    public OwStandardObjectReference(String dmsid_p, String name_p, String mimetype_p, int itype_p, String resourceid_p, OwRepository repository_p, boolean fHasContent_p) {
        this.m_dmsid = dmsid_p;
        this.m_name = name_p;
        this.m_mimetype = mimetype_p;
        this.m_type = itype_p;
        this.m_id = this.m_dmsid;
        this.m_mimeparameter = "";
        this.m_pagecount = 0;
        this.m_fhascontent = fHasContent_p;
        this.m_resourceid = resourceid_p;
        this.m_repository = repository_p;
    }

    @Override
    public OwObject getInstance() throws Exception {
        return this.m_repository.getObjectFromDMSID(this.getDMSID(), false);
    }

    @Override
    public String getResourceID() throws Exception {
        return this.m_resourceid;
    }

    public OwStandardObjectReference(String dmsid_p, String ref_p, OwRepository repository_p) {
        this.m_repository = repository_p;
        this.m_dmsid = dmsid_p;
        OwEscapedStringTokenizer tokenizer = new OwEscapedStringTokenizer(ref_p);
        this.m_name = tokenizer.next();
        this.m_mimetype = tokenizer.hasNext() ? tokenizer.next() : "";
        this.m_type = tokenizer.hasNext() ? Integer.parseInt(tokenizer.next()) : 4097;
        this.m_pagecount = tokenizer.hasNext() ? Integer.parseInt(tokenizer.next()) : 0;
        this.m_fhascontent = tokenizer.hasNext() ? tokenizer.next().equalsIgnoreCase("true") : true;
        this.m_id = this.m_dmsid;
        this.m_mimeparameter = "";
    }

    public static String getReferenceString(OwObjectReference obj_p, int iContext_p) throws Exception {
        Vector<String> tokens = new Vector<String>();
        tokens.add(obj_p.getName());
        tokens.add(obj_p.getMIMEType());
        tokens.add(String.valueOf(obj_p.getType()));
        tokens.add(String.valueOf(obj_p.getPageCount()));
        try {
            tokens.add(String.valueOf(obj_p.hasContent(iContext_p)));
        }
        catch (OwStatusContextException e) {
            if (OwStandardObjectClass.isContentType(obj_p.getType())) {
                tokens.add(String.valueOf(true));
            }
            tokens.add(String.valueOf(false));
        }
        return OwEscapedStringTokenizer.createDelimitedString(tokens);
    }

    public OwStandardObjectReference(String ref_p, OwRepository repository_p) {
        this.m_repository = repository_p;
        OwEscapedStringTokenizer tokenizer = new OwEscapedStringTokenizer(ref_p);
        this.m_name = tokenizer.next();
        this.m_mimetype = tokenizer.hasNext() ? tokenizer.next() : "";
        this.m_type = tokenizer.hasNext() ? Integer.parseInt(tokenizer.next()) : 4097;
        this.m_pagecount = tokenizer.hasNext() ? Integer.parseInt(tokenizer.next()) : 0;
        this.m_resourceid = tokenizer.hasNext() ? tokenizer.next() : "";
        this.m_dmsid = tokenizer.hasNext() ? tokenizer.next() : "";
        this.m_mimeparameter = tokenizer.hasNext() ? tokenizer.next() : "";
        this.m_fhascontent = tokenizer.hasNext() ? tokenizer.next().equalsIgnoreCase("true") : true;
        this.m_id = this.m_dmsid;
        this.m_mimeparameter = "";
    }

    public static String getCompleteReferenceString(OwObjectReference obj_p, int iContext_p) throws Exception {
        Vector<String> tokens = new Vector<String>();
        tokens.add(obj_p.getName());
        tokens.add(obj_p.getMIMEType());
        tokens.add(String.valueOf(obj_p.getType()));
        tokens.add(String.valueOf(obj_p.getPageCount()));
        try {
            tokens.add(obj_p.getResourceID());
        }
        catch (OwObjectNotFoundException e) {
            tokens.add("");
        }
        tokens.add(obj_p.getDMSID());
        tokens.add(obj_p.getMIMEParameter());
        try {
            tokens.add(String.valueOf(obj_p.hasContent(iContext_p)));
        }
        catch (OwStatusContextException e) {
            if (OwStandardObjectClass.isContentType(obj_p.getType())) {
                tokens.add(String.valueOf(true));
            }
            tokens.add(String.valueOf(false));
        }
        return OwEscapedStringTokenizer.createDelimitedString(tokens);
    }

    @Override
    public String getDMSID() throws Exception {
        return this.m_dmsid;
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    @Override
    public String getMIMEParameter() throws Exception {
        return this.m_mimeparameter;
    }

    @Override
    public String getMIMEType() throws Exception {
        return this.m_mimetype;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public int getPageCount() throws Exception {
        return this.m_pagecount;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public boolean hasContent(int context_p) throws Exception {
        return this.m_fhascontent;
    }
}

