/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFormat;
import com.wewebu.ow.server.fieldctrlimpl.OwRelativeDate;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OwStandardPropertyClass
implements OwPropertyClass {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardPropertyClass.class);
    private static final String DATE_TEXT_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String EXACT_DATE_TEXT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.S'Z'Z";
    protected String m_strClassName;
    protected String m_strJavaClassName;
    protected OwString m_DisplayName;
    protected OwString m_description;
    protected boolean m_fSystem;
    protected boolean[] m_fReadOnly = new boolean[3];
    protected boolean m_fName;
    protected OwEnumCollection m_Enums;
    protected boolean m_fRequired;
    protected boolean m_fArray;
    protected Object m_DMSType;
    protected Collection m_operators;
    protected Object m_MaxValue;
    protected Object m_MinValue;
    protected Object m_Default;
    protected boolean[] m_fHidden = new boolean[3];

    @Override
    public String getClassName() {
        return this.m_strClassName;
    }

    @Override
    public OwFormat getFormat() {
        return null;
    }

    public void setJavaClassName(String strJavaClassName_p) {
        this.m_strJavaClassName = strJavaClassName_p;
    }

    @Override
    public String getDisplayName(Locale locale_p) {
        return this.m_DisplayName.getString(locale_p);
    }

    @Override
    public String getDescription(Locale locale_p) {
        if (null != this.m_description) {
            return this.m_description.getString(locale_p);
        }
        return this.getDisplayName(locale_p);
    }

    @Override
    public String getJavaClassName() {
        return this.m_strJavaClassName;
    }

    @Override
    public Object getNativeType() throws Exception {
        return this.m_DMSType;
    }

    @Override
    public boolean isArray() throws Exception {
        return this.m_fArray;
    }

    @Override
    public boolean isEnum() throws Exception {
        return this.m_Enums != null;
    }

    @Override
    public OwEnumCollection getEnums() throws Exception {
        return this.m_Enums;
    }

    @Override
    public boolean isSystemProperty() throws Exception {
        return this.m_fSystem;
    }

    @Override
    public boolean isNameProperty() throws Exception {
        return this.m_fName;
    }

    @Override
    public boolean isRequired() throws Exception {
        return this.m_fRequired;
    }

    @Override
    public boolean isReadOnly(int iContext_p) throws Exception {
        return this.m_fReadOnly[iContext_p];
    }

    @Override
    public Object getMaxValue() throws Exception {
        return this.m_MaxValue;
    }

    @Override
    public Object getMinValue() throws Exception {
        return this.m_MinValue;
    }

    @Override
    public Object getDefaultValue() throws Exception {
        return this.m_Default;
    }

    @Override
    public boolean isHidden(int iContext_p) throws Exception {
        return this.m_fHidden[iContext_p];
    }

    @Override
    public Object getValueFromNode(Node node_p) throws Exception {
        return OwStandardPropertyClass.getValueFromNode(node_p, this);
    }

    public static Object getValueFromNode(Node node_p, OwFieldDefinition definition_p) throws Exception {
        if (null == node_p) {
            return null;
        }
        if (node_p.getNodeType() == 3) {
            return OwStandardPropertyClass.getValueFromString(node_p.getNodeValue(), definition_p);
        }
        Class<?> newClass = Class.forName(definition_p.getJavaClassName());
        Constructor<?> constr = newClass.getConstructor(Node.class);
        return constr.newInstance(node_p);
    }

    @Override
    public Object getValueFromString(String text_p) throws Exception {
        return OwStandardPropertyClass.getValueFromString(text_p, this);
    }

    public static Object getValueFromString(String text_p, OwFieldDefinition definition_p) throws Exception {
        String strJavaClassName = definition_p.getJavaClassName();
        if (definition_p.isArray()) {
            StringTokenizer arraytokens = new StringTokenizer(text_p, ",");
            Object[] retArray = new Object[arraytokens.countTokens()];
            int i = 0;
            while (arraytokens.hasMoreTokens()) {
                String strToken = arraytokens.nextToken();
                retArray[i++] = OwStandardPropertyClass.getSkalarValueFromString(strToken, strJavaClassName);
            }
            return retArray;
        }
        return OwStandardPropertyClass.getSkalarValueFromString(text_p, strJavaClassName);
    }

    public static Object getSkalarEmptyValue(String strJavaClassName_p) throws Exception {
        try {
            return OwStandardPropertyClass.getSkalarValueFromString("", strJavaClassName_p);
        }
        catch (Exception e) {
            return OwStandardPropertyClass.getSkalarValueFromString("0", strJavaClassName_p);
        }
    }

    public static Object getSkalarValueFromString(String strLiteral_p, String strJavaClassName_p) throws Exception {
        if (strJavaClassName_p.equals("java.util.Date")) {
            if (strLiteral_p.length() == 0) {
                return null;
            }
            try {
                if (-1 != strLiteral_p.indexOf(46)) {
                    return new SimpleDateFormat(EXACT_DATE_TEXT_FORMAT).parse(strLiteral_p);
                }
                if (strLiteral_p.length() > 24) {
                    strLiteral_p = strLiteral_p.substring(0, strLiteral_p.length() - 3) + strLiteral_p.substring(strLiteral_p.length() - 2);
                }
                try {
                    return new SimpleDateFormat(DATE_TEXT_FORMAT).parse(strLiteral_p);
                }
                catch (ParseException e) {
                    OwRelativeDate relativeDate = OwRelativeDate.fromString(strLiteral_p);
                    if (relativeDate != null) {
                        return relativeDate;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                String msg = "Invalid date format for :" + strLiteral_p;
                LOG.error((Object)msg, (Throwable)e);
                throw new OwInvalidOperationException(new OwString1("app.OwStandardPropertyClass.invalid.date.format", "Invalid date format %1", strLiteral_p), (Throwable)e);
            }
        }
        Class<?> newClass = Class.forName(strJavaClassName_p);
        Constructor<?> constr = newClass.getConstructor(String.class);
        return constr.newInstance(strLiteral_p);
    }

    @Override
    public Node getNodeFromValue(Object value_p, Document doc_p) throws Exception {
        return OwStandardPropertyClass.getNodeFromValue(value_p, doc_p, this.getJavaClassName());
    }

    public static Node getNodeFromValue(Object value_p, Document doc_p, String javaClassName_p) throws Exception {
        if (null == value_p) {
            return null;
        }
        if (javaClassName_p.equals("java.util.Date")) {
            return doc_p.createTextNode(new SimpleDateFormat(EXACT_DATE_TEXT_FORMAT).format((Date)value_p));
        }
        return doc_p.createTextNode(value_p.toString());
    }

    public static String getStringFromValue(Object value_p, String strJavaClassName_p) {
        try {
            if (strJavaClassName_p.equals("java.util.Date")) {
                return new SimpleDateFormat(EXACT_DATE_TEXT_FORMAT).format((Date)value_p);
            }
            return value_p.toString();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public String getCategory() throws Exception {
        return "";
    }

    @Override
    public Collection getOperators() throws Exception {
        return this.m_operators;
    }

    public static boolean isType(Class base_p, String sSubJavaClassName_p) throws ClassNotFoundException {
        return base_p.isAssignableFrom(Class.forName(sSubJavaClassName_p));
    }

    public boolean isType(Class base_p) throws ClassNotFoundException {
        return base_p.isAssignableFrom(Class.forName(this.getJavaClassName()));
    }

    public static OwPropertyCollection getClonedProperties(OwObject object_p, Collection propertyNames_p) throws Exception {
        OwPropertyCollection Properties2 = object_p.getProperties(propertyNames_p);
        OwStandardPropertyCollection retList = new OwStandardPropertyCollection();
        if (null == propertyNames_p) {
            for (OwProperty Property : Properties2.values()) {
                retList.put(Property.getPropertyClass().getClassName(), Property.clone());
            }
        } else {
            for (String propname : propertyNames_p) {
                OwProperty property = (OwProperty)Properties2.get(propname);
                if (property == null) {
                    String classname = "...";
                    try {
                        classname = " [" + object_p.getObjectClass().getClassName() + "]...";
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String msg = "OwStandardPropertyClass.getClonedProperties: Error accessing the property=[" + propname + "], the property is not valid for the object class" + classname + " Please check your configuration!";
                    LOG.debug((Object)msg);
                    throw new OwObjectNotFoundException(msg);
                }
                retList.put(property.getPropertyClass().getClassName(), property.clone());
            }
        }
        return retList;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public List getComplexChildClasses() throws Exception {
        return null;
    }
}

