/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.ecm.OwSearchObjectStore;
import com.wewebu.ow.server.ecm.OwSearchPath;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwStandardSearchSpecialNodeOperator {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardSearchSpecialNodeOperator.class);
    private Object[] m_classobjects;
    private int m_mergeType;
    private LinkedList m_paths = new LinkedList();

    public Object[] getClasses() {
        return this.m_classobjects;
    }

    public String getMergeTypeRepresentation() {
        switch (this.m_mergeType) {
            case 1026: {
                return "union";
            }
            case 1027: {
                return "intersection";
            }
        }
        if (1025 != this.m_mergeType && LOG.isDebugEnabled()) {
            LOG.info((Object)("OwStandardSearchSpecialNodeOperator.getMergeType: merge operator not matching OwSearchOperator.MERGE_NONE value =" + this.m_mergeType));
        }
        return "none";
    }

    public int getMergeType() {
        return this.m_mergeType;
    }

    public List getObjectStores() {
        LinkedList<OwSearchObjectStore> objectStores = new LinkedList<OwSearchObjectStore>();
        for (OwSearchPath path : this.getPaths()) {
            OwSearchObjectStore objectStore = path.getObjectStore();
            if (objectStores.contains(objectStore)) continue;
            objectStores.add(objectStore);
        }
        return objectStores;
    }

    public Collection getPaths() {
        return this.m_paths;
    }

    public List getSubpaths() {
        LinkedList<OwSearchPath> subpaths = new LinkedList<OwSearchPath>();
        for (OwSearchPath path : this.m_paths) {
            if (path.isObjectStoreReference()) continue;
            subpaths.add(path);
        }
        return subpaths;
    }

    public void scan(OwSearchNode searchNode_p) throws Exception {
        if (!searchNode_p.isCriteriaNode()) {
            List nodeChildren = searchNode_p.getChilds();
            Iterator itSearch = nodeChildren.iterator();
            while (itSearch.hasNext()) {
                this.scan((OwSearchNode)itSearch.next());
            }
        } else {
            OwSearchCriteria criteria = searchNode_p.getCriteria();
            OwFieldDefinition fieldDefinition = criteria.getFieldDefinition();
            String fieldClass = fieldDefinition.getClassName();
            if ("OwSearchPath".equals(fieldClass)) {
                this.handleResourcepaths(searchNode_p);
                this.setMergeType(criteria.getOperator());
            } else if ("OwClassSelectObject".equals(fieldClass)) {
                this.handleClasses(searchNode_p);
            }
        }
    }

    protected void handleResourcepaths(OwSearchNode pathSearchNode_p) {
        OwSearchCriteria pathCriteria = pathSearchNode_p.getCriteria();
        OwSearchPath path = (OwSearchPath)pathCriteria.getValue();
        if (null == path) {
            return;
        }
        this.m_paths.add(path);
    }

    protected void handleClasses(OwSearchNode classSearchNode_p) {
        Object o = classSearchNode_p.getCriteria().getValue();
        this.setClasses((Object[])o);
    }

    protected void setMergeType(int mergeType_p) {
        this.m_mergeType = mergeType_p;
    }

    protected void setClasses(Object[] owClassArr_p) {
        this.m_classobjects = owClassArr_p;
    }
}

