/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwClass;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwSearchObjectStore;
import com.wewebu.ow.server.ecm.OwSearchPath;
import com.wewebu.ow.server.ecm.OwSearchPathField;
import com.wewebu.ow.server.ecm.OwStandardClassSelectObject;
import com.wewebu.ow.server.ecm.OwStandardContentBasedRetrivalObject;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwFormat;
import com.wewebu.ow.server.field.OwHeaderFieldColumnInfoDecorator;
import com.wewebu.ow.server.field.OwPriorityRule;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchOperator;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OwStandardSearchTemplate
implements OwSearchTemplate {
    private static final String CUSTOMOBJECT_TYPE = "customobject";
    private static final String FOLDER_TYPE = "folder";
    private static final String DOCUMENT_TYPE = "document";
    private static final String ATTRIBUTE_ALIGNMENT = "alignment";
    private static final String ATTRIBUTE_ALLOWWILDCARD = "allowwildcard";
    private static final String ATTRIBUTE_CHOICEID = "choiceId";
    private static final String ATTRIBUTE_DATE_MODE = "datemode";
    private static final String ATTRIBUTE_DATE_MODE_IGNORE_DATE = "ignoredate";
    private static final String ATTRIBUTE_DATE_MODE_IGNORE_TIME = "ignoretime";
    private static final String ATTRIBUTE_DATE_MODE_USE_TIME = "usetime";
    private static final String ATTRIBUTE_EDIT_MODE = "editproperty";
    private static final String ATTRIBUTE_EDIT_MODE_EDITABLE = "editable";
    private static final String ATTRIBUTE_EDIT_MODE_HIDDEN = "hidden";
    private static final String ATTRIBUTE_EDIT_MODE_READONLY = "readonly";
    private static final String ATTRIBUTE_EDIT_MODE_REQUIRED = "required";
    private static final String ATTRIBUTE_HASCHOICES = "haschoices";
    private static final String ATTRIBUTE_INCLUDESUBCLASSES = "includesubclasses";
    private static final String ATTRIBUTE_INSTRUCTION = "instruction";
    private static final String ATTRIBUTE_LITERAL_RANGE_1 = "value_1";
    private static final String ATTRIBUTE_LITERAL_RANGE_2 = "value_2";
    private static final String ATTRIBUTE_MAX_VALUE = "maxvalue";
    private static final String ATTRIBUTE_MIN_VALUE = "minvalue";
    private static final String ATTRIBUTE_OBJECTTYPE = "objecttype";
    private static final String ATTRIBUTE_OVERRIDE_DATATYPE = "overridedatatype";
    private static final String ATTRIBUTE_SORTLEVEL = "sortlevel";
    private static final String ATTRIBUTE_SORTORDER = "sortorder";
    private static final String ATTRIBUTE_SYMNAME = "symname";
    private static final String ATTRIBUTE_UNIQUENAME = "uniquename";
    private static final String ATTRIBUTE_VIEW_MODE = "view";
    private static final String CRITERIA_GROUP_ELEMENT_NAME = "c-g";
    private static final String CRITERION_ELEMENT_NAME = "c";
    private static final String ELEMENT_LITERAL = "literal";
    private static final String ELEMENT_PROPDESC = "propdesc";
    private static final String ELEMENT_WHEREPROP = "whereprop";
    public static final String LITERAL_PLACEHOLDER_LEFT_DELIMITER = "{";
    public static final String LITERAL_PLACEHOLDER_RIGHT_DELIMITER = "}";
    private static final Logger LOG = OwLogCore.getLogger(OwStandardSearchTemplate.class);
    protected static final SqlOperatorSingleton m_SqlOperators = new SqlOperatorSingleton();
    private static final String NAME_ATTR_NAME = "name";
    private static final int OW_CLASS_BASECLASSNAME = 3;
    private static final int OW_CLASS_TYPE = 1;
    private static final int OW_CLASS_CLASSNAME = 2;
    private static final int OW_CLASS_ENABLED = 5;
    private static final int OW_CLASS_INCLUDE_SUBCLASSES = 6;
    private static final int OW_CLASS_RESOURCENAME = 4;
    private static final int[] OW_CLASS_STRUCTURE = new int[]{1, 2, 3, 4, 5};
    private static final String SECOND_CRITERION_ELEMENT_NAME = "s-c";
    private static final String VALUE_ELEMENT_NAME = "v";
    private OwSearchNode m_cashedSearch;
    protected List m_ColumnInfoList;
    protected Node m_ColumnInfoNode;
    private OwNetworkContext m_context;
    protected OwFieldDefinitionProvider m_fieldDefinitionProvider;
    protected OwFieldProvider m_fieldProvider = null;
    private Node m_folders;
    private int m_iDefaultMaxSize;
    protected boolean m_isWrittableAttributeBagAvailable;
    protected int m_iVersionSelection = 2;
    private Locale m_local;
    protected OwObject m_object;
    private Node m_objectstores;
    private Map m_OnTheFlyClassDescriptions;
    protected Collection m_resourceNames;
    private String m_savedSearch;
    protected OwSearchNode m_Search;
    protected String m_strHtmlLayout;
    protected String m_strJspLayoutPage;
    protected String m_strName;
    private Node m_XMLSearchTemplateNode;

    protected static Node getAttributeByName(Node node_p, String attributeName_p) throws OwException {
        if (node_p == null || attributeName_p == null) {
            throw new OwInvalidOperationException("OwStandardSearchTemplate.getAttributeByName: One of the parameter (node or attributeName) is a null reference...");
        }
        Node att = node_p.getAttributes().getNamedItem(attributeName_p);
        if (att == null) {
            String msg = "OwStandardSearchTemplate.getAttributeByName: Searchtemplate failure, the attribute=\"" + attributeName_p + "\" could not be found in node=" + node_p.getNodeName();
            LOG.error((Object)msg);
            throw new OwConfigurationException(msg);
        }
        return att;
    }

    public static boolean isDocId(String text_p) {
        if (text_p.length() != 38) {
            return false;
        }
        if (text_p.charAt(9) != '-') {
            return false;
        }
        if (text_p.charAt(14) != '-') {
            return false;
        }
        if (text_p.charAt(19) != '-') {
            return false;
        }
        return text_p.charAt(24) == '-';
    }

    public OwStandardSearchTemplate(OwNetworkContext context_p, Node xmlSearchTemplateNode_p, String strName_p, String strResourceName_p) throws Exception {
        this.m_context = context_p;
        this.m_local = context_p.getLocale();
        this.m_strName = strName_p;
        this.m_XMLSearchTemplateNode = xmlSearchTemplateNode_p;
        this.m_folders = null;
        this.m_objectstores = null;
        this.scanCustomInfo(xmlSearchTemplateNode_p);
    }

    @Deprecated
    public OwStandardSearchTemplate(OwNetworkContext context_p, Node xmlSearchTemplateNode_p, String strName_p, String strResourceName_p, boolean useSearchPaths_p) throws Exception {
        this(context_p, xmlSearchTemplateNode_p, strName_p, strResourceName_p);
        if (!useSearchPaths_p) {
            throw new OwNotSupportedException("The support of OwStandardResourceSelectPath was deprecated in 3.0.0.0 and is no more supported since 4.0.0.0");
        }
    }

    public OwStandardSearchTemplate(OwNetworkContext context_p, OwObject obj_p) throws Exception {
        this.m_context = context_p;
        this.m_local = this.m_context.getLocale();
        this.m_object = obj_p;
        this.m_strName = obj_p.getName();
    }

    public OwStandardSearchTemplate(OwNetworkContext context_p, OwObject obj_p, boolean useSearchPaths_p) throws Exception {
        this(context_p, obj_p);
        if (!useSearchPaths_p) {
            throw new OwNotSupportedException("The support of OwStandardResourceSelectPath was deprecated in 3.0.0.0 and is no more supported since 4.0.0.0");
        }
    }

    @Override
    public boolean canDeleteSearch() {
        return this.m_isWrittableAttributeBagAvailable;
    }

    @Override
    public boolean canSaveSearch() {
        return this.m_isWrittableAttributeBagAvailable;
    }

    @Override
    public boolean canUpdateSearch() {
        return this.m_isWrittableAttributeBagAvailable;
    }

    protected int convertOperator(String strOperator_p) throws OwConfigurationException {
        try {
            Integer operator = (Integer)OwStandardSearchTemplate.m_SqlOperators.m_OperatorMap.get(strOperator_p);
            return operator;
        }
        catch (NullPointerException e) {
            LOG.error((Object)("OwStandardSearchTemplate.convertOperator: Invalid operator = '" + strOperator_p + "' in searchtemplate = " + this.getName()), (Throwable)e);
            throw new OwConfigurationException(OwString.localize2(this.m_local, "server.ecm.OwStandardSearchTemplate.invalidOperator", "Invalid operator '%1' in search template '%2'", strOperator_p, this.getName()), (Throwable)e);
        }
    }

    private List createColumnInfo(Node columnInfoNode_p) throws Exception {
        ArrayList<OwHeaderFieldColumnInfoDecorator> ColumnInfoList = new ArrayList<OwHeaderFieldColumnInfoDecorator>();
        for (Node n = columnInfoNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.hasAttributes()) continue;
            String strClassName = OwStandardSearchTemplate.getAttributeByName(n, ATTRIBUTE_SYMNAME).getNodeValue();
            int iAlignment = 0;
            try {
                String strAlignment = n.getAttributes().getNamedItem(ATTRIBUTE_ALIGNMENT).getNodeValue();
                if (strAlignment.equalsIgnoreCase("left")) {
                    iAlignment = 1;
                }
                if (strAlignment.equalsIgnoreCase("center")) {
                    iAlignment = 2;
                }
                if (strAlignment.equalsIgnoreCase("right")) {
                    iAlignment = 3;
                }
                if (strAlignment.equalsIgnoreCase("leftnowrap")) {
                    iAlignment = 4;
                }
                if (strAlignment.equalsIgnoreCase("centernowrap")) {
                    iAlignment = 5;
                }
                if (strAlignment.equalsIgnoreCase("rightnowrap")) {
                    iAlignment = 6;
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            OwFieldDefinition propClass = this.getPropertyClassInternal(strClassName, new OwStandardXMLUtil(n));
            if (propClass != null) {
                OwStandardFieldColumnInfo info = new OwStandardFieldColumnInfo(propClass, iAlignment);
                ColumnInfoList.add(new OwHeaderFieldColumnInfoDecorator(info, this.getName()));
                continue;
            }
            LOG.debug((Object)("OwStandardSearchTemplate.createColumnInfo: Search Template parser error, undefined criteria property = " + strClassName));
            throw new OwObjectNotFoundException(OwString.localize1(this.m_local, "server.ecm.OwStandardSearchTemplate.UndefinedCriteriaProperty", "Search Template parser error, undefined criteria property: %1", strClassName));
        }
        return ColumnInfoList;
    }

    protected OwSearchNode createSearchNode(int iOp_p, int iNodeType_p) {
        return new OwSearchNode(iOp_p, iNodeType_p);
    }

    protected OwSearchNode createSearchNode(OwField field_p, int iOp_p, int iAttributes_p, String strUniqueName_p, String strInstruction_p, Collection wildcarddefinitions_p) throws Exception {
        return new OwSearchNode(field_p, iOp_p, iAttributes_p, strUniqueName_p, strInstruction_p, wildcarddefinitions_p);
    }

    protected OwSearchNode createSearchNode(OwFieldDefinition fieldDefinition_p, int iOp_p, Object oInitialAndDefaultValue_p, int iAttributes_p, String strUniqueName_p, String strInstruction_p, Collection wildcarddefinitions_p) {
        return new OwSearchNode(fieldDefinition_p, iOp_p, oInitialAndDefaultValue_p, iAttributes_p, strUniqueName_p, strInstruction_p, wildcarddefinitions_p);
    }

    protected OwSearchNode createSearchNode(OwFieldDefinition fieldDefinition_p, int iOp_p, Object oInitialAndDefaultValue_p, int iAttributes_p, String strUniqueName_p, String strInstruction_p, Collection wildcarddefinitions_p, Object minValue_p, Object maxValue_p, Object defaultValue_p, String sJavaClassName_p) throws Exception {
        return new OwSearchNode(fieldDefinition_p, iOp_p, oInitialAndDefaultValue_p, iAttributes_p, strUniqueName_p, strInstruction_p, wildcarddefinitions_p, minValue_p, maxValue_p, defaultValue_p, sJavaClassName_p);
    }

    @Override
    public void deleteSavedSearch(String name_p) throws Exception {
        OwNetwork network = ((OwMainAppContext)this.getContext()).getNetwork();
        String userId = network.getCredentials().getUserInfo().getUserID();
        OwAttributeBagWriteable attrBag = (OwAttributeBagWriteable)network.getApplicationObject(7, this.m_strName, userId, true, false);
        Collection names = attrBag.getAttributeNames();
        if (name_p != null && names.contains(name_p)) {
            attrBag.remove(name_p);
            attrBag.save();
        }
        this.m_savedSearch = null;
    }

    @Override
    public Collection getColumnInfoList() throws OwObjectNotFoundException, OwConfigurationException {
        if (this.m_ColumnInfoList == null) {
            if (null == this.m_ColumnInfoNode) {
                return new ArrayList();
            }
            try {
                this.m_ColumnInfoList = this.createColumnInfo(this.m_ColumnInfoNode);
            }
            catch (OwObjectNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)("Error found in the search template = " + this.getName()), (Throwable)e);
                throw new OwConfigurationException(OwString.localize1(this.m_local, "server.ecm.OwStandardSearchTemplate.ErrorInSearchtemplate", "Error found in search template: %1", this.getName()), (Throwable)e);
            }
        }
        return this.m_ColumnInfoList;
    }

    protected OwNetworkContext getContext() {
        return this.m_context;
    }

    @Override
    public int getDefaultMaxSize() {
        return this.m_iDefaultMaxSize;
    }

    @Override
    public String getDisplayName(Locale locale_p) {
        return OwString.localizeLabel(locale_p, this.getName());
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        if (this.m_fieldProvider == null) {
            this.m_fieldProvider = this.getSearch(false).getFieldProvider();
        }
        return this.m_fieldProvider.getField(strFieldClassName_p);
    }

    protected OwFieldDefinition getFieldDefinitionProviderField(String strFieldDefinitionName_p, String strResourceName_p) throws OwObjectNotFoundException, Exception {
        return this.m_fieldDefinitionProvider.getFieldDefinition(strFieldDefinitionName_p, strResourceName_p);
    }

    @Override
    public String getFieldProviderName() {
        return this.getName();
    }

    @Override
    public Object getFieldProviderSource() {
        return this;
    }

    @Override
    public int getFieldProviderType() {
        return 2;
    }

    @Override
    public Collection getFields() throws Exception {
        return this.getSearch(false).getCriteriaList(3);
    }

    @Override
    public String getHtmlLayout() {
        return this.m_strHtmlLayout;
    }

    @Override
    public String getIcon() {
        return null;
    }

    private Object getInitialAndDefaultValueFromNode(Node defaultValueNode_p, OwFieldDefinition propClass_p, int iOP_p) throws Exception {
        Object[] initialanddefaultvalue = null;
        if (defaultValueNode_p != null) {
            if (OwSearchOperator.isCriteriaOperatorRange(iOP_p)) {
                Object[] defaultvalues = new Object[2];
                for (Node nDefaultValue = defaultValueNode_p.getFirstChild(); nDefaultValue != null; nDefaultValue = nDefaultValue.getNextSibling()) {
                    if (nDefaultValue.getNodeName().equals(ATTRIBUTE_LITERAL_RANGE_1)) {
                        defaultvalues[0] = this.resolveLiteralValue(this.getName(), propClass_p, nDefaultValue.getFirstChild());
                    }
                    if (!nDefaultValue.getNodeName().equals(ATTRIBUTE_LITERAL_RANGE_2)) continue;
                    defaultvalues[1] = this.resolveLiteralValue(this.getName(), propClass_p, nDefaultValue.getFirstChild());
                }
                initialanddefaultvalue = defaultvalues;
            } else {
                initialanddefaultvalue = this.resolveLiteralValue(this.getName(), propClass_p, defaultValueNode_p.getFirstChild());
            }
        }
        return initialanddefaultvalue;
    }

    @Override
    public String getJspLayoutPage() {
        return this.m_strJspLayoutPage;
    }

    @Override
    public String getName() {
        return this.m_strName;
    }

    private int getObjectTypeFromClassName(String strClassName_p) {
        if (strClassName_p != null) {
            if (strClassName_p.equals(DOCUMENT_TYPE)) {
                return 4097;
            }
            if (strClassName_p.equals(FOLDER_TYPE)) {
                return 8193;
            }
            if (strClassName_p.equals(CUSTOMOBJECT_TYPE)) {
                return 12289;
            }
        }
        return 0;
    }

    protected Map getOnTheFlyClassDescriptions() {
        if (this.m_OnTheFlyClassDescriptions == null) {
            this.m_OnTheFlyClassDescriptions = new HashMap();
        }
        return this.m_OnTheFlyClassDescriptions;
    }

    @Override
    public OwPriorityRule getPriorityRule() {
        return null;
    }

    protected OwFieldDefinition getPropertyClassInternal(String strClassName_p, OwXMLUtil node_p) throws Exception {
        String strJavaClassName = node_p.getSafeStringAttributeValue("datatype", null);
        if (strJavaClassName != null) {
            OwFieldDefinition propClass = null;
            propClass = (OwFieldDefinition)this.getOnTheFlyClassDescriptions().get(strClassName_p);
            if (propClass == null) {
                String strDisplayName = node_p.getSafeStringAttributeValue(NAME_ATTR_NAME, null);
                if (strDisplayName != null) {
                    propClass = new OwOnTheFlySearchFieldDescription(strClassName_p, new OwString(strClassName_p, strDisplayName, true), strJavaClassName);
                    this.getOnTheFlyClassDescriptions().put(strClassName_p, propClass);
                } else {
                    String msg = "OwStandardSearchTemplate.getPropertyClassInternal: Error in searchtemplate = " + this.getName() + ", on the fly property could not be resolved. Please specify datatype and name for property = " + strClassName_p;
                    LOG.error((Object)msg);
                    throw new OwObjectNotFoundException(OwString.localize2(this.m_local, "server.ecm.OwStandardSearchTemplate.UndefinedField", "Error in searchtemplate '%1': could not resolve property '%2'", this.getName(), strClassName_p));
                }
            }
            return propClass;
        }
        OwFieldDefinition fieldDef = null;
        if (null != this.m_resourceNames) {
            Iterator it = this.m_resourceNames.iterator();
            while (fieldDef == null && it.hasNext()) {
                try {
                    fieldDef = this.getFieldDefinitionProviderField(strClassName_p, (String)it.next());
                }
                catch (OwObjectNotFoundException e) {}
            }
        } else {
            fieldDef = this.getFieldDefinitionProviderField(strClassName_p, null);
        }
        if (fieldDef == null) {
            LOG.error((Object)("OwStandardSearchTemplate.getPropertyClassInternal: Searchtemplate = " + this.getName() + ", could not resolve property = " + strClassName_p));
            throw new OwObjectNotFoundException(OwString.localize2(this.m_local, "server.ecm.OwStandardSearchTemplate.UndefinedField", "Error in searchtemplate '%1': could not resolve property '%2'", this.getName(), strClassName_p));
        }
        OwXMLUtil propdescNode = node_p.getSubUtil(ELEMENT_PROPDESC);
        if (propdescNode != null) {
            String hasChoices = propdescNode.getSafeStringAttributeValue(ATTRIBUTE_HASCHOICES, null);
            String choiceId = propdescNode.getSafeStringAttributeValue(ATTRIBUTE_CHOICEID, null);
            if (hasChoices != null && choiceId != null && hasChoices.equalsIgnoreCase("true")) {
                OwNetwork network = null;
                try {
                    network = (OwNetwork)this.m_fieldDefinitionProvider;
                }
                catch (ClassCastException cce) {
                    LOG.error((Object)("OwStandardSearchTemplate.getPropertyClassInternal: Searchtemplate = " + this.getName() + ", property = " + strClassName_p + ", can not cast the field definition provider to an OwNetwork to retrieve the choice list..."), (Throwable)cce);
                    throw new OwObjectNotFoundException(OwString.localize2(this.m_local, "server.ecm.OwStandardSearchTemplate.UndefinedField", "Error in searchtemplate '%1': could not resolve property '%2'", this.getName(), strClassName_p), (Throwable)cce);
                }
                OwEnumCollection newEnumCollection = null;
                try {
                    newEnumCollection = (OwEnumCollection)network.getApplicationObject(8, choiceId, false, false);
                }
                catch (Exception e) {
                    LOG.error((Object)("OwStandardSearchTemplate.getPropertyClassInternal: Searchtemplate = " + this.getName() + ", property = " + strClassName_p + ", can not read the enum collection, choiceId = '" + choiceId + "' from the network..."), (Throwable)e);
                    throw new OwObjectNotFoundException(OwString.localize3(this.m_local, "server.ecm.OwStandardSearchTemplate.UndefinedChoiceList", "Error in searchtemplate \"%1\": cannot read the enum collection with ID '%2' for property '%3'", this.getName(), choiceId, strClassName_p), (Throwable)e);
                }
                fieldDef = new OwFieldDefinitionEnumExchangeWrapper(fieldDef, newEnumCollection);
            }
        }
        return fieldDef;
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = this.getField(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public String getSavedSearch() throws Exception {
        return this.m_savedSearch;
    }

    @Override
    public Collection getSavedSearches() throws Exception {
        String userId;
        OwNetwork network = ((OwMainAppContext)this.getContext()).getNetwork();
        OwAttributeBagWriteable attrBag = (OwAttributeBagWriteable)network.getApplicationObject(7, this.m_strName, userId = network.getCredentials().getUserInfo().getUserID(), true, false);
        LinkedList result = attrBag.getAttributeNames();
        if (result != null) {
            result = new LinkedList(result);
            Collections.sort(result);
        }
        return result;
    }

    @Override
    public OwSearchNode getSearch(boolean fRefresh_p) throws Exception {
        if (this.m_cashedSearch == null || fRefresh_p) {
            try {
                this.m_cashedSearch = (OwSearchNode)this.m_Search.clone();
                this.m_fieldProvider = null;
            }
            catch (Exception e) {
                LOG.error((Object)"OwStandardSearchTemplate.getSearch: Search execution error.", (Throwable)e);
                throw new OwInvalidOperationException(OwString.localize(this.m_local, "server.ecm.OwStandardSearchTemplate.searchExecutionError", "Search execution error."), (Throwable)e);
            }
        }
        return this.m_cashedSearch;
    }

    protected int getSearchAttributeFromNode(Node node_p, int iDefaultEditAttribute_p) throws OwConfigurationException {
        int iRet = 0;
        String sEditAttribute = OwXMLDOMUtil.getSafeStringAttributeValue(node_p, ATTRIBUTE_EDIT_MODE, null);
        if (sEditAttribute == null) {
            sEditAttribute = OwXMLDOMUtil.getSafeStringAttributeValue(node_p, ATTRIBUTE_VIEW_MODE, "");
        }
        iRet = sEditAttribute.equals(ATTRIBUTE_EDIT_MODE_EDITABLE) ? (iRet |= 0) : (sEditAttribute.equals(ATTRIBUTE_EDIT_MODE_READONLY) ? (iRet |= 2) : (sEditAttribute.equals(ATTRIBUTE_EDIT_MODE_HIDDEN) ? (iRet |= 3) : (sEditAttribute.equals(ATTRIBUTE_EDIT_MODE_REQUIRED) ? (iRet |= 4) : (iRet |= iDefaultEditAttribute_p))));
        String sDateModeAttriute = OwXMLDOMUtil.getSafeStringAttributeValue(node_p, ATTRIBUTE_DATE_MODE, ATTRIBUTE_DATE_MODE_IGNORE_TIME);
        if (sDateModeAttriute.equals(ATTRIBUTE_DATE_MODE_IGNORE_TIME)) {
            iRet |= 0x10;
        } else if (sDateModeAttriute.equals(ATTRIBUTE_DATE_MODE_IGNORE_DATE)) {
            iRet |= 0x20;
        } else if (!sDateModeAttriute.endsWith(ATTRIBUTE_DATE_MODE_USE_TIME)) {
            StringBuilder msg = new StringBuilder();
            msg.append("OwStandardSearchTemplate.getSearchAttributeFromNode: Undefined date mode = ");
            msg.append(sDateModeAttriute);
            msg.append(", please define correct ");
            msg.append(ATTRIBUTE_DATE_MODE);
            msg.append(" tag. One of: ");
            msg.append(ATTRIBUTE_DATE_MODE_IGNORE_TIME);
            msg.append(", ");
            msg.append(ATTRIBUTE_DATE_MODE_IGNORE_DATE);
            msg.append(", ");
            msg.append(ATTRIBUTE_DATE_MODE_USE_TIME);
            LOG.error((Object)msg.toString());
            throw new OwConfigurationException(OwString.localize2(this.m_local, "server.ecm.OwStandardSearchTemplate.UndefinedDateMode", "Please define a corect '%1'. It must be one of the following: '%2'", ATTRIBUTE_DATE_MODE, "ignoretime, ignoredate, usetime"));
        }
        return iRet;
    }

    @Override
    public OwSort getSort(int iMinSortCriteria_p) {
        if (this.m_ColumnInfoNode == null) {
            return new OwSort(iMinSortCriteria_p, true);
        }
        HashMap<Integer, OwSort.OwSortCriteria> sorts = new HashMap<Integer, OwSort.OwSortCriteria>();
        int iMaxLevel = 0;
        for (Node n = this.m_ColumnInfoNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            String strClassName;
            if (!n.hasAttributes()) continue;
            try {
                strClassName = OwStandardSearchTemplate.getAttributeByName(n, ATTRIBUTE_SYMNAME).getNodeValue();
            }
            catch (OwException confEx) {
                LOG.warn((Object)"OwStandardSearchTemplate.getSort: error during attribute request", (Throwable)confEx);
                continue;
            }
            try {
                Integer sortlevel = Integer.valueOf(n.getAttributes().getNamedItem(ATTRIBUTE_SORTLEVEL).getNodeValue());
                String strSortorder = n.getAttributes().getNamedItem(ATTRIBUTE_SORTORDER).getNodeValue();
                boolean fAsc = strSortorder.equalsIgnoreCase("ascending");
                OwSort.OwSortCriteria crit = new OwSort.OwSortCriteria(strClassName, fAsc);
                if (sortlevel > iMaxLevel) {
                    iMaxLevel = sortlevel;
                }
                if (sortlevel <= 0) continue;
                sorts.put(sortlevel, crit);
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        if (sorts.size() > iMinSortCriteria_p) {
            iMinSortCriteria_p = sorts.size();
        }
        OwSort sort = new OwSort(iMinSortCriteria_p, true);
        for (int i = iMaxLevel; i > 0; --i) {
            OwSort.OwSortCriteria crit = (OwSort.OwSortCriteria)sorts.get(i);
            if (crit == null) continue;
            sort.addCriteria(crit);
        }
        return sort;
    }

    @Override
    public int getVersionSelection() {
        return this.m_iVersionSelection;
    }

    private void getZones(Node node_p, List zones_p) {
        for (Node n = node_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeName().equals("verityzonename")) {
                zones_p.add(n.getFirstChild().getNodeValue());
                continue;
            }
            this.getZones(n, zones_p);
        }
    }

    @Override
    public boolean hasHtmlLayout() {
        return this.m_strHtmlLayout != null;
    }

    @Override
    public boolean hasJspLayoutPage() {
        return this.m_strJspLayoutPage != null;
    }

    @Override
    public void init(OwFieldDefinitionProvider fieldDefinitionProvider_p) throws Exception {
        OwSearchNode newSearchNode;
        this.m_isWrittableAttributeBagAvailable = this.isWrittableAttributeBagAvailable();
        if (this.m_object != null) {
            this.loadXMLTemplateFromObject(this.m_object);
            this.m_object = null;
        }
        this.m_fieldDefinitionProvider = fieldDefinitionProvider_p;
        Node whereSearchNode = null;
        Node cbrNode = null;
        Node fromNodeNode = null;
        Node subClassesNode = null;
        this.parseVersionSelection(OwXMLDOMUtil.getSafeStringAttributeValue(this.m_XMLSearchTemplateNode, "versionselection", null));
        block0: for (Node n = this.m_XMLSearchTemplateNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equalsIgnoreCase("select")) {
                for (Node col = n.getFirstChild(); col != null; col = col.getNextSibling()) {
                    if (!col.getNodeName().equalsIgnoreCase("selectprops")) continue;
                    this.m_ColumnInfoNode = col;
                    continue block0;
                }
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("from")) {
                fromNodeNode = n;
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("subclasses")) {
                subClassesNode = n;
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("where")) {
                whereSearchNode = n;
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("layout")) {
                if (n.getFirstChild() == null) continue;
                this.m_strHtmlLayout = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("jsppage")) {
                if (n.getFirstChild() == null) continue;
                this.m_strJspLayoutPage = n.getFirstChild().getNodeValue();
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("folders")) {
                this.m_folders = n;
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("objectstores")) {
                this.m_objectstores = n;
                continue;
            }
            if (!n.getNodeName().equalsIgnoreCase("veritycontent")) continue;
            cbrNode = n;
        }
        this.m_Search = this.createSearchNode(1, 5);
        OwSearchNode newSpecialSearchNode = null;
        if (this.m_folders != null || this.m_objectstores != null) {
            newSpecialSearchNode = this.createSearchNode(1, 2);
            this.m_Search.add(newSpecialSearchNode);
            this.scanResourceNodeEx(newSpecialSearchNode, this.m_folders, this.m_objectstores);
        }
        if (whereSearchNode != null) {
            newSearchNode = this.createSearchNode(1, 1);
            this.m_Search.add(newSearchNode);
            this.scanSearchNode(whereSearchNode, newSearchNode);
        }
        if (fromNodeNode != null) {
            if (newSpecialSearchNode == null) {
                newSpecialSearchNode = this.createSearchNode(1, 2);
                this.m_Search.add(newSpecialSearchNode);
            }
            this.scanClasses(newSpecialSearchNode, fromNodeNode, subClassesNode);
        }
        if (null != cbrNode) {
            newSearchNode = this.createSearchNode(1, 3);
            this.m_Search.add(newSearchNode);
            this.scanCBRNode(newSearchNode, cbrNode);
        }
        this.m_XMLSearchTemplateNode = null;
        this.m_folders = null;
        this.m_objectstores = null;
    }

    @Override
    public boolean isInitalized() {
        return this.m_Search != null;
    }

    protected boolean isOperator(String strOperator_p) throws OwConfigurationException {
        return OwStandardSearchTemplate.m_SqlOperators.m_OperatorMap.containsKey(strOperator_p);
    }

    private boolean isWrittableAttributeBagAvailable() {
        boolean result = false;
        try {
            OwNetwork network = ((OwMainAppContext)this.getContext()).getNetwork();
            String userId = network.getCredentials().getUserInfo().getUserID();
            OwAttributeBagWriteable attrBag = (OwAttributeBagWriteable)network.getApplicationObject(7, this.m_strName, userId, true, false);
            if (attrBag != null) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void loadXMLTemplateFromObject(OwObject obj_p) throws SAXException, IOException, Exception {
        NodeList searchNodes;
        NodeList objectstores;
        NodeList rootNodes;
        NodeList folders;
        Node foldersNode = null;
        Node objectstoresNode = null;
        Document doc = null;
        try {
            doc = OwXMLDOMUtil.getDocumentFromInputStream(obj_p.getContentCollection().getContentElement(1, 1).getContentStream(null));
        }
        catch (Exception e) {
            String msg = "Exception loading XML Search-Template from Object";
            if (obj_p != null) {
                msg = msg + ", name = " + obj_p.getName();
            }
            LOG.error((Object)msg, (Throwable)e);
            throw e;
        }
        NodeList options = doc.getElementsByTagName("options");
        if (options.getLength() > 0) {
            Node option = options.item(0);
            this.m_iDefaultMaxSize = Integer.parseInt(OwXMLDOMUtil.getSafeStringAttributeValue(option, "maxrecords", "0"));
        }
        if ((folders = doc.getElementsByTagName("folders")).getLength() > 0) {
            foldersNode = folders.item(0);
        }
        if ((rootNodes = doc.getElementsByTagName("searchspec")).getLength() > 0) {
            Node rootNode = rootNodes.item(0);
            this.parseVersionSelection(OwXMLDOMUtil.getSafeStringAttributeValue(rootNode, "versionselection", null));
        }
        if ((objectstores = doc.getElementsByTagName("objectstores")).getLength() > 0) {
            objectstoresNode = objectstores.item(0);
        }
        if ((searchNodes = doc.getElementsByTagName("searchclause")) == null || searchNodes.getLength() == 0) {
            searchNodes = doc.getElementsByTagName("searchclauses");
        }
        if (searchNodes.getLength() <= 0) {
            LOG.error((Object)("OwStandardSearchTemplate.loadXMLTemplateFromObject: Can not load XML from object, searchNodes.getLength()=0, object getName = " + obj_p.getName()));
            throw new OwInvalidOperationException(OwString.localize1(this.m_local, "server.ecm.OwStandardSearchTemplate.cannotLoadXmlFromObject", "Cannot load XML from object with name: '%1'", obj_p.getName()));
        }
        this.m_XMLSearchTemplateNode = searchNodes.item(0);
        this.m_folders = foldersNode;
        this.m_objectstores = objectstoresNode;
        this.scanCustomInfo(doc);
    }

    private void parseVersionSelection(String strVersionSelectionAttribute_p) {
        if (strVersionSelectionAttribute_p == null) {
            return;
        }
        if (strVersionSelectionAttribute_p.equalsIgnoreCase("minorversions")) {
            this.m_iVersionSelection = 6;
            return;
        }
        if (strVersionSelectionAttribute_p.equalsIgnoreCase("majorversions")) {
            this.m_iVersionSelection = 5;
            return;
        }
        if (strVersionSelectionAttribute_p.equalsIgnoreCase("inprocessversion")) {
            this.m_iVersionSelection = 7;
            return;
        }
        if (strVersionSelectionAttribute_p.equalsIgnoreCase("checkedoutversion")) {
            this.m_iVersionSelection = 8;
            return;
        }
        if (strVersionSelectionAttribute_p.equalsIgnoreCase("releasedversion")) {
            this.m_iVersionSelection = 2;
            return;
        }
        if (strVersionSelectionAttribute_p.equalsIgnoreCase("allversions")) {
            this.m_iVersionSelection = 3;
            return;
        }
        if (strVersionSelectionAttribute_p.equalsIgnoreCase("currentversion")) {
            this.m_iVersionSelection = 4;
            return;
        }
        this.m_iVersionSelection = 2;
    }

    protected Object resolveLiteralPlaceholder(String contextname_p, String placeholdername_p) throws Exception {
        return this.getContext().resolveLiteralPlaceholder(contextname_p, placeholdername_p);
    }

    protected Object resolveLiteralValue(String contextname_p, OwFieldDefinition propClass_p, Node literal_p) throws Exception {
        if (literal_p == null) {
            return null;
        }
        String literal = literal_p.getNodeValue();
        if (null == literal) {
            return propClass_p.getValueFromNode(literal_p);
        }
        if (literal.startsWith("\\{")) {
            return propClass_p.getValueFromString(literal.substring(1));
        }
        if (literal.startsWith(LITERAL_PLACEHOLDER_LEFT_DELIMITER) && literal.endsWith(LITERAL_PLACEHOLDER_RIGHT_DELIMITER)) {
            if (OwStandardSearchTemplate.isDocId(literal)) {
                return propClass_p.getValueFromNode(literal_p);
            }
            return this.resolveLiteralPlaceholder(contextname_p, literal.substring(1, literal.length() - 1));
        }
        return propClass_p.getValueFromNode(literal_p);
    }

    @Override
    public void saveSearch(String name_p) throws Exception {
        OwSearchNode currentSearch;
        OwNetwork network = ((OwMainAppContext)this.getContext()).getNetwork();
        String userId = network.getCredentials().getUserInfo().getUserID();
        OwSearchNode owSearchNode = currentSearch = this.m_cashedSearch == null ? this.m_Search : this.m_cashedSearch;
        if (currentSearch != null && name_p != null) {
            SearchNodeXMLSerializer serializer = new SearchNodeXMLSerializer(currentSearch);
            String encodedSearchCriteria = serializer.serializeToString();
            OwAttributeBagWriteable attrBag = (OwAttributeBagWriteable)network.getApplicationObject(7, this.m_strName, userId, true, true);
            attrBag.setAttribute(name_p, encodedSearchCriteria);
            attrBag.save();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Encoded search template:\n" + encodedSearchCriteria + "\n"));
            }
        }
    }

    private void scanCBRNode(OwSearchNode search_p, Node cbrNode_p) throws Exception {
        for (Node n = cbrNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            OwSearchNode newSearchNode;
            if (n.getNodeName().equals("verityitem")) {
                String strLiteral = "";
                for (Node parameter = n.getFirstChild(); parameter != null; parameter = parameter.getNextSibling()) {
                    if (!parameter.getNodeName().equals("usertext") || parameter.getFirstChild() == null) continue;
                    strLiteral = parameter.getFirstChild().getNodeValue();
                }
                ArrayList zones = new ArrayList();
                this.getZones(n, zones);
                OwStandardContentBasedRetrivalObject cbrValue = new OwStandardContentBasedRetrivalObject(strLiteral, zones);
                String strOperator = OwXMLDOMUtil.getSafeStringAttributeValue(n, "groupaction", null);
                if (null == strOperator) {
                    String msg = "OwStandardSearchTemplate.scanCBRNode: CBR Operator not defined, operator = 'groupaction' in searchtemplate = " + this.getName();
                    LOG.error((Object)msg);
                    throw new OwInvalidOperationException(OwString.localize2(this.m_local, "server.ecm.OwStandardSearchTemplate.invalidOperator", "Invalid operator '%1' in search template '%2'", "groupaction", this.getName()));
                }
                int iOP = this.convertOperator("cbr_" + strOperator);
                String strInstruction = OwXMLDOMUtil.getSafeStringAttributeValue(n, ATTRIBUTE_INSTRUCTION, null);
                search_p.add(this.createSearchNode(cbrValue, iOP, this.getSearchAttributeFromNode(n, 0), "OwContentBasedRetrivalObject", strInstruction, null));
            }
            if (n.getNodeName().equals("verityand")) {
                newSearchNode = this.createSearchNode(1, 3);
                search_p.add(newSearchNode);
                this.scanCBRNode(newSearchNode, n);
            }
            if (!n.getNodeName().equals("verityor")) continue;
            newSearchNode = this.createSearchNode(2, 3);
            search_p.add(newSearchNode);
            this.scanCBRNode(newSearchNode, n);
        }
    }

    private void scanClasses(OwSearchNode search_p, Node fromNode_p, Node classesNode_p) throws Exception {
        String strInstruction = null;
        OwStandardClassSelectObject from = OwStandardClassSelectObject.CLASS_FROM.newObject();
        List fromClassNodes = new OwStandardXMLUtil(fromNode_p).getSafeUtilList("class");
        for (OwXMLUtil fromClassNode : fromClassNodes) {
            String symName = fromClassNode.getSafeStringAttributeValue(ATTRIBUTE_SYMNAME, null);
            String objectType = fromClassNode.getSafeStringAttributeValue(ATTRIBUTE_OBJECTTYPE, null);
            int iObjectType = this.getObjectTypeFromClassName(objectType);
            from.addClass(iObjectType, symName, objectType, null, true);
        }
        search_p.add(this.createSearchNode(from, 4, 1, "OwClassFrom", strInstruction, null));
        OwStandardClassSelectObject subclasses = OwStandardClassSelectObject.CLASS_SUBCLASSES.newObject();
        OwStandardClassSelectObject classes = OwStandardClassSelectObject.CLASS_CLASS_NAME.newObject();
        int hiddenClassesFlag = 1;
        if (classesNode_p != null) {
            OwStandardXMLUtil classesNodeWrapper = new OwStandardXMLUtil(classesNode_p);
            List subClasses = classesNodeWrapper.getSafeNodeList();
            strInstruction = classesNodeWrapper.getSafeStringAttributeValue(ATTRIBUTE_INSTRUCTION, null);
            if (subClasses.size() > 0) {
                for (int i = 0; i < subClasses.size(); ++i) {
                    Node subclass = (Node)subClasses.get(i);
                    int hiddenClass = this.getSearchAttributeFromNode(subclass, 1);
                    hiddenClassesFlag &= hiddenClass;
                    String strBaseClaseName = OwStandardSearchTemplate.getAttributeByName(subclass, ATTRIBUTE_OBJECTTYPE).getNodeValue();
                    String strClassName = OwStandardSearchTemplate.getAttributeByName(subclass, ATTRIBUTE_SYMNAME).getNodeValue();
                    boolean includesubclasses = OwXMLDOMUtil.getSafeBooleanAttributeValue(subclass, ATTRIBUTE_INCLUDESUBCLASSES, false);
                    int iObjectType = this.getObjectTypeFromClassName(strBaseClaseName);
                    classes.addClass(iObjectType, strClassName, strBaseClaseName, null, includesubclasses);
                    subclasses.addClass(iObjectType, strClassName, strBaseClaseName, null, includesubclasses);
                }
                String maxvalue = classesNodeWrapper.getSafeStringAttributeValue(ATTRIBUTE_MAX_VALUE, null);
                String minvalue = classesNodeWrapper.getSafeStringAttributeValue(ATTRIBUTE_MIN_VALUE, null);
                search_p.add(this.createSubclassNode(classes.getFieldDefinition(), 4, classes.getValue(), hiddenClassesFlag, "OwClassSelectObject", strInstruction, null, minvalue, maxvalue, null, null));
                search_p.add(this.createSubclassNode(subclasses.getFieldDefinition(), 4, classes.getValue(), hiddenClassesFlag, "OwClassSubclasses", strInstruction, null, minvalue, maxvalue, null, null));
                return;
            }
        }
        search_p.add(this.createSearchNode(subclasses, 4, 1, "OwClassSubclasses", strInstruction, null));
        Node nodeClass = new OwStandardXMLUtil(fromNode_p).getSubNode("class");
        if (nodeClass == null) {
            throw new OwConfigurationException("OwStandardSearchTemplate.scanClass: failed, no \"class\" subnode could be found");
        }
        String strBaseClassName = OwStandardSearchTemplate.getAttributeByName(nodeClass, ATTRIBUTE_SYMNAME).getNodeValue();
        int iObjectType = this.getObjectTypeFromClassName(strBaseClassName);
        classes.addClass(iObjectType, strBaseClassName, strBaseClassName, null, true);
        search_p.add(this.createSearchNode(classes, 4, hiddenClassesFlag, "OwClassSelectObject", strInstruction, null));
    }

    protected OwSearchNode createSubclassNode(OwFieldDefinition fieldDefinition_p, int iOp_p, Object oInitialAndDefaultValue_p, int iAttributes_p, String strUniqueName_p, String strInstruction_p, Collection wildcarddefinitions_p, Object minValue_p, Object maxValue_p, Object defaultValue_p, String sJavaClassName_p) throws Exception {
        if (OwStandardClassSelectObject.CLASS_SUBCLASSES.getClassName().equals(fieldDefinition_p.getClassName())) {
            iAttributes_p = 1;
        }
        return this.createSearchNode(fieldDefinition_p, iOp_p, oInitialAndDefaultValue_p, iAttributes_p, strUniqueName_p, strInstruction_p, wildcarddefinitions_p, minValue_p, maxValue_p, defaultValue_p, sJavaClassName_p);
    }

    protected void scanCustomInfo(Node searchTemplateNode_p) {
    }

    protected void scanResourceNodeEx(OwSearchNode search_p, Node foldersNode_p, Node objectstoresNode_p) throws Exception {
        String name;
        HashMap<String, OwSearchObjectStore> osByIds = new HashMap<String, OwSearchObjectStore>();
        HashMap<String, OwSearchObjectStore> osByNames = new HashMap<String, OwSearchObjectStore>();
        String pathNodeName = "searchPath";
        int mergeOperator = 1025;
        if (objectstoresNode_p != null) {
            String strMergeOption = OwXMLDOMUtil.getSafeStringAttributeValue(objectstoresNode_p, "mergeoption", "");
            if (strMergeOption.equals("union")) {
                mergeOperator = 1026;
            }
            if (strMergeOption.equals("intersection")) {
                mergeOperator = 1027;
            }
            for (Node n = objectstoresNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals("objectstore")) continue;
                String objectStoreId = OwXMLDOMUtil.getSafeStringAttributeValue(n, "id", null);
                String objectStoreName = OwXMLDOMUtil.getSafeStringAttributeValue(n, NAME_ATTR_NAME, null);
                OwSearchObjectStore objectStore = new OwSearchObjectStore(objectStoreId, objectStoreName);
                if (objectStoreId != null) {
                    osByIds.put(objectStoreId, objectStore);
                }
                if (objectStoreName == null) continue;
                osByNames.put(objectStoreName, objectStore);
            }
        }
        LinkedList<OwSearchObjectStore> pathDefinedStores = new LinkedList<OwSearchObjectStore>();
        String defaultInstruction = OwString.localize(this.m_local, "ecm.OwStandardSearchTemplate.resourcepathinstr", "File path with object store, .../* also browses subfolders.");
        if (foldersNode_p != null) {
            for (Node n = foldersNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals(FOLDER_TYPE)) continue;
                int attributes = this.getSearchAttributeFromNode(n, 1);
                String instruction = OwXMLDOMUtil.getSafeStringAttributeValue(n, ATTRIBUTE_INSTRUCTION, null);
                if (null == instruction) {
                    instruction = defaultInstruction;
                }
                String objectStoreId = null;
                String objectStoreName = null;
                for (Node objectStoreNode = n.getFirstChild(); objectStoreNode != null; objectStoreNode = objectStoreNode.getNextSibling()) {
                    if (n.getNodeType() == 1 && !objectStoreNode.getNodeName().equals("objectstore")) continue;
                    objectStoreId = OwXMLDOMUtil.getSafeStringAttributeValue(objectStoreNode, "id", null);
                    objectStoreName = OwXMLDOMUtil.getSafeStringAttributeValue(objectStoreNode, NAME_ATTR_NAME, null);
                    break;
                }
                OwSearchObjectStore objectStore = new OwSearchObjectStore(objectStoreId, objectStoreName);
                if (objectStoreId != null) {
                    OwSearchObjectStore osById = (OwSearchObjectStore)osByIds.get(objectStoreId);
                    if (osById != null) {
                        objectStore = osById.unify(objectStore);
                        osByIds.put(objectStoreId, objectStore);
                    } else {
                        osByIds.put(objectStoreId, objectStore);
                    }
                }
                if ((objectStoreName = objectStore.getName()) != null) {
                    OwSearchObjectStore osByName = (OwSearchObjectStore)osByNames.get(objectStoreName);
                    if (osByName != null) {
                        if ((objectStore = osByName.unify(objectStore)).getId() != null) {
                            osByIds.put(objectStore.getId(), objectStore);
                        }
                        osByNames.put(objectStoreName, objectStore);
                    } else {
                        osByNames.put(objectStoreName, objectStore);
                    }
                }
                pathDefinedStores.add(objectStore);
                String pathName = OwXMLDOMUtil.getSafeStringAttributeValue(n, "pathname", null);
                String pathId = null;
                boolean searchSubfolders = OwXMLDOMUtil.getSafeBooleanAttributeValue(n, "searchsubfolders", false);
                OwSearchPath searchPath = new OwSearchPath(pathId, pathName, searchSubfolders, objectStore);
                OwSearchPathField field = new OwSearchPathField(searchPath);
                search_p.add(this.createSearchNode(field.getFieldDefinition(), mergeOperator, searchPath, attributes, "searchPath", instruction, null));
            }
        }
        this.m_resourceNames = new LinkedList();
        for (OwSearchObjectStore pathStore : pathDefinedStores) {
            String id = pathStore.getId();
            name = pathStore.getName();
            if (name == null) {
                String msg = "All objectstores must have names ! Found objecstore with id=" + id + " that has no name!";
                LOG.error((Object)("OwStandardSearchTemplate.scanResourceNodeEx() : " + msg + ".The current OwStandardSearchTemplate implementation does not support nameless objectstores!"));
                throw new OwInvalidOperationException(msg);
            }
            this.m_resourceNames.add(name);
            if (id != null) {
                osByIds.remove(id);
            }
            if (name == null) continue;
            osByNames.remove(name);
        }
        LinkedList objectStoreRootPaths = new LinkedList();
        objectStoreRootPaths.addAll(osByIds.values());
        for (OwSearchObjectStore store : objectStoreRootPaths) {
            name = store.getName();
            if (name == null) continue;
            osByNames.remove(name);
        }
        objectStoreRootPaths.addAll(osByNames.values());
        for (OwSearchObjectStore store : objectStoreRootPaths) {
            OwSearchPath osReference = new OwSearchPath(store);
            String name2 = store.getName();
            if (name2 == null) {
                String msg = "All objectstores must have names ! Found objecstore with id=" + store.getId() + " that has no name!";
                LOG.error((Object)("OwStandardSearchTemplate.scanResourceNodeEx() : " + msg + ".The current OwStandardSearchTemplate implementation does not support nameless objectstores!"));
                throw new OwInvalidOperationException(msg);
            }
            this.m_resourceNames.add(name2);
            OwSearchPathField field = new OwSearchPathField(osReference);
            search_p.add(this.createSearchNode(field.getFieldDefinition(), mergeOperator, osReference, 1, "searchPath", defaultInstruction, null));
        }
    }

    private void scanSearchNode(Node searchDOMNode_p, OwSearchNode search_p) throws Exception {
        for (Node n = searchDOMNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            OwSearchNode newSearchNode;
            if (n.getNodeType() != 1) continue;
            if (n.getNodeName().equalsIgnoreCase("and")) {
                newSearchNode = this.createSearchNode(1, 1);
                search_p.add(newSearchNode);
                this.scanSearchNode(n, newSearchNode);
                continue;
            }
            if (n.getNodeName().equalsIgnoreCase("or")) {
                newSearchNode = this.createSearchNode(2, 1);
                search_p.add(newSearchNode);
                this.scanSearchNode(n, newSearchNode);
                continue;
            }
            String strOperator = n.getNodeName();
            int iOP = this.convertOperator(strOperator);
            OwXMLUtil criteriaNode = null;
            Node defaultValueNode = null;
            for (Node node = n.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                if (node.getNodeName().equalsIgnoreCase(ELEMENT_WHEREPROP)) {
                    criteriaNode = new OwStandardXMLUtil(node);
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase(ELEMENT_LITERAL) || !node.hasChildNodes()) continue;
                defaultValueNode = node;
            }
            String strClassName = criteriaNode.getSafeStringAttributeValue(ATTRIBUTE_SYMNAME, null);
            String strUniqueName = criteriaNode.getSafeStringAttributeValue(ATTRIBUTE_UNIQUENAME, strClassName);
            boolean fAllowWildCard = criteriaNode.getSafeBooleanAttributeValue(ATTRIBUTE_ALLOWWILDCARD, false);
            String strInstruction = criteriaNode.getSafeStringAttributeValue(ATTRIBUTE_INSTRUCTION, null);
            int iAttributes = this.getSearchAttributeFromNode(criteriaNode.getNode(), 0);
            String sOverrideDatatype = criteriaNode.getSafeStringAttributeValue(ATTRIBUTE_OVERRIDE_DATATYPE, null);
            OwFieldDefinition PropClass = this.getPropertyClassInternal(strClassName, criteriaNode);
            if (PropClass != null) {
                Object initialanddefaultvalue = this.getInitialAndDefaultValueFromNode(defaultValueNode, PropClass, iOP);
                if (fAllowWildCard) {
                    iAttributes += 8;
                }
                if (null == sOverrideDatatype) {
                    search_p.add(this.createSearchNode(PropClass, iOP, initialanddefaultvalue, iAttributes, strUniqueName, strInstruction, this.m_fieldDefinitionProvider.getWildCardDefinitions(PropClass.getClassName(), null, iOP)));
                    continue;
                }
                search_p.add(this.createSearchNode(PropClass, iOP, initialanddefaultvalue, iAttributes, strUniqueName, strInstruction, this.m_fieldDefinitionProvider.getWildCardDefinitions(PropClass.getClassName(), null, iOP), PropClass.getMinValue(), PropClass.getMaxValue(), PropClass.getDefaultValue(), sOverrideDatatype));
                continue;
            }
            LOG.error((Object)("OwStandardSearchTemplate.scanSearchNode: Search Template parser error, undefined criteria property = " + strClassName));
            throw new OwInvalidOperationException(OwString.localize1(this.m_local, "server.ecm.OwStandardSearchTemplate.UndefinedCriteriaProperty", "Search Template parser error, undefined criteria property: %1", strClassName));
        }
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        this.getField(sName_p).setValue(value_p);
    }

    @Override
    public void setSavedSearch(String name_p) throws Exception {
        this.m_savedSearch = name_p;
        if (this.m_savedSearch != null) {
            OwNetwork network = ((OwMainAppContext)this.getContext()).getNetwork();
            String userId = network.getCredentials().getUserInfo().getUserID();
            OwSearchNode currentSearch = this.getSearch(true);
            if (currentSearch != null) {
                OwAttributeBagWriteable attrBag = (OwAttributeBagWriteable)network.getApplicationObject(7, this.m_strName, userId, true, false);
                String attributeValue = (String)attrBag.getAttribute(name_p);
                SearchNodeXMLDeserializer deserializer = new SearchNodeXMLDeserializer(attributeValue);
                deserializer.deserialize(currentSearch);
            }
        }
    }

    public static class SqlOperatorSingleton {
        Map m_OperatorMap = new HashMap();

        public SqlOperatorSingleton() {
            this.m_OperatorMap.put("eq", 4);
            this.m_OperatorMap.put("noteq", 5);
            this.m_OperatorMap.put("neq", 5);
            this.m_OperatorMap.put("like", 6);
            this.m_OperatorMap.put("notlike", 7);
            this.m_OperatorMap.put("gt", 8);
            this.m_OperatorMap.put("lt", 10);
            this.m_OperatorMap.put("gte", 12);
            this.m_OperatorMap.put("lte", 14);
            this.m_OperatorMap.put("isnotnull", 17);
            this.m_OperatorMap.put("isnull", 16);
            this.m_OperatorMap.put("isin", 274);
            this.m_OperatorMap.put("isnotin", 275);
            this.m_OperatorMap.put("in", 276);
            this.m_OperatorMap.put("notin", 277);
            this.m_OperatorMap.put("between", 530);
            this.m_OperatorMap.put("notbetween", 531);
            this.m_OperatorMap.put("cbr_none", 770);
            this.m_OperatorMap.put("cbr_all", 772);
            this.m_OperatorMap.put("cbr_any", 774);
            this.m_OperatorMap.put("cbr_in", 776);
            this.m_OperatorMap.put("cbr_zone", 778);
            this.m_OperatorMap.put("cbr_near", 780);
            this.m_OperatorMap.put("cbr_paragraph", 782);
            this.m_OperatorMap.put("cbr_sentence", 784);
            this.m_OperatorMap.put("cbr_vql", 786);
        }
    }

    public class SearchNodeXMLSerializer {
        private Document m_document;
        private OwSearchNode m_searchNode;

        public SearchNodeXMLSerializer(OwSearchNode searchNode_p) {
            this.m_searchNode = searchNode_p;
        }

        private void appendCriterion(Element element_p, OwSearchNode node_p) throws Exception {
            block4: {
                block2: {
                    Element theNewElement;
                    OwSearchCriteria criteria;
                    block3: {
                        if (!node_p.isCriteriaNode()) break block2;
                        criteria = node_p.getCriteria();
                        theNewElement = this.m_document.createElement(OwStandardSearchTemplate.CRITERION_ELEMENT_NAME);
                        element_p.appendChild(theNewElement);
                        theNewElement.setAttribute(OwStandardSearchTemplate.NAME_ATTR_NAME, criteria.getUniqueName());
                        if (criteria.isHidden() || criteria.isReadonly()) break block3;
                        this.encodeValue(theNewElement, criteria);
                        if (criteria.isCriteriaOperatorRange()) {
                            this.encodeSecondRangeCriteria(criteria, theNewElement);
                        }
                        break block4;
                    }
                    if (!criteria.isCriteriaOperatorRange()) break block4;
                    this.encodeSecondRangeCriteria(criteria, theNewElement);
                    break block4;
                }
                Element criteriaGroup = this.m_document.createElement(OwStandardSearchTemplate.CRITERIA_GROUP_ELEMENT_NAME);
                element_p.appendChild(criteriaGroup);
                Iterator it = node_p.getChilds().iterator();
                while (it.hasNext()) {
                    this.appendCriterion(criteriaGroup, (OwSearchNode)it.next());
                }
            }
        }

        private void encodeSecondRangeCriteria(OwSearchCriteria criteria_p, Element theNewElement_p) throws Exception {
            OwSearchCriteria secondRangeCriteria = criteria_p.getSecondRangeCriteria();
            if (secondRangeCriteria != null) {
                Element secondCriterionElement = this.m_document.createElement(OwStandardSearchTemplate.SECOND_CRITERION_ELEMENT_NAME);
                theNewElement_p.appendChild(secondCriterionElement);
                if (!criteria_p.isHidden() && !criteria_p.isReadonly()) {
                    this.encodeValue(secondCriterionElement, secondRangeCriteria);
                }
            }
        }

        private String encodeSimpleCriteriaValue(OwSearchCriteria criteria_p, Object value_p) throws Exception {
            StringBuilder encodedValue = new StringBuilder();
            if (value_p != null) {
                try {
                    Class<?> javaClass = Class.forName(criteria_p.getJavaClassName());
                    if (OwObject.class.isAssignableFrom(javaClass)) {
                        OwObject objectValue = (OwObject)value_p;
                        encodedValue.append(objectValue.getDMSID());
                    } else if (OwClass.class.isAssignableFrom(javaClass)) {
                        OwClass classValue = (OwClass)value_p;
                        encodedValue.append(classValue.getObjectType()).append("|").append(classValue.getClassName()).append("|").append(classValue.getBaseClassName()).append("|").append(classValue.getResourceName()).append("|").append(classValue.isEnabled()).append("|").append(classValue.isIncludeSubclasses());
                    } else if (criteria_p.isDateType()) {
                        Date dateValue = (Date)value_p;
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'Z");
                        encodedValue.append(formatter.format(dateValue));
                    } else {
                        encodedValue.append(value_p);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.error((Object)("Cannot find the corresponding JavaClass for this criteria " + criteria_p.getUniqueName()), (Throwable)e);
                    }
                    throw new OwObjectNotFoundException(OwStandardSearchTemplate.this.getContext().localize1("", "Cannot find the corresponding JavaClass for this criteria %1", criteria_p.getUniqueName()));
                }
            }
            return encodedValue.toString();
        }

        private void encodeValue(Element criteriaElement_p, OwSearchCriteria criteria_p) throws Exception {
            Object value = criteria_p.getValue();
            if (criteria_p.isArray()) {
                Object[] values = (Object[])value;
                for (int i = 0; i < values.length; ++i) {
                    Element valueElement = this.m_document.createElement(OwStandardSearchTemplate.VALUE_ELEMENT_NAME);
                    Text textNode = this.m_document.createTextNode(this.encodeSimpleCriteriaValue(criteria_p, values[i]));
                    valueElement.appendChild(textNode);
                    criteriaElement_p.appendChild(valueElement);
                }
            } else {
                Element valueElement = this.m_document.createElement(OwStandardSearchTemplate.VALUE_ELEMENT_NAME);
                Text textNode = this.m_document.createTextNode(this.encodeSimpleCriteriaValue(criteria_p, value));
                valueElement.appendChild(textNode);
                criteriaElement_p.appendChild(valueElement);
            }
        }

        public Document serialize() throws Exception {
            this.m_document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = this.m_document.createElement("criteria");
            this.m_document.appendChild(root);
            this.appendCriterion(root, this.m_searchNode);
            return this.m_document;
        }

        public String serializeToString() throws Exception {
            Document doc = this.serialize();
            return OwXMLDOMUtil.toString(doc.getDocumentElement());
        }
    }

    public class SearchNodeXMLDeserializer {
        private Document m_document;

        public SearchNodeXMLDeserializer(String xmlAsString_p) throws Exception {
            try {
                this.m_document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xmlAsString_p)));
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cannot parse serialized xml: \n" + xmlAsString_p), (Throwable)e);
                }
                throw new OwInvalidOperationException(OwStandardSearchTemplate.this.getContext().localize("server.ecm.OwStandardSearchTemplate.serialization.cannotParseXml", "Cannot parse the serialized xml."), (Throwable)e);
            }
        }

        private void decodeCriteria(Element element_p, OwSearchCriteria criteria_p) throws Exception {
            NodeList valueList = element_p.getElementsByTagName(OwStandardSearchTemplate.VALUE_ELEMENT_NAME);
            if (valueList != null) {
                String criteriaClassName = criteria_p.getJavaClassName();
                Class<?> criteriaClass = Class.forName(criteriaClassName);
                if (criteria_p.isArray()) {
                    int size = valueList.getLength();
                    Object array = Array.newInstance(criteriaClass, size);
                    for (int i = 0; i < valueList.getLength(); ++i) {
                        Object value;
                        Node valueNode = valueList.item(i);
                        String valueNodeAsString = null;
                        if (valueNode.hasChildNodes()) {
                            valueNodeAsString = valueNode.getFirstChild().getNodeValue();
                        }
                        ((Object[])array)[i] = value = this.decodeValue(criteriaClass, criteria_p, valueList, valueNodeAsString);
                    }
                    criteria_p.setValue(array);
                } else {
                    Node valueNode = valueList.item(0);
                    String valueNodeAsString = null;
                    if (valueNode.hasChildNodes()) {
                        valueNodeAsString = valueNode.getFirstChild().getNodeValue();
                    }
                    Object value = this.decodeValue(criteriaClass, criteria_p, valueList, valueNodeAsString);
                    criteria_p.setValue(value);
                }
            }
        }

        private void decodeSecondCriteria(Element element_p, OwSearchCriteria criteria_p) throws Exception {
            OwSearchCriteria secondCriteria = criteria_p.getSecondRangeCriteria();
            if (secondCriteria != null && !secondCriteria.isHidden() && !secondCriteria.isReadonly()) {
                NodeList secondCriteriaElements = element_p.getElementsByTagName(OwStandardSearchTemplate.SECOND_CRITERION_ELEMENT_NAME);
                if (secondCriteriaElements.getLength() != 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"OwStandardSearchTemplate$SeachNodeXMLDeserializer.decodeSecondCriteria: Problem reading the second criteria elements");
                    }
                    throw new OwInvalidOperationException(OwStandardSearchTemplate.this.getContext().localize("server.ecm.OwStandardSearchTemplate.serialization.invalidXmlOrSearchNode", "The serialized XML structure doesn't match the search node structure. It's possible to have an old xml."));
                }
                Element secondCriteriaElement = (Element)secondCriteriaElements.item(0);
                this.decodeCriteria(secondCriteriaElement, secondCriteria);
            }
        }

        private Object decodeValue(Class criteriaClass_p, OwSearchCriteria criteria_p, NodeList valueList_p, String valueNodeAsString_p) throws Exception {
            Object result = null;
            if (valueNodeAsString_p != null) {
                if (OwObject.class.isAssignableFrom(criteriaClass_p)) {
                    OwNetwork network = ((OwMainAppContext)OwStandardSearchTemplate.this.getContext()).getNetwork();
                    result = network.getObjectFromDMSID(valueNodeAsString_p, true);
                } else if (OwClass.class.isAssignableFrom(criteriaClass_p)) {
                    StringTokenizer tokenizer = new StringTokenizer(valueNodeAsString_p, "|");
                    if (tokenizer.countTokens() != 6) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"OwStandardSearchTemplate$SeachNodeXMLDeserializer.decodeValue: Cannot deserialize OWClass criteria!");
                        }
                        throw new OwInvalidOperationException(OwStandardSearchTemplate.this.getContext().localize("server.ecm.OwStandardSearchTemplate.serialization.cannotDeserialiseOwClass", "Cannot deserialize OWClass criteria."));
                    }
                    int objectType = -1;
                    String className = "";
                    String baseClassName = "";
                    String resourceName = "";
                    boolean enabled = false;
                    boolean includeSubclasses = false;
                    block14: for (int i = 0; i < OW_CLASS_STRUCTURE.length; ++i) {
                        String token = tokenizer.nextToken();
                        switch (OW_CLASS_STRUCTURE[i]) {
                            case 1: {
                                try {
                                    objectType = Integer.parseInt(token);
                                    continue block14;
                                }
                                catch (Exception e) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"OwStandardSearchTemplate$SeachNodeXMLDeserializer.decodeValue: Cannot deserialize OWClass criteria.", (Throwable)e);
                                    }
                                    throw new OwInvalidOperationException(OwStandardSearchTemplate.this.getContext().localize("server.ecm.OwStandardSearchTemplate.serialization.cannotDeserialiseOwClass", "Cannot deserialize OWClass criteria."), (Throwable)e);
                                }
                            }
                            case 2: {
                                className = token;
                                continue block14;
                            }
                            case 3: {
                                baseClassName = token;
                                continue block14;
                            }
                            case 4: {
                                resourceName = token;
                                continue block14;
                            }
                            case 5: {
                                enabled = Boolean.valueOf(token);
                                continue block14;
                            }
                            case 6: {
                                includeSubclasses = Boolean.valueOf(token);
                                continue block14;
                            }
                        }
                    }
                    result = new OwClass(objectType, className, baseClassName, resourceName, enabled, includeSubclasses);
                } else if (criteria_p.isDateType()) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'Z");
                    Date theDate = df.parse(valueNodeAsString_p);
                    long timestamp = theDate.getTime();
                    if (Date.class.isAssignableFrom(criteriaClass_p)) {
                        try {
                            Constructor constr = criteriaClass_p.getConstructor(Long.TYPE);
                            result = constr.newInstance(timestamp);
                        }
                        catch (Exception e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Cannot create search criteria value from string: " + valueNodeAsString_p), (Throwable)e);
                            }
                            throw new OwInvalidOperationException(OwStandardSearchTemplate.this.getContext().localize("server.ecm.OwStandardSearchTemplate.serialization.cannotCreateValue", "Cannot create the search criteria value."), (Throwable)e);
                        }
                    }
                } else if (Boolean.class.getName().equals(criteriaClass_p.getName())) {
                    result = Boolean.valueOf(valueNodeAsString_p);
                } else {
                    try {
                        Constructor constr = criteriaClass_p.getConstructor(String.class);
                        result = constr.newInstance(valueNodeAsString_p);
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Cannot create search criteria value from string: " + valueNodeAsString_p), (Throwable)e);
                        }
                        throw new OwInvalidOperationException(OwStandardSearchTemplate.this.getContext().localize("server.ecm.OwStandardSearchTemplate.serialization.cannotCreateValue", "Cannot create the search criteria value."), (Throwable)e);
                    }
                }
            }
            return result;
        }

        private void deserialize(Element element_p, OwSearchNode searchNode_p) throws Exception {
            block7: {
                block5: {
                    OwSearchCriteria criteria;
                    block6: {
                        if (!searchNode_p.isCriteriaNode()) break block5;
                        criteria = searchNode_p.getCriteria();
                        if (criteria.isReadonly() || criteria.isHidden()) break block6;
                        this.decodeCriteria(element_p, criteria);
                        if (criteria.isCriteriaOperatorRange()) {
                            this.decodeSecondCriteria(element_p, criteria);
                        }
                        break block7;
                    }
                    if (!criteria.isCriteriaOperatorRange()) break block7;
                    this.decodeSecondCriteria(element_p, criteria);
                    break block7;
                }
                NodeList xmlNodes = element_p.getChildNodes();
                if (xmlNodes.getLength() > 0) {
                    List searchNodes = searchNode_p.getChilds();
                    if (xmlNodes.getLength() != searchNodes.size()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"OwStandardSearchTemplate$SeachNodeXMLDeserializer.deserialize: The serialized XML structure doesn't match the search node structure. It's possible to have an old xml.");
                        }
                        throw new OwInvalidOperationException(OwStandardSearchTemplate.this.getContext().localize("server.ecm.OwStandardSearchTemplate.serialization.invalidXmlOrSearchNode", "The serialized XML structure doesn't match the search node structure. It's possible to have an old xml."));
                    }
                    for (int i = 0; i < searchNodes.size(); ++i) {
                        OwSearchNode searchNode = (OwSearchNode)searchNodes.get(i);
                        this.deserialize((Element)xmlNodes.item(i), searchNode);
                    }
                }
            }
        }

        public void deserialize(OwSearchNode searchNode_p) throws Exception {
            Element rootElement = this.m_document.getDocumentElement();
            this.deserialize((Element)rootElement.getFirstChild(), searchNode_p);
        }
    }

    public class OwOnTheFlySearchFieldDescription
    extends OwStandardPropertyClass {
        public OwOnTheFlySearchFieldDescription(String strClassName_p, OwString displayName_p, String strJavaClassName_p) {
            this.m_strClassName = strClassName_p;
            this.m_DisplayName = displayName_p;
            this.m_strJavaClassName = strJavaClassName_p;
            this.m_fSystem = true;
            this.m_fReadOnly[0] = false;
            this.m_fReadOnly[1] = false;
            this.m_fReadOnly[2] = false;
            this.m_fName = false;
            this.m_fRequired = false;
            this.m_DMSType = null;
        }
    }

    public class OwFieldDefinitionEnumExchangeWrapper
    implements OwFieldDefinition {
        protected OwEnumCollection m_exchangedEnum;
        protected OwFieldDefinition m_fieldDefinition;

        public OwFieldDefinitionEnumExchangeWrapper(OwFieldDefinition fieldDefinition_p, OwEnumCollection exchangedEnum_p) {
            this.m_fieldDefinition = fieldDefinition_p;
            this.m_exchangedEnum = exchangedEnum_p;
        }

        @Override
        public String getClassName() {
            return this.m_fieldDefinition.getClassName();
        }

        @Override
        public List getComplexChildClasses() throws Exception {
            return this.m_fieldDefinition.getComplexChildClasses();
        }

        @Override
        public Object getDefaultValue() throws Exception {
            return this.m_fieldDefinition.getDefaultValue();
        }

        @Override
        public String getDescription(Locale locale_p) {
            return this.m_fieldDefinition.getDescription(locale_p);
        }

        @Override
        public String getDisplayName(Locale locale_p) {
            return this.m_fieldDefinition.getDisplayName(locale_p);
        }

        @Override
        public OwEnumCollection getEnums() throws Exception {
            return this.m_exchangedEnum;
        }

        @Override
        public OwFormat getFormat() {
            return this.m_fieldDefinition.getFormat();
        }

        @Override
        public String getJavaClassName() {
            return this.m_fieldDefinition.getJavaClassName();
        }

        @Override
        public Object getMaxValue() throws Exception {
            return this.m_fieldDefinition.getMaxValue();
        }

        @Override
        public Object getMinValue() throws Exception {
            return this.m_fieldDefinition.getMinValue();
        }

        @Override
        public Object getNativeType() throws Exception {
            return this.m_fieldDefinition.getNativeType();
        }

        @Override
        public Node getNodeFromValue(Object value_p, Document doc_p) throws Exception {
            return this.m_fieldDefinition.getNodeFromValue(value_p, doc_p);
        }

        @Override
        public Collection getOperators() throws Exception {
            return this.m_fieldDefinition.getOperators();
        }

        @Override
        public Object getValueFromNode(Node node_p) throws Exception {
            return this.m_fieldDefinition.getValueFromNode(node_p);
        }

        @Override
        public Object getValueFromString(String text_p) throws Exception {
            return this.m_fieldDefinition.getValueFromString(text_p);
        }

        @Override
        public boolean isArray() throws Exception {
            return this.m_fieldDefinition.isArray();
        }

        @Override
        public boolean isComplex() {
            return this.m_fieldDefinition.isComplex();
        }

        @Override
        public boolean isEnum() throws Exception {
            return true;
        }

        @Override
        public boolean isRequired() throws Exception {
            return this.m_fieldDefinition.isRequired();
        }
    }
}

