/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm;

import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.ecm.OwAttributeBagsSupport;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwString2;
import com.wewebu.ow.server.util.OwTransientBagRepository;
import org.apache.log4j.Logger;

public class OwTransientBagsSupport
implements OwAttributeBagsSupport {
    private static final Logger LOG = OwLogCore.getLogger(OwTransientBagsSupport.class);

    @Override
    public OwAttributeBag getNameKeyAttributeBag(OwNetworkContext networkContext_p, String name_p, String userID_p) throws OwException {
        OwTransientBagRepository bagsRepository = OwTransientBagRepository.getInstance();
        return bagsRepository.getBag(userID_p, name_p);
    }

    @Override
    public OwAttributeBagWriteable getUserKeyAttributeBagWriteable(OwNetworkContext networkContext_p, String name_p, String userID_p) throws OwException {
        try {
            String userID = userID_p;
            if (userID == null) {
                OwBaseUserInfo userInfo = networkContext_p.getCurrentUser();
                userID = userInfo.getUserID();
            }
            OwTransientBagRepository bagsRepository = OwTransientBagRepository.getInstance();
            return bagsRepository.getBag(userID, name_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Could not retrieve user key attribute bag name=" + name_p + "; userID=" + userID_p;
            LOG.error((Object)("OwTransientBagsSupport.getUserKeyAttributeBag:" + msg), (Throwable)e);
            throw new OwInvalidOperationException(new OwString2("ecmimpl.AttributeBagsSupport.getUserKeyAttributeBag.error", "Could not resolve user key bag name=%1;userID=%2", name_p, userID_p), (Throwable)e);
        }
    }

    public String toString() {
        return "OwTransientBagsSupport";
    }
}

