/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecm.eaop;

import com.wewebu.ow.server.ecm.eaop.OwAdvice;
import com.wewebu.ow.server.ecm.eaop.OwAdviser;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwThreadAdviser
implements OwAdviser {
    private static final Logger LOG = OwLogCore.getLogger(OwThreadAdviser.class);
    private static ThreadLocal<OwThreadAdviser> localAdviser = new ThreadLocal();
    private Map<Class, List<Object>> advices = new HashMap<Class, List<Object>>();

    public static OwThreadAdviser currentAdviser() {
        OwThreadAdviser adviser = localAdviser.get();
        if (adviser == null) {
            adviser = new OwThreadAdviser();
            localAdviser.set(adviser);
        }
        return adviser;
    }

    private OwThreadAdviser() {
    }

    private Set<Class<?>> findAdvices(Class<?> class_p) throws OwInvalidOperationException {
        HashSet advisers = new HashSet();
        this.findAdvices(class_p, advisers);
        return advisers;
    }

    private void findAdvices(Class<?> class_p, Set<Class<?>> advices_p) throws OwInvalidOperationException {
        Class<?> superClass;
        OwAdvice advice = class_p.getAnnotation(OwAdvice.class);
        if (advice != null) {
            if (class_p.isInterface()) {
                Method[] methods = class_p.getMethods();
                advices_p.add(class_p);
            } else {
                String msg = "Invalid advice " + class_p.toString() + ". Only interface advices are allowed.";
                LOG.error((Object)msg);
                throw new OwInvalidOperationException(msg);
            }
        }
        if ((superClass = class_p.getSuperclass()) != null) {
            this.findAdvices(superClass, advices_p);
        }
        Class<?>[] interfaces = class_p.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.findAdvices(interfaces[i], advices_p);
        }
    }

    @Override
    public synchronized void add(Object ... advices_p) throws OwInvalidOperationException {
        for (Object advice : advices_p) {
            Class<?> clazz = advice.getClass();
            Set<Class<?>> classAdvices = this.findAdvices(clazz);
            for (Class<?> adviceClass : classAdvices) {
                List<Object> adviceList = this.advices.get(adviceClass);
                if (adviceList == null) {
                    adviceList = new LinkedList<Object>();
                    this.advices.put(adviceClass, adviceList);
                }
                adviceList.add(advice);
            }
        }
    }

    @Override
    public synchronized void remove(Object ... advices_p) throws OwInvalidOperationException {
        for (Object advice : advices_p) {
            Class<?> clazz = advice.getClass();
            Set<Class<?>> classAdvices = this.findAdvices(clazz);
            for (Class<?> adviceClass : classAdvices) {
                List<Object> adviceList = this.advices.get(adviceClass);
                if (adviceList == null) continue;
                adviceList.remove(advice);
            }
        }
    }

    @Override
    public synchronized <A> List<A> get(Class<A> advicerClass_p) throws OwInvalidOperationException {
        return this.advices.get(advicerClass_p);
    }
}

