/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl;

import com.wewebu.ow.server.ao.OwAOProvider;
import com.wewebu.ow.server.ao.OwAOType;
import com.wewebu.ow.server.ao.OwRoleManagedAOType;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.exceptions.OwAccessDeniedException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwString1;
import java.util.LinkedList;
import java.util.List;

public class OwBackwardsCompatibilityAOProvider
implements OwAOProvider {
    private OwNetwork network;
    private OwRoleManager roleManager;

    public OwBackwardsCompatibilityAOProvider(OwNetwork adaptor, OwRoleManager roleManager) {
        this.network = adaptor;
        this.roleManager = roleManager;
    }

    @Override
    public <T> List<T> getApplicationObjects(OwAOType<T> type, String name, boolean forceSpecificObj) throws OwException {
        LinkedList col = null;
        try {
            col = this.network.getApplicationObjects(type.getType(), this.getDefaultLocation(type, name, null), forceSpecificObj);
            if (type instanceof OwRoleManagedAOType) {
                LinkedList allowedCollection = new LinkedList();
                OwRoleManagedAOType roleManagedType = (OwRoleManagedAOType)type;
                for (Object object : col) {
                    if (!roleManagedType.isAllowed(object, this.roleManager)) continue;
                    allowedCollection.add(object);
                }
                col = allowedCollection;
            }
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Unknown Problem during application object retrieval", (Throwable)e);
        }
        return new LinkedList(col);
    }

    @Override
    public <T> T getApplicationObject(OwAOType<T> type, String name, boolean forceSpecificObj, boolean createNonExisting) throws OwException {
        OwRoleManagedAOType roleManagedType;
        Object answer = null;
        try {
            answer = this.network.getApplicationObject(type.getType(), name, forceSpecificObj, createNonExisting);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Unknown Problem during application object retrieval", (Throwable)e);
        }
        Object tAnswer = answer;
        if (type instanceof OwRoleManagedAOType && !(roleManagedType = (OwRoleManagedAOType)type).isAllowed(tAnswer, this.roleManager)) {
            throw new OwAccessDeniedException(new OwString1("app.OwAOProvider.acces.denied", "Access to the application object %1 was denied", name));
        }
        return (T)tAnswer;
    }

    @Override
    public <T> T getApplicationObject(OwAOType<T> aoType, String name, List<Object> params, boolean forceSpecificObj, boolean createNonExisting) throws OwException {
        Object answer = null;
        try {
            answer = this.network.getApplicationObject(aoType.getType(), name, params, forceSpecificObj, createNonExisting);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Unknown Problem during application object retrieval", (Throwable)e);
        }
        return (T)answer;
    }

    protected String getDefaultLocation(OwAOType<?> aoType, String name, List<Object> params) {
        String location = name;
        if (name == null) {
            switch (aoType.getType()) {
                case 3: {
                    location = "owsearchtemplates";
                    break;
                }
                case 1: {
                    location = "other";
                    break;
                }
                default: {
                    location = name;
                }
            }
        }
        return location;
    }
}

