/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExternalScope;
import com.wewebu.expression.language.OwExprObjectProperty;
import com.wewebu.expression.language.OwExprProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.field.OwFieldDefinition;
import java.util.List;

public class OwComplexPropertyChildScope
extends OwExprExternalScope {
    private Object[] values;
    private OwPropertyClass complexPropertyClass;

    public OwComplexPropertyChildScope(String name_p, Object[] values_p, OwPropertyClass complexPropertyClass_p) {
        super(name_p);
        this.values = values_p;
        this.complexPropertyClass = complexPropertyClass_p;
    }

    private int getComplexPropertyIndex(String propertyName_p) throws OwExprEvaluationException {
        try {
            List children = this.complexPropertyClass.getComplexChildClasses();
            int childrenSize = children.size();
            for (int i = 0; i < childrenSize; ++i) {
                OwFieldDefinition child = (OwFieldDefinition)children.get(i);
                String className = child.getClassName();
                if (!className.equals(propertyName_p)) continue;
                return i;
            }
            return -1;
        }
        catch (Exception e) {
            throw new OwExprEvaluationException("Could not get property " + propertyName_p + " from complex property sciope" + this.toString(), (Throwable)e);
        }
    }

    protected OwExprProperty prelevateProperty(String propertyName_p) throws OwExprEvaluationException {
        try {
            int index = this.getComplexPropertyIndex(propertyName_p);
            if (index > -1) {
                List childClasses = this.complexPropertyClass.getComplexChildClasses();
                OwPropertyClass childClass = (OwPropertyClass)childClasses.get(index);
                String javaClass = childClass.getJavaClassName();
                return new OwExprObjectProperty(this.values[index], Class.forName(javaClass));
            }
        }
        catch (Exception e) {
            throw new OwExprEvaluationException("Could not get property " + propertyName_p + " from complex property scope" + this.toString(), (Throwable)e);
        }
        throw new OwExprEvaluationException("Could not get property " + propertyName_p + " from complex property scope" + this.toString());
    }

    public boolean hasProperty(String propertyName_p) throws OwExprEvaluationException {
        return this.getComplexPropertyIndex(propertyName_p) > -1;
    }

    public int length() throws OwExprEvaluationException {
        return super.length();
    }

    public String toString() {
        String className = "<noPropertyClassName>";
        try {
            className = this.complexPropertyClass.getClassName();
        }
        catch (Exception e) {
            className = className + ":" + e.getMessage();
        }
        return super.toString() + " aka complex OwProperty " + className;
    }
}

