/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import com.wewebu.expression.language.OwExprBooleanValue;
import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExpressionType;
import com.wewebu.expression.language.OwExprExternalScope;
import com.wewebu.expression.language.OwExprType;
import com.wewebu.expression.language.OwExprValue;
import com.wewebu.expression.parser.OwExprParser;
import com.wewebu.expression.parser.ParseException;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwObjectScope;
import com.wewebu.ow.server.field.OwPriorityRuleBase;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.util.List;
import org.w3c.dom.Node;

public class OwExpressionPriorityRule
extends OwPriorityRuleBase {
    public static final String NODE_NAME_EXPRESSION = "expression";
    private OwExprExpression m_expression;

    public static OwExpressionPriorityRule newPiorityRule(Node configNode_p, OwFieldDefinitionProvider fieldefinitionprovider_p) throws Exception {
        String scontainer = OwXMLDOMUtil.getSafeStringAttributeValue(configNode_p, "container", null);
        String sResource = OwXMLDOMUtil.getSafeStringAttributeValue(configNode_p, "resource", null);
        OwStandardXMLUtil prionode = new OwStandardXMLUtil(configNode_p);
        String sStyleClass = prionode.getSafeTextValue("styleclass", "owpriostyle");
        List cdataExpressions = prionode.getSafeCDATAList(NODE_NAME_EXPRESSION);
        if (cdataExpressions.isEmpty()) {
            throw new Exception("Invalid Expression Priority rule config : no CDATA expressions found in the expression element !");
        }
        if (cdataExpressions.size() > 1) {
            throw new Exception("Invalid Expression Priority rule config : only one CDATA expression in the expression element supported!");
        }
        String expressionString = (String)cdataExpressions.get(0);
        return new OwExpressionPriorityRule(scontainer, sResource, sStyleClass, expressionString);
    }

    private OwExpressionPriorityRule(String scontainer_p, String sresource_p, String styleClass_p, String expressionString_p) throws Exception {
        super(scontainer_p, sresource_p, styleClass_p);
        try {
            this.m_expression = OwExprParser.parse((String)expressionString_p);
            if (this.m_expression.hasErrors()) {
                throw new OwInvalidOperationException("Could not create WF Lan priority rule for expression  " + expressionString_p + " : " + this.m_expression.getErrorTable());
            }
            OwExprExpressionType expressionType = this.m_expression.type();
            if (!expressionType.canInfer(OwExprType.BOOLEAN)) {
                throw new OwInvalidOperationException("Could not create WF Lan priority rule for non boolean expression  " + expressionString_p);
            }
        }
        catch (ParseException e) {
            throw new OwInvalidOperationException("Could not create WF Lan priority rule for expression : " + expressionString_p, (Throwable)e);
        }
    }

    @Override
    public final boolean appliesTo(OwObject object_p) throws OwInvalidOperationException {
        OwObjectScope objectScope = new OwObjectScope("object", object_p);
        try {
            OwExprExternalScope[] priorityScopes = new OwExprExternalScope[]{objectScope};
            if (this.m_expression.symbolsVisibleInScopes(priorityScopes)) {
                OwExprValue value = this.m_expression.evaluate(priorityScopes);
                return OwExprBooleanValue.TRUE.equals((Object)value);
            }
            return false;
        }
        catch (OwExprEvaluationException e) {
            throw new OwInvalidOperationException("Could not evaluate WFLan expression : " + this.m_expression.toString(), (Throwable)e);
        }
    }

    public String toString() {
        return "PriorityRule : [" + this.m_expression + " => " + this.getStylClass() + "]";
    }
}

