/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwExpressionPriorityRule;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwPriorityRule;
import com.wewebu.ow.server.field.OwStandardPriorityRule;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class OwPriorityRuleFactory {
    private static final String NODE_NAME_PRIORITY_RULES = "PriorityRules";
    private static OwPriorityRuleFactory instance = null;

    public static synchronized OwPriorityRuleFactory getInstance() {
        if (instance == null) {
            instance = new OwPriorityRuleFactory();
        }
        return instance;
    }

    private OwPriorityRuleFactory() {
    }

    public List createRulesList(OwXMLUtil configNode_p, OwFieldDefinitionProvider fieldefinitionprovider_p) throws Exception {
        ArrayList<OwPriorityRule> rulesList = new ArrayList<OwPriorityRule>();
        if (configNode_p.getSubNode(NODE_NAME_PRIORITY_RULES) != null) {
            for (Node n : configNode_p.getSafeNodeList(NODE_NAME_PRIORITY_RULES)) {
                OwPriorityRule rule = this.createRule(n, fieldefinitionprovider_p);
                rulesList.add(rule);
            }
        }
        return rulesList;
    }

    public Map createRulesContainerMap(OwXMLUtil configNode_p, OwFieldDefinitionProvider fieldefinitionprovider_p) throws Exception {
        HashMap<String, ArrayList<OwPriorityRule>> rulesMap = new HashMap<String, ArrayList<OwPriorityRule>>();
        if (configNode_p.getSubNode(NODE_NAME_PRIORITY_RULES) != null) {
            for (Node n : configNode_p.getSafeNodeList(NODE_NAME_PRIORITY_RULES)) {
                OwPriorityRule rule = this.createRule(n, fieldefinitionprovider_p);
                ArrayList<OwPriorityRule> rulelist = (ArrayList<OwPriorityRule>)rulesMap.get(rule.getContainer());
                if (rulelist == null) {
                    rulelist = new ArrayList<OwPriorityRule>();
                    rulesMap.put(rule.getContainer(), rulelist);
                }
                rulelist.add(rule);
            }
        }
        return rulesMap;
    }

    public OwPriorityRule createRule(Node configNode_p, OwFieldDefinitionProvider fieldefinitionprovider_p) throws Exception {
        OwStandardXMLUtil prionode = new OwStandardXMLUtil(configNode_p);
        if (prionode.getSubNode("SearchNode") != null) {
            OwStandardPriorityRule legacyRule = new OwStandardPriorityRule();
            legacyRule.init(configNode_p, fieldefinitionprovider_p);
            return legacyRule;
        }
        if (prionode.getSubNode("expression") != null) {
            return OwExpressionPriorityRule.newPiorityRule(configNode_p, fieldefinitionprovider_p);
        }
        throw new OwInvalidOperationException("Could not create priority rule ! Either SearchNode or expression expected in the configuration XML!");
    }
}

