/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchCriteriaFieldDefOverride;
import com.wewebu.ow.server.fieldimpl.OwSearchNodeFilter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OwSearchNode {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_HIDDEN = 1;
    public static final int FILTER_NONPROPERTY = 2;
    public static final int FILTER_READONLY = 4;
    public static final int NODE_TYPE_PROPERTY = 1;
    public static final int NODE_TYPE_SPECIAL = 2;
    public static final int NODE_TYPE_CBR = 3;
    public static final int NODE_TYPE_CRITERIA = 4;
    public static final int NODE_TYPE_COMBINATION = 5;
    protected int m_iNodeType;
    public static final int SEARCH_OP_UNDEF = 0;
    public static final int SEARCH_OP_AND = 1;
    public static final int SEARCH_OP_OR = 2;
    protected int m_iOp;
    protected OwSearchCriteria m_Criteria;
    protected LinkedList m_Childs;
    protected static final String PERSIST_SEARCH_NODE_NAME = "SN";
    protected static final String PERSIST_UNIQUE_NAME__ATTR_NAME = "un";
    protected static final String PERSIST_OPERATOR_ATTR_NAME = "op";
    protected static final String PERSIST_START_RANGE_NAME = "v1";
    protected static final String PERSIST_END_RANGE_NAME = "v2";

    public void dump(Writer w_p) throws Exception {
        w_p.write("[Combination]        node that may contain any other node<br>");
        w_p.write("[Property]           node that contains only property criteria<br>");
        w_p.write("[CBR]                node that contains only content based library criteria<br>");
        w_p.write("[Special]            node that contains only special criteria<br>");
        w_p.write("[Criteria]           criteria node with no further nodes<br>");
        OwSearchNode.dump(w_p, this, 0, true);
    }

    private static void dumpLevelLine(Writer w_p, int iLevel_p, String strText_p, boolean fHtml_p) throws Exception {
        if (fHtml_p) {
            w_p.write("<br>");
        } else {
            w_p.write("\r\n");
        }
        for (int i = 0; i < iLevel_p; ++i) {
            if (fHtml_p) {
                w_p.write("&nbsp;&nbsp;&nbsp;&nbsp;");
                continue;
            }
            w_p.write("  ");
        }
        w_p.write(strText_p);
    }

    private static String getOperatorDisplayName(Locale locale_p, int iOP_p) {
        switch (iOP_p) {
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
        }
        return "undef";
    }

    private static String getDumpNodeTypeString(int iNodeType_p) {
        switch (iNodeType_p) {
            case 1: {
                return "Property";
            }
            case 2: {
                return "Special";
            }
            case 3: {
                return "CBR";
            }
            case 4: {
                return "Criteria";
            }
            case 5: {
                return "Combination";
            }
        }
        return "undef";
    }

    private static String dumpJavaClassName(String strJCalss_p) {
        return strJCalss_p.substring(strJCalss_p.lastIndexOf(46) + 1);
    }

    private static String dumpAttributes(int iAttributes_p) {
        String strRet = "";
        if (0 != (iAttributes_p & 1)) {
            strRet = strRet + "ATTRIBUTE_HIDDEN ";
        }
        if (0 != (iAttributes_p & 2)) {
            strRet = strRet + "ATTRIBUTE_READONLY ";
        }
        if (0 != (iAttributes_p & 4)) {
            strRet = strRet + "ATTRIBUTE_REQUIRED ";
        }
        if (0 != (iAttributes_p & 8)) {
            strRet = strRet + "ATTRIBUTE_ALLOWWILDCARD ";
        }
        return strRet;
    }

    private static void dump(Writer w_p, OwSearchNode search_p, int iLevel_p, boolean fHtml_p) throws Exception {
        if (search_p.isCriteriaNode()) {
            OwSearchCriteria crit = search_p.getCriteria();
            StringBuffer buff = new StringBuffer("[");
            buff.append(OwSearchNode.getDumpNodeTypeString(search_p.getNodeType()));
            buff.append(": ");
            buff.append(crit.getDisplayName(Locale.getDefault()));
            buff.append("] - ");
            buff.append(crit.getDisplayName(Locale.getDefault()));
            buff.append(": <b>\"");
            try {
                if (crit.isArray()) {
                    boolean fDelimiter = false;
                    Object[] arrVal = (Object[])crit.getValue();
                    for (int i = 0; i < arrVal.length; ++i) {
                        if (fDelimiter) {
                            buff.append(", ");
                        }
                        if (arrVal[i] == null) {
                            buff.append("<null>");
                        } else {
                            buff.append(arrVal[i].toString());
                        }
                        fDelimiter = true;
                    }
                } else if (crit.getValue() == null) {
                    buff.append("<null>");
                } else {
                    buff.append(crit.getValue().toString());
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            buff.append("\"</b> CLASS: ");
            buff.append(search_p.getCriteria().getClassName());
            buff.append(" J-CLASS: ");
            buff.append(OwSearchNode.dumpJavaClassName(search_p.getCriteria().getJavaClassName()));
            buff.append(" UNIQUE: ");
            buff.append(crit.getUniqueName());
            buff.append(" ATTR: ");
            buff.append(OwSearchNode.dumpAttributes(search_p.getCriteria().getAttributes()));
            OwSearchNode.dumpLevelLine(w_p, iLevel_p, buff.toString(), fHtml_p);
        } else {
            OwSearchNode.dumpLevelLine(w_p, iLevel_p, "[" + OwSearchNode.getDumpNodeTypeString(search_p.getNodeType()) + "] - " + OwSearchNode.getOperatorDisplayName(Locale.getDefault(), search_p.getOperator()), fHtml_p);
            Iterator it = search_p.getChilds().iterator();
            while (it.hasNext()) {
                OwSearchNode.dump(w_p, (OwSearchNode)it.next(), iLevel_p + 1, fHtml_p);
            }
        }
    }

    public OwSearchNode(OwSearchCriteria criteria_p) {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
        this.m_Criteria = criteria_p;
        this.m_iNodeType = 4;
    }

    public OwSearchNode(OwFieldDefinition fieldDefinition_p, int iOp_p, Object oInitialAndDefaultValue_p, int iAttributes_p, String strUniqueName_p, String strInstruction_p, Collection wildcarddefinitions_p) {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
        this.m_Criteria = new OwSearchCriteria();
        this.m_Criteria.m_iOp = iOp_p;
        this.m_Criteria.m_strUniqueName = strUniqueName_p;
        this.m_Criteria.m_iAttributes = iAttributes_p;
        this.m_Criteria.m_FieldDefinition = fieldDefinition_p;
        this.m_Criteria.m_strInstruction = strInstruction_p;
        this.m_Criteria.m_wildcarddefinitions = wildcarddefinitions_p;
        this.m_iNodeType = 4;
        this.m_Criteria.setInitialAndDefaultValue(oInitialAndDefaultValue_p);
    }

    public OwSearchNode(OwFieldDefinition fieldDefinition_p, int iOp_p, Object oInitialAndDefaultValue_p, int iAttributes_p, String strUniqueName_p, String strInstruction_p, Collection wildcarddefinitions_p, Object minValue_p, Object maxValue_p, Object defaultValue_p, String sJavaClassName_p) throws Exception {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
        this.m_Criteria = new OwSearchCriteriaFieldDefOverride();
        ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setMinValue(minValue_p);
        ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setMaxValue(maxValue_p);
        ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setDefaultValue(defaultValue_p);
        ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setJavaClassName(sJavaClassName_p);
        this.m_Criteria.m_iOp = iOp_p;
        this.m_Criteria.m_strUniqueName = strUniqueName_p;
        this.m_Criteria.m_iAttributes = iAttributes_p;
        this.m_Criteria.m_FieldDefinition = fieldDefinition_p;
        this.m_Criteria.m_strInstruction = strInstruction_p;
        this.m_Criteria.m_wildcarddefinitions = wildcarddefinitions_p;
        this.m_iNodeType = 4;
        this.m_Criteria.setInitialAndDefaultValue(oInitialAndDefaultValue_p);
    }

    public OwSearchNode(OwField field_p, int iOp_p, int iAttributes_p, String strUniqueName_p, String strInstruction_p, Collection wildcarddefinitions_p) throws Exception {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
        this.m_Criteria = new OwSearchCriteria();
        this.m_Criteria.m_iOp = iOp_p;
        this.m_Criteria.m_oValue = field_p.getValue();
        this.m_Criteria.m_strUniqueName = strUniqueName_p;
        this.m_Criteria.m_iAttributes = iAttributes_p;
        this.m_Criteria.m_FieldDefinition = field_p.getFieldDefinition();
        this.m_Criteria.m_strInstruction = strInstruction_p;
        this.m_Criteria.m_wildcarddefinitions = wildcarddefinitions_p;
        this.m_iNodeType = 4;
    }

    public OwSearchNode(OwFieldDefinition fieldDefinition_p, int iOp_p, Object oInitialAndDefaultValue_p, int iAttributes_p) {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
        this.m_Criteria = new OwSearchCriteria();
        this.m_Criteria.m_iOp = iOp_p;
        this.m_Criteria.m_strUniqueName = fieldDefinition_p.getClassName();
        this.m_Criteria.m_iAttributes = iAttributes_p;
        this.m_Criteria.m_FieldDefinition = fieldDefinition_p;
        this.m_Criteria.m_strInstruction = null;
        this.m_iNodeType = 4;
        this.m_Criteria.setInitialAndDefaultValue(oInitialAndDefaultValue_p);
    }

    public OwSearchNode(OwField field_p, int iOp_p, int iAttributes_p) throws Exception {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
        this.m_Criteria = new OwSearchCriteria();
        this.m_Criteria.m_iOp = iOp_p;
        this.m_Criteria.m_oValue = field_p.getValue();
        this.m_Criteria.m_strUniqueName = field_p.getFieldDefinition().getClassName();
        this.m_Criteria.m_iAttributes = iAttributes_p;
        this.m_Criteria.m_FieldDefinition = field_p.getFieldDefinition();
        this.m_Criteria.m_strInstruction = null;
        this.m_iNodeType = 4;
    }

    public OwSearchNode(int iOp_p, int iNodeType_p) {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
        this.m_Childs = new LinkedList();
        this.m_iOp = iOp_p;
        this.m_iNodeType = iNodeType_p;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new OwSearchNode(this);
        }
        catch (Exception e) {
            return null;
        }
    }

    public OwSearchNode(OwSearchNode search_p) throws Exception {
        block6: {
            block4: {
                OwSearchCriteriaFieldDefOverride overrideCriteria;
                block5: {
                    this.m_iNodeType = 0;
                    this.m_iOp = 0;
                    this.m_iOp = search_p.getOperator();
                    this.m_iNodeType = search_p.getNodeType();
                    if (!search_p.isCriteriaNode()) break block4;
                    overrideCriteria = null;
                    try {
                        overrideCriteria = (OwSearchCriteriaFieldDefOverride)search_p.m_Criteria;
                    }
                    catch (ClassCastException cce) {
                        overrideCriteria = null;
                    }
                    if (overrideCriteria != null) break block5;
                    this.m_Criteria = new OwSearchCriteria();
                    this.m_Criteria.m_iOp = search_p.m_Criteria.m_iOp;
                    this.m_Criteria.m_strUniqueName = search_p.m_Criteria.m_strUniqueName;
                    this.m_Criteria.m_iAttributes = search_p.m_Criteria.m_iAttributes;
                    this.m_Criteria.m_FieldDefinition = search_p.m_Criteria.m_FieldDefinition;
                    this.m_Criteria.m_strInstruction = search_p.m_Criteria.m_strInstruction;
                    this.m_Criteria.m_wildcarddefinitions = search_p.m_Criteria.m_wildcarddefinitions;
                    this.m_Criteria.m_oValue = search_p.m_Criteria.m_oValue;
                    this.m_Criteria.m_oDefaultValue = search_p.m_Criteria.m_oDefaultValue;
                    if (search_p.m_Criteria.m_secondrangecriteria != null) {
                        this.m_Criteria.getSecondRangeCriteria().m_oValue = search_p.m_Criteria.m_secondrangecriteria.m_oValue;
                        this.m_Criteria.getSecondRangeCriteria().m_oDefaultValue = search_p.m_Criteria.m_secondrangecriteria.m_oDefaultValue;
                    }
                    break block6;
                }
                this.m_Criteria = new OwSearchCriteriaFieldDefOverride();
                ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setMinValue(overrideCriteria.getMinValue());
                ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setMaxValue(overrideCriteria.getMaxValue());
                ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setDefaultValue(overrideCriteria.getDefaultValue());
                ((OwSearchCriteriaFieldDefOverride)this.m_Criteria).setJavaClassName(overrideCriteria.getJavaClassName());
                this.m_Criteria.m_iOp = overrideCriteria.m_iOp;
                this.m_Criteria.m_strUniqueName = overrideCriteria.m_strUniqueName;
                this.m_Criteria.m_iAttributes = overrideCriteria.m_iAttributes;
                this.m_Criteria.m_FieldDefinition = overrideCriteria.m_FieldDefinition;
                this.m_Criteria.m_strInstruction = overrideCriteria.m_strInstruction;
                this.m_Criteria.m_wildcarddefinitions = overrideCriteria.m_wildcarddefinitions;
                this.m_Criteria.m_oValue = overrideCriteria.m_oValue;
                this.m_Criteria.m_oDefaultValue = overrideCriteria.m_oDefaultValue;
                if (overrideCriteria.m_secondrangecriteria == null) break block6;
                this.m_Criteria.getSecondRangeCriteria().m_oValue = overrideCriteria.m_secondrangecriteria.m_oValue;
                this.m_Criteria.getSecondRangeCriteria().m_oDefaultValue = overrideCriteria.m_secondrangecriteria.m_oDefaultValue;
                break block6;
            }
            this.m_Childs = new LinkedList();
            Iterator it = search_p.getChilds().iterator();
            while (it.hasNext()) {
                this.add(new OwSearchNode((OwSearchNode)it.next()));
            }
        }
    }

    public int getOperator() {
        return this.m_iOp;
    }

    public List getCriteriaList(int iFilter_p) {
        OwSearchNodeFilter filter = new OwSearchNodeFilter(iFilter_p);
        return filter.getCriteriaList(this);
    }

    public Map getCriteriaMap(int iFilter_p) {
        OwSearchNodeFilter filter = new OwSearchNodeFilter(iFilter_p);
        return filter.getCriteriaMap(this);
    }

    public void reset() throws Exception {
        for (OwSearchCriteria criteria : this.getCriteriaList(1)) {
            if (criteria.isCriteriaOperatorRange()) {
                criteria.setValue(criteria.getDefaultValue());
                criteria.getSecondRangeCriteria().setValue(criteria.getSecondRangeCriteria().getDefaultValue());
                continue;
            }
            criteria.setValue(criteria.getDefaultValue());
        }
    }

    public OwSearchCriteria getCriteria() {
        return this.m_Criteria;
    }

    public List getChilds() {
        return this.m_Childs;
    }

    public int getNodeType() {
        return this.m_iNodeType;
    }

    public boolean isEmpty() {
        for (OwSearchCriteria criteria : this.getCriteriaList(0)) {
            if (criteria.getValue() == null || criteria.getValue().toString().length() == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isCriteriaNode() {
        return this.m_iNodeType == 4;
    }

    public void add(OwSearchNode search_p) throws Exception {
        if (this.getCriteria() != null) {
            throw new Exception("Can not add a search to a criteria search node.");
        }
        this.m_Childs.add(search_p);
    }

    protected OwSearchNode() {
        this.m_iNodeType = 0;
        this.m_iOp = 0;
    }

    public void setPersistentNode(Node persistentNode_p) throws Exception {
        List criteriaList = this.getCriteriaList(1);
        int i = 0;
        for (Node n = persistentNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (i >= criteriaList.size()) {
                throw new OwInvalidOperationException("OwSearchNode.setPersistentNode: Die persistenten Suchkriterien passen nicht zum Suchobjekt.");
            }
            OwSearchCriteria criteria = (OwSearchCriteria)criteriaList.get(i);
            if (n.getNodeType() == 1) {
                int iOperator = Integer.parseInt(n.getAttributes().getNamedItem(PERSIST_OPERATOR_ATTR_NAME).getNodeValue());
                criteria.setOperator(iOperator);
                if (criteria.isCriteriaOperatorRange()) {
                    for (Node subvalue = n.getFirstChild(); subvalue != null; subvalue = subvalue.getNextSibling()) {
                        if (subvalue.getNodeName().equals(PERSIST_START_RANGE_NAME)) {
                            criteria.setValue(criteria.getValueFromNode(subvalue.getFirstChild()));
                        }
                        if (!subvalue.getNodeName().equals(PERSIST_END_RANGE_NAME)) continue;
                        criteria.getSecondRangeCriteria().setValue(criteria.getSecondRangeCriteria().getValueFromNode(subvalue.getFirstChild()));
                    }
                } else {
                    criteria.setValue(criteria.getValueFromNode(n.getFirstChild()));
                }
            }
            ++i;
        }
        if (i < criteriaList.size()) {
            throw new OwInvalidOperationException("OwSearchNode.setPersistentNode: Die persistenten Suchkriterien passen nicht zum Suchobjekt.");
        }
    }

    public Node getPersistentNode(Document doc_p) throws Exception {
        Element retNode = doc_p.createElement(PERSIST_SEARCH_NODE_NAME);
        List criteriaList = this.getCriteriaList(1);
        for (int i = 0; i < criteriaList.size(); ++i) {
            OwSearchCriteria criteria = (OwSearchCriteria)criteriaList.get(i);
            Element criteriaNode = doc_p.createElement(criteria.getClassName());
            criteriaNode.setAttribute(PERSIST_UNIQUE_NAME__ATTR_NAME, criteria.getUniqueName());
            criteriaNode.setAttribute(PERSIST_OPERATOR_ATTR_NAME, String.valueOf(criteria.getOperator()));
            Node valueNode = criteria.getNodeFromValue(criteria.getValue(), doc_p);
            if (criteria.isCriteriaOperatorRange()) {
                Node valueNode2 = criteria.getSecondRangeCriteria().getNodeFromValue(criteria.getSecondRangeCriteria().getValue(), doc_p);
                Element subnode1 = doc_p.createElement(PERSIST_START_RANGE_NAME);
                Element subnode2 = doc_p.createElement(PERSIST_END_RANGE_NAME);
                if (null != valueNode) {
                    subnode1.appendChild(valueNode);
                }
                if (null != valueNode2) {
                    subnode2.appendChild(valueNode2);
                }
                criteriaNode.appendChild(subnode1);
                criteriaNode.appendChild(subnode2);
            } else if (null != valueNode) {
                criteriaNode.appendChild(valueNode);
            }
            retNode.appendChild(criteriaNode);
        }
        return retNode;
    }

    public OwFieldProvider getFieldProvider() {
        return new OwSearchNodeFieldProvider(this);
    }

    public OwSearchNode findSearchNode(int iNodeType_p) {
        return this.findSearchNodeInternal(this, iNodeType_p);
    }

    private OwSearchNode findSearchNodeInternal(OwSearchNode searchNode_p, int iNodeType_p) {
        if (searchNode_p.getNodeType() == iNodeType_p) {
            return searchNode_p;
        }
        if (searchNode_p.isCriteriaNode()) {
            return null;
        }
        Iterator it = searchNode_p.getChilds().iterator();
        while (it.hasNext()) {
            OwSearchNode search = this.findSearchNodeInternal((OwSearchNode)it.next(), iNodeType_p);
            if (null == search) continue;
            return search;
        }
        return null;
    }

    public boolean isValid() throws Exception {
        boolean fOneIsSet = false;
        List criterialist = this.getCriteriaList(3);
        if (criterialist.size() == 0) {
            return true;
        }
        for (OwSearchCriteria crit : criterialist) {
            if (null != crit.getValue() && crit.getValue().toString().length() != 0) {
                if (crit.isCriteriaOperatorRange()) {
                    if (null != crit.getDefaultValue()) continue;
                    fOneIsSet = true;
                    continue;
                }
                if (null != crit.getDefaultValue() && crit.getDefaultValue().toString().length() != 0 && crit.getDefaultValue().equals(crit.getValue())) continue;
                fOneIsSet = true;
                continue;
            }
            if (!crit.isRequired()) continue;
            return false;
        }
        return fOneIsSet;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            OwSearchNode.dump(writer, this, 0, false);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return writer.toString();
    }

    public static class OwSearchNodeFieldProvider
    implements OwFieldProvider {
        private Map m_FieldMap;

        public OwSearchNodeFieldProvider(OwSearchNode search_p) {
            Iterator it = search_p.getCriteriaList(1).iterator();
            this.m_FieldMap = new HashMap();
            while (it.hasNext()) {
                OwSearchCriteria criteria = (OwSearchCriteria)it.next();
                this.m_FieldMap.put(criteria.getUniqueName(), criteria);
            }
        }

        @Override
        public Object getFieldProviderSource() {
            return this;
        }

        @Override
        public String getFieldProviderName() {
            return "OwSearchNode";
        }

        @Override
        public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
            OwField field = (OwField)this.m_FieldMap.get(strFieldClassName_p);
            if (field == null) {
                throw new OwObjectNotFoundException("OwSearchNode$OwSearchNodeFieldProvider.getField: Property not found, strFieldClassName_p = " + strFieldClassName_p);
            }
            return field;
        }

        @Override
        public int getFieldProviderType() {
            return 2;
        }

        @Override
        public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
            this.getField(sName_p).setValue(value_p);
        }

        @Override
        public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
            try {
                OwField field = this.getField(sName_p);
                return field.getValue();
            }
            catch (Exception e) {
                return defaultvalue_p;
            }
        }

        @Override
        public Collection getFields() throws Exception {
            return this.m_FieldMap.values();
        }
    }

    @Deprecated
    public class OwSearchMap
    extends HashMap {
        private static final long serialVersionUID = 1L;
        private int m_iFilter;

        private boolean hasFilter(int iFlag_p) {
            return (this.m_iFilter & iFlag_p) != 0;
        }

        public OwSearchMap(OwSearchNode search_p, int iFilter_p) {
            this.m_iFilter = iFilter_p;
            this.traverseSearchTree(search_p);
        }

        private void traverseSearchTree(OwSearchNode search_p) {
            List Childs;
            OwSearchCriteria Criteria = search_p.getCriteria();
            if (!(Criteria == null || this.hasFilter(1) && Criteria.isHidden())) {
                super.put(Criteria.getUniqueName(), Criteria);
            }
            if (!(search_p.getNodeType() != 4 && search_p.getNodeType() != 1 && this.hasFilter(2) || (Childs = search_p.getChilds()) == null)) {
                for (int i = 0; i < Childs.size(); ++i) {
                    this.traverseSearchTree((OwSearchNode)Childs.get(i));
                }
            }
        }
    }

    @Deprecated
    public class OwSearchList
    extends LinkedList {
        private static final long serialVersionUID = 1L;
        private int m_iFilter;

        private boolean hasFilter(int iFlag_p) {
            return (this.m_iFilter & iFlag_p) != 0;
        }

        public OwSearchList(OwSearchNode search_p, int iFilter_p) {
            this.m_iFilter = iFilter_p;
            this.traverseSearchTree(search_p);
        }

        private void traverseSearchTree(OwSearchNode search_p) {
            List Childs;
            OwSearchCriteria criteria = search_p.getCriteria();
            if (!(criteria == null || this.hasFilter(1) && criteria.isHidden())) {
                super.add(criteria);
            }
            if (!(search_p.getNodeType() != 5 && search_p.getNodeType() != 1 && this.hasFilter(2) || (Childs = search_p.getChilds()) == null)) {
                for (int i = 0; i < Childs.size(); ++i) {
                    this.traverseSearchTree((OwSearchNode)Childs.get(i));
                }
            }
        }
    }
}

