/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import com.wewebu.ow.server.util.OwString;
import java.util.HashMap;
import java.util.Locale;

public class OwSearchOperator {
    public static final int CRIT_OP_UNDEF = 2;
    public static final int CRIT_OP_EQUAL = 4;
    public static final int CRIT_OP_NOT_EQUAL = 5;
    public static final int CRIT_OP_LIKE = 6;
    public static final int CRIT_OP_NOT_LIKE = 7;
    public static final int CRIT_OP_GREATER = 8;
    public static final int CRIT_OP_LESS = 10;
    public static final int CRIT_OP_GREATER_EQUAL = 12;
    public static final int CRIT_OP_LESS_EQUAL = 14;
    public static final int CRIT_OP_IS_NULL = 16;
    public static final int CRIT_OP_IS_NOT_NULL = 17;
    public static final int CRIT_OP_IS_IN = 274;
    public static final int CRIT_OP_IS_NOT_IN = 275;
    public static final int CRIT_OP_IS_ARRAY_IN = 276;
    public static final int CRIT_OP_IS_ARRAY_NOT_IN = 277;
    public static final int CRIT_OP_BETWEEN = 530;
    public static final int CRIT_OP_NOT_BETWEEN = 531;
    public static final int CRIT_OP_CBR_NONE = 770;
    public static final int CRIT_OP_CBR_ALL = 772;
    public static final int CRIT_OP_CBR_ANY = 774;
    public static final int CRIT_OP_CBR_IN = 776;
    public static final int CRIT_OP_CBR_ZONE = 778;
    public static final int CRIT_OP_CBR_NEAR = 780;
    public static final int CRIT_OP_CBR_PARAGRAPH = 782;
    public static final int CRIT_OP_CBR_SENTENCE = 784;
    public static final int CRIT_OP_CBR_VQL = 786;
    public static final int MERGE_NONE = 1025;
    public static final int MERGE_UNION = 1026;
    public static final int MERGE_INTERSECT = 1027;
    protected static final OperatorMapSingleton m_maps = new OperatorMapSingleton();

    public static boolean isCriteriaOperatorNot(int op_p) {
        return (op_p & 1) > 0;
    }

    public static boolean isCriteriaOperatorRange(int op_p) {
        return op_p == 530 || op_p == 531;
    }

    public static String getOperatorDisplayString(Locale locale_p, int iOP_p) {
        OwString str = (OwString)OwSearchOperator.m_maps.m_stringOperatorMap.get(iOP_p);
        if (null == str) {
            return null;
        }
        return str.getString(locale_p);
    }

    public static String getOperatorDisplaySymbol(Locale locale_p, int iOP_p) {
        return (String)OwSearchOperator.m_maps.m_symbolOperatorMap.get(iOP_p);
    }

    public static HashMap getSymbolOperatorMap() {
        return OwSearchOperator.m_maps.m_symbolOperatorMap;
    }

    public static HashMap getSymbolInverseOperatorMap() {
        return OwSearchOperator.m_maps.m_symbolInverseOperatorMap;
    }

    protected static class OperatorMapSingleton {
        public HashMap m_stringOperatorMap = null;
        public HashMap m_symbolOperatorMap = null;
        public HashMap m_symbolInverseOperatorMap = null;

        private OperatorMapSingleton() {
            if (this.m_stringOperatorMap == null) {
                this.m_stringOperatorMap = new HashMap();
                this.m_stringOperatorMap.put(4, new OwString("field.OwSearchOperator.equal", "is equal"));
                this.m_stringOperatorMap.put(5, new OwString("field.OwSearchOperator.notequal", "is not equal"));
                this.m_stringOperatorMap.put(6, new OwString("field.OwSearchOperator.like", "is like"));
                this.m_stringOperatorMap.put(7, new OwString("field.OwSearchOperator.notlike", "is not like"));
                this.m_stringOperatorMap.put(8, new OwString("field.OwSearchOperator.greater", "greater than"));
                this.m_stringOperatorMap.put(10, new OwString("field.OwSearchOperator.less", "less than"));
                this.m_stringOperatorMap.put(12, new OwString("field.OwSearchOperator.greaterequal", "greater or equal"));
                this.m_stringOperatorMap.put(14, new OwString("field.OwSearchOperator.lessequal", "less or equal"));
                this.m_stringOperatorMap.put(530, new OwString("field.OwSearchOperator.between", "between"));
                this.m_stringOperatorMap.put(531, new OwString("field.OwSearchOperator.notbetween", "not between"));
                this.m_stringOperatorMap.put(16, new OwString("field.OwSearchOperator.isnull", "is null"));
                this.m_stringOperatorMap.put(17, new OwString("field.OwSearchOperator.isnotnull", "is not null"));
                this.m_stringOperatorMap.put(274, new OwString("field.OwSearchOperator.isin", "is in"));
                this.m_stringOperatorMap.put(275, new OwString("field.OwSearchOperator.isnotin", "is not in"));
                this.m_stringOperatorMap.put(276, new OwString("field.OwSearchOperator.isarrayin", "is within"));
                this.m_stringOperatorMap.put(277, new OwString("field.OwSearchOperator.isarraynotin", "is not within"));
                this.m_stringOperatorMap.put(770, new OwString("field.OwSearchOperator.cbrnone", "find words"));
                this.m_stringOperatorMap.put(772, new OwString("field.OwSearchOperator.cbrall", "find all words"));
                this.m_stringOperatorMap.put(774, new OwString("field.OwSearchOperator.cbrany", "find any word"));
                this.m_stringOperatorMap.put(776, new OwString("field.OwSearchOperator.cbrin", "find words within"));
                this.m_stringOperatorMap.put(778, new OwString("field.OwSearchOperator.cbrzone", "find within zone"));
                this.m_stringOperatorMap.put(780, new OwString("field.OwSearchOperator.cbrnear", "find similar words"));
                this.m_stringOperatorMap.put(782, new OwString("field.OwSearchOperator.cbrparagraph", "find in paragraph"));
                this.m_stringOperatorMap.put(784, new OwString("field.OwSearchOperator.cbrsentence", "find in sentence"));
                this.m_stringOperatorMap.put(786, new OwString("field.OwSearchOperator.cbrvql", "VQL Search"));
                this.m_stringOperatorMap.put(1025, new OwString("field.OwSearchOperator.mergenone", "is"));
                this.m_stringOperatorMap.put(1026, new OwString("field.OwSearchOperator.mergeunion", "is sum of"));
                this.m_stringOperatorMap.put(1027, new OwString("field.OwSearchOperator.mergeintersect", "is subset of"));
            }
            if (this.m_symbolOperatorMap == null) {
                this.m_symbolOperatorMap = new HashMap();
                this.m_symbolOperatorMap.put(4, "=");
                this.m_symbolOperatorMap.put(5, "<>");
                this.m_symbolOperatorMap.put(6, "LIKE");
                this.m_symbolOperatorMap.put(7, "NOT LIKE");
                this.m_symbolOperatorMap.put(8, ">");
                this.m_symbolOperatorMap.put(10, "<");
                this.m_symbolOperatorMap.put(12, ">=");
                this.m_symbolOperatorMap.put(14, "<=");
                this.m_symbolOperatorMap.put(16, "IS NULL");
                this.m_symbolOperatorMap.put(17, "IS NOT NULL");
            }
            if (this.m_symbolInverseOperatorMap == null) {
                this.m_symbolInverseOperatorMap = new HashMap();
                this.m_symbolInverseOperatorMap.put("=", 4);
                this.m_symbolInverseOperatorMap.put("<>", 5);
                this.m_symbolInverseOperatorMap.put("LIKE", 6);
                this.m_symbolInverseOperatorMap.put("NOT LIKE", 7);
                this.m_symbolInverseOperatorMap.put(">", 8);
                this.m_symbolInverseOperatorMap.put("<", 10);
                this.m_symbolInverseOperatorMap.put(">=", 12);
                this.m_symbolInverseOperatorMap.put("<=", 14);
                this.m_symbolInverseOperatorMap.put("IS NULL", 16);
                this.m_symbolInverseOperatorMap.put("IS NOT NULL", 17);
            }
        }
    }
}

