/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.field;

import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwPriorityRuleBase;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchOperator;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwStandardPriorityRule
extends OwPriorityRuleBase {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardPriorityRule.class);
    public static final String NODE_NAME_SEARCHNODE = "SearchNode";
    private static final String ATTRIBUTE_NAME_OPERATOR = "op";
    private static final String NODE_NAME_LITERAL = "literal";
    private static final String NODE_NAME_SYMNAME = "symname";
    private OwSearchNode m_searchnode;

    public void init(Node configNode_p, OwFieldDefinitionProvider fieldefinitionprovider_p) throws Exception {
        String sResource;
        this.m_scontainer = OwXMLDOMUtil.getSafeStringAttributeValue(configNode_p, "container", null);
        OwStandardXMLUtil prionode = new OwStandardXMLUtil(configNode_p);
        this.m_sresource = sResource = OwXMLDOMUtil.getSafeStringAttributeValue(configNode_p, "resource", null);
        this.m_searchnode = this.scanSearchNode(prionode.getSubNode(NODE_NAME_SEARCHNODE), fieldefinitionprovider_p, sResource);
        this.m_sStyleClass = prionode.getSafeTextValue("styleclass", "owpriostyle");
    }

    private OwSearchNode scanSearchNode(Node configNode_p, OwFieldDefinitionProvider fieldefinitionprovider_p, String sResource_p) throws Exception {
        String sOP = OwXMLDOMUtil.getSafeStringAttributeValue(configNode_p, ATTRIBUTE_NAME_OPERATOR, null);
        if (null == sOP) {
            String msg = "OwStandardPriorityRule.scanSearchNode: Define Op in the PriorityRule search / criteria  Node.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        if (configNode_p.getNodeName().equals(NODE_NAME_SEARCHNODE)) {
            int iOP = OwSearchNode.class.getField(sOP).getInt(null);
            OwSearchNode searchnode = new OwSearchNode(iOP, 1);
            for (Node n = configNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1) continue;
                searchnode.add(this.scanSearchNode(n, fieldefinitionprovider_p, sResource_p));
            }
            return searchnode;
        }
        int iOP = OwSearchOperator.class.getField(sOP).getInt(null);
        OwStandardXMLUtil critnode = new OwStandardXMLUtil(configNode_p);
        String sSymname = critnode.getSafeTextValue(NODE_NAME_SYMNAME, null);
        String sLiteral = critnode.getSafeTextValue(NODE_NAME_LITERAL, null);
        if (null == sSymname) {
            String msg = "OwStandardPriorityRule.scanSearchNode: Define symname in the PriorityRule criteria Node.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        if (null == sLiteral) {
            String msg = "OwStandardPriorityRule.scanSearchNode: Define literal in the PriorityRule criteria Node.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        OwFieldDefinition fielddefinition = fieldefinitionprovider_p.getFieldDefinition(sSymname, sResource_p);
        return new OwSearchNode(fielddefinition, iOP, fielddefinition.getValueFromString(sLiteral), 0);
    }

    public OwSearchNode getRule() {
        return this.m_searchnode;
    }

    @Override
    public final boolean appliesTo(OwObject object_p) throws OwInvalidOperationException {
        try {
            OwSearchCriteria criteria = ((OwSearchNode)this.m_searchnode.getChilds().get(0)).getCriteria();
            OwProperty prop = object_p.getProperty(criteria.getClassName());
            return criteria.getValue().equals(prop.getValue());
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not process property rule!", (Throwable)e);
        }
    }
}

