/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldctrlimpl;

import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwFieldManagerException;
import com.wewebu.ow.server.ecm.OwStandardObjectClass;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwFormat;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwNumberFieldControl
extends OwFieldManagerControl {
    private static final String ARRAY_FIELD_ID_SEPARATOR = "_";
    private static final String DEFAULT_EXTERNAL_COMPLEX_ID_DELIMITER = "_";
    private static final Logger LOG = OwLogCore.getLogger(OwNumberFieldControl.class);
    private static final String NUMBER_FORMAT_ELEMENT = "NumberFormat";
    public static final String ARRAY_ITEM_INDEX_KEY = "aitem";
    public static final String FIELD_ID_KEY = "fieldid";
    public static final int DEFAULT_SIZE = 32;
    private NumberFormat m_numberFormat = NumberFormat.getInstance();
    private Map m_updateErrorFields = new HashMap();
    private Map m_clearMarkedArraySizes = new HashMap();
    private Map m_containerFieldErrorCounts = new HashMap();
    private boolean m_acceptPartialParse = false;

    @Override
    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        Object[] value_p = field_p.getValue();
        if (fieldDef_p.isArray()) {
            w_p.write("<fieldset id='");
            String fieldId = String.valueOf(field_p.hashCode());
            w_p.write(fieldId);
            w_p.write("' class='accessibility'>");
            w_p.write("<legend class='accessibility'>");
            w_p.write(fieldDef_p.getDisplayName(this.getContext().getLocale()));
            w_p.write("</legend>");
            if (value_p == null) {
                value_p = new Object[]{};
            }
            if (value_p.getClass().isArray()) {
                Object[] values = value_p;
                w_p.write("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
                if (values.length > 0) {
                    int deleteErrorSkips = 0;
                    for (int i = 0; i < values.length; ++i) {
                        w_p.write("<tr><td valign=\"bottom\">");
                        String arrayItemId = strID_p + "_" + String.valueOf(i);
                        String errorFieldId = strID_p + "_" + String.valueOf(i + deleteErrorSkips);
                        if (this.isMarkedForClear(errorFieldId)) {
                            ++deleteErrorSkips;
                        }
                        errorFieldId = strID_p + "_" + String.valueOf(i + deleteErrorSkips);
                        this.insertSingleEditField(w_p, fieldDef_p, values[i], arrayItemId, errorFieldId);
                        w_p.write("</td><td>");
                        if (values.length > 1 || i != 0 || !(field_p instanceof OwSearchCriteria)) {
                            this.insertRemoveArrayItemLink(w_p, fieldDef_p, i, strID_p);
                        } else {
                            w_p.write("</td><td style='width:17px;'>");
                        }
                        w_p.write("</td></tr>");
                    }
                    w_p.write("<tr>");
                    w_p.write("<td>");
                    this.insertAddArrayItemLink(w_p, fieldDef_p, strID_p);
                    w_p.write("</td>");
                    w_p.write("</tr>");
                } else {
                    w_p.write("<tr><td valign=\"bottom\">");
                    w_p.write("</td><td>");
                    this.insertAddArrayItemLink(w_p, fieldDef_p, strID_p);
                    w_p.write("</td></tr>");
                }
            } else {
                String errMessage = this.getContext().localize("app.OwNumberFieldControl.invalidfield", "Invalid number field :") + fieldDef_p.getClass();
                LOG.error((Object)("OwNumberFieldControl.insertEditField : non array value found for an array based field - " + fieldDef_p.getClassName()));
                throw new OwFieldManagerException(errMessage);
            }
            w_p.write("</table>");
            w_p.write("</fieldset>");
        } else {
            this.insertSingleEditField(w_p, fieldDef_p, value_p, strID_p, strID_p);
        }
        this.clearMarkedArrayItemErrors();
    }

    protected void insertAddArrayItemLink(Writer w_p, OwFieldDefinition fieldDef_p, String strID_p) throws Exception {
        String addButtonTooltip = this.getContext().localize("app.OwStandardFieldManager.addarrayitemtooltip", "Add Element");
        String strAddEventURL = "javascript:document." + this.getFieldManager().getFormName() + ".action = '" + this.getEventURL("AddArrayItem", "fieldid=" + strID_p) + "';document." + this.getFieldManager().getFormName() + ".submit()";
        w_p.write("<a title=\"");
        w_p.write(addButtonTooltip);
        w_p.write("\" href=\"");
        w_p.write(strAddEventURL);
        w_p.write("\">");
        if (fieldDef_p != null) {
            addButtonTooltip = this.getContext().localize1("app.OwStandardFieldManager.addarrayitemtooltipimg", "Add new item for %1", fieldDef_p.getDisplayName(this.getContext().getLocale()));
        }
        w_p.write("<img vspace=\"5\" align=\"absmiddle\" border=\"0\" src=\"");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/addbtn.png\"");
        w_p.write(" alt=\"");
        w_p.write(addButtonTooltip);
        w_p.write("\" title=\"");
        w_p.write(addButtonTooltip);
        w_p.write("\"/></a>");
    }

    protected void insertRemoveArrayItemLink(Writer w_p, OwFieldDefinition fieldDef_p, int index_p, String strID_p) throws IOException, Exception {
        String deleteButtonTooltip = this.getContext().localize("app.OwStandardFieldManager.delarrayitem", "Delete Element");
        w_p.write("<a title=\"");
        w_p.write(deleteButtonTooltip);
        w_p.write("\" href=\"");
        w_p.write(this.getFormEventURL("DeleteArrayItem", "aitem=" + String.valueOf(index_p) + "&" + FIELD_ID_KEY + "=" + strID_p));
        w_p.write("\">");
        w_p.write("<img hspace=\"5\" align=\"absmiddle\" border=\"0\" src=\"");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/deletebtn.png\"");
        if (fieldDef_p != null) {
            String fieldDisplayName = fieldDef_p.getDisplayName(this.getContext().getLocale());
            deleteButtonTooltip = this.getContext().localize2("app.OwStandardFieldManager.delarrayitemindexed", "Delete element at position %1 from %2", "" + (index_p + 1), fieldDisplayName);
        }
        w_p.write(" alt=\"");
        w_p.write(deleteButtonTooltip);
        w_p.write("\" title=\"");
        w_p.write(deleteButtonTooltip);
        w_p.write("\"/></a>");
    }

    public void onDeleteArrayItem(HttpServletRequest request_p) throws Exception {
        String arrayItemIdex = request_p.getParameter(ARRAY_ITEM_INDEX_KEY);
        int iIndex = Integer.parseInt(arrayItemIdex);
        String fieldId = request_p.getParameter(FIELD_ID_KEY);
        OwFieldManager fieldManager = this.getFieldManager();
        OwField field = fieldManager.getField(fieldId);
        Object[] values = (Object[])field.getValue();
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.updateSingleField(request_p, field.getFieldDefinition(), values[i], fieldId + "_" + i, false);
        }
        this.markArrayItemErrorForClear(fieldId + "_" + iIndex, fieldId, iIndex, values.length);
        fieldManager.clearFieldError(field);
        if (values.length < 2) {
            field.setValue(null);
            return;
        }
        Object[] newValues = new Object[values.length - 1];
        int iNew = 0;
        int iOrigin = 0;
        do {
            if (iIndex == iOrigin) {
                // empty if block
            }
            int n = iNew++;
            int n2 = ++iOrigin;
            ++iOrigin;
            newValues[n] = values[n2];
        } while (iNew < newValues.length);
        field.setValue(newValues);
    }

    public void onAddArrayItem(HttpServletRequest request_p) throws Exception {
        String key = request_p.getParameter(FIELD_ID_KEY);
        OwField field = this.getFieldManager().getField(key);
        Object[] values = (Object[])field.getValue();
        Object[] newValues = null;
        if (null == values) {
            newValues = new Object[1];
        } else {
            newValues = new Object[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = values[i];
            }
        }
        newValues[newValues.length - 1] = OwStandardObjectClass.createInitialNullValue(field.getFieldDefinition(), true);
        field.setValue(newValues);
    }

    protected int calculateFieldSize(OwFieldDefinition fieldDef_p) throws Exception {
        return 32;
    }

    private String createDisplayValue(String id_p, String errorFieldId_p, Object value_p, OwFieldDefinition fieldDef_p) throws OwFieldManagerException {
        String displayedValue = null;
        if (id_p == null || !this.isErrorField(errorFieldId_p) && !this.isErrorContainment(errorFieldId_p)) {
            displayedValue = "";
            if (value_p != null) {
                if (value_p instanceof Number) {
                    try {
                        displayedValue = this.m_numberFormat.format(value_p);
                    }
                    catch (IllegalArgumentException e) {
                        String errMessage = this.getContext().localize("app.OwNumberFieldControl.invalidfield", "Invalid number field : ") + fieldDef_p.getClass();
                        LOG.error((Object)("OwNumberFieldControl.createDisplayValue : invalid field value ( it cloud not be formated, not a number maybe? ) - " + fieldDef_p.getClassName()), (Throwable)e);
                        throw new OwFieldManagerException(errMessage, (Throwable)e);
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.error((Object)("OwNumberFieldControl.createDisplayValue : forced to display an invalid field value of class " + value_p.getClass() + " when a java.lang.Number was expected for filed " + fieldDef_p.getClassName() + " !"));
                    }
                    displayedValue = value_p.toString();
                }
            }
        } else {
            if (id_p != null && !this.isComplexChildId(id_p)) {
                OwAppContext context = this.getContext();
                HttpServletRequest request = context.getHttpRequest();
                displayedValue = request.getParameter(errorFieldId_p);
            }
            if (displayedValue == null) {
                displayedValue = "";
            }
        }
        return displayedValue;
    }

    protected String getValueIndexTitle(String strID_p) {
        String[] idElements = strID_p.split("_");
        StringBuffer valueIndexInformation = new StringBuffer();
        if (idElements.length > 1) {
            for (int i = 1; i < idElements.length; ++i) {
                int index = -1;
                try {
                    index = Integer.parseInt(idElements[i]);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("OwStandardFieldManager.getValueIndexTitle(): Invalid indexed field ID component string : " + idElements[i]));
                }
                if (i == idElements.length - 1) {
                    valueIndexInformation.insert(0, this.getContext().localize1("app.OwStandardFieldManager.field.value.top.index", " - indexed value number %1 ", "" + (index + 1)));
                    continue;
                }
                valueIndexInformation.insert(0, this.getContext().localize1("app.OwStandardFieldManager.field.value.sub.index", " of  sub-indexed value number %1 ", "" + (index + 1)));
            }
        }
        return valueIndexInformation.toString();
    }

    protected void insertSingleEditField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p, String id_p, String errorFieldId_p) throws Exception {
        w_p.write("<input name=\"");
        w_p.write(id_p);
        w_p.write("\" id=\"");
        w_p.write(id_p);
        w_p.write("\" title=\"");
        OwHTMLHelper.writeSecureHTML(w_p, fieldDef_p.getDescription(this.getContext().getLocale()));
        OwHTMLHelper.writeSecureHTML(w_p, this.getValueIndexTitle(id_p));
        w_p.write("\" type=\"text\" value=\"");
        w_p.write(this.createDisplayValue(id_p, errorFieldId_p, value_p, fieldDef_p));
        w_p.write("\" maxlength=\"");
        w_p.write(Integer.toString(this.calculateFieldSize(fieldDef_p)));
        w_p.write("\" class=\"OwInputControl OwInputControlNumber OwInputControlNumber_");
        w_p.write(fieldDef_p.getClassName());
        w_p.write("\" onblur=\"onFieldManagerFieldExit('");
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getClassName()));
        w_p.write("', '");
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(fieldDef_p.getJavaClassName()));
        w_p.write("', '");
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(Integer.toString(this.getFieldManager().getFieldProvider().getFieldProviderType())));
        w_p.write("', '");
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(this.getFieldManager().getFieldProvider().getFieldProviderName()));
        w_p.write("', '");
        OwHTMLHelper.writeSecureHTML(w_p, OwHTMLHelper.encodeJavascriptString(id_p));
        w_p.write("', this.value)\" />");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        if (fieldDef_p.isArray()) {
            if (value_p == null) {
                value_p = new Object[]{};
            }
            if (!value_p.getClass().isArray()) {
                String errMessage = this.getContext().localize("app.OwNumberFieldControl.invalidfield", "Invalid number field : ") + fieldDef_p.getClass();
                LOG.error((Object)("OwNumberFieldControl.insertEditField : non array value found for an array based field - " + fieldDef_p.getClassName()));
                throw new OwFieldManagerException(errMessage);
            }
            Object[] values = value_p;
            boolean fDelimiter = false;
            for (int i = 0; i < values.length; ++i) {
                if (fDelimiter) {
                    w_p.write("<div style=\"clear:left;padding-top:2px\">");
                    w_p.write("<hr class=\"OwStandardFieldManager_Array\">");
                    w_p.write("</div>");
                }
                this.insertSingleReadOnlyField(w_p, fieldDef_p, null, values[i]);
                fDelimiter = true;
            }
            return;
        } else {
            this.insertSingleReadOnlyField(w_p, fieldDef_p, null, value_p);
        }
    }

    public void insertSingleReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, String id_p, Object value_p) throws Exception {
        String displayValue = this.createDisplayValue(id_p, id_p, value_p, fieldDef_p);
        OwHTMLHelper.writeSecureHTML(w_p, displayValue, true);
    }

    @Override
    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        if (fieldDef_p.isArray()) {
            int i;
            if (value_p == null) {
                return null;
            }
            Object[] values = (Object[])value_p;
            Object[] result = new Object[values.length];
            for (i = 0; i < values.length; ++i) {
                result[i] = this.updateSingleField(request_p, fieldDef_p, values[i], strID_p + "_" + String.valueOf(i), true);
            }
            for (i = 0; i < values.length; ++i) {
                String fieldID = strID_p + "_" + i;
                if (!this.isErrorField(fieldID)) continue;
                this.setFieldManagerError(strID_p, this.getFieldError(fieldID));
                break;
            }
            return result;
        }
        Object updatedValue = this.updateSingleField(request_p, fieldDef_p, value_p, strID_p, true);
        if (this.isErrorField(strID_p)) {
            this.setFieldManagerError(strID_p, this.getFieldError(strID_p));
        }
        return updatedValue;
    }

    protected boolean isComplexChildId(String strID_p) {
        String externalDelimiter = this.getExternalComplexFieldIdDelimiter();
        int index = strID_p.indexOf(externalDelimiter);
        if (index < 0) {
            return false;
        }
        return (index = strID_p.indexOf(externalDelimiter, index + externalDelimiter.length())) > -1;
    }

    protected void setFieldManagerError(String strID_p, String error_p) {
        String fieldId = strID_p;
        if (this.isComplexChildId(strID_p)) {
            int firstDelimiterIndex = strID_p.indexOf(this.getExternalComplexFieldIdDelimiter());
            fieldId = strID_p.substring(0, firstDelimiterIndex);
        }
        OwField field = this.getFieldManager().getField(fieldId);
        this.getFieldManager().setFieldError(field, error_p);
    }

    protected String getExternalComplexFieldIdDelimiter() {
        return "_";
    }

    protected String createParseIndexedError(String numberString_p, int index_p) {
        if (numberString_p != null && numberString_p.length() > index_p) {
            String errorCharString = "" + numberString_p.charAt(index_p);
            String error = this.getContext().localize1("app.OwStandardFieldManager.invalidnumbervalue.withPosition", "Please insert a number. Char '%1' is wrong.", errorCharString);
            return error;
        }
        return this.getContext().localize("app.OwStandardFieldManager.invalidnumbervalue", "Please insert a number.");
    }

    protected Number validateNumber(String id_p, Number value_p, OwFieldDefinition fieldDef_p, boolean updateErrors_p) throws Exception {
        OwFieldManager fManager;
        OwFieldProvider fProvider;
        String error;
        OwFormat format;
        if (value_p instanceof Comparable) {
            Comparable comparableValue = (Comparable)((Object)value_p);
            Object maxValue = fieldDef_p.getMaxValue();
            if (maxValue != null && maxValue instanceof Number && comparableValue.compareTo(maxValue) > 0) {
                if (updateErrors_p) {
                    this.setInternalFieldError(id_p, this.getContext().localize1("app.OwStandardFieldManager.invalidmax", "Value must be below (%1).", maxValue.toString()));
                }
                return null;
            }
            Object minValue = fieldDef_p.getMinValue();
            if (minValue != null && minValue instanceof Number && comparableValue.compareTo(minValue) < 0) {
                if (updateErrors_p) {
                    this.setInternalFieldError(id_p, this.getContext().localize1("app.OwStandardFieldManager.invalidmin", "Value must be greater than (%1).", minValue.toString()));
                }
                return null;
            }
        }
        if ((format = fieldDef_p.getFormat()) != null && format.canValidate() && (error = format.validate((fProvider = (fManager = this.getFieldManager()).getFieldProvider()).getFieldProviderType(), value_p, this.getContext().getLocale())) != null) {
            if (updateErrors_p) {
                this.setInternalFieldError(id_p, error);
            }
            return null;
        }
        return value_p;
    }

    protected final void setInternalFieldError(String id_p, String error_p) {
        if (this.m_updateErrorFields.get(id_p) == null) {
            this.addContainmentError(id_p, 1);
        }
        this.m_updateErrorFields.put(id_p, error_p);
    }

    protected final void addContainmentError(String id_p, int errCount_p) {
        int count = this.fieldContainmentCount(id_p);
        this.m_containerFieldErrorCounts.put(this.fieldContainmentId(id_p), count + errCount_p);
    }

    protected final void clearFieldError(String id_p) throws Exception {
        if (id_p != null) {
            if (this.m_updateErrorFields.containsKey(id_p) && this.m_updateErrorFields.get(id_p) != null) {
                this.addContainmentError(id_p, -1);
            }
            this.m_updateErrorFields.remove(id_p);
        }
    }

    protected final void markArrayItemErrorForClear(String id_p, String fieldId_p, int index_p, int arraySize_p) throws Exception {
        if (id_p != null) {
            if (this.m_updateErrorFields.containsKey(id_p) && this.m_updateErrorFields.get(id_p) != null) {
                this.addContainmentError(id_p, -1);
            }
            this.m_updateErrorFields.put(id_p, null);
            this.m_clearMarkedArraySizes.put(id_p, new Object[]{fieldId_p, index_p, arraySize_p});
        }
    }

    protected final void clearMarkedArrayItemErrors() throws Exception {
        Set entries = this.m_clearMarkedArraySizes.entrySet();
        for (Map.Entry entry : entries) {
            String id = (String)entry.getKey();
            this.m_updateErrorFields.remove(id);
            Object[] markData = (Object[])entry.getValue();
            String fieldId = (String)markData[0];
            Integer index = (Integer)markData[1];
            Integer arraySize = (Integer)markData[2];
            int intIndex = index;
            int intSize = arraySize;
            for (int j = intIndex + 1; j < intSize; ++j) {
                String itemId = fieldId + "_" + j;
                if (!this.m_updateErrorFields.containsKey(itemId)) continue;
                Object error = this.m_updateErrorFields.get(itemId);
                String prevItemId = fieldId + "_" + j;
                this.m_updateErrorFields.put(prevItemId, error);
                this.m_updateErrorFields.remove(itemId);
            }
        }
        this.m_clearMarkedArraySizes.clear();
    }

    protected final boolean isErrorField(String id_p) {
        return this.m_updateErrorFields.containsKey(id_p) && this.m_updateErrorFields.get(id_p) != null;
    }

    protected final String fieldContainmentId(String id_p) {
        String containingField = id_p;
        if (containingField.indexOf("_") > -1 && !this.isComplexChildId(id_p)) {
            containingField = containingField.substring(0, containingField.indexOf("_"));
        }
        return containingField;
    }

    protected final int fieldContainmentCount(String id_p) {
        Integer count;
        String containingField = this.fieldContainmentId(id_p);
        if (containingField.indexOf("_") > -1) {
            containingField = containingField.substring(0, containingField.indexOf("_"));
        }
        if ((count = (Integer)this.m_containerFieldErrorCounts.get(containingField)) != null) {
            return count;
        }
        return 0;
    }

    protected final boolean isErrorContainment(String id_p) {
        return this.fieldContainmentCount(id_p) > 0;
    }

    protected final boolean isMarkedForClear(String id_p) {
        return this.m_updateErrorFields.containsKey(id_p) && this.m_updateErrorFields.get(id_p) == null;
    }

    protected final String getFieldError(String id_p) {
        return this.isErrorField(id_p) ? (String)this.m_updateErrorFields.get(id_p) : "NO ERROR";
    }

    public Object updateSingleField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p, boolean updateErrors_p) throws Exception {
        String numberString = request_p.getParameter(strID_p);
        if (numberString == null) {
            return value_p;
        }
        if (numberString.length() > 0) {
            String trimmedNumberString = numberString.trim();
            ParsePosition position = new ParsePosition(0);
            Number numberValue = this.m_numberFormat.parse(trimmedNumberString, position);
            if (position.getErrorIndex() > -1) {
                if (updateErrors_p) {
                    this.setInternalFieldError(strID_p, this.createParseIndexedError(numberString, position.getErrorIndex()));
                }
                return value_p;
            }
            if (this.m_acceptPartialParse || !this.m_acceptPartialParse && position.getIndex() == trimmedNumberString.length()) {
                Number typeEnforcedNumber;
                Number validValue;
                if (updateErrors_p) {
                    this.clearFieldError(strID_p);
                }
                if ((validValue = this.validateNumber(strID_p, typeEnforcedNumber = this.tryToEnforceNumberType(numberValue, fieldDef_p), fieldDef_p, updateErrors_p)) != null) {
                    return validValue;
                }
                return value_p;
            }
            if (updateErrors_p) {
                this.setInternalFieldError(strID_p, this.createParseIndexedError(numberString, position.getIndex()));
            }
            return value_p;
        }
        if (updateErrors_p) {
            this.clearFieldError(strID_p);
        }
        return null;
    }

    private Number tryToEnforceNumberType(Number numberValue_p, OwFieldDefinition fieldDefinition_p) {
        String javaClassName = fieldDefinition_p.getJavaClassName();
        try {
            Class<?> expectedNumberClass = Class.forName(javaClassName);
            if (Number.class.isAssignableFrom(expectedNumberClass)) {
                Class<?> valueClass = numberValue_p.getClass();
                if (expectedNumberClass.isAssignableFrom(valueClass)) {
                    return numberValue_p;
                }
                if (expectedNumberClass.equals(Integer.class)) {
                    return this.tryToEnforceInteger(numberValue_p);
                }
                if (expectedNumberClass.equals(Long.class)) {
                    return this.tryToEnforceLong(numberValue_p);
                }
                if (expectedNumberClass.equals(Double.class)) {
                    return this.tryToEnforceDouble(numberValue_p);
                }
                if (expectedNumberClass.equals(Float.class)) {
                    return this.tryToEnforceFloat(numberValue_p);
                }
                if (expectedNumberClass.equals(BigInteger.class)) {
                    return this.tryToEnforceBigInteger(numberValue_p);
                }
                if (expectedNumberClass.equals(BigDecimal.class)) {
                    return this.tryToEnforceBigDecimal(numberValue_p);
                }
                return numberValue_p;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)"OwNumberFieldControl.tryToEnforceNumberType: ClassNotFoundException", (Throwable)e);
        }
        return null;
    }

    private boolean isNaturalIntegerClass(Class aClass_p) {
        return Integer.class.equals((Object)aClass_p) || Long.class.equals((Object)aClass_p) || Byte.class.equals((Object)aClass_p);
    }

    private boolean isRationalNumberClass(Class aClass_p) {
        return this.isNaturalIntegerClass(aClass_p) || Double.class.equals((Object)aClass_p) || Float.class.equals((Object)aClass_p);
    }

    private Number tryToEnforceInteger(Number number_p) {
        Class<?> numberClass = number_p.getClass();
        if (this.isNaturalIntegerClass(numberClass) && Integer.MAX_VALUE >= number_p.longValue() && Integer.MIN_VALUE <= number_p.longValue()) {
            int intNumber = number_p.intValue();
            return intNumber;
        }
        return number_p;
    }

    private Number tryToEnforceLong(Number number_p) {
        Class<?> numberClass = number_p.getClass();
        if (this.isNaturalIntegerClass(numberClass)) {
            long longNumber = number_p.longValue();
            return longNumber;
        }
        return number_p;
    }

    private Number tryToEnforceDouble(Number number_p) {
        Class<?> numberClass = number_p.getClass();
        if (this.isRationalNumberClass(numberClass)) {
            double doubleNumber = number_p.doubleValue();
            return new Double(doubleNumber);
        }
        return number_p;
    }

    private Number tryToEnforceFloat(Number number_p) {
        Class<?> numberClass = number_p.getClass();
        if (this.isRationalNumberClass(numberClass) && 3.4028234663852886E38 >= number_p.doubleValue() && (double)1.4E-45f <= number_p.doubleValue()) {
            float floatNumber = number_p.floatValue();
            return new Float(floatNumber);
        }
        return number_p;
    }

    private Number tryToEnforceBigInteger(Number number_p) {
        Class<?> numberClass = number_p.getClass();
        if (this.isNaturalIntegerClass(numberClass)) {
            long longNumber = number_p.longValue();
            return BigInteger.valueOf(longNumber);
        }
        return number_p;
    }

    private Number tryToEnforceBigDecimal(Number number_p) {
        Class<?> numberClass = number_p.getClass();
        if (this.isNaturalIntegerClass(numberClass)) {
            long longNumber = number_p.longValue();
            BigInteger bigInt = BigInteger.valueOf(longNumber);
            return new BigDecimal(bigInt);
        }
        if (this.isRationalNumberClass(numberClass)) {
            double doubleNumber = number_p.doubleValue();
            return new BigDecimal("" + doubleNumber);
        }
        return number_p;
    }

    @Override
    public void init(OwFieldManager fieldmanager_p, Node configNode_p) throws Exception {
        super.init(fieldmanager_p, configNode_p);
        OwStandardXMLUtil configUtil = new OwStandardXMLUtil(configNode_p);
        NumberFormat defaultLocaleFormat = NumberFormat.getInstance();
        String numberFormatString = configUtil.getSafeTextValue(NUMBER_FORMAT_ELEMENT, "");
        if (numberFormatString.length() == 0) {
            this.m_numberFormat = defaultLocaleFormat;
        } else {
            OwAppContext context = fieldmanager_p.getContext();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(context.getLocale());
            this.m_numberFormat = new DecimalFormat(numberFormatString, symbols);
        }
    }
}

