/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldimpl;

import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OwSearchNodeFilter {
    private int mask;
    private boolean nonProp;

    public OwSearchNodeFilter(int filterMask) {
        this.setFilter(filterMask);
    }

    public OwSearchNodeFilter() {
    }

    public void setFilter(int filterMask) {
        this.mask = 0;
        if (0 != (1 & filterMask)) {
            this.mask |= 1;
        }
        if (0 != (4 & filterMask)) {
            this.mask |= 2;
        }
        this.nonProp = 0 != (2 & filterMask);
    }

    public boolean filterNonProperties() {
        return this.nonProp;
    }

    protected boolean match(OwSearchCriteria crit) {
        return (crit.getAttributes() & this.mask) != 0;
    }

    public Map<String, OwSearchCriteria> getCriteriaMap(OwSearchNode node) {
        MapContainer cont = new MapContainer();
        this.traverseNode(cont, node);
        Object results = cont.getResults();
        cont.clean();
        return results;
    }

    public List<OwSearchCriteria> getCriteriaList(OwSearchNode node) {
        ListContainer cont = new ListContainer();
        this.traverseNode(cont, node);
        Object results = cont.getResults();
        cont.clean();
        return results;
    }

    private void traverseNode(ResultContainer<?> v, OwSearchNode node) {
        List childs;
        OwSearchCriteria crit = node.getCriteria();
        if (crit != null && !this.match(crit)) {
            v.add(crit);
        }
        if (!(node.getNodeType() != 1 && node.getNodeType() != 5 && this.filterNonProperties() || (childs = node.getChilds()) == null)) {
            Iterator it = childs.iterator();
            while (it.hasNext()) {
                this.traverseNode(v, (OwSearchNode)it.next());
            }
        }
    }

    private class ListContainer
    implements ResultContainer<List<OwSearchCriteria>> {
        private LinkedList<OwSearchCriteria> results = new LinkedList();

        @Override
        public void add(OwSearchCriteria crit) {
            this.results.add(crit);
        }

        @Override
        public List<OwSearchCriteria> getResults() {
            return this.results;
        }

        @Override
        public void clean() {
            this.results = null;
        }
    }

    private class MapContainer
    implements ResultContainer<HashMap<String, OwSearchCriteria>> {
        private HashMap<String, OwSearchCriteria> results = new HashMap();

        @Override
        public void add(OwSearchCriteria crit) {
            this.results.put(crit.getUniqueName(), crit);
        }

        @Override
        public HashMap<String, OwSearchCriteria> getResults() {
            return this.results;
        }

        @Override
        public void clean() {
            this.results = null;
        }
    }

    private static interface ResultContainer<T> {
        public void add(OwSearchCriteria var1);

        public T getResults();

        public void clean();
    }
}

