/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.fieldimpl.filter;

import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.fieldimpl.filter.OwAbstractComparator;
import java.util.Calendar;
import java.util.Date;

public class OwDateComparator
extends OwAbstractComparator<Date> {
    @Override
    protected boolean matchBetween(OwSearchCriteria filter, Date value) {
        Date val = (Date)filter.getValue();
        Date val2 = (Date)filter.getSecondRangeCriteria().getValue();
        if (val == null || val2 == null || value == null) {
            return false;
        }
        long filterVal = this.getSpecificValue(filter, val);
        long filterVal2 = this.getSpecificValue(filter, val2);
        long longValue = this.getSpecificValue(filter, value);
        return filterVal <= longValue && longValue <= filterVal2;
    }

    @Override
    protected boolean matchLessEquals(OwSearchCriteria filter, Date value) {
        Date val = (Date)filter.getValue();
        if (val == null || value == null) {
            return false;
        }
        long filterVal = this.getSpecificValue(filter, val);
        return this.getSpecificValue(filter, value) <= filterVal;
    }

    @Override
    protected boolean matchGreaterEquals(OwSearchCriteria filter, Date value) {
        Date val = (Date)filter.getValue();
        if (val == null || value == null) {
            return false;
        }
        long filterVal = this.getSpecificValue(filter, val);
        return this.getSpecificValue(filter, value) >= filterVal;
    }

    @Override
    protected boolean matchLess(OwSearchCriteria filter, Date value) {
        Date val = (Date)filter.getValue();
        if (val == null || value == null) {
            return false;
        }
        long filterVal = this.getSpecificValue(filter, val);
        return this.getSpecificValue(filter, value) < filterVal;
    }

    @Override
    protected boolean matchGreater(OwSearchCriteria filter, Date value) {
        Date val = (Date)filter.getValue();
        if (val == null || value == null) {
            return false;
        }
        long filterVal = this.getSpecificValue(filter, val);
        return this.getSpecificValue(filter, value) > filterVal;
    }

    @Override
    protected boolean matchLike(OwSearchCriteria filter, Date value) {
        return false;
    }

    @Override
    protected boolean matchEquals(OwSearchCriteria filter, Date value) {
        Date val = (Date)filter.getValue();
        if (val == null || value == null) {
            return false;
        }
        long filterVal = this.getSpecificValue(filter, val);
        return filterVal == this.getSpecificValue(filter, value);
    }

    private long getSpecificValue(OwSearchCriteria filter, Date value) {
        Calendar ret = Calendar.getInstance();
        ret.setTimeInMillis(value.getTime());
        if (filter.ignoreTime()) {
            ret.add(14, -1 * ret.get(14));
            ret.add(13, -1 * ret.get(13));
            ret.add(12, -1 * ret.get(12));
            ret.add(11, -1 * ret.get(11));
        } else if (filter.ignoreDate()) {
            ret.set(6, 1);
            ret.clear(1);
        }
        return ret.getTimeInMillis();
    }
}

