/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.history;

import com.wewebu.ow.server.ecm.OwClass;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.event.OwEvent;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardEnumCollection;
import com.wewebu.ow.server.field.OwStandardLocalizeableEnum;
import com.wewebu.ow.server.history.OwHistoryAnnotationEvent;
import com.wewebu.ow.server.history.OwHistoryManager;
import com.wewebu.ow.server.history.OwHistoryManagerContext;
import com.wewebu.ow.server.history.OwHistoryObjectChangeEvent;
import com.wewebu.ow.server.history.OwHistoryObjectCreateEvent;
import com.wewebu.ow.server.history.OwHistoryPropertyChangeEvent;
import com.wewebu.ow.server.history.OwSessionHistoryDeleteEvent;
import com.wewebu.ow.server.history.OwSessionHistoryEntry;
import com.wewebu.ow.server.history.OwTouchConfiguration;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OwStandardHistoryManager
implements OwHistoryManager {
    private OwTouchConfiguration m_inMemoryConfiguration = new OwTouchConfiguration(false);
    private Map<String, List<OwSessionHistoryEntry>> m_eventTypeSessionEntries = new HashMap<String, List<OwSessionHistoryEntry>>();
    private Map<String, List<OwSessionHistoryEntry>> m_eventIdSessionEntries = new HashMap<String, List<OwSessionHistoryEntry>>();
    private Map<String, List<OwSessionHistoryEntry>> m_eventTypeAndIdSessionEntries = new HashMap<String, List<OwSessionHistoryEntry>>();
    private static OwEventIDDisplayStrings m_EventIDDisplayNames = new OwEventIDDisplayStrings();
    private static OwEventTypeDisplayNames m_EventTypeDisplayNames = new OwEventTypeDisplayNames();
    private static OwEventStatusDisplayNames m_StatusDisplayNames = new OwEventStatusDisplayNames();
    private OwXMLUtil m_ConfigNode;
    private OwHistoryManagerContext m_MainContext;
    private OwNetwork m_network;

    public static void addEventIDDisplayString(String id_p, OwString displaystring_p) {
        m_EventIDDisplayNames.addDisplayString(id_p, displaystring_p);
    }

    public static String getEventIDDisplayName(Locale locale_p, String strEventID_p) {
        return m_EventIDDisplayNames.getDisplayName(locale_p, strEventID_p);
    }

    public static Collection getEventIDs() {
        return m_EventIDDisplayNames.getEventIDs();
    }

    public static OwEnumCollection getEventTypeEnum() {
        return m_EventTypeDisplayNames.getEnum();
    }

    public static OwEnumCollection getEventStatusEnum() {
        return m_StatusDisplayNames.getEnum();
    }

    protected OwXMLUtil getConfigNode() {
        return this.m_ConfigNode;
    }

    public OwHistoryManagerContext getContext() {
        return this.m_MainContext;
    }

    @Override
    public void init(OwHistoryManagerContext mainContext_p, OwXMLUtil configNode_p) throws Exception {
        this.m_MainContext = mainContext_p;
        this.m_ConfigNode = configNode_p;
        Locale locale = this.m_MainContext.getLocale();
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        this.m_inMemoryConfiguration.init(this.m_ConfigNode.getSubNode("SessionEvents"), locale);
    }

    @Override
    public void setNetwork(OwNetwork network_p) {
        this.m_network = network_p;
    }

    public OwNetwork getNetwork() {
        return this.m_network;
    }

    @Override
    public OwObjectCollection doObjectSearch(OwObjectReference object_p, OwSearchNode filterCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int[] includeSubObjectTypes_p, int maxSize_p) throws Exception {
        Object value;
        Map criteriaMap;
        OwSearchCriteria mainCriteria;
        OwStandardObjectCollection result = null;
        if (this.m_inMemoryConfiguration.isTouchConfigurationInitialized() && object_p != null && filterCriteria_p != null && (mainCriteria = (OwSearchCriteria)(criteriaMap = filterCriteria_p.getCriteriaMap(0)).get("OwClassSelectObject")) != null && (value = mainCriteria.getValue()) != null) {
            OwClass selectionClass = null;
            if (value.getClass().isArray()) {
                Object[] valueAsArray = (Object[])value;
                OwClass owClass = selectionClass = valueAsArray.length > 0 ? (OwClass)valueAsArray[0] : null;
            }
            if (selectionClass != null && selectionClass.getClassName().equals(OwSessionHistoryEntry.getStaticObjectClass().getClassName())) {
                OwSearchCriteria eventIdCriteria;
                result = new OwStandardObjectCollection();
                Integer eventTypeAsInteger = null;
                String eventId = null;
                OwSearchCriteria eventTypeCriteria = (OwSearchCriteria)criteriaMap.get("OW_HIST_Type");
                if (eventTypeCriteria != null) {
                    if (eventTypeCriteria.getOperator() != 4) {
                        throw new OwInvalidOperationException("Only search for exact match is allowed");
                    }
                    eventTypeAsInteger = (Integer)eventTypeCriteria.getValue();
                }
                if ((eventIdCriteria = (OwSearchCriteria)criteriaMap.get("OW_HIST_ID")) != null) {
                    if (eventIdCriteria.getOperator() != 4) {
                        throw new OwInvalidOperationException("Only search for exact match is allowed");
                    }
                    eventId = (String)eventIdCriteria.getValue();
                }
                String key = null;
                Map<String, List<OwSessionHistoryEntry>> searchMap = null;
                if (eventId == null) {
                    if (eventTypeAsInteger != null) {
                        key = object_p.getDMSID() + String.valueOf(eventTypeAsInteger);
                        searchMap = this.m_eventTypeSessionEntries;
                    }
                } else if (eventTypeAsInteger == null) {
                    key = this.createDmsidEventIdKey(eventId, object_p.getDMSID());
                    searchMap = this.m_eventIdSessionEntries;
                } else {
                    key = this.createDmsidEventTypeEventIdKey(eventTypeAsInteger, eventId, object_p.getDMSID());
                    searchMap = this.m_eventTypeAndIdSessionEntries;
                }
                if (searchMap != null) {
                    List partialResult = (List)searchMap.get(key);
                    if (partialResult != null) {
                        result.addAll(partialResult);
                    }
                    String filteringKey = null;
                    searchMap = null;
                    if (this.m_inMemoryConfiguration.isGenericEventId(eventId) && this.m_inMemoryConfiguration.isGenericEventType(eventTypeAsInteger)) {
                        filteringKey = object_p.getDMSID();
                        searchMap = this.m_eventTypeAndIdSessionEntries;
                    } else if (this.m_inMemoryConfiguration.isGenericEventId(eventId) && !this.m_inMemoryConfiguration.isGenericEventType(eventTypeAsInteger)) {
                        if (eventTypeAsInteger == null) {
                            filteringKey = object_p.getDMSID();
                            searchMap = this.m_eventIdSessionEntries;
                        } else {
                            filteringKey = this.createDmsidEventTypeKey(eventTypeAsInteger, object_p.getDMSID());
                            searchMap = this.m_eventTypeSessionEntries;
                        }
                    } else if (!this.m_inMemoryConfiguration.isGenericEventId(eventId) && this.m_inMemoryConfiguration.isGenericEventType(eventTypeAsInteger)) {
                        if (eventId == null) {
                            filteringKey = object_p.getDMSID();
                            searchMap = this.m_eventTypeSessionEntries;
                        } else {
                            filteringKey = this.createDmsidEventIdKey(eventId, object_p.getDMSID());
                            searchMap = this.m_eventIdSessionEntries;
                        }
                    }
                    if (filteringKey != null && searchMap != null) {
                        this.addEntriesToResultForDMSID(result, searchMap, filteringKey);
                    }
                }
            }
        }
        return result;
    }

    private void addEntriesToResultForDMSID(OwObjectCollection result_p, Map<String, List<OwSessionHistoryEntry>> searchMap_p, String filteringKey_p) {
        for (Map.Entry<String, List<OwSessionHistoryEntry>> entry : searchMap_p.entrySet()) {
            String toBeComparedKey = entry.getKey();
            if (!toBeComparedKey.startsWith(filteringKey_p)) continue;
            result_p.addAll((Collection)entry.getValue());
        }
    }

    @Override
    public void addEvent(int eventType_p, String strEventID_p, OwEvent event_p, int status_p) throws Exception {
        if (this.m_inMemoryConfiguration.isTouchConfigurationInitialized() && status_p == 1) {
            boolean isConfigured = false;
            isConfigured = strEventID_p == null ? this.m_inMemoryConfiguration.isConfigured(eventType_p) : this.m_inMemoryConfiguration.isConfigured(eventType_p, strEventID_p);
            if (isConfigured) {
                if (11 == eventType_p) {
                    this.clearSessionEvents(event_p);
                } else {
                    List dmsIDs = this.getDMSIdsFromEvent(event_p);
                    for (String dmsID : dmsIDs) {
                        String keyDmsidEventType = this.createDmsidEventTypeKey(eventType_p, dmsID);
                        String keyDmsIdEventId = this.createDmsidEventIdKey(strEventID_p, dmsID);
                        String keyDmsIdEventTypeEventId = this.createDmsidEventTypeEventIdKey(eventType_p, strEventID_p, dmsID);
                        OwSessionHistoryEntry historyEntry = new OwSessionHistoryEntry(this.getContext(), new Date(), strEventID_p, eventType_p, status_p, event_p.getSummary(), this.getNetwork().getCredentials().getUserInfo().getUserID());
                        this.saveHistoryEntry(historyEntry, eventType_p, strEventID_p, event_p, status_p, keyDmsidEventType, this.m_eventTypeSessionEntries);
                        this.saveHistoryEntry(historyEntry, eventType_p, strEventID_p, event_p, status_p, keyDmsIdEventId, this.m_eventIdSessionEntries);
                        this.saveHistoryEntry(historyEntry, eventType_p, strEventID_p, event_p, status_p, keyDmsIdEventTypeEventId, this.m_eventTypeAndIdSessionEntries);
                    }
                }
            }
        }
    }

    private void clearSessionEvents(OwEvent event_p) throws Exception {
        List dmsIds = this.getDMSIdsFromEvent(event_p);
        for (String dmsId : dmsIds) {
            this.clearSessionEventsFromMap(dmsId, this.m_eventIdSessionEntries);
            this.clearSessionEventsFromMap(dmsId, this.m_eventTypeAndIdSessionEntries);
            this.clearSessionEventsFromMap(dmsId, this.m_eventTypeSessionEntries);
        }
    }

    private void clearSessionEventsFromMap(String dmsId_p, Map<String, List<OwSessionHistoryEntry>> sessionEntries_p) {
        Set<String> keyset = sessionEntries_p.keySet();
        Iterator<String> keysIterator = keyset.iterator();
        while (keysIterator.hasNext()) {
            String key = keysIterator.next();
            if (!key.startsWith(dmsId_p)) continue;
            keysIterator.remove();
        }
    }

    private String createDmsidEventTypeEventIdKey(int eventType_p, String strEventID_p, String dmsID_p) {
        return dmsID_p + String.valueOf(eventType_p) + strEventID_p;
    }

    private String createDmsidEventIdKey(String strEventID_p, String dmsID_p) {
        return dmsID_p + strEventID_p;
    }

    private String createDmsidEventTypeKey(int eventType_p, String dmsID_p) {
        return dmsID_p + String.valueOf(eventType_p);
    }

    private void saveHistoryEntry(OwSessionHistoryEntry historyEntry_p, int eventType_p, String strEventID_p, OwEvent event_p, int status_p, String key_p, Map<String, List<OwSessionHistoryEntry>> sessionEntriesMap_p) throws Exception {
        List<OwSessionHistoryEntry> availableEntries = sessionEntriesMap_p.get(key_p);
        if (availableEntries == null) {
            availableEntries = new ArrayList<OwSessionHistoryEntry>();
        }
        availableEntries.add(historyEntry_p);
        sessionEntriesMap_p.put(key_p, availableEntries);
    }

    protected List getDMSIdsFromEvent(OwEvent event_p) throws Exception {
        LinkedList<String> affectedDMSids = new LinkedList<String>();
        if (event_p != null) {
            if (event_p instanceof OwHistoryAnnotationEvent) {
                OwHistoryAnnotationEvent event = (OwHistoryAnnotationEvent)event_p;
                if (event.getAffectedObject() != null) {
                    affectedDMSids.add(event.getAffectedObject().getDMSID());
                }
            } else if (event_p instanceof OwHistoryObjectChangeEvent) {
                OwHistoryObjectChangeEvent event = (OwHistoryObjectChangeEvent)event_p;
                Collection affectedObjects = event.getAffectedObjects();
                if (affectedObjects != null) {
                    for (OwObjectReference object : affectedObjects) {
                        affectedDMSids.add(object.getDMSID());
                    }
                }
            } else if (event_p instanceof OwHistoryObjectCreateEvent) {
                OwHistoryObjectCreateEvent event = (OwHistoryObjectCreateEvent)event_p;
                affectedDMSids.add(event.getDmsid());
            } else if (event_p instanceof OwHistoryPropertyChangeEvent) {
                OwHistoryPropertyChangeEvent event = (OwHistoryPropertyChangeEvent)event_p;
                if (event.getAffectedObject() != null) {
                    affectedDMSids.add(event.getAffectedObject().getDMSID());
                }
            } else if (event_p instanceof OwSessionHistoryDeleteEvent) {
                OwSessionHistoryDeleteEvent event = (OwSessionHistoryDeleteEvent)event_p;
                affectedDMSids.add(event.getAffectedDmsId());
            }
        }
        return affectedDMSids;
    }

    private static class OwEventStatusDisplayNames {
        private OwStandardEnumCollection m_enums = new OwStandardEnumCollection();

        public OwEventStatusDisplayNames() {
            this.m_enums.add(new OwStandardLocalizeableEnum(1, new OwString("event.OwEventManager.HISTORY_STATUS_OK", "OK")));
            this.m_enums.add(new OwStandardLocalizeableEnum(2, new OwString("event.OwEventManager.HISTORY_STATUS_FAILED", "Failed")));
            this.m_enums.add(new OwStandardLocalizeableEnum(3, new OwString("event.OwEventManager.HISTORY_STATUS_CANCEL", "Cancel")));
            this.m_enums.add(new OwStandardLocalizeableEnum(4, new OwString("event.OwEventManager.HISTORY_STATUS_BEGIN", "Begin")));
        }

        public OwEnumCollection getEnum() {
            return this.m_enums;
        }
    }

    private static class OwEventTypeDisplayNames {
        private OwStandardEnumCollection m_enums = new OwStandardEnumCollection();

        public OwEventTypeDisplayNames() {
            this.m_enums.add(new OwStandardLocalizeableEnum(10, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_GENERIC", "General")));
            this.m_enums.add(new OwStandardLocalizeableEnum(1, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_PLUGIN_INVOKE_UI", "User Interface")));
            this.m_enums.add(new OwStandardLocalizeableEnum(2, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_PLUGIN_INVOKE_VIEW", "View")));
            this.m_enums.add(new OwStandardLocalizeableEnum(3, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_PLUGIN_INVOKE_EDIT", "Edit")));
            this.m_enums.add(new OwStandardLocalizeableEnum(4, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_PLUGIN_DSPATCH", "Open")));
            this.m_enums.add(new OwStandardLocalizeableEnum(5, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_ECM", "ECM")));
            this.m_enums.add(new OwStandardLocalizeableEnum(6, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_OBJECT", "Object")));
            this.m_enums.add(new OwStandardLocalizeableEnum(7, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_PROPERTY", "Property")));
            this.m_enums.add(new OwStandardLocalizeableEnum(9, new OwString("event.OwEventManager.HISTORY_EVENT_TYPE_VERSION", "Version")));
        }

        public OwEnumCollection getEnum() {
            return this.m_enums;
        }
    }

    private static class OwEventIDDisplayStrings {
        private Map m_displaystrings = new HashMap();

        public OwEventIDDisplayStrings() {
            this.m_displaystrings.put("login", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_LOGIN", "Login"));
            this.m_displaystrings.put("logoff", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_LOGOFF", "Logout"));
            this.m_displaystrings.put("search", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_SEARCH", "Search"));
            this.m_displaystrings.put("newobject", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_NEW_OBJECT", "Create new object"));
            this.m_displaystrings.put("copyobject", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_COPY_OBJECT", "Copy object"));
            this.m_displaystrings.put("download", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_DOWNLOAD", "Download object content"));
            this.m_displaystrings.put("upload", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_UPLOAD", "Upload object content"));
            this.m_displaystrings.put("addobject", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_ADD", "Add object"));
            this.m_displaystrings.put("moveobject", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_MOVE", "Move object"));
            this.m_displaystrings.put("lockobject", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_LOCK", "Lock object"));
            this.m_displaystrings.put("removeref", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_REMOVE_REF", "Remove object reference"));
            this.m_displaystrings.put("delete", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_DELETE", "Delete object"));
            this.m_displaystrings.put("dispatch", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_DISPATCH", "Dispatch object"));
            this.m_displaystrings.put("returntosource", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_RETURN_TO_SOURCE", "Return to source"));
            this.m_displaystrings.put("resubmit", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_RESUBMIT", "Resubmit object"));
            this.m_displaystrings.put("modifyprops", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_MODIFY_PROPERTIES", "Modify object properties"));
            this.m_displaystrings.put("modifyperm", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_MODIFY_PERMISSIONS", "Modify object permissions"));
            this.m_displaystrings.put("checkout", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_CHECKOUT", "Check out object"));
            this.m_displaystrings.put("cancelcheckout", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_CANCELCHECKOUT", "Cancel check-out"));
            this.m_displaystrings.put("checkin", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_CHECKIN", "Check in object"));
            this.m_displaystrings.put("promote", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_PROMOTE", "Promote object"));
            this.m_displaystrings.put("demote", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_DEMOTE", "Demote object"));
            this.m_displaystrings.put("generic", new OwString("event.OwEventManager.idname.HISTORY_EVENT_ID_OBJECT_GENERIC", "Change object"));
        }

        public void addDisplayString(String id_p, OwString displaystring_p) {
            this.m_displaystrings.put(id_p, displaystring_p);
        }

        public String getDisplayName(Locale locale_p, String strEventID_p) {
            OwString displayname = (OwString)this.m_displaystrings.get(strEventID_p);
            if (displayname == null) {
                return strEventID_p;
            }
            return displayname.getString(locale_p);
        }

        public Collection getEventIDs() {
            return this.m_displaystrings.keySet();
        }
    }
}

