/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.history;

import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.history.OwHistoryModifiedPropertyValue;
import com.wewebu.ow.server.util.OwEscapedStringTokenizer;

public class OwStandardHistoryModifiedPropertyValue
implements OwHistoryModifiedPropertyValue {
    public static final String NULL_DISPLAY_VALUE = "<null>";
    private OwFieldDefinitionProvider m_fielddefprovider;
    private String m_className;
    private String m_oldValue;
    private String m_newValue;
    private String m_resource;
    private OwFieldDefinition m_fielddefinition;

    public OwStandardHistoryModifiedPropertyValue(String className_p, boolean isArray_p, String oldValue_p, String newValue_p, OwFieldDefinitionProvider fielddefprovider_p, String resource_p) {
        this.m_className = className_p;
        this.m_oldValue = oldValue_p;
        this.m_newValue = newValue_p;
        this.m_fielddefprovider = fielddefprovider_p;
        this.m_resource = resource_p;
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    @Override
    public OwFieldDefinition getFieldDefinition() throws OwObjectNotFoundException, Exception {
        if (null == this.m_fielddefinition) {
            if (null == this.m_fielddefprovider) {
                throw new OwObjectNotFoundException("OwStandardHistoryModifiedPropertyValue.getFieldDefinition: Missing fielddefprovider.");
            }
            this.m_fielddefinition = this.m_fielddefprovider.getFieldDefinition(this.getClassName(), this.m_resource);
        }
        return this.m_fielddefinition;
    }

    private Object getValueFromString(String stringvalue_p, OwFieldDefinition fielddefinition_p) throws Exception {
        if (null == stringvalue_p) {
            return null;
        }
        if (fielddefinition_p.isArray()) {
            return new OwEscapedStringTokenizer(stringvalue_p).toCollection().toArray();
        }
        return fielddefinition_p.getValueFromString(stringvalue_p);
    }

    @Override
    public OwField getOldValue() throws OwObjectNotFoundException, Exception {
        OwFieldDefinition fielddefinition = this.getFieldDefinition();
        return new OwModifiedField(this.getValueFromString(this.getOldValueString(), fielddefinition), fielddefinition);
    }

    @Override
    public OwField getNewValue() throws OwObjectNotFoundException, Exception {
        OwFieldDefinition fielddefinition = this.getFieldDefinition();
        return new OwModifiedField(this.getValueFromString(this.getNewValueString(), fielddefinition), fielddefinition);
    }

    @Override
    public String getOldValueString() {
        return this.m_oldValue;
    }

    @Override
    public String getNewValueString() {
        return this.m_newValue;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getClassName());
        ret.append(": ");
        if (this.getOldValueString() == null) {
            ret.append(NULL_DISPLAY_VALUE);
        } else {
            ret.append(this.getOldValueString());
        }
        ret.append(" > ");
        if (this.getNewValueString() == null) {
            ret.append(NULL_DISPLAY_VALUE);
        } else {
            ret.append(this.getNewValueString());
        }
        return ret.toString();
    }

    public static class OwModifiedField
    implements OwField {
        private OwFieldDefinition m_fielddefinition;
        private Object m_value;

        public OwModifiedField(Object value_p, OwFieldDefinition fieldDefinition_p) {
            this.m_fielddefinition = fieldDefinition_p;
            this.m_value = value_p;
        }

        @Override
        public OwFieldDefinition getFieldDefinition() throws Exception {
            return this.m_fielddefinition;
        }

        @Override
        public Object getValue() throws Exception {
            return this.m_value;
        }

        @Override
        public void setValue(Object value_p) throws Exception {
            this.m_value = value_p;
        }
    }
}

