/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owutil;

import com.wewebu.expression.language.OwExprEvaluationException;
import com.wewebu.expression.language.OwExprExpression;
import com.wewebu.expression.language.OwExprExternalScope;
import com.wewebu.expression.language.OwExprValue;
import com.wewebu.expression.parser.OwExprParser;
import com.wewebu.expression.parser.ParseException;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.field.OwObjectScope;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwMappingUtils {
    private static final Logger LOG = OwLogCore.getLogger(OwMappingUtils.class);
    public static final int EMPTY_MAPPING = 0;
    public static final int AUTO_SELECT_CLASS = 1;
    public static final int AUTO_SELECT_FOLDER = 2;

    private static Object evaluate(String expression_p, OwObject object_p) throws ParseException, OwExprEvaluationException {
        String objectScopeName = "object";
        OwExprParser parser = new OwExprParser((Reader)new StringReader("object." + expression_p));
        OwExprExpression expression = parser.ExprExpression();
        OwObjectScope objectScope = new OwObjectScope("object", object_p);
        OwExprValue evalResult = expression.evaluate(new OwExprExternalScope[]{objectScope});
        return evalResult.toJavaObject(evalResult.getJavaType());
    }

    private static Object findParameterValueInRecord(OwXMLUtil confignode_p, OwObject rootObject_p, OwObject obj_p, String expression_p) throws Exception {
        try {
            return OwMappingUtils.evaluate(expression_p, obj_p);
        }
        catch (OwExprEvaluationException e) {
            LOG.debug((Object)"Could not find parameter expression value. Trying root object.", (Throwable)e);
        }
        catch (ParseException e) {
            LOG.error((Object)"Could not find parameter value.", (Throwable)e);
            throw new OwConfigurationException("Could not find parameter value :  " + expression_p + " (" + confignode_p.getSafeTextValue("id", "unknown") + ")", (Throwable)e);
        }
        if (obj_p.getDMSID().equals(rootObject_p.getDMSID())) {
            return null;
        }
        OwObjectCollection parents = obj_p.getParents();
        if (parents == null || parents.size() == 0) {
            return null;
        }
        OwObject parent = (OwObject)parents.get(0);
        return OwMappingUtils.findParameterValueInRecord(confignode_p, rootObject_p, parent, expression_p);
    }

    private static Object findParameterValueInObject(OwXMLUtil confignode_p, OwObject sourceObject_p, String expression_p) throws Exception {
        try {
            return OwMappingUtils.evaluate(expression_p, sourceObject_p);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not find parameter value.", (Throwable)e);
            throw new OwConfigurationException("Could not find parameter value :  " + expression_p + " (" + confignode_p.getSafeTextValue("id", "unknown") + ")", (Throwable)e);
        }
    }

    public static Map getParameterMapValuesFromRecord(OwXMLUtil confignode_p, OwObject rootObject_p, OwObject folderObject_p) throws Exception {
        if (null == folderObject_p) {
            return null;
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        List mappingConfiguration = confignode_p.getSafeStringList("ParameterMapping");
        for (String strInstruction : mappingConfiguration) {
            OwParamMappingNameStructure paramStructure = OwMappingUtils.extractParameterNames(confignode_p, strInstruction);
            Object parentValue = OwMappingUtils.findParameterValueInRecord(confignode_p, rootObject_p, folderObject_p, paramStructure.sourceExpression);
            if (null == parentValue) continue;
            valuesMap.put(paramStructure.destinationParameterName, parentValue);
        }
        if (valuesMap.size() == 0) {
            return null;
        }
        return valuesMap;
    }

    public static Map getParameterMapValuesFromObject(OwXMLUtil confignode_p, OwObject sourceObject_p, String mappingElementName_p) throws Exception {
        if (null == sourceObject_p) {
            return null;
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        List mappingConfiguration = confignode_p.getSafeStringList(mappingElementName_p);
        for (String strInstruction : mappingConfiguration) {
            OwParamMappingNameStructure paramStructure = OwMappingUtils.extractParameterNames(confignode_p, strInstruction);
            Object sourceValue = OwMappingUtils.findParameterValueInObject(confignode_p, sourceObject_p, paramStructure.sourceExpression);
            if (null == sourceValue) continue;
            valuesMap.put(paramStructure.destinationParameterName, sourceValue);
        }
        if (valuesMap.size() == 0) {
            return null;
        }
        return valuesMap;
    }

    private static OwParamMappingNameStructure extractParameterNames(OwXMLUtil confignode_p, String strInstruction_p) throws OwConfigurationException {
        int iSplit = strInstruction_p.indexOf(61);
        if (-1 == iSplit) {
            String msg = "OwMappingUtils.getParameterMapValuesFromRecord: Incorrect ParameterMapping format used in plugin descriptor of = " + confignode_p.getSafeTextValue("id", "unknown");
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        String destinationParameterName = strInstruction_p.substring(0, iSplit).trim();
        String sourceParameterName = strInstruction_p.substring(iSplit + 1).trim();
        return new OwParamMappingNameStructure(destinationParameterName, sourceParameterName);
    }

    public static int getObjectClassMap(OwXMLUtil confignode_p, Map objectclassmap_p) throws Exception {
        List mappingConfiguration = confignode_p.getSafeStringList("ObjectClassMapping");
        if (mappingConfiguration.size() == 0) {
            return 0;
        }
        int iDirection = 1;
        iDirection = OwXMLDOMUtil.getSafeStringAttributeValue(confignode_p.getSubNode("ObjectClassMapping"), "direction", "autoselectclass").equalsIgnoreCase("autoselectclass") ? 1 : 2;
        for (String strInstruction : mappingConfiguration) {
            int iSplit = strInstruction.indexOf(61);
            if (-1 == iSplit) {
                String msg = "OwMappingUtils.getObjectClassMap: Incorrect ObjectClassMapping format used in plugin descriptor of = " + confignode_p.getSafeTextValue("id", "unknown");
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            String strSubFolderName = strInstruction.substring(0, iSplit);
            String strObjectClassName = strInstruction.substring(iSplit + 1);
            strSubFolderName = strSubFolderName.trim();
            strObjectClassName = strObjectClassName.trim();
            switch (iDirection) {
                case 1: {
                    objectclassmap_p.put(strSubFolderName, strObjectClassName);
                    break;
                }
                case 2: {
                    objectclassmap_p.put(strObjectClassName, strSubFolderName);
                }
            }
        }
        return iDirection;
    }

    private static class OwParamMappingNameStructure {
        public final String destinationParameterName;
        public final String sourceExpression;

        public OwParamMappingNameStructure(String destinationParameterName_p, String sourceExpression_p) {
            this.destinationParameterName = destinationParameterName_p;
            this.sourceExpression = sourceExpression_p;
        }
    }
}

