/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.role;

import com.wewebu.ow.server.conf.OwBaseConfiguration;
import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtilPlaceholderFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public abstract class OwStandardRoleManager
implements OwRoleManager {
    private static final Logger LOG = OwLogCore.getLogger(OwStandardRoleManager.class);
    public static final String MS_OFFICE_EMBEDED_DESIGN = "msoffice";
    public static final String APPLICATION_PREFIX_DELIMITER = "/";
    private OwRoleManagerContext m_MainContext;
    protected OwXMLUtil m_ConfigNode;
    private static CategoryNames m_categoryNames = new CategoryNames();
    private static StandardFunctionResources m_StandardFunctionResources = new StandardFunctionResources();
    protected Map m_MimeMap = null;
    protected Map m_DefaultMimeMap = null;
    protected Map m_PluginTypesMap = null;
    protected Map m_PluginMap = null;
    protected Map m_AllowedPluginTypesMap = null;
    protected Map m_SelectiveConfigurationMap = null;
    private boolean m_fInitialized = false;
    protected String m_strDesign;
    protected Map m_PluginCategoryMap;
    protected Map m_DesignCategoryMap;
    protected Map m_SearchTemplateCategoryMap;
    protected Map<String, String> m_VirtualFolderCategoryMap;
    protected Map m_GroupBoxCategoryMap;
    protected Map m_objectClassesMap;
    protected Map m_indexFieldsMap;

    protected Map getCategoryMap() {
        return OwStandardRoleManager.m_categoryNames.m_categories;
    }

    protected Map getStandardFunctionResourceMap() {
        return OwStandardRoleManager.m_StandardFunctionResources.m_Resources;
    }

    protected boolean isInitialized() {
        return this.m_fInitialized;
    }

    protected OwXMLUtil getConfigNode() {
        return this.m_ConfigNode;
    }

    protected OwBaseUserInfo getCurrentUser() throws Exception {
        return this.m_MainContext.getCurrentUser();
    }

    public static void applicationInitalize(OwBaseInitializer initializer_p) throws OwConfigurationException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"OwStandardRoleManager.applicationInitalize: role manger configuration started...");
        }
        try {
            OwStandardRoleManager.createPluginsMap(initializer_p);
            LOG.debug((Object)"OwStandardRoleManager.applicationInitalize: plugins successfully initialized.");
        }
        catch (Exception ex) {
            String msg = "Failed to load the plugins. Please check your configuration files.";
            LOG.error((Object)msg, (Throwable)ex);
            throw new OwConfigurationException(msg, (Throwable)ex);
        }
        try {
            OwStandardRoleManager.createMimeMap(initializer_p);
            LOG.debug((Object)"OwStandardRoleManager.applicationInitalize: mimetable successfully initialized.");
        }
        catch (Exception ex) {
            String msg = "Failed to load the mimetable. Please check your configuration files.";
            LOG.error((Object)msg, (Throwable)ex);
            throw new OwConfigurationException(msg, (Throwable)ex);
        }
        try {
            OwStandardRoleManager.createSelectiveConfigurationMap(initializer_p);
            LOG.debug((Object)"OwStandardRoleManager.applicationInitalize: selective configurations successfully initialized.");
        }
        catch (Exception ex) {
            String msg = "Failed to load the selective configuration. Please check your configuration files.";
            LOG.error((Object)msg, (Throwable)ex);
            throw new OwConfigurationException(msg, (Throwable)ex);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"OwStandardRoleManager.applicationInitalize: ...role manger configuration finished.");
        }
    }

    @Override
    public void refreshStaticConfiguration() throws OwConfigurationException {
        LOG.debug((Object)"OwStandardRoleManager.refreshStaticConfiguration: refresh the application configuration....");
        OwStandardRoleManager.applicationInitalize(this.m_MainContext);
    }

    @Override
    public boolean canRefreshStaticConfiguration() throws Exception {
        return true;
    }

    @Override
    public void init(OwRoleManagerContext mainContext_p, OwXMLUtil configNode_p) throws OwException {
        this.m_MainContext = mainContext_p;
        this.m_ConfigNode = configNode_p;
        this.m_strDesign = configNode_p.getSafeTextValue("DesignName", null);
        if (this.m_strDesign == null) {
            this.m_strDesign = mainContext_p.getConfigurationName();
            if (this.m_strDesign.indexOf("_vti_bin/owssvr.dll") != -1) {
                this.m_strDesign = MS_OFFICE_EMBEDED_DESIGN;
            } else {
                int i = this.m_strDesign.lastIndexOf(47);
                if (i != -1) {
                    this.m_strDesign = this.m_strDesign.substring(i + 1);
                    i = this.m_strDesign.lastIndexOf(46);
                    this.m_strDesign = i != -1 ? this.m_strDesign.substring(0, i) : "default41";
                } else {
                    this.m_strDesign = "default41";
                }
                if (this.m_strDesign.equals("adaptor")) {
                    this.m_strDesign = "default41";
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwStandardRoleManager.init: used DesignName = " + this.m_strDesign));
        }
    }

    protected boolean isMsOfficeEmbedded() {
        return this.m_strDesign.equals(MS_OFFICE_EMBEDED_DESIGN);
    }

    @Override
    public void loginInit() throws Exception {
        this.m_MimeMap = (Map)this.m_MainContext.getApplicationAttribute("OwStandardRoleManager.m_MimeMap");
        if (this.m_MimeMap == null) {
            String msg = "OwStandardRoleManager.loginInit: Error - the MimeMap is not initialized correctly, is null...";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_DefaultMimeMap = (Map)this.m_MainContext.getApplicationAttribute("OwStandardRoleManager.m_DefaultMimeMap");
        if (this.m_DefaultMimeMap == null) {
            String msg = "OwStandardRoleManager.loginInit: Error - the DefaultMimeMap is not initialized correctly, is null...";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_PluginTypesMap = (Map)this.m_MainContext.getApplicationAttribute("OwStandardRoleManager.m_PluginTypesMap");
        if (this.m_PluginTypesMap == null) {
            String msg = "OwStandardRoleManager.loginInit: Error - the PluginTypesMap is not initialized correctly, is null...";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_PluginMap = (Map)this.m_MainContext.getApplicationAttribute("OwStandardRoleManager.m_PluginMap");
        if (this.m_PluginMap == null) {
            String msg = "OwStandardRoleManager.loginInit: Error - the PluginMap is not initialized correctly, is null...";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_SelectiveConfigurationMap = (Map)this.m_MainContext.getApplicationAttribute("OwStandardRoleManager.m_SelectiveConfigurationMap");
        if (this.m_SelectiveConfigurationMap == null) {
            String msg = "OwStandardRoleManager.loginInit: Error - the SelectiveConfigurationMap is not initialized correctly, is null...";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        this.m_fInitialized = true;
    }

    protected OwRoleManagerContext getContext() {
        return this.m_MainContext;
    }

    @Override
    public String getDesign() throws Exception {
        return this.m_strDesign;
    }

    private static void createPluginsMap(OwBaseInitializer context_p) throws Exception {
        Document doc;
        HashMap typesMap = new HashMap();
        HashMap<String, OwStandardXMLUtil> pluginMap = new HashMap<String, OwStandardXMLUtil>();
        InputStream in = null;
        try {
            in = context_p.getXMLConfigDoc("plugins");
            doc = OwXMLDOMUtil.getDocumentFromInputStream(in);
            OwXMLDOMUtil.initialize(doc);
        }
        catch (Exception e) {
            String msg = "OwStandardRoleManager.createPluginsMap: 'owplugins.xml' can not be read. Possible cause: invalid XML format or the file is missing...";
            LOG.fatal((Object)msg, (Throwable)e);
            throw new OwConfigurationException(msg, (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioex) {
                    LOG.warn((Object)"Stream could not be closed after read of owplugins.xml.", (Throwable)ioex);
                }
                in = null;
            }
        }
        NodeList IncludeList = doc.getElementsByTagName("Include");
        for (int i = 0; i < IncludeList.getLength(); ++i) {
            String msg;
            Document includedDocument;
            Node includeElement = IncludeList.item(i);
            NamedNodeMap includeAttributes = includeElement.getAttributes();
            Node includeFileNode = includeAttributes.getNamedItem("file");
            Node includeElementParent = includeElement.getParentNode();
            Node includeElementSibling = includeElement.getNextSibling();
            if (includeFileNode == null) {
                String msg2 = "OwStandardRoleManager.createPluginsMap: Can not resolve include statement. <include> element is missing the file attribute.";
                LOG.fatal((Object)msg2);
                throw new OwConfigurationException(msg2);
            }
            String includeFileName = includeFileNode.getNodeValue();
            InputStream includeInputStream = null;
            try {
                URL includeURL = context_p.getConfigURL(includeFileName);
                includeInputStream = includeURL.openStream();
            }
            catch (Exception e) {
                String msg3 = "OwStandardRoleManager.createPluginsMap: Error reading included file, includeFileName = " + includeFileName;
                LOG.fatal((Object)msg3, (Throwable)e);
                if (includeInputStream != null) {
                    try {
                        includeInputStream.close();
                    }
                    catch (IOException ioex) {
                        // empty catch block
                    }
                    includeInputStream = null;
                }
                throw new OwConfigurationException(msg3, (Throwable)e);
            }
            try {
                includedDocument = OwXMLDOMUtil.getDocumentFromInputStream(includeInputStream);
            }
            catch (Exception e) {
                msg = "OwStandardRoleManager.createPluginsMap: Included file " + includeFileName + " can not be read, probably due to a syntax error.";
                LOG.fatal((Object)msg, (Throwable)e);
                throw new OwConfigurationException(msg, (Throwable)e);
            }
            finally {
                if (includeInputStream != null) {
                    try {
                        includeInputStream.close();
                    }
                    catch (IOException ioex) {
                        LOG.warn((Object)"Stream could not be closed after include Document.", (Throwable)ioex);
                    }
                    includeInputStream = null;
                }
            }
            Element includedDocumentElement = includedDocument.getDocumentElement();
            if (!includedDocumentElement.getNodeName().equals("SubPlugIn")) {
                msg = "OwStandardRoleManager.createPluginsMap: The included file " + includeFileName + " does not start with a <SubPlugIn> Element!";
                LOG.fatal((Object)msg);
                throw new OwConfigurationException(msg);
            }
            for (Node includedDocumentCopySource = includedDocumentElement.getFirstChild(); includedDocumentCopySource != null; includedDocumentCopySource = includedDocumentCopySource.getNextSibling()) {
                Node importedNode = doc.importNode(includedDocumentCopySource, true);
                if (includeElementSibling == null) {
                    includeElementParent.appendChild(importedNode);
                    continue;
                }
                includeElementParent.insertBefore(importedNode, includeElementSibling);
            }
            includeElementParent.removeChild(includeElement);
        }
        NodeList plugNodeList = doc.getElementsByTagName("PlugIn");
        for (int i = 0; i < plugNodeList.getLength(); ++i) {
            Node plugNode = plugNodeList.item(i);
            NamedNodeMap Attributes2 = plugNode.getAttributes();
            Node typeNode = Attributes2.getNamedItem("type");
            LinkedList<OwStandardXMLUtil> pluginList = (LinkedList<OwStandardXMLUtil>)typesMap.get(typeNode.getNodeValue());
            if (pluginList == null) {
                pluginList = new LinkedList<OwStandardXMLUtil>();
                typesMap.put(typeNode.getNodeValue(), pluginList);
            }
            OwStandardXMLUtil plugWrapper = new OwStandardXMLUtil(plugNode);
            pluginList.add(plugWrapper);
            pluginMap.put(plugWrapper.getSafeTextValue("id", null), plugWrapper);
        }
        context_p.setApplicationAttribute("OwStandardRoleManager.m_PluginTypesMap", typesMap);
        context_p.setApplicationAttribute("OwStandardRoleManager.m_PluginMap", pluginMap);
    }

    @Override
    public List getPlugins(String strType_p) throws Exception {
        if (!this.isInitialized()) {
            String msg = "OwStandardRoleManager.getPlugins: Rolemanager not initialized yet.";
            LOG.debug((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        return (List)this.getAllowedPluginsMap().get(strType_p);
    }

    @Override
    public OwXMLUtil getPlugin(String strID_p) throws Exception {
        if (!this.isInitialized()) {
            String msg = "OwStandardRoleManager.getPlugin: Rolemanager not initialized yet.";
            LOG.debug((Object)msg);
            throw new OwInvalidOperationException(msg);
        }
        return (OwXMLUtil)this.m_PluginMap.get(strID_p);
    }

    protected void updateAllowedPlugins() {
        this.m_AllowedPluginTypesMap = null;
    }

    private Map getAllowedPluginsMap() throws Exception {
        if (this.m_AllowedPluginTypesMap == null) {
            this.m_AllowedPluginTypesMap = new HashMap();
            for (Map.Entry currentEntry : this.m_PluginTypesMap.entrySet()) {
                String strPluginType = (String)currentEntry.getKey();
                List pluginList = (List)currentEntry.getValue();
                for (OwXMLUtil pluginDescriptionNode : pluginList) {
                    String strPluginID = pluginDescriptionNode.getSafeTextValue("id", null);
                    if (!this.isAllowed(1, strPluginID)) continue;
                    LinkedList<OwXMLUtil> newList = (LinkedList<OwXMLUtil>)this.m_AllowedPluginTypesMap.get(strPluginType);
                    if (newList == null) {
                        newList = new LinkedList<OwXMLUtil>();
                        this.m_AllowedPluginTypesMap.put(strPluginType, newList);
                    }
                    OwXMLUtil node = pluginDescriptionNode;
                    if (null != this.m_MainContext.getMandator()) {
                        node = new OwXMLUtilPlaceholderFilter(pluginDescriptionNode, (OwAttributeBag)this.m_MainContext.getMandator());
                    }
                    newList.add(node);
                }
            }
        }
        return this.m_AllowedPluginTypesMap;
    }

    @Override
    public OwXMLUtil getMIMENode(String strMIMEType_p) throws Exception {
        try {
            return (OwXMLUtil)this.m_MimeMap.get(strMIMEType_p.toLowerCase());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public OwXMLUtil getDefaultMIMENode(int iObjectType_p) throws Exception {
        return (OwXMLUtil)this.m_DefaultMimeMap.get(iObjectType_p);
    }

    private static void createSelectiveConfigurationMap(OwBaseInitializer context_p) throws Exception {
        HashMap selectiveConfigurationMap = new HashMap();
        OwStandardRoleManager.scanXMLFileForSelectiveConfigurationMap(selectiveConfigurationMap, "bootstrap", context_p);
        OwStandardRoleManager.scanXMLFileForSelectiveConfigurationMap(selectiveConfigurationMap, "plugins", context_p);
        OwStandardRoleManager.scanXMLFileForSelectiveConfigurationMap(selectiveConfigurationMap, "mimetable", context_p);
        context_p.setApplicationAttribute("OwStandardRoleManager.m_SelectiveConfigurationMap", selectiveConfigurationMap);
    }

    private static void scanXMLFileForSelectiveConfigurationMap(Map selectiveConfigurationMap_p, String xmlFileName_p, OwBaseInitializer context_p) throws OwConfigurationException {
        InputStream in = null;
        try {
            in = context_p.getXMLConfigDoc(xmlFileName_p);
            Document doc = OwXMLDOMUtil.getDocumentFromInputStream(in);
            OwStandardRoleManager.iterativeScanElementForOptionid(selectiveConfigurationMap_p, doc.getDocumentElement());
        }
        catch (IOException ex) {
            String msg = "Invalid file entry for the XMLConfigDoc = " + xmlFileName_p + ". Possible cause: syntax error or the file is missing...";
            LOG.error((Object)msg, (Throwable)ex);
            throw new OwConfigurationException(msg, (Throwable)ex);
        }
        catch (SAXParseException ex) {
            String msg = "Parse Exception: invalid entries for the XMLConfigDoc = " + xmlFileName_p + ". Possible cause: syntax error or the file is missing...";
            LOG.error((Object)msg, (Throwable)ex);
            throw new OwConfigurationException(msg, (Throwable)ex);
        }
        catch (Exception ex) {
            String msg = "Error loading or validating the the XMLConfigDoc = " + xmlFileName_p + ". Possible cause: syntax error or the file is missing...";
            LOG.error((Object)msg, (Throwable)ex);
            throw new OwConfigurationException(msg, (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    String msg = "Could not close inputstream after handling of " + xmlFileName_p;
                    LOG.error((Object)msg, (Throwable)e);
                    throw new OwConfigurationException(msg, (Throwable)e);
                }
                in = null;
            }
        }
    }

    private static void iterativeScanElementForOptionid(Map selectiveConfigurationMap_p, Element elem_p) throws Exception {
        String optionidAttribute = elem_p.getAttribute("optionid");
        if (optionidAttribute.length() != 0) {
            String tagName = elem_p.getTagName();
            String id = tagName + (tagName.equals("mime") ? "." + elem_p.getAttribute("type") + "." : ".") + optionidAttribute;
            selectiveConfigurationMap_p.put(id, id);
        }
        for (Node testNode = elem_p.getFirstChild(); testNode != null; testNode = testNode.getNextSibling()) {
            if (testNode.getNodeType() != 1) continue;
            OwStandardRoleManager.iterativeScanElementForOptionid(selectiveConfigurationMap_p, (Element)testNode);
        }
    }

    private static void createMimeMap(OwBaseInitializer context_p) throws Exception {
        HashMap<String, OwStandardXMLUtil> mimeMap = new HashMap<String, OwStandardXMLUtil>();
        HashMap<Integer, OwStandardXMLUtil> defaultMimeMap = new HashMap<Integer, OwStandardXMLUtil>();
        String sMimeTableName = "mimetable";
        InputStream in = null;
        Document doc = null;
        try {
            in = context_p.getXMLConfigDoc(sMimeTableName);
            doc = OwXMLDOMUtil.getDocumentFromInputStream(in);
            OwXMLDOMUtil.initialize(doc);
        }
        catch (Exception e) {
            String msg = "OwStandardRoleManager.createMimeMap: 'owmimetable.xml' can not be read. Possible cause: invalid XML format or the file is missing...";
            LOG.fatal((Object)msg, (Throwable)e);
            throw new OwConfigurationException(msg, (Throwable)e);
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
        }
        NodeList mimeNodes = doc.getElementsByTagName("mime");
        for (int i = 0; i < mimeNodes.getLength(); ++i) {
            String strMimetype;
            Node mimeItem = mimeNodes.item(i);
            NamedNodeMap attributes = mimeItem.getAttributes();
            Node typeNode = attributes.getNamedItem("type");
            OwStandardXMLUtil mimenode = new OwStandardXMLUtil(mimeItem);
            String strMimetypekey = strMimetype = typeNode.getNodeValue();
            String optionid = mimenode.getSafeStringAttributeValue("optionid", null);
            if (null != optionid) {
                strMimetypekey = "mime." + strMimetype + "." + optionid;
            }
            mimeMap.put(strMimetypekey.toLowerCase(), mimenode);
            if (!strMimetype.startsWith("ow_default/")) continue;
            try {
                String sType = strMimetype.substring("ow_default/".length());
                Integer iObj = null;
                try {
                    iObj = (Integer)OwObjectReference.class.getField(sType).get(null);
                }
                catch (NoSuchFieldException e) {
                    iObj = Integer.valueOf(sType);
                }
                defaultMimeMap.put(iObj, mimenode);
                continue;
            }
            catch (Exception e) {
                String msg = "Default MIME type in MIME map could not be resolved, MIME type = " + strMimetype;
                LOG.error((Object)msg, (Throwable)e);
                throw new OwConfigurationException(msg, (Throwable)e);
            }
        }
        context_p.setApplicationAttribute("OwStandardRoleManager.m_MimeMap", mimeMap);
        context_p.setApplicationAttribute("OwStandardRoleManager.m_DefaultMimeMap", defaultMimeMap);
    }

    @Override
    public Collection getCategories() {
        return this.getCategoryMap().keySet();
    }

    @Override
    public Collection getConfiguredCategories() {
        return this.getCategories();
    }

    @Override
    public String getCategoryDisplayName(Locale locale_p, int categorie_p) {
        return ((OwString)this.getCategoryMap().get(categorie_p)).getString(locale_p);
    }

    protected Map getPluginCategoryMap() {
        if (this.m_PluginCategoryMap == null) {
            this.m_PluginCategoryMap = new LinkedHashMap();
            for (int i = 0; i < OwBaseConfiguration.getPluginTypeDefinitions().length; ++i) {
                List plugs = (List)this.m_PluginTypesMap.get(OwBaseConfiguration.getPluginTypeDefinitions()[i].getType());
                if (plugs == null) continue;
                for (OwXMLUtil plugDescriptionNode : plugs) {
                    String key = plugDescriptionNode.getSafeTextValue("id", "");
                    StringBuffer value = new StringBuffer("@");
                    value.append(OwBaseConfiguration.getPluginTypeDisplayName(plugDescriptionNode.getSafeStringAttributeValue("type", "[unknown]"), this.getContext().getLocale()));
                    value.append("@");
                    value.append(this.getContext().getBaseConfiguration().getLocalizedPluginTitle(plugDescriptionNode));
                    this.m_PluginCategoryMap.put(key, value);
                }
            }
        }
        return this.m_PluginCategoryMap;
    }

    protected Map getDesignCategoryMap() {
        if (this.m_DesignCategoryMap == null) {
            this.m_DesignCategoryMap = new LinkedHashMap();
            List availableDesigns = this.m_ConfigNode.getSafeNodeList("AvailableDesigns");
            Iterator it = availableDesigns.iterator();
            while (it.hasNext()) {
                OwStandardXMLUtil designNode = null;
                try {
                    designNode = new OwStandardXMLUtil((Node)it.next());
                }
                catch (Exception e) {
                    continue;
                }
                String id = designNode.getSafeTextValue(null);
                String displayName = designNode.getSafeStringAttributeValue("displayName", "");
                if (id == null || id.length() <= 0) continue;
                this.m_DesignCategoryMap.put(id, this.getContext().localize("design." + id + ".title", displayName));
            }
        }
        return this.m_DesignCategoryMap;
    }

    protected Map getRepositories() {
        HashMap<String, OwRepository> repositories = new HashMap<String, OwRepository>();
        repositories.put("OW_HISTORY", this.getContext().getHistoryManager());
        repositories.put("OW_ECM_ADAPTER", this.getContext().getNetwork());
        return repositories;
    }

    protected Map<String, String> getVirtualFoldersCategoryMap() throws Exception {
        if (this.m_VirtualFolderCategoryMap == null) {
            this.m_VirtualFolderCategoryMap = new HashMap<String, String>();
            OwNetwork network = this.m_MainContext.getNetwork();
            Collection allVirtualFolders = network.getApplicationObjects(1, null, false);
            for (OwVirtualFolderObject virtualFolder : allVirtualFolders) {
                this.m_VirtualFolderCategoryMap.put(virtualFolder.getVirtualFolderName(), virtualFolder.getName());
            }
        }
        return this.m_VirtualFolderCategoryMap;
    }

    protected Map getSearchTemplateCategoryMap() throws Exception {
        if (this.m_SearchTemplateCategoryMap == null) {
            this.m_SearchTemplateCategoryMap = new HashMap();
            for (int i = 0; i < OwBaseConfiguration.getPluginTypeDefinitions().length; ++i) {
                List plugins = (List)this.m_PluginTypesMap.get(OwBaseConfiguration.getPluginTypeDefinitions()[i].getType());
                if (plugins == null) continue;
                for (OwXMLUtil plugDescriptionNode : plugins) {
                    List searchTemplateLocations = plugDescriptionNode.getSafeNodeList("SearchTemplates");
                    if (searchTemplateLocations.size() <= 0) continue;
                    Iterator itSearchTemplateLocations = searchTemplateLocations.iterator();
                    while (itSearchTemplateLocations.hasNext()) {
                        OwStandardXMLUtil repositoryNode = new OwStandardXMLUtil((Node)itSearchTemplateLocations.next());
                        String repName = repositoryNode.getSafeStringAttributeValue("repname", null);
                        OwRepository repository = (OwRepository)this.getRepositories().get(repName);
                        if (repository == null) {
                            LOG.fatal((Object)("OwStandardRoleManager.getSearchTemplateCategoryMap: Repository is not existing, repName = " + repName));
                            throw new OwConfigurationException(this.getContext().localize("owsearch.OwSearchDocument.repositorynotdefined", "Repository is not existing:") + " " + repName);
                        }
                        String strSearchTemplates = repositoryNode.getNode().getFirstChild().getNodeValue();
                        if (strSearchTemplates == null) {
                            LOG.fatal((Object)"OwStandardRoleManager.getSearchTemplateCategoryMap: Search template category has not been defined at the search plugin.");
                            throw new OwConfigurationException(this.getContext().localize("owsearch.OwSearchDocument.templatesnotdefined", "Search template category has not been defined at the Search Plugin."));
                        }
                        Collection SearchTemplateObjects = this.getContext().getNetwork().getApplicationObjects(3, strSearchTemplates, false);
                        if (SearchTemplateObjects == null) continue;
                        for (OwSearchTemplate searchtemplate : SearchTemplateObjects) {
                            this.m_SearchTemplateCategoryMap.put(searchtemplate.getName(), searchtemplate);
                        }
                    }
                }
            }
        }
        return this.m_SearchTemplateCategoryMap;
    }

    protected Map getGroupBoxCategoryMap() throws Exception {
        if (this.m_GroupBoxCategoryMap == null) {
            this.m_GroupBoxCategoryMap = new HashMap();
            Collection groupBoxSearchTemplates = null;
            try {
                groupBoxSearchTemplates = this.getContext().getNetwork().getApplicationObjects(3, "owbpmviewtemplates", false);
            }
            catch (OwObjectNotFoundException e) {
                return this.m_GroupBoxCategoryMap;
            }
            for (OwSearchTemplate searchtemplate : groupBoxSearchTemplates) {
                this.m_GroupBoxCategoryMap.put(searchtemplate.getName(), searchtemplate);
            }
        }
        return this.m_GroupBoxCategoryMap;
    }

    protected Map getObjectClassesMap() throws Exception {
        if (this.m_objectClassesMap == null) {
            this.m_objectClassesMap = new LinkedHashMap();
            OwRoleManagerContext context = this.getContext();
            OwNetwork netwrok = context.getNetwork();
            Map allClassNamesMap = netwrok.getObjectClassNames(null, false, false, null);
            for (Map.Entry allClassNamesEntry : allClassNamesMap.entrySet()) {
                String className = (String)allClassNamesEntry.getKey();
                String displayName = (String)allClassNamesEntry.getValue();
                this.m_objectClassesMap.put(className, displayName);
            }
        }
        return this.m_objectClassesMap;
    }

    protected Map getIndexFieldsMap() throws Exception {
        if (this.m_indexFieldsMap == null) {
            this.m_indexFieldsMap = new LinkedHashMap();
            Map allClassNamesMap = this.getContext().getNetwork().getObjectClassNames(null, false, false, null);
            for (Map.Entry allClassNamesEntry : allClassNamesMap.entrySet()) {
                String className = (String)allClassNamesEntry.getKey();
                OwObjectClass objectClass = this.getContext().getNetwork().getObjectClass(className, null);
                String classDisplayName = objectClass.getDisplayName(this.getContext().getLocale());
                Collection propertyClassNames = objectClass.getPropertyClassNames();
                Iterator itPropertyClassNames = propertyClassNames.iterator();
                String create = this.getContext().localize("owrole.OwStandardRoleManager.ContextCreateDisplayPrefix", "CREATE");
                String createPrefix = Integer.toString(1);
                String checkin = this.getContext().localize("owrole.OwStandardRoleManager.ContextCheckinDisplayPrefix", "CHECKIN");
                String checkinPrefix = Integer.toString(2);
                String view = this.getContext().localize("owrole.OwStandardRoleManager.ContextViewDisplayPrefix", "VIEW");
                String viewPrefix = Integer.toString(3);
                while (itPropertyClassNames.hasNext()) {
                    String propertyClassName = (String)itPropertyClassNames.next();
                    OwPropertyClass propertyClass = objectClass.getPropertyClass(propertyClassName);
                    String propertyDisplayName = propertyClass.getDisplayName(this.getContext().getLocale());
                    String keyPostId = "." + className + "." + propertyClassName;
                    String valuePrefix = "@" + classDisplayName + "@";
                    String valuePostId = "." + classDisplayName + "." + propertyDisplayName;
                    this.m_indexFieldsMap.put(createPrefix + keyPostId, valuePrefix + create + valuePostId);
                    this.m_indexFieldsMap.put(checkinPrefix + keyPostId, valuePrefix + checkin + valuePostId);
                    this.m_indexFieldsMap.put(viewPrefix + keyPostId, valuePrefix + view + valuePostId);
                }
            }
        }
        return this.m_indexFieldsMap;
    }

    protected abstract String dynamicResourceNameFromId(Locale var1, String var2, int var3);

    @Override
    public boolean isStaticResourceCategory(int category_p) {
        return 11 != category_p;
    }

    protected abstract Collection<String> getDynamicResources(int var1) throws OwException;

    @Override
    public Collection getResources(int category_p) throws Exception {
        switch (category_p) {
            case 1: {
                return this.getPluginCategoryMap().keySet();
            }
            case 3: {
                return this.getGroupBoxCategoryMap().keySet();
            }
            case 5: {
                return this.getSearchTemplateCategoryMap().keySet();
            }
            case 12: {
                return this.getVirtualFoldersCategoryMap().keySet();
            }
            case 6: {
                return this.getStandardFunctionResourceMap().keySet();
            }
            case 7: {
                return this.getDesignCategoryMap().keySet();
            }
            case 8: {
                return this.m_SelectiveConfigurationMap.keySet();
            }
            case 9: {
                return this.getObjectClassesMap().keySet();
            }
            case 10: {
                return this.getIndexFieldsMap().keySet();
            }
            case 11: {
                return this.getDynamicResources(category_p);
            }
        }
        String msg = "OwStandardRoleManager.getResources: Requested category not defined, category = " + category_p;
        LOG.error((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    @Override
    public String getResourceDisplayName(Locale locale_p, int categorie_p, String strID_p) {
        try {
            switch (categorie_p) {
                case 1: {
                    return this.getPluginCategoryMap().get(strID_p).toString();
                }
                case 3: {
                    try {
                        return ((OwSearchTemplate)this.getGroupBoxCategoryMap().get(strID_p)).getDisplayName(locale_p);
                    }
                    catch (Exception e) {
                        return strID_p;
                    }
                }
                case 5: {
                    try {
                        return ((OwSearchTemplate)this.getSearchTemplateCategoryMap().get(strID_p)).getDisplayName(locale_p);
                    }
                    catch (Exception e) {
                        return strID_p;
                    }
                }
                case 12: {
                    try {
                        String virtualFolder = this.getVirtualFoldersCategoryMap().get(strID_p);
                        String localizedVirtualFolder = OwString.localizeLabel(locale_p, virtualFolder);
                        return localizedVirtualFolder;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not retrieve virtual folder display name ", (Throwable)e);
                        return strID_p;
                    }
                }
                case 6: {
                    return ((OwString)this.getStandardFunctionResourceMap().get(strID_p)).getString(locale_p);
                }
                case 7: {
                    return (String)this.getDesignCategoryMap().get(strID_p);
                }
                case 8: {
                    return (String)this.m_SelectiveConfigurationMap.get(strID_p);
                }
                case 9: {
                    try {
                        return (String)this.getObjectClassesMap().get(strID_p);
                    }
                    catch (Exception e) {
                        return strID_p;
                    }
                }
                case 10: {
                    try {
                        return (String)this.getIndexFieldsMap().get(strID_p);
                    }
                    catch (Exception e) {
                        return strID_p;
                    }
                }
                case 11: {
                    return this.dynamicResourceNameFromId(locale_p, strID_p, categorie_p);
                }
            }
            return strID_p;
        }
        catch (NullPointerException e) {
            return strID_p;
        }
    }

    @Override
    public Map getAccessMaskDescriptions(int category_p) {
        HashMap<Integer, String> results = new HashMap<Integer, String>();
        switch (category_p) {
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 9: {
                results.put(1, this.getContext().localize("app.OwRoleManager.ROLE_ACCESS_MASK_FLAG_OBJECT_CLASSES_VIEW", "View"));
                results.put(2, this.getContext().localize("app.OwRoleManager.ROLE_ACCESS_MASK_FLAG_OBJECT_CLASSES_CREATE", "Create"));
                results.put(4, this.getContext().localize("app.OwRoleManager.ROLE_ACCESS_MASK_FLAG_OBJECT_CLASSES_CHECKIN", "Check-in"));
                break;
            }
            case 10: {
                results.put(1, this.getContext().localize("app.OwRoleManager.ROLE_ACCESS_MASK_FLAG_INDEX_FIELD_VIEW", "View"));
                results.put(2, this.getContext().localize("app.OwRoleManager.ROLE_ACCESS_MASK_FLAG_INDEX_FIELD_MODIFY", "Modify"));
                break;
            }
            case 11: {
                results.put(1, this.getContext().localize("app.OwRoleManager.ROLE_ACCESS_MASK_FLAG_DYNAMIC_RESOURCE_MODIFY", "Modify"));
                break;
            }
        }
        return results;
    }

    @Override
    public boolean isGlobalRole(String rolename_p) {
        return this.getContext().getMandatorManager().getGlobalRoleNames().contains(rolename_p);
    }

    public static class StandardFunctionResources {
        public Map m_Resources = new HashMap();

        public StandardFunctionResources() {
            this.m_Resources.put("owcaneditsitesettings", new OwString("app.OwRoleManager.stdfunctions.editsitesettings", "Edit site settings"));
        }
    }

    public static class CategoryNames {
        public Map m_categories = new HashMap();

        public CategoryNames() {
            this.m_categories.put(1, new OwString("app.OwRoleManager.plugin", "Plugin"));
            this.m_categories.put(3, new OwString("app.OwRoleManager.groupbox", "Virtual Queue"));
            this.m_categories.put(5, new OwString("app.OwRoleManager.template", "Search Template"));
            this.m_categories.put(6, new OwString("app.OwRoleManager.function", "Supplementary Function"));
            this.m_categories.put(7, new OwString("app.OwRoleManager.design", "Design"));
            this.m_categories.put(8, new OwString("app.OwRoleManager.selectiveconfiguration", "Selective Configuration"));
            this.m_categories.put(9, new OwString("app.OwRoleManager.objectclasses", "Object Class"));
            this.m_categories.put(10, new OwString("app.OwRoleManager.indexfields", "Index Field"));
            this.m_categories.put(11, new OwString("app.OwRoleManager.startupfolder", "Startup Folder"));
            this.m_categories.put(12, new OwString("app.OwRoleManager.virtualFolder", "Virtual Folder"));
        }
    }
}

