/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.roleimpl.simplerole;

import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.role.OwStandardRoleManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class OwSimpleRoleManager
extends OwStandardRoleManager {
    private Map m_precalculatedSimpleAccessMasks;

    @Override
    public boolean isAllowed(int iCategory_p, String strResourceID_p) throws Exception {
        return this.getAccessRights(this.getCurrentUser().getUserName(), iCategory_p, strResourceID_p) == 1;
    }

    @Override
    public boolean hasAccessMaskRight(int iCategory_p, String strResourceID_p, int requiredAccessMask_p) throws Exception {
        if (!this.isAllowed(iCategory_p, strResourceID_p)) {
            return false;
        }
        return (this.getAccessMask(this.getCurrentUser().getUserName(), iCategory_p, strResourceID_p) & requiredAccessMask_p) == requiredAccessMask_p;
    }

    @Override
    public int getAccessRights(String roleName_p, int category_p, String resourceId_p) throws Exception {
        if (category_p == 6 && resourceId_p.equals("owcaneditsitesettings")) {
            return this.getConfigNode().getSafeStringSet("SiteAdmins").contains(roleName_p) ? 1 : 0;
        }
        return 1;
    }

    @Override
    public Collection getAllowedResources(int category_p) throws Exception {
        return this.getResources(category_p);
    }

    @Override
    public Collection getMasterRoles() throws Exception {
        return null;
    }

    @Override
    public String getMasterRoleDisplayName(Locale locale_p, String strRole_p) throws Exception {
        return strRole_p;
    }

    @Override
    public String getMasterRole() throws Exception {
        return null;
    }

    @Override
    public boolean setMasterRole(String strRole_p) throws Exception {
        return false;
    }

    @Override
    public boolean hasMasterRoles() {
        return false;
    }

    @Override
    public void setAccessRights(String roleName_p, int category_p, String resourceId_p, int accessRights_p) throws Exception {
        throw new OwNotSupportedException(this.getContext().localize("roleimpl.simplerole.OwSimpleRoleManager.accessrightschangenotsupported", "Changing access rights is not supported by SimpleRoleManager."));
    }

    @Override
    public boolean canExplicitDeny() {
        return false;
    }

    @Override
    public boolean isGlobalRoleModificationAllowed() {
        return false;
    }

    protected Map getPrecalculatedSimpleAccessMasks() {
        if (this.m_precalculatedSimpleAccessMasks == null) {
            this.m_precalculatedSimpleAccessMasks = new HashMap();
            Collection categories = this.getCategories();
            Iterator itCategories = categories.iterator();
            while (itCategories.hasNext()) {
                int fullAccessMask = 0;
                int category = (Integer)itCategories.next();
                Map accessFlags = this.getAccessMaskDescriptions(category);
                Iterator itFlags = accessFlags.keySet().iterator();
                while (itFlags.hasNext()) {
                    int flag = (Integer)itFlags.next();
                    fullAccessMask |= flag;
                }
                this.m_precalculatedSimpleAccessMasks.put(category, fullAccessMask);
            }
        }
        return this.m_precalculatedSimpleAccessMasks;
    }

    @Override
    public int getAccessMask(String roleName_p, int category_p, String resourceId_p) {
        Integer fullAccessMask = (Integer)this.getPrecalculatedSimpleAccessMasks().get(category_p);
        return fullAccessMask == null ? 0 : fullAccessMask;
    }

    @Override
    public void setAccessMask(String roleName_p, int category_p, String resourceId_p, int accessMask_p) throws Exception {
        throw new OwNotSupportedException(this.getContext().localize("roleimpl.simplerole.OwSimpleRoleManager.accessrightschangenotsupported", "Changing access rights is not supported by SimpleRoleManager."));
    }

    @Override
    public boolean canPersistAccessMask() {
        return false;
    }

    @Override
    protected Collection<String> getDynamicResources(int category_p) {
        return Collections.emptyList();
    }

    @Override
    public void replaceResource(String roleName_p, int category_p, String oldResourceId_p, String newResourceId_p) throws Exception {
    }

    @Override
    protected String dynamicResourceNameFromId(Locale locale_p, String resourceId_p, int category_p) {
        return resourceId_p;
    }
}

