/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.log.OwLogCore;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class OwGetPropertyContent
extends HttpServlet {
    private static final Logger LOG = OwLogCore.getLogger(OwGetPropertyContent.class);
    private static final long serialVersionUID = 1680461643878695932L;
    private static final String DEFAULT_RESOURCE_INIT_PARAMETER = "default_resource";
    private static final String DEFAULT_RESOURCE_CONTENT_TYPE_INIT_PARAMETER = "default_resource_content_type";
    private String m_defaultResource;
    private String m_defaultResourceContentType;

    public void init() throws ServletException {
        this.m_defaultResource = this.getInitParameter(DEFAULT_RESOURCE_INIT_PARAMETER);
        this.m_defaultResourceContentType = this.getInitParameter(DEFAULT_RESOURCE_CONTENT_TYPE_INIT_PARAMETER);
    }

    private void processWithDefaultResource(HttpServletRequest request_p, HttpServletResponse response_p) throws IOException {
        if (this.m_defaultResource != null && this.m_defaultResourceContentType != null) {
            int readCount;
            URL defaultResourceURL = this.getServletContext().getResource(this.m_defaultResource);
            InputStream defaultResourceStream = defaultResourceURL.openStream();
            response_p.setContentType(this.m_defaultResourceContentType);
            ServletOutputStream stream = response_p.getOutputStream();
            byte[] readBuffer = new byte[2048];
            while ((readCount = defaultResourceStream.read(readBuffer)) != -1) {
                stream.write(readBuffer, 0, readCount);
            }
            defaultResourceStream.close();
            stream.flush();
            stream.close();
        } else {
            LOG.debug((Object)"No default resource configured !");
            response_p.flushBuffer();
        }
    }

    protected void doGet(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
        this.processRequest(request_p, response_p);
    }

    protected void doPost(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
        this.processRequest(request_p, response_p);
    }

    protected void processRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
        block11: {
            HttpSession session = request_p.getSession();
            OwMainAppContext context = (OwMainAppContext)session.getAttribute("ow_Context");
            try {
                if (context == null) {
                    String contextMissingMsg = "Alfresco Workdesk context missing!This might not be a Alfresco Workdesk session!";
                    LOG.debug((Object)contextMissingMsg);
                    throw new ServletException(contextMissingMsg);
                }
                if (!context.isLogin()) {
                    String userIsNotLoggedIn = "User is not logged in!";
                    LOG.debug((Object)userIsNotLoggedIn);
                    throw new ServletException(userIsNotLoggedIn);
                }
                String strDMSID = request_p.getParameter("dmsid");
                String strContentMimeType = request_p.getParameter("cmimetype");
                String strPropertyName = request_p.getParameter("cproperty");
                try {
                    OwObject object = context.getNetwork().getObjectFromDMSID(strDMSID, false);
                    OwObjectClass objectClass = object.getObjectClass();
                    OwPropertyClass contentPropertyClass = objectClass.getPropertyClass(strPropertyName);
                    if (contentPropertyClass != null) {
                        OwProperty property = object.getProperty(strPropertyName);
                        Object propertyValue = property.getValue();
                        if (propertyValue == null) {
                            this.processWithDefaultResource(request_p, response_p);
                        } else if (propertyValue instanceof byte[]) {
                            byte[] byteArrayValue = (byte[])propertyValue;
                            response_p.setContentType(strContentMimeType);
                            ServletOutputStream stream = response_p.getOutputStream();
                            stream.write(byteArrayValue);
                            stream.flush();
                            stream.close();
                        } else {
                            String missingContentProperty = "Content property : " + strContentMimeType + " of " + strDMSID + " has invalid value type " + propertyValue.getClass() + "  while byte[] was expected!";
                            LOG.debug((Object)missingContentProperty);
                            this.processWithDefaultResource(request_p, response_p);
                        }
                        break block11;
                    }
                    String missingContentProperty = "Missing content property : " + strContentMimeType + " for object : " + strDMSID;
                    LOG.debug((Object)missingContentProperty);
                    this.processWithDefaultResource(request_p, response_p);
                }
                catch (Exception e) {
                    String objectAccessFailedMsg = "Could not access object for property content!";
                    LOG.debug((Object)objectAccessFailedMsg, (Throwable)e);
                    this.processWithDefaultResource(request_p, response_p);
                }
            }
            catch (Exception e) {
                String contextError = "Error checking context!";
                LOG.debug((Object)contextError, (Throwable)e);
                throw new ServletException(contextError, (Throwable)e);
            }
        }
    }
}

