/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.servlets.OwServerContext;
import com.wewebu.ow.server.servlets.OwServletBaseInitializer;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public abstract class OwInitialisingContextListener
implements ServletContextListener,
OwBaseInitializer {
    private static final Logger LOG = OwLogCore.getLogger(OwInitialisingContextListener.class);
    public static final String STARTUP_ERROR_KEY = "STARTUP_ERROR_KEY";
    protected ServletContext m_ServletContext;
    private OwServerContext m_serverContext;
    private OwBaseInitializer baseInitializer;

    public void init(ServletContext servletContext_p) {
        this.m_ServletContext = servletContext_p;
        this.m_serverContext = OwServerContext.from(servletContext_p);
        this.baseInitializer = new OwServletBaseInitializer(servletContext_p);
        try {
            this.applicationInitalize();
        }
        catch (OwConfigurationException e) {
            LOG.fatal((Object)"Errors detected on starting up the application. Please check your configuration files...", (Throwable)e);
            this.m_ServletContext.setAttribute(STARTUP_ERROR_KEY, (Object)e);
        }
        catch (OwServerException e) {
            LOG.fatal((Object)"Errors detected on starting up the application. Server errors detected...", (Throwable)e);
            this.m_ServletContext.setAttribute(STARTUP_ERROR_KEY, (Object)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(this.getClass().getName() + ".contextInitialized: ...finished"));
        }
    }

    public void contextInitialized(ServletContextEvent event_p) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(this.getClass().getName() + ".contextInitialized: started..."));
        }
        this.init(event_p.getServletContext());
    }

    public void contextDestroyed(ServletContextEvent arg0_p) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"OwInitialisingContextListener.contextDestroyed");
        }
        if (this.m_ServletContext != null) {
            Enumeration names = this.m_ServletContext.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                this.m_ServletContext.removeAttribute(name);
            }
            this.m_ServletContext = null;
        }
    }

    protected abstract void applicationInitalize() throws OwConfigurationException, OwServerException;

    @Override
    public Object getApplicationAttribute(String key_p) {
        return this.baseInitializer.getApplicationAttribute(key_p);
    }

    @Override
    public Object setApplicationAttribute(String key_p, Object object_p) {
        return this.baseInitializer.setApplicationAttribute(key_p, object_p);
    }

    @Override
    public String getBasePath() {
        return this.baseInitializer.getBasePath();
    }

    @Override
    public String getInitParameter(String strParamName_p) {
        return this.baseInitializer.getInitParameter(strParamName_p);
    }

    @Override
    public InputStream getXMLConfigDoc(String strName_p) throws Exception {
        return this.baseInitializer.getXMLConfigDoc(strName_p);
    }

    @Override
    public URL getConfigURL(String strName_p) throws Exception {
        return this.baseInitializer.getConfigURL(strName_p);
    }
}

