/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.history.OwStandardHistoryObjectChangeEvent;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.servlets.OwAbstractUpload;
import com.wewebu.ow.server.servlets.download.OwHttpContentDisposition;
import com.wewebu.ow.server.util.OwStreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class OwMultifileDownload
extends OwAbstractUpload {
    private static final String HTTP_HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final long serialVersionUID = -7317019966397901048L;
    private static final Logger LOG = OwLogCore.getLogger(OwMultifileDownload.class);
    public static final String ATTRIBUTE_NAME_FILES_TO_DOWNLOAD = "OwMultifileDownload.files2download";
    private static final String PARAM_ZIP_FILENAME = "download_file_name";
    private static final String PARAM_FILENAME_ENCODING = "file_name_encoding";
    private static final String PARAM_SINGLE_FILE_ZIPPED = "single_file_zipped";
    private String m_encodingFileName = "UTF-8";
    private String m_zipFileName;
    private boolean m_singleFileToBeZipped;

    public String getServletInfo() {
        return "Servlet to upload zipped multifile for Alfresco Workdesk.";
    }

    public void init(ServletConfig config_p) throws ServletException {
        String encoding;
        super.init(config_p);
        String singleFileZipped = config_p.getInitParameter(PARAM_SINGLE_FILE_ZIPPED);
        this.m_singleFileToBeZipped = singleFileZipped == null || !singleFileZipped.equals("false");
        String fileName = config_p.getInitParameter(PARAM_ZIP_FILENAME);
        if (fileName != null) {
            this.m_zipFileName = fileName;
        }
        if ((encoding = config_p.getInitParameter(PARAM_FILENAME_ENCODING)) != null) {
            this.m_encodingFileName = encoding;
        }
    }

    protected String createArchivedObjectFolderName(String objectName_p) {
        String folderName = null;
        folderName = objectName_p != null ? objectName_p.replaceAll("[<>/\\:*?\"|]", "").replaceAll("\u00c4", "Ae").replaceAll("\u00e4", "ae").replaceAll("\u00d6", "Oe").replaceAll("\u00f6", "oe").replaceAll("\u00dc", "Ue").replaceAll("\u00fc", "ue").replaceAll("\u00df", "ss") : "undef";
        return folderName;
    }

    protected String createArchivedContentFileName(String defaultName_p, OwContentElement element_p) {
        String fileName;
        try {
            fileName = this.createFileName(defaultName_p, element_p);
        }
        catch (Exception e) {
            fileName = "unknownFile";
        }
        return fileName;
    }

    protected OwFolderArchiveEntry createContentArchive(List<OwObject> objectsToZip_p, OwMainAppContext context_p) throws IOException {
        LOG.info((Object)"OwMultifileDownload.createContentArchive: Creating Contents Archive ...");
        OwFolderArchiveEntry root = new OwFolderArchiveEntry();
        for (OwObject owObject : objectsToZip_p) {
            String msg;
            int pageCount;
            String objectName = owObject.getName();
            try {
                OwContentCollection contentCollection = owObject.getContentCollection();
                pageCount = contentCollection.getPageCount();
            }
            catch (Exception e) {
                msg = "OwMultifileDownload.createContentArchive : Unexpected Exception for the document, document name=[" + objectName + "] when retrieving content collection info.";
                LOG.error((Object)msg, (Throwable)e);
                continue;
            }
            if (pageCount > 1) {
                try {
                    this.addMultiContentArchiveEntry(root, owObject);
                }
                catch (Exception e) {
                    msg = "OwMultifileDownload.createContentArchive : Unexpected Exception for the document, document name=[" + objectName + "] when creating multiple content archive entry.";
                    LOG.error((Object)msg, (Throwable)e);
                }
                continue;
            }
            if (pageCount == 1) {
                try {
                    this.addSingleContentEntry(root, owObject);
                }
                catch (Exception e) {
                    msg = "OwMultifileDownload.createContentArchive : Unexpected Exception for the document, document name=[" + objectName + "] when creating single content archive entry.";
                    LOG.error((Object)msg, (Throwable)e);
                }
                continue;
            }
            String msg2 = "OwMultifileDownload.createContentArchive : Document has no content element and is discarded, document name=[" + objectName + "]";
            LOG.warn((Object)msg2);
        }
        return root;
    }

    protected void addSingleContentEntry(OwFolderArchiveEntry parentFolder_p, OwObject object_p) throws Exception {
        OwContentElement element;
        String objectName = object_p.getName();
        String objectFolderName = this.createArchivedObjectFolderName(objectName);
        OwContentCollection contentCollection = object_p.getContentCollection();
        try {
            element = contentCollection.getContentElement(1, 1);
        }
        catch (Exception e) {
            String msg = "OwMultifileDownload.createSingleContentEntry : Unexpected Exception for the document, document name=[" + objectName + "] at content element with index [1]";
            LOG.error((Object)msg, (Throwable)e);
            throw e;
        }
        OwContentElementEntry contentElementEntry = new OwContentElementEntry(element, objectName, 1);
        String elementFileName = this.createArchivedContentFileName(objectFolderName, element);
        parentFolder_p.addChild(elementFileName, contentElementEntry);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwMultifileDownload.createSingleContentEntry: + file=[" + elementFileName + "]"));
        }
    }

    protected void addMultiContentArchiveEntry(OwFolderArchiveEntry parentFolder_p, OwObject object_p) throws Exception {
        String objectName = object_p.getName();
        OwContentCollection contentCollection = object_p.getContentCollection();
        String folderName = this.createArchivedObjectFolderName(objectName);
        OwFolderArchiveEntry objectFolderEntry = new OwFolderArchiveEntry();
        parentFolder_p.addChild(folderName, objectFolderEntry);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwMultifileDownload.createMultiContentArchiveEntry: + folder=[" + folderName + "]"));
        }
        int pageCount = contentCollection.getPageCount();
        for (int j = 0; j < pageCount; ++j) {
            OwContentElement element;
            int elementIndex = j + 1;
            try {
                element = contentCollection.getContentElement(1, elementIndex);
            }
            catch (Exception e) {
                String msg = "OwMultifileDownload.createMultiContentArchiveEntry: Unexpected Exception for the document, folder name=[" + folderName + "] at content element with index [" + elementIndex + "]";
                LOG.error((Object)msg, (Throwable)e);
                continue;
            }
            OwContentElementEntry contentElementEntry = new OwContentElementEntry(element, folderName, elementIndex);
            String elementFileName = this.createArchivedContentFileName(folderName, element);
            objectFolderEntry.addChild(elementFileName, contentElementEntry);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("OwMultifileDownload.createMultiContentArchiveEntry: + file=[" + folderName + "/" + elementFileName + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws ServletException, IOException {
        String userAgent = request_p.getHeader("User-Agent");
        LOG.info((Object)userAgent);
        try {
            HttpSession session = request_p.getSession();
            OwMainAppContext context = (OwMainAppContext)session.getAttribute("ow_Context");
            response_p.setHeader("Expires", "-1");
            response_p.setCharacterEncoding("UTF-8");
            if (context == null) {
                LOG.error((Object)"OwMultifileDownload.processRequest: Could not get Alfresco Workdesk context.");
                this.tidyUp(session);
                return;
            }
            List filesToZip = (List)session.getAttribute(ATTRIBUTE_NAME_FILES_TO_DOWNLOAD);
            if (filesToZip == null || filesToZip.size() == 0) {
                String errorMsg = context.localize("servlets.OwMultifileDownload.nofilesfound", "No valid files found to download.");
                this.writeErrorMessagePage(response_p, errorMsg);
                this.tidyUp(session);
                return;
            }
            ArrayList<OwObject> filesToZipWithContent = new ArrayList<OwObject>();
            for (OwObject owObject : filesToZip) {
                try {
                    boolean hasContent = owObject.hasContent(2);
                    if (!hasContent) continue;
                    filesToZipWithContent.add(owObject);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot obtain the content status from the object", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            }
            ServletOutputStream servletOutStream = response_p.getOutputStream();
            ZipOutputStream zipOutputStream = null;
            try {
                if (filesToZipWithContent.size() > 0) {
                    OwFolderArchiveEntry archive = this.createContentArchive(filesToZipWithContent, context);
                    if (archive.isSingleFileEntry() && !this.m_singleFileToBeZipped) {
                        archive.serveSingleFileOn(request_p, response_p, "");
                    } else {
                        response_p.setContentType("application/zip");
                        response_p.addHeader(HTTP_HEADER_CONTENT_DISPOSITION, "attachment;filename=\"" + this.m_zipFileName + "\"");
                        zipOutputStream = new ZipOutputStream((OutputStream)servletOutStream);
                        zipOutputStream.setEncoding(this.m_encodingFileName);
                        archive.zipIt(zipOutputStream, "");
                    }
                }
            }
            finally {
                block27: {
                    block26: {
                        try {
                            if (zipOutputStream != null) {
                                zipOutputStream.flush();
                                zipOutputStream.close();
                            }
                        }
                        catch (IOException ex) {
                            if (!LOG.isDebugEnabled()) break block26;
                            LOG.debug((Object)"Error during closing of ZIP stream handler", (Throwable)ex);
                        }
                    }
                    try {
                        if (servletOutStream != null) {
                            servletOutStream.flush();
                            servletOutStream.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!LOG.isDebugEnabled()) break block27;
                        LOG.debug((Object)"Error during closing native servlet stream", (Throwable)ex);
                    }
                }
                this.tidyUp(session);
            }
            try {
                context.getHistoryManager().addEvent(6, "download", new OwStandardHistoryObjectChangeEvent(filesToZipWithContent, null), 1);
            }
            catch (Exception e) {
                LOG.error((Object)"OwMultifileDownload.processRequest: Writing history failed!", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.writeErrorMessagePage(response_p, e.toString());
        }
    }

    private void tidyUp(HttpSession session_p) {
        session_p.setAttribute(ATTRIBUTE_NAME_FILES_TO_DOWNLOAD, null);
    }

    private void writeErrorMessagePage(HttpServletResponse response_p, String errorMsg_p) throws IOException {
        response_p.setContentType("text/html");
        PrintWriter writer = response_p.getWriter();
        writer.write("<html><body>");
        writer.write(errorMsg_p);
        writer.write("<br><br>");
        writer.write("<FORM><INPUT TYPE=\"button\" VALUE=\"Back\" onClick=\"history.go(-1);return true;\"> </FORM>");
        writer.write("</body></html>");
        response_p.flushBuffer();
    }

    protected class OwFolderArchiveEntry
    implements OwContentArchiveEntry {
        private Map<String, List<OwContentArchiveEntry>> m_childrenTable = new HashMap<String, List<OwContentArchiveEntry>>();

        public void addChild(String childName_p, OwContentArchiveEntry entry_p) {
            List<OwContentArchiveEntry> childEntries = this.m_childrenTable.get(childName_p);
            if (childEntries == null) {
                childEntries = new LinkedList<OwContentArchiveEntry>();
                this.m_childrenTable.put(childName_p, childEntries);
            }
            childEntries.add(entry_p);
        }

        private String createIndexedChildName(String childName_p, int index_p) {
            String suffix;
            String prefix;
            int dotIndex = childName_p.lastIndexOf(46);
            if (dotIndex != -1) {
                prefix = childName_p.substring(0, dotIndex);
                suffix = childName_p.substring(dotIndex);
            } else {
                prefix = childName_p;
                suffix = "";
            }
            return prefix + "_" + index_p + suffix;
        }

        private String createChildZipPath(String path_p, String childName_p) {
            if (path_p != null && path_p.length() > 0) {
                return path_p + "/" + childName_p;
            }
            return childName_p;
        }

        @Override
        public int fileCount() {
            Set<Map.Entry<String, List<OwContentArchiveEntry>>> entries = this.m_childrenTable.entrySet();
            int fileCount = 0;
            for (Map.Entry<String, List<OwContentArchiveEntry>> childrenMapEntry : entries) {
                List<OwContentArchiveEntry> children = childrenMapEntry.getValue();
                for (OwContentArchiveEntry entry : children) {
                    fileCount += entry.fileCount();
                }
            }
            return fileCount;
        }

        public boolean isSingleFileEntry() {
            return this.fileCount() == 1;
        }

        private Map.Entry<String, List<OwContentArchiveEntry>> getSingleFileMapEntry() throws OwInvalidOperationException {
            if (this.isSingleFileEntry()) {
                Set<Map.Entry<String, List<OwContentArchiveEntry>>> entries = this.m_childrenTable.entrySet();
                for (Map.Entry<String, List<OwContentArchiveEntry>> childrenMapEntry : entries) {
                    List<OwContentArchiveEntry> children = childrenMapEntry.getValue();
                    for (OwContentArchiveEntry archiveEntry : children) {
                        if (archiveEntry.fileCount() <= 0) continue;
                        return childrenMapEntry;
                    }
                }
                throw new OwInvalidOperationException("OwFolderArchiveEntry.getContentMimeType:Single file archive but no child file in children table!");
            }
            throw new OwInvalidOperationException("OwFolderArchiveEntry.getContentMimeType:Archive content MIME type retrieval permitted only on sigle file archives! ");
        }

        @Override
        public void serveSingleFileOn(HttpServletRequest request_p, HttpServletResponse response_p, String fileName_p) throws OwInvalidOperationException {
            if (this.isSingleFileEntry()) {
                Map.Entry<String, List<OwContentArchiveEntry>> singleFileMapEntry = this.getSingleFileMapEntry();
                String entryName = singleFileMapEntry.getKey();
                List<OwContentArchiveEntry> contentEntries = singleFileMapEntry.getValue();
                for (OwContentArchiveEntry singleContentEntry : contentEntries) {
                    if (singleContentEntry.fileCount() <= 0) continue;
                    singleContentEntry.serveSingleFileOn(request_p, response_p, entryName);
                    break;
                }
            } else {
                throw new OwInvalidOperationException("OwFolderArchiveEntry.serveSingleFileOn: Archive content  single file serving is permitted only on sigle file archives! ");
            }
        }

        @Override
        public void zipIt(ZipOutputStream zipOutputStream_p, String path_p) throws Exception {
            Set<Map.Entry<String, List<OwContentArchiveEntry>>> childEntries = this.m_childrenTable.entrySet();
            for (Map.Entry<String, List<OwContentArchiveEntry>> entry : childEntries) {
                int childrenCount = entry.getValue().size();
                if (childrenCount > 1) {
                    int j = 0;
                    for (OwContentArchiveEntry contententry : entry.getValue()) {
                        String indexedName = this.createIndexedChildName(entry.getKey(), ++j);
                        String zipPath = this.createChildZipPath(path_p, indexedName);
                        contententry.zipIt(zipOutputStream_p, zipPath);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("OwFolderArchiveEntry.zipOn: Z> [" + zipPath + "]"));
                    }
                    continue;
                }
                if (childrenCount != 1) continue;
                OwContentArchiveEntry contententry = entry.getValue().get(0);
                String zipPath = this.createChildZipPath(path_p, entry.getKey());
                contententry.zipIt(zipOutputStream_p, zipPath);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("OwFolderArchiveEntry.zipOn: Z> [" + zipPath + "]"));
            }
        }
    }

    protected class OwContentElementEntry
    extends OwBufferedSingleContentEntry {
        private OwContentElement m_element;
        private String m_objectName;
        private int m_elementIndex_p;

        public OwContentElementEntry(OwContentElement element_p, String objectName_p, int elementIndex_p) {
            this.m_element = element_p;
            this.m_objectName = objectName_p;
            this.m_elementIndex_p = elementIndex_p;
        }

        @Override
        protected String createMimeType() throws Exception {
            try {
                return this.m_element.getMIMEType();
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not get MIME type for document name=[" + this.m_objectName + "] at content element with index [" + this.m_elementIndex_p + "]. ''application/octet-stream'' will be used !"), (Throwable)e);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void downloadFile(ServletOutputStream responseOutputStream_p) throws Exception {
            if (this.m_element.getContentRepresentation() == 2) {
                if (this.m_element.isInputStreamNative()) {
                    InputStream input = this.m_element.getContentStream(null);
                    try {
                        OwStreamUtil.upload(input, (OutputStream)responseOutputStream_p, false);
                    }
                    finally {
                        input.close();
                    }
                } else {
                    this.m_element.getContentStream((OutputStream)responseOutputStream_p);
                }
            } else {
                LOG.warn((Object)new StringBuilder("OwContentElementEntry.createContentBuffer : currently we just support Content Type Stream in OwContentElement, documentName=[").append(this.m_objectName).append("] with content element index [").append(this.m_elementIndex_p).append("]"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zipIt(ZipOutputStream zipOutputStream_p, String fileName_p) throws Exception {
            ZipEntry ze = new ZipEntry(fileName_p);
            zipOutputStream_p.putNextEntry(ze);
            if (this.m_element.getContentRepresentation() == 2) {
                InputStream fileAsStream = null;
                fileAsStream = this.m_element.getContentStream(null);
                try {
                    OwStreamUtil.upload(fileAsStream, (OutputStream)zipOutputStream_p, false);
                }
                finally {
                    fileAsStream.close();
                }
            }
            zipOutputStream_p.closeEntry();
        }
    }

    protected abstract class OwBufferedSingleContentEntry
    implements OwContentArchiveEntry {
        protected OwBufferedSingleContentEntry() {
        }

        @Override
        public final int fileCount() {
            return 1;
        }

        protected abstract void downloadFile(ServletOutputStream var1) throws Exception;

        protected abstract String createMimeType() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void serveSingleFileOn(HttpServletRequest request_p, HttpServletResponse response_p, String fileName_p) throws OwInvalidOperationException {
            try {
                String mimeType = null;
                try {
                    mimeType = this.createMimeType();
                }
                catch (Exception e) {
                    LOG.warn((Object)"OwBufferedSingleContentEntry.serveSingleFileOn : Could not get MIME type. ''application/octet-stream'' will be used !", (Throwable)e);
                    mimeType = "application/octet-stream";
                }
                response_p.setContentType(mimeType);
                OwHttpContentDisposition attachmentElement = OwHttpContentDisposition.forRequest(request_p, fileName_p, OwHttpContentDisposition.OwElementType.ATTACHMENT);
                response_p.addHeader(OwMultifileDownload.HTTP_HEADER_CONTENT_DISPOSITION, attachmentElement.toString());
                ServletOutputStream responseOutputStream = response_p.getOutputStream();
                try {
                    this.downloadFile(responseOutputStream);
                }
                finally {
                    responseOutputStream.flush();
                    responseOutputStream.close();
                }
            }
            catch (Exception e) {
                String msg = "Could not get content stream for document!";
                LOG.error((Object)msg, (Throwable)e);
                throw new OwInvalidOperationException(msg, (Throwable)e);
            }
        }
    }

    protected static interface OwContentArchiveEntry {
        public void zipIt(ZipOutputStream var1, String var2) throws Exception;

        public void serveSingleFileOn(HttpServletRequest var1, HttpServletResponse var2, String var3) throws OwInvalidOperationException;

        public int fileCount();
    }
}

