/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets;

import com.wewebu.ow.server.conf.OwBaseInitializer;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.servlets.OwServerContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class OwServletBaseInitializer
implements OwBaseInitializer {
    private static final Logger LOG = OwLogCore.getLogger(OwServletBaseInitializer.class);
    private ServletContext servletContext;
    private OwServerContext serverContext;
    private String basePath;

    public OwServletBaseInitializer(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.serverContext = OwServerContext.from(servletContext);
        this.initBasePath();
    }

    private void initBasePath() {
        this.basePath = this.servletContext.getRealPath("");
        if (this.basePath == null) {
            try {
                String deploymentUrl = this.servletContext.getResource("/").toExternalForm();
                File file = new File(new URI(deploymentUrl));
                this.basePath = file.getPath();
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Could not get BasePath...", (Throwable)e);
            }
            catch (URISyntaxException e) {
                LOG.error((Object)"Could not get BasePath...", (Throwable)e);
            }
        }
        if (this.basePath.endsWith("/") || this.basePath.endsWith("\\")) {
            this.basePath = this.basePath.substring(0, this.basePath.length() - 1);
        }
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getInitParameter(String strParamName_p) {
        return this.servletContext.getInitParameter(strParamName_p);
    }

    @Override
    public InputStream getXMLConfigDoc(String strName_p) {
        URL configURL = null;
        String file = "ow" + strName_p + ".xml";
        try {
            configURL = this.getConfigURL(file);
        }
        catch (Exception e) {
            String msg = "Initialisation Error: Cannot get the configuration from URL=" + configURL;
            LOG.error((Object)msg, (Throwable)e);
            return null;
        }
        try {
            return configURL.openStream();
        }
        catch (IOException ioE) {
            String msg = "Initialisation Error: Cannot open the XML file, file not found (" + file + ")! Configuration URL=" + (configURL == null ? "null" : configURL.toString());
            LOG.error((Object)msg, (Throwable)ioE);
            return null;
        }
    }

    private String getConfigPath() {
        String strResourceFilePath = null;
        String strEnvironmentVarName = this.getInitParameter("OwResourceFilePathEnvironmentVarName");
        if (strEnvironmentVarName != null && strEnvironmentVarName.length() > 0) {
            try {
                strResourceFilePath = System.getProperty(strEnvironmentVarName);
            }
            catch (Exception e) {
                LOG.error((Object)("Can not read System property '" + strEnvironmentVarName + "' to get the config location. Using ResourceFilePath (if any) or default location instead."), (Throwable)e);
            }
        }
        if (strResourceFilePath == null) {
            strResourceFilePath = this.serverContext.getResourceFilePath();
        }
        if (strResourceFilePath == null || strResourceFilePath.length() == 0) {
            return this.getBasePath() + "/WEB-INF";
        }
        if (strResourceFilePath.startsWith("deploy#")) {
            return this.getBasePath() + "/" + strResourceFilePath.substring("deploy#".length(), strResourceFilePath.length());
        }
        return strResourceFilePath;
    }

    @Override
    public URL getConfigURL(String strName_p) throws Exception {
        URL configUrl = null;
        StringBuffer jndiParameterName = new StringBuffer();
        jndiParameterName.append(strName_p);
        jndiParameterName.append("JNDI");
        String strJNDIName = this.getInitParameter(jndiParameterName.toString());
        if (strJNDIName != null) {
            InitialContext ctx = new InitialContext();
            configUrl = (URL)ctx.lookup(strJNDIName);
        }
        if (configUrl == null) {
            String resourceFilePath = this.serverContext.getResourceFilePath();
            if (resourceFilePath != null && resourceFilePath.startsWith("lib#")) {
                String configurationPathPrefix = resourceFilePath.substring("lib#".length(), resourceFilePath.length());
                StringBuffer resourcePath = new StringBuffer();
                resourcePath.append("/");
                resourcePath.append(configurationPathPrefix);
                resourcePath.append("/");
                resourcePath.append(strName_p);
                return this.getClass().getResource(resourcePath.toString());
            }
            configUrl = new File(this.getConfigPath() + "/" + strName_p).toURL();
        }
        return configUrl;
    }

    @Override
    public Object getApplicationAttribute(String key_p) {
        return this.servletContext.getAttribute(key_p);
    }

    @Override
    public Object setApplicationAttribute(String key_p, Object object_p) {
        Object previousObject = this.servletContext.getAttribute(key_p);
        if (object_p != null) {
            this.servletContext.setAttribute(key_p, object_p);
        } else {
            this.servletContext.removeAttribute(key_p);
        }
        return previousObject;
    }
}

