/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.servlets.download;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public class OwHttpContentDisposition {
    private static final String UTF_8 = "UTF-8";
    private static final String HTTP_HEADER_USER_AGENT = "User-Agent";
    private String encodedFileName;
    private OwElementType elementType;

    private OwHttpContentDisposition(String encodedFileName_p, OwElementType elementType_p) {
        this.encodedFileName = encodedFileName_p;
        this.elementType = elementType_p;
    }

    public static OwHttpContentDisposition forRequest(HttpServletRequest request_p, String fileName_p, OwElementType elementType_p) throws UnsupportedEncodingException {
        String userAgent = request_p.getHeader(HTTP_HEADER_USER_AGENT);
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        boolean is_ISO_8859_1 = encoder.canEncode(fileName_p);
        if (!is_ISO_8859_1) {
            String encodedFileName = userAgent.contains("MSIE") || userAgent.contains("Opera") ? URLEncoder.encode(fileName_p, UTF_8) : "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])fileName_p.getBytes(UTF_8)), UTF_8) + "?=";
            return new OwHttpContentDisposition(encodedFileName, elementType_p);
        }
        return new OwHttpContentDisposition(fileName_p, elementType_p);
    }

    public String toString() {
        return this.elementType.toString() + ";filename=\"" + this.encodedFileName + "\"";
    }

    public static enum OwElementType {
        ATTACHMENT("attachment"),
        INLINE("inline");

        private String elName;

        private OwElementType(String elName_p) {
            this.elName = elName_p;
        }

        public String toString() {
            return this.elName;
        }
    }
}

