/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.settingsimpl;

import com.wewebu.ow.server.app.OwEditablePropertyDate;
import com.wewebu.ow.server.app.OwFieldManagerException;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwUserSelectDialog;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.settingsimpl.OwSettingsPropertyBaseImpl;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OwSettingsPropertyBPMProxy
extends OwSettingsPropertyBaseImpl
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLogCore.getLogger(OwSettingsPropertyBPMProxy.class);
    private static final String PROXY_PERSON_ID_FROM_DATE = "_fromdate";
    private static final String PROXY_PERSON_ID_TO_DATE = "_todate";
    private String m_sAbsentPersonID;
    private boolean m_fAdmin;

    @Override
    public void init(Node propertyDefinitionNode_p, Node valueNode_p, String strSetName_p) throws Exception {
        Object value;
        this.m_propertyDefinitionNode = propertyDefinitionNode_p;
        this.m_strSetName = strSetName_p;
        this.m_fList = OwXMLDOMUtil.getSafeBooleanAttributeValue(propertyDefinitionNode_p, "list", false);
        if (this.m_fList) {
            value = null;
            this.m_defaultValue = new ArrayList();
        } else {
            value = null;
            this.m_defaultValue = null;
        }
        this.setValue(value);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        OwMainAppContext mainContext = (OwMainAppContext)this.getContext();
        this.m_fAdmin = mainContext.isAllowed(6, "owcaneditsitesettings");
        OwCredentials credentials = mainContext.getCredentials();
        OwUserInfo userInfo = credentials.getUserInfo();
        this.m_sAbsentPersonID = userInfo.getUserID();
    }

    @Override
    public Node getValueNode(Document doc_p) {
        return doc_p.createElement("property");
    }

    protected OwWorkitemRepository getBPMRepository() throws Exception {
        return (OwWorkitemRepository)((OwMainAppContext)this.getContext()).getNetwork().getInterface("com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository", null);
    }

    @Override
    public Object getValue() {
        if (this.m_value == null && this.isList()) {
            try {
                this.m_value = this.getBPMRepository().getProxies(this.getAbsentUserID());
            }
            catch (Exception e) {
                LOG.debug((Object)"Can not get the value of the properties, possible cause: no DB DataSource configured, property not found... Please analyze the Stacktrace....", (Throwable)e);
            }
        }
        return this.m_value;
    }

    protected String getAbsentUserID() throws Exception {
        return this.m_sAbsentPersonID;
    }

    @Override
    public void insertFormField(Writer w_p) throws Exception {
        if (this.m_fAdmin) {
            w_p.write("<div class='OwPropertyName' style='padding-top:5px;padding-bottom:15px;'>");
            w_p.write("<label for='absentPersonId'>");
            String tooltip = this.getContext().localize("settingsimpl.OwSettingsPropertyBPMProxy.absentuserselect", "Select absent person");
            w_p.write(tooltip);
            w_p.write("</label>");
            w_p.write(":&nbsp;");
            w_p.write("<input size='32' id='absentPersonId' class='OwInputControl' readonly type='text' value='");
            w_p.write(this.getUserDisplayName(this.getAbsentUserID()));
            w_p.write("'>");
            w_p.write("<a title='");
            w_p.write(tooltip);
            w_p.write("' href=\"");
            w_p.write(this.getFormEventURL("SelectAbsentPerson", null));
            w_p.write("\"><img border='0' align='absmiddle' src='");
            w_p.write(this.getContext().getDesignURL());
            w_p.write("/images/user.png'");
            w_p.write(" alt='");
            w_p.write(tooltip);
            w_p.write("' title='");
            w_p.write(tooltip);
            w_p.write("'/></a>");
            w_p.write("</div>");
        }
        super.insertFormField(w_p);
    }

    protected String getUserDisplayName(String sID_p) {
        try {
            OwMainAppContext context = (OwMainAppContext)this.getContext();
            OwNetwork network = context.getNetwork();
            OwUserInfo userInfo = network.getUserFromID(sID_p);
            return userInfo.getUserDisplayName();
        }
        catch (OwObjectNotFoundException e) {
            if (null != sID_p) {
                return sID_p;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("OwSettingsPropertyBPMProxy.getUserDisplayName: Error getting User with Id = " + sID_p), (Throwable)e);
        }
        return "";
    }

    @Override
    protected void insertFormValue(Writer w_p, Object value_p, String strID_p, int iIndex_p) throws Exception {
        OwWorkitemRepository.OwProxyInfo info = (OwWorkitemRepository.OwProxyInfo)value_p;
        String sProxyPerson = info.getProxyPersonID();
        Date fromdate = info.getStarttime();
        Date todate = info.getEndtime();
        w_p.write("<span class='OwPropertyName'>");
        w_p.write("<table border=0 cellpadding=0 cellspacing=0><tr><td style=\"text-align: left; vertical-align: middle;\">");
        w_p.write("<input size='32' title='" + this.getContext().localize1("settingsimpl.OwSettingsPropertyBPMProxy.indexed.proxy.title", "Proxy number %1", "" + (iIndex_p + 1)) + "'class='OwInputControl' readonly type='text' value='");
        if (sProxyPerson != null) {
            w_p.write(this.getUserDisplayName(sProxyPerson));
        } else {
            w_p.write("");
        }
        w_p.write("'>");
        w_p.write("&nbsp;");
        w_p.write("<a title='");
        String tooltip = this.getContext().localize("settingsimpl.OwSettingsPropertyBPMProxy.proxyuserselect", "Select Proxy");
        w_p.write(tooltip);
        w_p.write("' href=\"");
        w_p.write(this.getFormEventURL("SelectProxyPerson", "item=" + String.valueOf(iIndex_p)));
        w_p.write("\"><img border='0' align='absmiddle' src='");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/user.png'");
        w_p.write(" alt='");
        w_p.write(tooltip);
        w_p.write("' title='");
        w_p.write(tooltip);
        w_p.write("'/></a>");
        w_p.write("&nbsp;");
        w_p.write("</td><td style=\"text-align: left; vertical-align: middle;\">");
        w_p.write(this.getContext().localize("settingsimpl.OwSettingsPropertyBPMProxy.from", "from"));
        w_p.write(":&nbsp;");
        w_p.write("</td><td style=\"text-align: left; vertical-align: middle;\">");
        OwEditablePropertyDate.insertEditHTML((OwMainAppContext)this.getContext(), this.getContext().getLocale(), w_p, fromdate, strID_p + PROXY_PERSON_ID_FROM_DATE, ((OwMainAppContext)this.getContext()).useJS_DateControl(), false, ((OwMainAppContext)this.getContext()).getDateFormatStringWithoutTime());
        w_p.write("</td><td style=\"text-align: left; vertical-align: middle;\">");
        w_p.write("&nbsp;");
        w_p.write(this.getContext().localize("settingsimpl.OwSettingsPropertyBPMProxy.to", "to"));
        w_p.write(":&nbsp;");
        w_p.write("</td><td style=\"text-align: left; vertical-align: middle;\">");
        OwEditablePropertyDate.insertEditHTML((OwMainAppContext)this.getContext(), this.getContext().getLocale(), w_p, todate, strID_p + PROXY_PERSON_ID_TO_DATE, ((OwMainAppContext)this.getContext()).useJS_DateControl(), true, ((OwMainAppContext)this.getContext()).getDateFormatStringWithoutTime());
        w_p.write("</td></tr></table>");
        w_p.write("</span>");
    }

    public void onSelectAbsentPerson(HttpServletRequest request_p) throws Exception {
        OwBPMSettingsUserSelectDialog dlgUser = new OwBPMSettingsUserSelectDialog(new int[]{1}, false);
        this.getContext().openDialog(dlgUser, this);
    }

    public void onSelectProxyPerson(HttpServletRequest request_p) throws Exception {
        this.m_strError = "";
        int iItem = Integer.parseInt(request_p.getParameter("item"));
        OwWorkitemRepository.OwProxyInfo info = null;
        try {
            info = (OwWorkitemRepository.OwProxyInfo)((List)this.getValue()).get(iItem);
        }
        catch (ClassCastException e) {
            info = (OwWorkitemRepository.OwProxyInfo)this.getValue();
        }
        OwBPMSettingsUserSelectDialog dlgUser = new OwBPMSettingsUserSelectDialog(new int[]{1}, false, info);
        this.getContext().openDialog(dlgUser, null);
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        this.m_strError = null;
        try {
            if (this.isList()) {
                List list = (List)this.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    OwWorkitemRepository.OwProxyInfo info = (OwWorkitemRepository.OwProxyInfo)list.get(i);
                    this.setSingleValueFromRequest(request_p, String.valueOf(this.hashCode()) + "_item" + String.valueOf(i), info);
                }
            } else {
                OwWorkitemRepository.OwProxyInfo info = (OwWorkitemRepository.OwProxyInfo)this.getValue();
                this.setSingleValueFromRequest(request_p, String.valueOf(this.hashCode()), info);
            }
            if (fSave_p) {
                this.getBPMRepository().setProxies((Collection)this.getValue(), this.getAbsentUserID());
            }
        }
        catch (Exception e) {
            this.m_strError = e.getLocalizedMessage();
        }
        return true;
    }

    protected void setSingleValueFromRequest(HttpServletRequest request_p, String strID_p, OwWorkitemRepository.OwProxyInfo info_p) throws Exception {
        if (info_p.getProxyPersonID() == null) {
            throw new OwFieldManagerException(this.getContext().localize("settingsimpl.OwSettingsPropertyBPMProxy.noproxyuser", "No user selected as proxy, please select a user."));
        }
        Date fromdate = info_p.getStarttime();
        Date todate = info_p.getEndtime();
        String dateFormatterPattern = ((OwMainAppContext)this.getContext()).getDateFormatStringWithoutTime();
        fromdate = OwEditablePropertyDate.updateField(this.getContext().getLocale(), request_p, strID_p + PROXY_PERSON_ID_FROM_DATE, ((OwMainAppContext)this.getContext()).useJS_DateControl(), fromdate, false, dateFormatterPattern);
        info_p.setStarttime(OwDateTimeUtil.setBeginOfDayTime(fromdate));
        todate = OwEditablePropertyDate.updateField(this.getContext().getLocale(), request_p, strID_p + PROXY_PERSON_ID_TO_DATE, ((OwMainAppContext)this.getContext()).useJS_DateControl(), todate, true, dateFormatterPattern);
        if (todate != null && todate.compareTo(fromdate) < 0) {
            LOG.error((Object)("The end date (" + todate + ") is before the begin date (" + fromdate + ")."));
            SimpleDateFormat df = new SimpleDateFormat(dateFormatterPattern);
            throw new OwFieldManagerException(this.getContext().localize2("settingsimpl.OwSettingsPropertyBPMProxy.invaliddate", "The end date (%1) is before the begin date (%2).", df.format(todate), df.format(fromdate)));
        }
        info_p.setEndtime(todate == null ? null : OwDateTimeUtil.setEndOfDayTime(todate));
    }

    @Override
    protected Object createSingleClonedValue(Object oSingleValue_p) {
        return oSingleValue_p;
    }

    @Override
    protected Object getDefaultListItemValue() {
        try {
            return this.getBPMRepository().createProxy();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        String suserid;
        List users = null;
        try {
            users = ((OwUserSelectDialog)dialogView_p).getSelectedUsers();
        }
        catch (ClassCastException e) {
            String msg = "Casting exception: Try to cast to [OwUserSelectDialog], passed class = [" + dialogView_p.getClass() + "]";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwInvalidOperationException(msg, (Throwable)e);
        }
        if (null != users && null != (suserid = ((OwUserInfo)users.get(0)).getUserID())) {
            this.m_sAbsentPersonID = suserid;
            this.m_value = null;
        }
    }

    @Override
    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
    }

    private static class OwBPMSettingsUserSelectDialog
    extends OwUserSelectDialog {
        private OwWorkitemRepository.OwProxyInfo m_info;

        public OwBPMSettingsUserSelectDialog(int[] filterType_p, boolean fMultiselect_p, OwWorkitemRepository.OwProxyInfo info_p) {
            super(filterType_p, fMultiselect_p);
            this.m_info = info_p;
        }

        public OwBPMSettingsUserSelectDialog(int[] filterType_p, boolean fMultiselect_p) {
            super(filterType_p, fMultiselect_p);
        }

        @Override
        public void closeDialog() throws Exception {
            OwUserInfo user;
            super.closeDialog();
            List users = this.getSelectedUsers();
            if (users != null && (user = (OwUserInfo)users.iterator().next()) != null && null != this.m_info) {
                this.m_info.setProxyPersonID(user.getUserID());
            }
        }
    }
}

