/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.settingsimpl;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSettingsPropertyControl;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OwSettingsPropertyBaseImpl
extends OwSettingsPropertyControl {
    private static final Logger LOG = OwLogCore.getLogger(OwSettingsPropertyBaseImpl.class);
    protected Node m_propertyDefinitionNode;
    protected Object m_defaultValue;
    protected String m_strSetName;
    protected static final String ITEM_QUERY_KEY = "item";
    protected static final String ITEM_PREFIX = "_item";
    protected boolean m_fList;
    protected Object m_value;
    protected String m_strError;
    protected OwEventTarget m_externalFormEventTarget = this;

    @Override
    protected void init() throws Exception {
    }

    @Override
    public String getHelpPath() {
        return OwXMLDOMUtil.getSafeStringAttributeValue(this.m_propertyDefinitionNode, "helppath", null);
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    protected Object createSingleClonedValue(Object oSingleValue_p) {
        return this.m_value;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public void saved() {
    }

    protected Object getDefaultListItemValue() throws Exception {
        return null;
    }

    public boolean isList() {
        return this.m_fList;
    }

    @Override
    public void setValue(Object value_p) {
        this.m_value = value_p;
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        this.m_strError = null;
        try {
            if (this.isList()) {
                List list = (List)this.getValue();
                int iSize = list.size();
                LinkedList<Object> newList = new LinkedList<Object>();
                for (int i = 0; i < iSize; ++i) {
                    newList.add(this.getSingleValueFromRequest(request_p, String.valueOf(this.hashCode()) + ITEM_PREFIX + String.valueOf(i)));
                }
                ((List)this.m_value).clear();
                ((List)this.m_value).addAll(newList);
            } else {
                this.m_value = this.getSingleValueFromRequest(request_p, String.valueOf(this.hashCode()));
            }
        }
        catch (Exception e) {
            this.m_strError = e.getLocalizedMessage();
        }
        return true;
    }

    protected Object getSingleValueFromRequest(HttpServletRequest request_p, String strID_p) throws Exception {
        return request_p.getParameter(strID_p);
    }

    @Override
    public String getSafePropertyError() {
        String strRet = this.m_strError == null ? "" : this.m_strError;
        this.m_strError = null;
        return strRet;
    }

    @Override
    public boolean hasError() {
        return this.m_strError != null;
    }

    @Override
    public String getPropertyError() {
        return this.m_strError == null ? "" : this.m_strError;
    }

    @Override
    public void insertFormField(Writer w_p) throws Exception {
        if (this.isList()) {
            w_p.write("<table>");
            List list = (List)this.getValue();
            if (null != list) {
                for (int i = 0; i < list.size(); ++i) {
                    w_p.write("\n<tr><td>");
                    this.insertFormValue(w_p, list.get(i), String.valueOf(this.hashCode()) + ITEM_PREFIX + String.valueOf(i), i);
                    w_p.write("</td><td>");
                    this.writeDeleteButton(w_p, i);
                    w_p.write("</td></tr>\n");
                }
            }
            if (this.canAdd()) {
                w_p.write("\n<tr><td colspan='2'>");
                this.writeAddNewItemButton(w_p);
                w_p.write("\n</td><tr>");
            }
            w_p.write("</table>");
        } else {
            this.insertFormValue(w_p, this.getValue(), String.valueOf(this.hashCode()), 0);
        }
    }

    protected void writeAddNewItemButton(Writer w_p) throws Exception {
        String addButtonTooltip = this.getContext().localize("app.OwEditableProperty.add", "add");
        w_p.write("<a title=\"");
        w_p.write(addButtonTooltip);
        w_p.write("\" href=\"");
        w_p.write(this.getFormEventURL("Add", null));
        w_p.write("\"><img src=\"");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/addbtn.png\"");
        if (this.getDisplayName() != null) {
            addButtonTooltip = this.getContext().localize1("settingsimpl.OwSettingsPropertyBaseImpl.addarrayitemtooltipimg", "Add new element for property %1", this.getDisplayName());
        }
        w_p.write(" alt=\"");
        w_p.write(addButtonTooltip);
        w_p.write("\" title=\"");
        w_p.write(addButtonTooltip);
        w_p.write("\"/></a>");
    }

    protected void writeDeleteButton(Writer w_p, int position_p) throws Exception {
        String tooltip = this.getContext().localize("app.OwEditableProperty.delete", "delete");
        w_p.write("&nbsp;<a title=\"");
        w_p.write(tooltip);
        w_p.write("\" href=\"");
        w_p.write(this.getFormEventURL("Delete", "item=" + String.valueOf(position_p)));
        w_p.write("\">");
        String displayName = this.getDisplayName();
        if (displayName != null) {
            tooltip = this.getContext().localize2("settingsimpl.OwSettingsPropertyBaseImpl.delarrayitemindexed", "Delete element at position %1 from property %2", "" + (position_p + 1), displayName);
        }
        w_p.write("<img align=\"absmiddle\" src=\"");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/deletebtn.png\" alt=\"");
        w_p.write(tooltip);
        w_p.write("\" title=\"");
        w_p.write(tooltip);
        w_p.write("\"/></a>");
    }

    public void onDelete(HttpServletRequest request_p) throws Exception {
        int iItem = Integer.parseInt(request_p.getParameter(ITEM_QUERY_KEY));
        ((List)this.getValue()).remove(iItem);
    }

    protected boolean canAdd() {
        return 0 == this.getMaxListSize() || this.getValue() == null || ((List)this.getValue()).size() < this.getMaxListSize();
    }

    public void onAdd(HttpServletRequest request_p) throws Exception {
        if (this.canAdd()) {
            if (this.getValue() == null) {
                throw new OwObjectNotFoundException("OwSettingsPropertyBaseImpl.onAdd: The current value of the property is null, possible cause: Attribute Bag or DB DataSource is missing or wrong configured....");
            }
            ((List)this.getValue()).add(this.getDefaultListItemValue());
        }
    }

    protected void insertFormValue(Writer w_p, Object value_p, String strID_p, int iIndex_p) throws Exception {
        String strValue = "";
        if (null != value_p) {
            strValue = value_p.toString();
        }
        String title = this.getDisplayName();
        String indexTitleString = this.extractIDIndex(strID_p, ITEM_PREFIX, 1);
        if (indexTitleString != null) {
            title = this.getContext().localize2("settingsimpl.OwSettingsPropertyBaseImpl.indexed.string.tite", "%1 . Entry number %2.", this.getDisplayName(), indexTitleString);
        }
        w_p.write("<input class=\"OwInputControl\" type=\"text\" title=\"");
        w_p.write(title);
        w_p.write("\" name=\"");
        w_p.write(strID_p);
        w_p.write("\" value=\"");
        w_p.write(strValue);
        w_p.write("\" />");
    }

    protected Node getPropertyDefinitionNode() {
        return this.m_propertyDefinitionNode;
    }

    @Override
    public void setDefault() {
        if (this.isList()) {
            this.m_value = new ArrayList();
            ((List)this.m_value).addAll((List)this.m_defaultValue);
        } else {
            this.m_value = this.m_defaultValue;
        }
    }

    @Override
    public Node getValueNode(Document doc_p) {
        Element valueNode = doc_p.createElement(this.getName());
        if (this.m_fList) {
            List list = (List)this.getValue();
            for (Object value : list) {
                if (value != null && !"".equals(value)) {
                    Element valueListEntryNode = doc_p.createElement("property");
                    valueNode.appendChild(valueListEntryNode);
                    this.appendSingleValueNode(valueListEntryNode, value);
                    continue;
                }
                LOG.debug((Object)"OwSettingsPropertyBaseImpl.getValueNode: Empty setting value was removed, empty value for setting set can not be saved...");
            }
        } else {
            Object value = this.getValue();
            if (value != null && !"".equals(value)) {
                Element valueListEntryNode = doc_p.createElement("property");
                valueNode.appendChild(valueListEntryNode);
                this.appendSingleValueNode(valueListEntryNode, value);
            } else {
                LOG.debug((Object)"OwSettingsPropertyBaseImpl.getValueNode: Empty setting value was removed, empty value for setting set can not be saved...");
            }
        }
        return valueNode;
    }

    protected void appendSingleValueNode(Node valueRootNode_p, Object value_p) {
        valueRootNode_p.appendChild(valueRootNode_p.getOwnerDocument().createTextNode(value_p.toString()));
    }

    @Override
    public boolean isUser() {
        return OwXMLDOMUtil.getSafeStringAttributeValue(this.m_propertyDefinitionNode, "scope", "").equals("user");
    }

    @Override
    public boolean isEditable() {
        return OwXMLDOMUtil.getSafeBooleanAttributeValue(this.m_propertyDefinitionNode, "edit", false);
    }

    @Override
    public String getDisplayName() {
        return ((OwMainAppContext)this.getContext()).getConfiguration().getLocalizedPluginSettingTitle(this.m_propertyDefinitionNode, this.m_strSetName);
    }

    @Override
    public String getName() {
        return this.m_propertyDefinitionNode.getNodeName();
    }

    @Override
    public String getFormName() {
        if (this == this.m_externalFormEventTarget) {
            return null;
        }
        return this.m_externalFormEventTarget.getFormName();
    }

    protected String extractIDIndex(String strID_p, String indexSeparator_p, int indexElement_p) {
        String[] idElements = strID_p.split(indexSeparator_p);
        if (idElements.length > indexElement_p) {
            try {
                return "" + (Integer.parseInt(idElements[indexElement_p]) + 1);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("OwSettingsPropertyBaseImpl.getValueIndexTitle(): Invalid indexed field ID component string : " + idElements[indexElement_p]));
            }
        }
        return null;
    }

    @Override
    public void setExternalFormTarget(OwEventTarget eventtarget_p) throws Exception {
        this.m_externalFormEventTarget = eventtarget_p;
    }

    @Override
    public OwEventTarget getFormTarget() {
        return this.m_externalFormEventTarget;
    }

    protected int getMaxListSize() {
        return OwXMLDOMUtil.getSafeIntegerAttributeValue(this.m_propertyDefinitionNode, "maxsize", 0);
    }

    @Override
    public void init(Node propertyDefinitionNode_p, Node valueNode_p, String strSetName_p) throws Exception {
        Object value;
        this.m_propertyDefinitionNode = propertyDefinitionNode_p;
        this.m_strSetName = strSetName_p;
        this.m_fList = OwXMLDOMUtil.getSafeBooleanAttributeValue(propertyDefinitionNode_p, "list", false);
        if (this.m_fList) {
            value = this.createValueList(valueNode_p);
            this.m_defaultValue = this.createValueList(propertyDefinitionNode_p);
        } else {
            value = this.createValue(valueNode_p);
            this.m_defaultValue = this.createValue(propertyDefinitionNode_p);
        }
        this.setValue(value);
    }

    protected Object getSingleValue(Node valueNode_p) {
        if (valueNode_p.getFirstChild() == null) {
            return null;
        }
        return valueNode_p.getFirstChild().getNodeValue();
    }

    protected Object createValue(Node valueNode_p) {
        for (Node n = valueNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals("property")) continue;
            return this.getSingleValue(n);
        }
        return null;
    }

    protected List createValueList(Node valueNode_p) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (Node n = valueNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals("property")) continue;
            valueList.add(this.getSingleValue(n));
        }
        return valueList;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\r\n");
        ret.append("OwSettingsPropertyBaseImpl: [");
        ret.append(", getValue() = " + this.getValue());
        ret.append(", isList() = " + this.isList());
        ret.append(", getDisplayName() = " + this.getDisplayName());
        ret.append(", getName() = " + this.getName());
        ret.append("]");
        return ret.toString();
    }
}

