/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.settingsimpl;

import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwPlugin;
import com.wewebu.ow.server.app.OwPluginKeyBoardMaping;
import com.wewebu.ow.server.settingsimpl.OwSettingsPropertyBaseImpl;
import com.wewebu.ow.server.ui.OwKeyboardDescription;
import com.wewebu.ow.server.ui.ua.OwOSFamily;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;

public class OwSettingsPropertyKeyBoardMapping
extends OwSettingsPropertyBaseImpl {
    private static final String ANY_OS_FAMILY = "ANY";
    private static final String OSF_PARAMETER_SUFFIX = "_osf";
    private static final String ID_PARAMETER_SUFFIX = "_id";
    private static final String KEY_PARAMETER_SUFFIX = "_key";
    private static final String CTRL_PARAMETER_SUFFIX = "_ctrl";

    @Override
    protected Object getDefaultListItemValue() {
        return new OwPluginKeyBoardMaping();
    }

    @Override
    protected Object getSingleValueFromRequest(HttpServletRequest request_p, String strID_p) {
        String strPluginID = request_p.getParameter(strID_p + ID_PARAMETER_SUFFIX);
        int iKeyCode = 0;
        String strKeyCode = request_p.getParameter(strID_p + KEY_PARAMETER_SUFFIX);
        if (strKeyCode.length() == 1) {
            iKeyCode = strKeyCode.toUpperCase().charAt(0);
        } else if (strKeyCode.length() == 2 && strKeyCode.toLowerCase().charAt(0) == 'f') {
            iKeyCode = 112 + Integer.parseInt(strKeyCode.substring(1)) - 1;
        } else {
            try {
                iKeyCode = Integer.parseInt(strKeyCode);
            }
            catch (NumberFormatException e) {
                iKeyCode = 63;
            }
        }
        int iCtrlCode = Integer.parseInt(request_p.getParameter(strID_p + CTRL_PARAMETER_SUFFIX));
        String osFamilyValue = request_p.getParameter(strID_p + OSF_PARAMETER_SUFFIX);
        OwOSFamily osFamily = OwOSFamily.UNKNOWN;
        if (!ANY_OS_FAMILY.equals(osFamilyValue)) {
            osFamily = OwOSFamily.valueOf(osFamilyValue);
        }
        return new OwPluginKeyBoardMaping(strPluginID, iKeyCode, iCtrlCode, osFamily);
    }

    @Override
    protected Object createSingleClonedValue(Object oSingleValue_p) {
        return new OwPluginKeyBoardMaping((OwPluginKeyBoardMaping)oSingleValue_p);
    }

    @Override
    protected Object getSingleValue(Node valueNode_p) {
        if (valueNode_p.getFirstChild() == null) {
            return null;
        }
        return new OwPluginKeyBoardMaping(valueNode_p);
    }

    @Override
    protected void appendSingleValueNode(Node valueRootNode_p, Object value_p) {
        valueRootNode_p.appendChild(valueRootNode_p.getOwnerDocument().createTextNode(value_p.toString()));
    }

    @Override
    protected void insertFormValue(Writer w_p, Object value_p, String strID_p, int iIndex_p) throws Exception {
        String selectedPluginId;
        if (value_p == null) {
            return;
        }
        OwPluginKeyBoardMaping map = (OwPluginKeyBoardMaping)value_p;
        w_p.write("<div class=\"OwPluginKeyBoardMaping\" style=\"clear:both\">");
        OwPlugin selectedPlugin = null;
        w_p.write("<div>");
        List pluginList = this.createPluginListItems();
        OwDefaultComboModel model = new OwDefaultComboModel(false, false, map.getPluginID(), pluginList);
        OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(model, strID_p + ID_PARAMETER_SUFFIX, null, null, null);
        renderer.renderCombo(w_p);
        String string = selectedPluginId = model.getSelectedItem() == null ? null : model.getSelectedItem().getValue();
        if (selectedPluginId != null) {
            selectedPlugin = ((OwMainAppContext)this.getContext()).getConfiguration().getAllowedPluginInstance(selectedPluginId);
        }
        w_p.write("</div>");
        w_p.write("<div>");
        if (selectedPlugin != null && selectedPlugin.getIcon() != null) {
            w_p.write("<img src=\"");
            w_p.write(selectedPlugin.getIcon());
            w_p.write("\"");
            String tooltip = "";
            if (selectedPlugin instanceof OwFunction) {
                tooltip = null == ((OwFunction)selectedPlugin).getTooltip() ? tooltip : ((OwFunction)selectedPlugin).getTooltip();
            }
            w_p.write(" alt=\"");
            w_p.write(tooltip);
            w_p.write("\" title=\"");
            w_p.write(tooltip);
            w_p.write("\"/>");
        } else {
            w_p.write("<span class=\"empty\">&nbsp;</span>");
        }
        w_p.write("</div>");
        String strKey = "";
        int keyCode = map.getKeyCode();
        if (keyCode >= 112 && keyCode <= 123) {
            strKey = "F" + String.valueOf(keyCode - 112 + 1);
        } else if (keyCode < 100) {
            if (keyCode >= 32) {
                strKey = strKey + (char)keyCode;
            }
        } else {
            strKey = String.valueOf(keyCode);
        }
        w_p.write("<div>");
        w_p.write("<input class=\"OwInputControl\" size=\"3\" type=\"text\" name=\"");
        w_p.write(strID_p);
        w_p.write("_key\" value=\"");
        w_p.write(strKey);
        w_p.write("\"></div>");
        w_p.write("<div>");
        List controlItems = this.createControlItems();
        OwDefaultComboModel ctrlModel = new OwDefaultComboModel(false, false, "" + map.getCtrlCode(), controlItems);
        OwComboboxRenderer ctrlRenderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(ctrlModel, strID_p + CTRL_PARAMETER_SUFFIX, null, null, null);
        ctrlRenderer.renderCombo(w_p);
        List osItems = this.createOSItems();
        String value = ANY_OS_FAMILY;
        if (OwOSFamily.UNKNOWN != map.getOSFamily()) {
            value = map.getOSFamily().name();
        }
        OwDefaultComboModel osModel = new OwDefaultComboModel(false, false, value, osItems);
        OwComboboxRenderer osRenderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(osModel, strID_p + OSF_PARAMETER_SUFFIX, null, null, null);
        osRenderer.renderCombo(w_p);
        w_p.write("</div>");
        w_p.write("</div>");
    }

    private List createControlItems() throws Exception {
        LinkedList<OwComboItem> result = new LinkedList<OwComboItem>();
        result.add(this.createCtrlItem(0));
        result.add(this.createCtrlItem(1024));
        result.add(this.createCtrlItem(512));
        result.add(this.createCtrlItem(256));
        return result;
    }

    private List createOSItems() throws Exception {
        LinkedList<OwComboItem> result = new LinkedList<OwComboItem>();
        result.add(this.createOSItem(OwOSFamily.WINDOWS));
        result.add(this.createOSItem(OwOSFamily.OS_X));
        result.add(this.createOSItem(OwOSFamily.UNKNOWN));
        return result;
    }

    private List createPluginListItems() {
        LinkedList result = new LinkedList();
        Iterator it = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunctionPlugins().iterator();
        this.addListItemsFromPlugins(result, it);
        it = ((OwMainAppContext)this.getContext()).getConfiguration().getRecordFunctionPlugins().iterator();
        this.addListItemsFromPlugins(result, it);
        it = ((OwMainAppContext)this.getContext()).getConfiguration().getMasterPlugins(true).iterator();
        this.addListItemsFromPlugins(result, it);
        return result;
    }

    private void addListItemsFromPlugins(List items_p, Iterator pluginsIterator_p) {
        while (pluginsIterator_p.hasNext()) {
            OwPlugin plug = (OwPlugin)pluginsIterator_p.next();
            String strID = plug.getPluginID();
            String displayValue = plug.getPluginTypeDisplayName() + ": " + plug.getPluginTitle();
            OwDefaultComboItem item = new OwDefaultComboItem(strID, displayValue);
            items_p.add(item);
        }
    }

    private OwComboItem createCtrlItem(int iCtrlCode_p) throws Exception {
        OwKeyboardDescription keyboardDescription = OwKeyboardDescription.getInstance();
        return new OwDefaultComboItem("" + iCtrlCode_p, keyboardDescription.getCtrlDescription(this.getContext().getLocale(), iCtrlCode_p));
    }

    private OwComboItem createOSItem(OwOSFamily osFamily) throws Exception {
        String displayName = osFamily == OwOSFamily.UNKNOWN ? ANY_OS_FAMILY : osFamily.getFamilyName();
        String value = osFamily == OwOSFamily.UNKNOWN ? ANY_OS_FAMILY : osFamily.name();
        return new OwDefaultComboItem(value, displayName);
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }
}

