/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.settingsimpl;

import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwSettingsPropertyControl;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OwSettingsPropertyLanguageString
extends OwSettingsPropertyControl {
    private static final Logger LOG = OwLogCore.getLogger(OwSettingsPropertyLanguageString.class);
    private static final String LANGUAGE_ATTRIBUTE_NAME = "lang";
    private Node m_propertyDefinitionNode;
    protected Object m_defaultValue;
    protected String m_strSetName;
    protected static final String ITEM_QUERY_KEY = "item";
    protected Map m_value;
    protected String m_strError;
    private Locale m_Locale;
    protected OwEventTarget m_externalFormEventTarget = this;

    @Override
    protected void init() throws Exception {
    }

    @Override
    public String getHelpPath() {
        return OwXMLDOMUtil.getSafeStringAttributeValue(this.m_propertyDefinitionNode, "helppath", null);
    }

    @Override
    public Object getValue() {
        Object ret = this.m_value.get(this.m_Locale.getLanguage());
        if (ret == null) {
            ret = "dd.MM.yyyy (HH:mm)";
        }
        return ret;
    }

    @Override
    protected Object createSingleClonedValue(Object oSingleValue_p) {
        return this.m_value;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public void saved() {
    }

    protected Object getDefaultListItemValue() throws Exception {
        return "";
    }

    public boolean isList() {
        return true;
    }

    @Override
    public void setValue(Object value_p) {
        this.m_value = (Map)value_p;
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        this.m_strError = null;
        try {
            int iSize = this.m_value.keySet().size();
            this.m_value.clear();
            for (int i = 0; i < iSize; ++i) {
                String sValue = request_p.getParameter(String.valueOf(this.hashCode()) + "_item" + String.valueOf(i));
                String sKey = request_p.getParameter(String.valueOf(this.hashCode()) + "_key" + String.valueOf(i));
                this.m_value.put(sKey, sValue);
            }
        }
        catch (Exception e) {
            this.m_strError = e.getLocalizedMessage();
        }
        return true;
    }

    @Override
    public String getSafePropertyError() {
        String strRet = this.m_strError == null ? "" : this.m_strError;
        this.m_strError = null;
        return strRet;
    }

    @Override
    public boolean hasError() {
        return this.m_strError != null;
    }

    @Override
    public String getPropertyError() {
        return this.m_strError == null ? "" : this.m_strError;
    }

    @Override
    public void insertFormField(Writer w_p) throws Exception {
        String tooltip;
        if (this.isList()) {
            w_p.write("<table cellspacing='0' cellpadding='0' border='0'>");
            Iterator it = this.m_value.keySet().iterator();
            int i = 0;
            String designRoot = this.getContext().getDesignURL();
            while (it.hasNext()) {
                String sKey = (String)it.next();
                String sValue = (String)this.m_value.get(sKey);
                if (sValue == null) {
                    sValue = "";
                }
                w_p.write("\n<tr><td>");
                w_p.write("<div style='clear:both'>");
                String sValueID = String.valueOf(this.hashCode()) + "_item" + String.valueOf(i);
                String sKeyID = String.valueOf(this.hashCode()) + "_key" + String.valueOf(i);
                w_p.write("<div style='float:left'>");
                w_p.write("<input type='text' name='" + sValueID + "' value='" + sValue + "'>");
                w_p.write("</div>");
                List languageList = this.createLanguageListItems();
                OwDefaultComboModel model = new OwDefaultComboModel(false, false, sKey, languageList);
                OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(model, sKeyID, null, null, null);
                w_p.write("<div style='float:left'>");
                renderer.renderCombo(w_p);
                w_p.write("</div>");
                w_p.write("</div>");
                w_p.write("</td><td>");
                String tooltip2 = this.getContext().localize("app.OwEditableProperty.delete", "delete");
                w_p.write("&nbsp;<a title='");
                w_p.write(tooltip2);
                w_p.write("' href=\"");
                w_p.write(this.getFormEventURL("Delete", "item=" + sKey));
                w_p.write("\"><img border='0' src='");
                w_p.write(designRoot);
                w_p.write("/images/deletebtn.png'");
                String displayName = this.getDisplayName();
                if (displayName != null) {
                    tooltip2 = this.getContext().localize2("settingsimpl.OwSettingsPropertyBaseImpl.delarrayitemindexed", "Delete element at position %1 from %2", "" + (i + 1), displayName);
                }
                w_p.write(" alt='");
                w_p.write(tooltip2);
                w_p.write("' title='");
                w_p.write(tooltip2);
                w_p.write("'/></a>");
                w_p.write("</td></tr>\n");
                ++i;
            }
            w_p.write("\n<tr><td colspan='2'>");
            tooltip = this.getContext().localize("app.OwEditableProperty.add", "add");
            w_p.write("<a title='");
            w_p.write(tooltip);
            w_p.write("' href=\"");
            w_p.write(this.getFormEventURL("Add", null));
            w_p.write("\"><img border='0' src='");
            w_p.write(designRoot);
            w_p.write("/images/addbtn.png'");
            if (this.getDisplayName() != null) {
                tooltip = this.getContext().localize1("settingsimpl.OwSettingsPropertyBaseImpl.addarrayitemtooltipimg", "Add new item for %1", this.getDisplayName());
            }
        } else {
            String msg = "OwSettingsPropertyLanguageString.insertFormField: must have the setting, list=true.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        w_p.write(" alt='");
        w_p.write(tooltip);
        w_p.write("' title='");
        w_p.write(tooltip);
        w_p.write("'/></a>");
        w_p.write("\n</td><tr>");
        w_p.write("</table>");
    }

    private List createLanguageListItems() {
        LinkedList<OwDefaultComboItem> result = new LinkedList<OwDefaultComboItem>();
        for (Node langNode : ((OwMainAppContext)this.getContext()).getConfiguration().getAvailableLanguages()) {
            String strLang = langNode.getFirstChild().getNodeValue();
            String strDisplayName = OwXMLDOMUtil.getSafeStringAttributeValue(langNode, "displayname", strLang);
            OwDefaultComboItem item = new OwDefaultComboItem(strLang, strDisplayName);
            result.add(item);
        }
        return result;
    }

    public void onDelete(HttpServletRequest request_p) throws Exception {
        String sKey = request_p.getParameter(ITEM_QUERY_KEY);
        this.m_value.remove(sKey);
    }

    public void onAdd(HttpServletRequest request_p) throws Exception {
        this.m_value.put("", this.getDefaultListItemValue());
    }

    protected Node getPropertyDefinitionNode() {
        return this.m_propertyDefinitionNode;
    }

    @Override
    public void setDefault() {
        if (this.isList()) {
            this.m_value.clear();
            this.m_value.putAll((Map)this.m_defaultValue);
        }
    }

    @Override
    public Node getValueNode(Document doc_p) {
        Element valueNode = doc_p.createElement(this.getName());
        for (String sKey : this.m_value.keySet()) {
            String sValue = (String)this.m_value.get(sKey);
            Element valueListEntryNode = doc_p.createElement("property");
            Attr langattr = doc_p.createAttribute(LANGUAGE_ATTRIBUTE_NAME);
            langattr.setNodeValue(sKey);
            valueListEntryNode.getAttributes().setNamedItem(langattr);
            valueNode.appendChild(valueListEntryNode);
            if (sValue == null) continue;
            valueListEntryNode.appendChild(valueListEntryNode.getOwnerDocument().createTextNode(sValue));
        }
        return valueNode;
    }

    @Override
    public boolean isUser() {
        return OwXMLDOMUtil.getSafeStringAttributeValue(this.m_propertyDefinitionNode, "scope", "").equals("user");
    }

    @Override
    public boolean isEditable() {
        return OwXMLDOMUtil.getSafeBooleanAttributeValue(this.m_propertyDefinitionNode, "edit", false);
    }

    @Override
    public String getDisplayName() {
        return ((OwMainAppContext)this.getContext()).getConfiguration().getLocalizedPluginSettingTitle(this.m_propertyDefinitionNode, this.m_strSetName);
    }

    @Override
    public String getName() {
        return this.m_propertyDefinitionNode.getNodeName();
    }

    @Override
    public String getFormName() {
        if (this == this.m_externalFormEventTarget) {
            return null;
        }
        return this.m_externalFormEventTarget.getFormName();
    }

    @Override
    public void setExternalFormTarget(OwEventTarget eventtarget_p) throws Exception {
        this.m_externalFormEventTarget = eventtarget_p;
    }

    @Override
    public OwEventTarget getFormTarget() {
        return this.m_externalFormEventTarget;
    }

    @Override
    public void init(Node propertyDefinitionNode_p, Node valueNode_p, String strSetName_p) throws Exception {
        this.m_propertyDefinitionNode = propertyDefinitionNode_p;
        this.m_strSetName = strSetName_p;
        boolean fList = OwXMLDOMUtil.getSafeBooleanAttributeValue(propertyDefinitionNode_p, "list", false);
        if (!fList) {
            String msg = "OwSettingsPropertyLanguageString.init: Must have the setting - list=true in plugin " + strSetName_p + " settings.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        Map value = this.createValueMap(valueNode_p);
        this.m_defaultValue = this.createValueMap(propertyDefinitionNode_p);
        this.setValue(value);
    }

    protected Object getSingleValue(Node valueNode_p) {
        if (valueNode_p.getFirstChild() == null) {
            return null;
        }
        return valueNode_p.getFirstChild().getNodeValue();
    }

    protected Map createValueMap(Node valueNode_p) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (Node n = valueNode_p.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals("property")) continue;
            String sKey = OwXMLDOMUtil.getSafeStringAttributeValue(n, LANGUAGE_ATTRIBUTE_NAME, "");
            valueMap.put(sKey, this.getSingleValue(n));
        }
        return valueMap;
    }

    public void setLocaleFromContext(OwMainAppContext mainContext_p) {
        this.m_Locale = mainContext_p.getLocale();
    }

    public Locale getLocaleFromContext() {
        return this.m_Locale;
    }
}

