/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ui;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwLoginView;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMainLayout;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.role.OwStandardRoleManager;
import com.wewebu.ow.server.servlets.OwConfigurationInitialisingContextListener;
import com.wewebu.ow.server.servlets.OwServerContext;
import com.wewebu.ow.server.ui.OwBootstrapToIdMapping;
import com.wewebu.ow.server.ui.OwWebApplication;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class OwAdaptor {
    private static final String SAVE_NODES_PARAMETER_NAME = "saveNodes";
    private static final String GET_EDIT_NODES_PARAMETER_NAME = "getEditNodes";
    private static final String LIST_SAVED_FILES_PARAMETER_NAME = "listSavedFiles";
    private static final String CURRENT_ADAPTOR_PARAMETER_NAME = "currentAdaptor";
    private static final String EDIT_FIELD_PREFIX_PARAM_NAME = "editField";
    private static final String OW_EDITABLE_BOOTSTRAP_NODES_PATH = "/ow_editable_bootstrap_nodes.owd";
    private static final String EMPTY_PATH_SUFFIX = "";
    private static final String DEPLOY_PREFIX = "deploy#";
    private static final String RESOURCE_FILE_PATH_PARAMETER_NAME = "resourceFilePath";
    private static String[][] adaptors_dev = new String[][]{{"opencmis_prof_dev (srvalfx64 | development)", "deploy#WEB-INF/conf/opencmis_prof_dev"}, {"opencmis_fncm5_dev (192.168.1.254 | development)", "deploy#WEB-INF/conf/opencmis_fncm5_dev"}, {"fncm5_dev (192.168.1.254:9080 | basic data model | development)", "deploy#WEB-INF/conf/fncm5_dev"}, {"opencmis_alfrescobpm_dev (srvalfx64 | development)", "deploy#WEB-INF/conf/opencmis_alfrescobpm_dev"}};
    private static String[][] adaptors = new String[][]{{"Dummy Adaptor", "deploy#WEB-INF/conf/dummy"}, {"cmis (deprecated | localhost | basic data model | only for enterprise,trial)", "deploy#WEB-INF/conf/cmis"}, {"fncm5 (192.168.1.254:9080 | basic data model | only for enterprise,trial)", "deploy#WEB-INF/conf/fncm5"}, {"opencmis (cmis.alfresco.com | basic data model | all editions)", "deploy#WEB-INF/conf/opencmis"}, {"opencmis_hr (srvalf3:8080 | HR Scenario | all editions)", "deploy#WEB-INF/conf/opencmis_hr"}, {"opencmis_trial (Trial Rackspace | Customer Management | csu,pou,bdu,tdu)", "deploy#WEB-INF/conf/opencmis_trial"}};
    private static String[][] adaptors_cross = new String[][]{{"ocmis_alfresco_x_ocmis_alfresco_dev (localhost + srvalfx64 | development)", "deploy#WEB-INF/conf/ocmis_alfresco_x_ocmis_alfresco_dev"}, {"ocmis_alfresco_x_ocmis_fncm5_dev (192.168.1.254 + srvalfx64 | development)", "deploy#WEB-INF/conf/ocmis_alfresco_x_ocmis_fncm5_dev"}};
    private static final Logger LOG = OwLogCore.getLogger(OwAdaptor.class);
    private static Map<String, String> AVAILABLE_ADAPTORS = null;
    private static final DateFormat JAVASCRIPT_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private ServletContext servletContext;
    private String basePath;
    private Map<String, List<String>> currentEditableNodes = new HashMap<String, List<String>>();
    private Map<String, OwRequestHandlerStrategy> requestHandlers = new HashMap<String, OwRequestHandlerStrategy>();

    private synchronized void initAdaptor() {
        AVAILABLE_ADAPTORS = new LinkedHashMap<String, String>();
        for (int i = 0; i < adaptors_dev.length; ++i) {
            AVAILABLE_ADAPTORS.put(adaptors_dev[i][1], adaptors_dev[i][0]);
        }
        for (int j = 0; j < adaptors.length; ++j) {
            AVAILABLE_ADAPTORS.put(adaptors[j][1], adaptors[j][0]);
        }
        for (int k = 0; k < adaptors_cross.length; ++k) {
            AVAILABLE_ADAPTORS.put(adaptors_cross[k][1], adaptors_cross[k][0]);
        }
    }

    public OwAdaptor() {
        this.registerRequestHandlerStrategy(new OwApplicationStarterStrategy());
        this.registerRequestHandlerStrategy(new OwListSavedFilesStrategy());
        this.registerRequestHandlerStrategy(new OwGetEditNodesStrategy());
        this.registerRequestHandlerStrategy(new OwSaveFileStrategy());
    }

    private void registerRequestHandlerStrategy(OwRequestHandlerStrategy strategy_p) {
        OwRequestHandlerStrategy oldStrategy = this.requestHandlers.put(strategy_p.getParameterId(), strategy_p);
        if (oldStrategy != null) {
            throw new RuntimeException("Cannot register more than one request handler strategy for id: " + strategy_p.getParameterId());
        }
    }

    public String getAvailableAdators() throws Exception {
        return OwAdaptor.buildAdaptorsJSArray(this.extractAvailableAdaptors());
    }

    private Map<String, String> extractAvailableAdaptors() throws Exception {
        if (AVAILABLE_ADAPTORS == null) {
            this.initAdaptor();
        }
        return this.filterAdaptors(AVAILABLE_ADAPTORS, EMPTY_PATH_SUFFIX);
    }

    private static String buildAdaptorsJSArray(Map<String, String> adaptorsMap_p) {
        StringBuilder builder = new StringBuilder("[");
        Set<Map.Entry<String, String>> entries = adaptorsMap_p.entrySet();
        Iterator<Map.Entry<String, String>> entriesIterator = entries.iterator();
        while (entriesIterator.hasNext()) {
            Map.Entry<String, String> entry = entriesIterator.next();
            builder.append("[");
            builder.append("'");
            builder.append(entry.getKey());
            builder.append("','");
            builder.append(entry.getValue());
            builder.append("'");
            builder.append("]");
            if (!entriesIterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public String getSelectedAdaptor() throws Exception {
        String selectedAdaptor = EMPTY_PATH_SUFFIX;
        Map<String, String> availableAdaptors = this.extractAvailableAdaptors();
        if (availableAdaptors.size() > 0) {
            selectedAdaptor = availableAdaptors.keySet().iterator().next();
        }
        return selectedAdaptor;
    }

    public String getBaseURL(HttpServletRequest request_p) {
        StringBuilder builder = new StringBuilder();
        builder.append(request_p.getScheme());
        builder.append("://");
        builder.append(request_p.getServerName());
        builder.append(":");
        builder.append(request_p.getServerPort());
        builder.append(request_p.getRequestURI());
        return builder.toString();
    }

    public void initialize(HttpServletRequest request_p, OwWebApplication owApplication_p) throws Exception {
        request_p.setCharacterEncoding("UTF-8");
        HttpSession session = request_p.getSession(true);
        this.servletContext = session.getServletContext();
        this.basePath = this.servletContext.getRealPath("/");
        owApplication_p.setContextClass(OwMainAppContext.class);
        owApplication_p.setViewClass(OwMainLayout.class);
        owApplication_p.setLoginClass(OwLoginView.class);
        owApplication_p.setJspPath("main.jsp");
    }

    public void processRequest(HttpServletRequest request_p, HttpServletResponse response_p, OwWebApplication owApplication_p) throws Exception {
        Set<String> registerParams = this.requestHandlers.keySet();
        for (String id : registerParams) {
            if (request_p.getParameter(id) == null) continue;
            this.requestHandlers.get(id).processRequest(request_p, response_p, owApplication_p);
        }
    }

    private String getSavedFiles(String currentAdaptor_p) {
        StringBuilder result = new StringBuilder();
        String fullPath = this.buildFullPath(EMPTY_PATH_SUFFIX, currentAdaptor_p);
        File configDir = new File(fullPath);
        if (!configDir.exists() || !configDir.isDirectory()) {
            throw new RuntimeException("TODO - files!!!");
        }
        File[] savedFiles = this.getSavedFiles(configDir);
        result.append("[");
        OwBootstrapToIdMapping mapping = OwBootstrapToIdMapping.getInstance();
        for (int i = 0; i < savedFiles.length; ++i) {
            result.append("[");
            result.append(i);
            result.append(",'");
            result.append(savedFiles[i].getName());
            result.append("','");
            String identifier = mapping.getIdentifier(fullPath, savedFiles[i].getName());
            if (identifier == null) {
                identifier = EMPTY_PATH_SUFFIX;
            }
            try {
                result.append(OwHTMLHelper.encodeJavascriptString(OwHTMLHelper.encodeToSecureHTML(identifier)));
            }
            catch (IOException e) {
                result.append(EMPTY_PATH_SUFFIX);
            }
            result.append("','");
            result.append(JAVASCRIPT_DATE_FORMAT.format(new Date(savedFiles[i].lastModified())));
            result.append("']");
            if (i == savedFiles.length - 1) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    private File[] getSavedFiles(File configDir_p) {
        File[] savedFiles = configDir_p.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file_p) {
                boolean result = false;
                String fileName = file_p.getName();
                if (fileName.startsWith("owbootstrap") && fileName.endsWith(".xml")) {
                    result = true;
                }
                return result;
            }
        });
        Arrays.sort(savedFiles, new Comparator<File>(){

            @Override
            public int compare(File file1_p, File file2_p) {
                if (file1_p.getName().equals("owbootstrap.xml")) {
                    return -1;
                }
                if (file2_p.getName().equals("owbootstrap.xml")) {
                    return 1;
                }
                return (int)(file1_p.lastModified() - file2_p.lastModified());
            }
        });
        return savedFiles;
    }

    public String getEditableAdaptors() throws Exception {
        if (AVAILABLE_ADAPTORS == null) {
            this.initAdaptor();
        }
        Map<String, String> configuredAdaptors = this.filterAdaptors(AVAILABLE_ADAPTORS, OW_EDITABLE_BOOTSTRAP_NODES_PATH);
        Set<String> keys = configuredAdaptors.keySet();
        return keys.toString();
    }

    public String getEditNodes(String adaptor_p, String selectedBootstrap_p) throws Exception {
        if (!this.getEditableAdaptors().contains(adaptor_p)) {
            return "[['','']]";
        }
        if (selectedBootstrap_p == null) {
            selectedBootstrap_p = "/owbootstrap.xml";
        }
        List<String> currentEditableNodesList = this.readEditableNodes(adaptor_p);
        Document currentDocumentDOM = this.getCurrentDocument(adaptor_p, selectedBootstrap_p);
        XPath xpath = this.createXPath();
        ArrayList<String> currentEditableValues = new ArrayList<String>(currentEditableNodesList.size());
        for (String editableNode : currentEditableNodesList) {
            String value;
            Node configNode = (Node)xpath.evaluate(editableNode, currentDocumentDOM, XPathConstants.NODE);
            StringBuilder nodeValueBuilder = new StringBuilder();
            if (configNode != null) {
                NodeList children = configNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 3) continue;
                    nodeValueBuilder.append(node.getNodeValue());
                }
            }
            currentEditableValues.add((value = nodeValueBuilder.toString().trim()) == null ? EMPTY_PATH_SUFFIX : value);
        }
        return this.buildEditNodes(currentEditableNodesList, currentEditableValues);
    }

    private XPath createXPath() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return xpath;
    }

    private Document getCurrentDocument(String adaptor_p, String selectedBootstrap_p) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        String fullPath = this.buildFullPath(selectedBootstrap_p, adaptor_p);
        File f = new File(fullPath);
        Document currentDocumentDOM = docBuilder.parse(f);
        return currentDocumentDOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readEditableNodes(String adaptor_p) {
        LinkedList<String> result = new LinkedList();
        if (this.currentEditableNodes.get(adaptor_p) == null) {
            String nodesPath = this.buildFullPath(OW_EDITABLE_BOOTSTRAP_NODES_PATH, adaptor_p);
            File nodesFile = new File(nodesPath);
            if (nodesFile.exists()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(nodesFile));
                    do {
                        if ((line = reader.readLine()) == null) continue;
                        result.add(line.trim());
                    } while (line != null);
                }
                catch (IOException e) {
                    LOG.debug((Object)"Error reading configurable nodes", (Throwable)e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                        reader = null;
                    }
                }
            }
        } else {
            result = this.currentEditableNodes.get(adaptor_p);
        }
        return result;
    }

    private String buildEditNodes(List<String> xpathNodes_p, List<String> xPathNodesValues_p) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < xpathNodes_p.size(); ++i) {
            if (i == 0) {
                builder.append("[");
            }
            builder.append("[");
            builder.append(i);
            builder.append(",'");
            String xPathString = xpathNodes_p.get(i);
            builder.append(xPathString);
            builder.append("','");
            String displayName = xPathString.substring(xPathString.lastIndexOf("/") + 1, xPathString.length());
            builder.append(displayName);
            builder.append("','");
            builder.append(xPathNodesValues_p.get(i));
            builder.append("']");
            if (i < xpathNodes_p.size() - 1) {
                builder.append(",");
                continue;
            }
            builder.append("]");
        }
        return builder.toString();
    }

    private Map<String, String> filterAdaptors(Map<String, String> adaptorsMap_p, String pathSuffix_p) throws Exception {
        if (AVAILABLE_ADAPTORS == null) {
            this.initAdaptor();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Set<String> paths = adaptorsMap_p.keySet();
        for (String path : paths) {
            String filePath = this.buildFullPath(pathSuffix_p, path);
            File f = new File(filePath);
            if (!f.exists()) continue;
            result.put(path, AVAILABLE_ADAPTORS.get(path));
        }
        return result;
    }

    private String buildFullPath(String pathSuffix_p, String adaptorPath_p) {
        String relativePath = this.buildRelativePath(adaptorPath_p + pathSuffix_p);
        String filePath = this.basePath + relativePath;
        return filePath;
    }

    private String buildRelativePath(String path_p) {
        String relativePath = path_p.substring(DEPLOY_PREFIX.length(), path_p.length());
        return relativePath;
    }

    public class OwSaveFileStrategy
    extends OwAjaxRequestHandlerStrategy {
        private String id;

        public OwSaveFileStrategy() {
            this.id = OwAdaptor.SAVE_NODES_PARAMETER_NAME;
        }

        @Override
        protected String processAjaxRequest(HttpServletRequest request_p, HttpServletResponse response_p, OwWebApplication owApplication_p) throws Exception {
            String currentAdaptor = request_p.getParameter(OwAdaptor.CURRENT_ADAPTOR_PARAMETER_NAME);
            String selectedBootstrap = request_p.getParameter("selectedBootstrap");
            String identifier = request_p.getParameter("identifier");
            List currentEditableNodesList = OwAdaptor.this.readEditableNodes(currentAdaptor);
            Map paramMap = request_p.getParameterMap();
            Iterator paramNamesIterator = paramMap.keySet().iterator();
            Document currentDocument = OwAdaptor.this.getCurrentDocument(currentAdaptor, "/" + selectedBootstrap);
            XPath xpath = OwAdaptor.this.createXPath();
            while (paramNamesIterator.hasNext()) {
                String param = (String)paramNamesIterator.next();
                if (!param.startsWith(OwAdaptor.EDIT_FIELD_PREFIX_PARAM_NAME)) continue;
                String paramIndex = param.substring(OwAdaptor.EDIT_FIELD_PREFIX_PARAM_NAME.length());
                try {
                    String editableNode;
                    int index = Integer.parseInt(paramIndex);
                    if (currentDocument == null || (editableNode = (String)currentEditableNodesList.get(index)) == null) continue;
                    Node configNode = (Node)xpath.evaluate(editableNode, currentDocument, XPathConstants.NODE);
                    if (configNode == null) {
                        configNode = this.createMissingNode(currentDocument, editableNode);
                    }
                    NodeList children = configNode.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node textNode = children.item(i);
                        if (textNode.getNodeType() != 3) continue;
                        configNode.removeChild(textNode);
                    }
                    Text updatedTextNode = currentDocument.createTextNode(request_p.getParameter(param));
                    updatedTextNode.normalize();
                    configNode.appendChild(updatedTextNode);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot change the DOM.", (Throwable)e);
                    throw e;
                }
            }
            Date fileNameDate = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String shortFileName = "owbootstrap_" + formatter.format(fileNameDate) + ".xml";
            String fileName = OwAdaptor.this.buildFullPath("/" + shortFileName, currentAdaptor);
            File savedFile = new File(fileName);
            boolean fileSaved = OwXMLDOMUtil.toFile(savedFile, currentDocument);
            String fullPath = OwAdaptor.this.buildFullPath(OwAdaptor.EMPTY_PATH_SUFFIX, currentAdaptor);
            if (fileSaved) {
                OwBootstrapToIdMapping mappings = OwBootstrapToIdMapping.getInstance();
                mappings.writeMappings(fullPath, shortFileName, identifier);
            }
            File configDir = new File(fullPath);
            File[] savedfiles = OwAdaptor.this.getSavedFiles(configDir);
            StringBuilder result = new StringBuilder("[");
            result.append(savedfiles.length);
            result.append(",'");
            result.append(shortFileName);
            result.append("','");
            result.append(OwHTMLHelper.encodeJavascriptString(OwHTMLHelper.encodeToSecureHTML(identifier)));
            result.append("','");
            result.append(JAVASCRIPT_DATE_FORMAT.format(new Date(savedFile.lastModified())));
            result.append("']");
            return result.toString();
        }

        private Node createMissingNode(Document currentDocument_p, String editableNode_p) throws Exception {
            String[] nodeNames = editableNode_p.split("/");
            XPath xpath = OwAdaptor.this.createXPath();
            Node lastNode = currentDocument_p.getDocumentElement();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < nodeNames.length; ++i) {
                builder.append("/");
                builder.append(nodeNames[i]);
                Node configNode = (Node)xpath.evaluate(builder.toString(), currentDocument_p, XPathConstants.NODE);
                if (configNode == null) {
                    Element theNode = currentDocument_p.createElement(nodeNames[i]);
                    lastNode.appendChild(theNode);
                    lastNode = theNode;
                    continue;
                }
                lastNode = configNode;
            }
            return lastNode;
        }

        @Override
        public String getParameterId() {
            return this.id;
        }
    }

    public class OwGetEditNodesStrategy
    extends OwAjaxRequestHandlerStrategy {
        private String id;

        public OwGetEditNodesStrategy() {
            this.id = OwAdaptor.GET_EDIT_NODES_PARAMETER_NAME;
        }

        @Override
        protected String processAjaxRequest(HttpServletRequest request_p, HttpServletResponse response_p, OwWebApplication owApplication_p) throws Exception {
            String currentAdaptor = request_p.getParameter(OwAdaptor.CURRENT_ADAPTOR_PARAMETER_NAME);
            if (currentAdaptor == null) {
                currentAdaptor = OwAdaptor.this.getSelectedAdaptor();
            }
            String currentFile = "/" + request_p.getParameter("currentFile");
            return OwAdaptor.this.getEditNodes(currentAdaptor, currentFile);
        }

        @Override
        public String getParameterId() {
            return this.id;
        }
    }

    public class OwListSavedFilesStrategy
    extends OwAjaxRequestHandlerStrategy {
        private String id;

        public OwListSavedFilesStrategy() {
            this.id = OwAdaptor.LIST_SAVED_FILES_PARAMETER_NAME;
        }

        @Override
        protected String processAjaxRequest(HttpServletRequest request_p, HttpServletResponse response_p, OwWebApplication owApplication_p) throws Exception {
            String currentAdaptor = request_p.getParameter(OwAdaptor.CURRENT_ADAPTOR_PARAMETER_NAME);
            if (currentAdaptor == null) {
                currentAdaptor = OwAdaptor.this.getSelectedAdaptor();
            } else {
                List currentEditableNodesAsList = (List)OwAdaptor.this.currentEditableNodes.get(currentAdaptor);
                if (currentEditableNodesAsList == null) {
                    OwAdaptor.this.currentEditableNodes.put(currentAdaptor, OwAdaptor.this.readEditableNodes(currentAdaptor));
                }
            }
            return OwAdaptor.this.getSavedFiles(currentAdaptor);
        }

        @Override
        public String getParameterId() {
            return this.id;
        }
    }

    public abstract class OwAjaxRequestHandlerStrategy
    implements OwRequestHandlerStrategy {
        @Override
        public void processRequest(HttpServletRequest request_p, HttpServletResponse response_p, OwWebApplication owApplication_p) throws Exception {
            try {
                String ajaxResponse = this.processAjaxRequest(request_p, response_p, owApplication_p);
                this.writeAjaxResponse(response_p, ajaxResponse);
            }
            catch (Exception e) {
                this.handleAjaxRequestException(request_p, response_p, owApplication_p, e);
            }
        }

        private void handleAjaxRequestException(HttpServletRequest request_p, HttpServletResponse response_p, OwWebApplication owApplication_p, Exception e_p) throws Exception {
            response_p.setStatus(500);
            String errMsg = e_p.getLocalizedMessage() == null ? "Cannot resolve your request" : e_p.getLocalizedMessage();
            response_p.getWriter().write(errMsg);
        }

        protected abstract String processAjaxRequest(HttpServletRequest var1, HttpServletResponse var2, OwWebApplication var3) throws Exception;

        private void writeAjaxResponse(HttpServletResponse response_p, String text_p) throws IOException {
            response_p.getWriter().write(text_p);
            response_p.getWriter().close();
        }
    }

    public class OwApplicationStarterStrategy
    implements OwRequestHandlerStrategy {
        private String parameterID = "resourceFilePath";

        @Override
        public void processRequest(HttpServletRequest request_p, HttpServletResponse response_p, OwWebApplication owApplication_p) throws Exception {
            String resourceFilePathStr = request_p.getParameter(this.parameterID);
            HttpSession session = request_p.getSession(true);
            ServletContext application = session.getServletContext();
            String selectedBootstrap = request_p.getParameter("selectedBootstrap");
            if (selectedBootstrap != null) {
                application.setAttribute("BOOTSTRAP_IN_USE", (Object)selectedBootstrap);
            }
            if (null != resourceFilePathStr) {
                session.invalidate();
                OwServerContext owServerContext = (OwServerContext)application.getAttribute("ow.serverContext");
                owServerContext.setResourceFilePath(resourceFilePathStr);
                OwConfigurationInitialisingContextListener baseInitializerConfiguration = new OwConfigurationInitialisingContextListener();
                baseInitializerConfiguration.init(application);
                OwConfiguration.applicationInitalize(baseInitializerConfiguration);
                OwStandardRoleManager.applicationInitalize(baseInitializerConfiguration);
                owApplication_p.checkSessionObjects(application, request_p, response_p, request_p.getSession(true));
                response_p.sendRedirect("./");
            }
        }

        @Override
        public String getParameterId() {
            return this.parameterID;
        }
    }

    public static interface OwRequestHandlerStrategy {
        public void processRequest(HttpServletRequest var1, HttpServletResponse var2, OwWebApplication var3) throws Exception;

        public String getParameterId();
    }
}

